/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.Chart;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * LabelPerformanceResp
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-09-12T14:10:29.201+08:00[Asia/Shanghai]")
public class LabelPerformanceResp {
  @SerializedName("search")
  private List<Chart> search = null;

  @SerializedName("editCount")
  private Integer editCount = null;

  @SerializedName("authorCount")
  private Integer authorCount = null;

  @SerializedName("collections")
  private List<Chart> collections = null;

  @SerializedName("executeFailed")
  private Float executeFailed = null;

  @SerializedName("stabilityGrowth")
  private Float stabilityGrowth = null;

  public LabelPerformanceResp search(List<Chart> search) {
    this.search = search;
    return this;
  }

  public LabelPerformanceResp addSearchItem(Chart searchItem) {
    if (this.search == null) {
      this.search = new ArrayList<Chart>();
    }
    this.search.add(searchItem);
    return this;
  }

   /**
   * 历史每天搜索次数（近30天）
   * @return search
  **/
  @Schema(description = "历史每天搜索次数（近30天）")
  public List<Chart> getSearch() {
    return search;
  }

  public void setSearch(List<Chart> search) {
    this.search = search;
  }

  public LabelPerformanceResp editCount(Integer editCount) {
    this.editCount = editCount;
    return this;
  }

   /**
   * 再次编辑次数
   * @return editCount
  **/
  @Schema(description = "再次编辑次数")
  public Integer getEditCount() {
    return editCount;
  }

  public void setEditCount(Integer editCount) {
    this.editCount = editCount;
  }

  public LabelPerformanceResp authorCount(Integer authorCount) {
    this.authorCount = authorCount;
    return this;
  }

   /**
   * 已授权人数
   * @return authorCount
  **/
  @Schema(description = "已授权人数")
  public Integer getAuthorCount() {
    return authorCount;
  }

  public void setAuthorCount(Integer authorCount) {
    this.authorCount = authorCount;
  }

  public LabelPerformanceResp collections(List<Chart> collections) {
    this.collections = collections;
    return this;
  }

  public LabelPerformanceResp addCollectionsItem(Chart collectionsItem) {
    if (this.collections == null) {
      this.collections = new ArrayList<Chart>();
    }
    this.collections.add(collectionsItem);
    return this;
  }

   /**
   * 历史每天收藏次数（近30天）
   * @return collections
  **/
  @Schema(description = "历史每天收藏次数（近30天）")
  public List<Chart> getCollections() {
    return collections;
  }

  public void setCollections(List<Chart> collections) {
    this.collections = collections;
  }

  public LabelPerformanceResp executeFailed(Float executeFailed) {
    this.executeFailed = executeFailed;
    return this;
  }

   /**
   * 任务最近30天失败率
   * @return executeFailed
  **/
  @Schema(description = "任务最近30天失败率")
  public Float getExecuteFailed() {
    return executeFailed;
  }

  public void setExecuteFailed(Float executeFailed) {
    this.executeFailed = executeFailed;
  }

  public LabelPerformanceResp stabilityGrowth(Float stabilityGrowth) {
    this.stabilityGrowth = stabilityGrowth;
    return this;
  }

   /**
   * 标签最近30天稳定性变化
   * @return stabilityGrowth
  **/
  @Schema(description = "标签最近30天稳定性变化")
  public Float getStabilityGrowth() {
    return stabilityGrowth;
  }

  public void setStabilityGrowth(Float stabilityGrowth) {
    this.stabilityGrowth = stabilityGrowth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LabelPerformanceResp labelPerformanceResp = (LabelPerformanceResp) o;
    return Objects.equals(this.search, labelPerformanceResp.search) &&
        Objects.equals(this.editCount, labelPerformanceResp.editCount) &&
        Objects.equals(this.authorCount, labelPerformanceResp.authorCount) &&
        Objects.equals(this.collections, labelPerformanceResp.collections) &&
        Objects.equals(this.executeFailed, labelPerformanceResp.executeFailed) &&
        Objects.equals(this.stabilityGrowth, labelPerformanceResp.stabilityGrowth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(search, editCount, authorCount, collections, executeFailed, stabilityGrowth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LabelPerformanceResp {\n");
    
    sb.append("    search: ").append(toIndentedString(search)).append("\n");
    sb.append("    editCount: ").append(toIndentedString(editCount)).append("\n");
    sb.append("    authorCount: ").append(toIndentedString(authorCount)).append("\n");
    sb.append("    collections: ").append(toIndentedString(collections)).append("\n");
    sb.append("    executeFailed: ").append(toIndentedString(executeFailed)).append("\n");
    sb.append("    stabilityGrowth: ").append(toIndentedString(stabilityGrowth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
