/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.LabelValueCount;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * LabelResultData
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class LabelResultData {
  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  @SerializedName("mautagScheduleTime")
  private String mautagScheduleTime = null;

  @SerializedName("distinctNumber")
  private Long distinctNumber = null;

  @SerializedName("coverage")
  private String coverage = null;

  @SerializedName("statistics")
  private List<LabelValueCount> statistics = null;

  @SerializedName("queryMauCost")
  private Long queryMauCost = null;

  @SerializedName("queryDataCost")
  private Long queryDataCost = null;

  public LabelResultData scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 调度运行时间
   * @return scheduleTime
  **/
  @Schema(description = "调度运行时间")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public LabelResultData mautagScheduleTime(String mautagScheduleTime) {
    this.mautagScheduleTime = mautagScheduleTime;
    return this;
  }

   /**
   * mautag调度运行时间
   * @return mautagScheduleTime
  **/
  @Schema(description = "mautag调度运行时间")
  public String getMautagScheduleTime() {
    return mautagScheduleTime;
  }

  public void setMautagScheduleTime(String mautagScheduleTime) {
    this.mautagScheduleTime = mautagScheduleTime;
  }

  public LabelResultData distinctNumber(Long distinctNumber) {
    this.distinctNumber = distinctNumber;
    return this;
  }

   /**
   * 标签累计覆盖人数（去重）
   * @return distinctNumber
  **/
  @Schema(description = "标签累计覆盖人数（去重）")
  public Long getDistinctNumber() {
    return distinctNumber;
  }

  public void setDistinctNumber(Long distinctNumber) {
    this.distinctNumber = distinctNumber;
  }

  public LabelResultData coverage(String coverage) {
    this.coverage = coverage;
    return this;
  }

   /**
   * 当前标签覆盖总人数占整个项目覆盖总人数比例 (distinctNumber/mautagDistinctNumber)*100%
   * @return coverage
  **/
  @Schema(description = "当前标签覆盖总人数占整个项目覆盖总人数比例 (distinctNumber/mautagDistinctNumber)*100%")
  public String getCoverage() {
    return coverage;
  }

  public void setCoverage(String coverage) {
    this.coverage = coverage;
  }

  public LabelResultData statistics(List<LabelValueCount> statistics) {
    this.statistics = statistics;
    return this;
  }

  public LabelResultData addStatisticsItem(LabelValueCount statisticsItem) {
    if (this.statistics == null) {
      this.statistics = new ArrayList<LabelValueCount>();
    }
    this.statistics.add(statisticsItem);
    return this;
  }

   /**
   * 标签枚举值统计列表
   * @return statistics
  **/
  @Schema(description = "标签枚举值统计列表")
  public List<LabelValueCount> getStatistics() {
    return statistics;
  }

  public void setStatistics(List<LabelValueCount> statistics) {
    this.statistics = statistics;
  }

  public LabelResultData queryMauCost(Long queryMauCost) {
    this.queryMauCost = queryMauCost;
    return this;
  }

   /**
   * 查询服务耗时毫秒数-mau查询部分耗时(类型为mau时恒为0)
   * @return queryMauCost
  **/
  @Schema(description = "查询服务耗时毫秒数-mau查询部分耗时(类型为mau时恒为0)")
  public Long getQueryMauCost() {
    return queryMauCost;
  }

  public void setQueryMauCost(Long queryMauCost) {
    this.queryMauCost = queryMauCost;
  }

  public LabelResultData queryDataCost(Long queryDataCost) {
    this.queryDataCost = queryDataCost;
    return this;
  }

   /**
   * 查询服务耗时毫秒数-查询部分耗时(包含mau查询的总耗时)
   * @return queryDataCost
  **/
  @Schema(description = "查询服务耗时毫秒数-查询部分耗时(包含mau查询的总耗时)")
  public Long getQueryDataCost() {
    return queryDataCost;
  }

  public void setQueryDataCost(Long queryDataCost) {
    this.queryDataCost = queryDataCost;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LabelResultData labelResultData = (LabelResultData) o;
    return Objects.equals(this.scheduleTime, labelResultData.scheduleTime) &&
        Objects.equals(this.mautagScheduleTime, labelResultData.mautagScheduleTime) &&
        Objects.equals(this.distinctNumber, labelResultData.distinctNumber) &&
        Objects.equals(this.coverage, labelResultData.coverage) &&
        Objects.equals(this.statistics, labelResultData.statistics) &&
        Objects.equals(this.queryMauCost, labelResultData.queryMauCost) &&
        Objects.equals(this.queryDataCost, labelResultData.queryDataCost);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scheduleTime, mautagScheduleTime, distinctNumber, coverage, statistics, queryMauCost, queryDataCost);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LabelResultData {\n");
    
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    mautagScheduleTime: ").append(toIndentedString(mautagScheduleTime)).append("\n");
    sb.append("    distinctNumber: ").append(toIndentedString(distinctNumber)).append("\n");
    sb.append("    coverage: ").append(toIndentedString(coverage)).append("\n");
    sb.append("    statistics: ").append(toIndentedString(statistics)).append("\n");
    sb.append("    queryMauCost: ").append(toIndentedString(queryMauCost)).append("\n");
    sb.append("    queryDataCost: ").append(toIndentedString(queryDataCost)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
