/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.LegacySegGroupInfo;
import code.byted.cdp.model.LegacySegOpenApiResponse;
import code.byted.cdp.model.SegmentExtraCondition;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * LegacySegOpenApiResponse
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class LegacySegOpenApiResponse {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("idType")
  private String idType = null;

  @SerializedName("idTypeName")
  private String idTypeName = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("count")
  private Long count = null;

  @SerializedName("createdBy")
  private String createdBy = null;

  @SerializedName("path")
  private String path = null;

  @SerializedName("exportAt")
  private String exportAt = null;

  /**
   * 分群更新方式
   */
  @JsonAdapter(ExportStrategyEnum.Adapter.class)
  public enum ExportStrategyEnum {
    UNKNOWN("Unknown"),
    ONCE("Once"),
    DAILY("Daily"),
    TRIGGER("Trigger"),
    REALTIME("Realtime");

    private String value;

    ExportStrategyEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ExportStrategyEnum fromValue(String input) {
      for (ExportStrategyEnum b : ExportStrategyEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ExportStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ExportStrategyEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ExportStrategyEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ExportStrategyEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("exportStrategy")
  private ExportStrategyEnum exportStrategy = null;

  /**
   * 分群类型
   */
  @JsonAdapter(SegTypeEnum.Adapter.class)
  public enum SegTypeEnum {
    UNKNOWN("Unknown"),
    CONDITIONAL("Conditional"),
    UPLOADED("Uploaded"),
    ABI("ABI"),
    LOOKALIKE("Lookalike"),
    CHILDSEG("ChildSeg"),
    PRIVATETRANSTOPUBLIC("PrivateTransToPublic"),
    SUBJECTTRANS("SubjectTrans"),
    FEATURERECOMMENDATION("FeatureRecommendation"),
    INSIGHTEXPORT("InsightExport"),
    INSIGHTEXPORTV2("InsightExportV2"),
    PUBLICCONDITIONAL("PublicConditional"),
    FINDER("Finder"),
    PUBLICMODELRESULT("PublicModelResult"),
    PUBLICUPLOADED("PublicUploaded"),
    MODEL("Model"),
    PUBLICLOOKALIKE("PublicLookalike"),
    PRIVATELOOKALIKE("PrivateLookalike"),
    SQLEXPORT("SqlExport"),
    REALTIMECONDITIONAL("RealtimeConditional"),
    PRIVATECLUSTER("PrivateCluster"),
    PRIVATECLUSTERCHILD("PrivateClusterChild"),
    PUBLICCLUSTER("PublicCluster"),
    PUBLICCLUSTERCHILD("PublicClusterChild"),
    MANUALREALTIME("ManualRealtime"),
    MULTISUBJECTCONDITIONAL("MultiSubjectConditional");

    private String value;

    SegTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SegTypeEnum fromValue(String input) {
      for (SegTypeEnum b : SegTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SegTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SegTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SegTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SegTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("segType")
  private SegTypeEnum segType = null;

  /**
   * 分群任务状态
   */
  @JsonAdapter(SegStatusEnum.Adapter.class)
  public enum SegStatusEnum {
    UNKNOWN("Unknown"),
    EXPORTING("Exporting"),
    INVALID("Invalid"),
    NORMAL("Normal");

    private String value;

    SegStatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SegStatusEnum fromValue(String input) {
      for (SegStatusEnum b : SegStatusEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SegStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SegStatusEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SegStatusEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SegStatusEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("segStatus")
  private SegStatusEnum segStatus = null;

  @SerializedName("sourceResultReady")
  private Boolean sourceResultReady = null;

  @SerializedName("createdAt")
  private String createdAt = null;

  @SerializedName("onlineSegStatus")
  private Boolean onlineSegStatus = null;

  @SerializedName("childSegments")
  private List<LegacySegOpenApiResponse> childSegments = null;

  @SerializedName("groupInf")
  private List<LegacySegGroupInfo> groupInf = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  @SerializedName("sourceModule")
  private String sourceModule = null;

  @SerializedName("updatedBy")
  private String updatedBy = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("detail")
  private SegmentExtraCondition detail = null;

  /**
   * 分群加密方法
   */
  @JsonAdapter(EncryptionMethodEnum.Adapter.class)
  public enum EncryptionMethodEnum {
    UNKNOWN("Unknown"),
    SHA256("SHA256"),
    MD5("MD5"),
    AES256("AES256"),
    NONE("None");

    private String value;

    EncryptionMethodEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static EncryptionMethodEnum fromValue(String input) {
      for (EncryptionMethodEnum b : EncryptionMethodEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<EncryptionMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EncryptionMethodEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public EncryptionMethodEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return EncryptionMethodEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("encryptionMethod")
  private EncryptionMethodEnum encryptionMethod = null;

  public LegacySegOpenApiResponse id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * 分群id
   * @return id
  **/
  @Schema(required = true, description = "分群id")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public LegacySegOpenApiResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LegacySegOpenApiResponse desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 分群描述
   * @return desc
  **/
  @Schema(description = "分群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public LegacySegOpenApiResponse idType(String idType) {
    this.idType = idType;
    return this;
  }

   /**
   * 分群实体类型code
   * @return idType
  **/
  @Schema(required = true, description = "分群实体类型code")
  public String getIdType() {
    return idType;
  }

  public void setIdType(String idType) {
    this.idType = idType;
  }

  public LegacySegOpenApiResponse idTypeName(String idTypeName) {
    this.idTypeName = idTypeName;
    return this;
  }

   /**
   * 分群实体类型名称
   * @return idTypeName
  **/
  @Schema(required = true, description = "分群实体类型名称")
  public String getIdTypeName() {
    return idTypeName;
  }

  public void setIdTypeName(String idTypeName) {
    this.idTypeName = idTypeName;
  }

  public LegacySegOpenApiResponse subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(required = true, description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public LegacySegOpenApiResponse count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 分群数量
   * @return count
  **/
  @Schema(description = "分群数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public LegacySegOpenApiResponse createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 分群创建人
   * @return createdBy
  **/
  @Schema(required = true, description = "分群创建人")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public LegacySegOpenApiResponse path(String path) {
    this.path = path;
    return this;
  }

   /**
   * 分群离线文件地址
   * @return path
  **/
  @Schema(description = "分群离线文件地址")
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public LegacySegOpenApiResponse exportAt(String exportAt) {
    this.exportAt = exportAt;
    return this;
  }

   /**
   * 分群离线文件导出时间，未就绪时为当前时间戳
   * @return exportAt
  **/
  @Schema(required = true, description = "分群离线文件导出时间，未就绪时为当前时间戳")
  public String getExportAt() {
    return exportAt;
  }

  public void setExportAt(String exportAt) {
    this.exportAt = exportAt;
  }

  public LegacySegOpenApiResponse exportStrategy(ExportStrategyEnum exportStrategy) {
    this.exportStrategy = exportStrategy;
    return this;
  }

   /**
   * 分群更新方式
   * @return exportStrategy
  **/
  @Schema(required = true, description = "分群更新方式")
  public ExportStrategyEnum getExportStrategy() {
    return exportStrategy;
  }

  public void setExportStrategy(ExportStrategyEnum exportStrategy) {
    this.exportStrategy = exportStrategy;
  }

  public LegacySegOpenApiResponse segType(SegTypeEnum segType) {
    this.segType = segType;
    return this;
  }

   /**
   * 分群类型
   * @return segType
  **/
  @Schema(required = true, description = "分群类型")
  public SegTypeEnum getSegType() {
    return segType;
  }

  public void setSegType(SegTypeEnum segType) {
    this.segType = segType;
  }

  public LegacySegOpenApiResponse segStatus(SegStatusEnum segStatus) {
    this.segStatus = segStatus;
    return this;
  }

   /**
   * 分群任务状态
   * @return segStatus
  **/
  @Schema(required = true, description = "分群任务状态")
  public SegStatusEnum getSegStatus() {
    return segStatus;
  }

  public void setSegStatus(SegStatusEnum segStatus) {
    this.segStatus = segStatus;
  }

  public LegacySegOpenApiResponse sourceResultReady(Boolean sourceResultReady) {
    this.sourceResultReady = sourceResultReady;
    return this;
  }

   /**
   * 分群是否就绪
   * @return sourceResultReady
  **/
  @Schema(required = true, description = "分群是否就绪")
  public Boolean isSourceResultReady() {
    return sourceResultReady;
  }

  public void setSourceResultReady(Boolean sourceResultReady) {
    this.sourceResultReady = sourceResultReady;
  }

  public LegacySegOpenApiResponse createdAt(String createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * 分群创建时间
   * @return createdAt
  **/
  @Schema(required = true, description = "分群创建时间")
  public String getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }

  public LegacySegOpenApiResponse onlineSegStatus(Boolean onlineSegStatus) {
    this.onlineSegStatus = onlineSegStatus;
    return this;
  }

   /**
   * 分群是否开启了在线服务配置
   * @return onlineSegStatus
  **/
  @Schema(description = "分群是否开启了在线服务配置")
  public Boolean isOnlineSegStatus() {
    return onlineSegStatus;
  }

  public void setOnlineSegStatus(Boolean onlineSegStatus) {
    this.onlineSegStatus = onlineSegStatus;
  }

  public LegacySegOpenApiResponse childSegments(List<LegacySegOpenApiResponse> childSegments) {
    this.childSegments = childSegments;
    return this;
  }

  public LegacySegOpenApiResponse addChildSegmentsItem(LegacySegOpenApiResponse childSegmentsItem) {
    if (this.childSegments == null) {
      this.childSegments = new ArrayList<LegacySegOpenApiResponse>();
    }
    this.childSegments.add(childSegmentsItem);
    return this;
  }

   /**
   * 分群子包信息
   * @return childSegments
  **/
  @Schema(description = "分群子包信息")
  public List<LegacySegOpenApiResponse> getChildSegments() {
    return childSegments;
  }

  public void setChildSegments(List<LegacySegOpenApiResponse> childSegments) {
    this.childSegments = childSegments;
  }

  public LegacySegOpenApiResponse groupInf(List<LegacySegGroupInfo> groupInf) {
    this.groupInf = groupInf;
    return this;
  }

  public LegacySegOpenApiResponse addGroupInfItem(LegacySegGroupInfo groupInfItem) {
    if (this.groupInf == null) {
      this.groupInf = new ArrayList<LegacySegGroupInfo>();
    }
    this.groupInf.add(groupInfItem);
    return this;
  }

   /**
   * 分群分组详情
   * @return groupInf
  **/
  @Schema(description = "分群分组详情")
  public List<LegacySegGroupInfo> getGroupInf() {
    return groupInf;
  }

  public void setGroupInf(List<LegacySegGroupInfo> groupInf) {
    this.groupInf = groupInf;
  }

  public LegacySegOpenApiResponse sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 来源平台
   * @return sourcePlatform
  **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public LegacySegOpenApiResponse sourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
    return this;
  }

   /**
   * 来源模块
   * @return sourceModule
  **/
  @Schema(description = "来源模块")
  public String getSourceModule() {
    return sourceModule;
  }

  public void setSourceModule(String sourceModule) {
    this.sourceModule = sourceModule;
  }

  public LegacySegOpenApiResponse updatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
    return this;
  }

   /**
   * 编辑人
   * @return updatedBy
  **/
  @Schema(description = "编辑人")
  public String getUpdatedBy() {
    return updatedBy;
  }

  public void setUpdatedBy(String updatedBy) {
    this.updatedBy = updatedBy;
  }

  public LegacySegOpenApiResponse updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 编辑时间
   * @return updateTime
  **/
  @Schema(description = "编辑时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public LegacySegOpenApiResponse detail(SegmentExtraCondition detail) {
    this.detail = detail;
    return this;
  }

   /**
   * Get detail
   * @return detail
  **/
  @Schema(description = "")
  public SegmentExtraCondition getDetail() {
    return detail;
  }

  public void setDetail(SegmentExtraCondition detail) {
    this.detail = detail;
  }

  public LegacySegOpenApiResponse encryptionMethod(EncryptionMethodEnum encryptionMethod) {
    this.encryptionMethod = encryptionMethod;
    return this;
  }

   /**
   * 分群加密方法
   * @return encryptionMethod
  **/
  @Schema(description = "分群加密方法")
  public EncryptionMethodEnum getEncryptionMethod() {
    return encryptionMethod;
  }

  public void setEncryptionMethod(EncryptionMethodEnum encryptionMethod) {
    this.encryptionMethod = encryptionMethod;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegacySegOpenApiResponse legacySegOpenApiResponse = (LegacySegOpenApiResponse) o;
    return Objects.equals(this.id, legacySegOpenApiResponse.id) &&
        Objects.equals(this.name, legacySegOpenApiResponse.name) &&
        Objects.equals(this.desc, legacySegOpenApiResponse.desc) &&
        Objects.equals(this.idType, legacySegOpenApiResponse.idType) &&
        Objects.equals(this.idTypeName, legacySegOpenApiResponse.idTypeName) &&
        Objects.equals(this.subjectId, legacySegOpenApiResponse.subjectId) &&
        Objects.equals(this.count, legacySegOpenApiResponse.count) &&
        Objects.equals(this.createdBy, legacySegOpenApiResponse.createdBy) &&
        Objects.equals(this.path, legacySegOpenApiResponse.path) &&
        Objects.equals(this.exportAt, legacySegOpenApiResponse.exportAt) &&
        Objects.equals(this.exportStrategy, legacySegOpenApiResponse.exportStrategy) &&
        Objects.equals(this.segType, legacySegOpenApiResponse.segType) &&
        Objects.equals(this.segStatus, legacySegOpenApiResponse.segStatus) &&
        Objects.equals(this.sourceResultReady, legacySegOpenApiResponse.sourceResultReady) &&
        Objects.equals(this.createdAt, legacySegOpenApiResponse.createdAt) &&
        Objects.equals(this.onlineSegStatus, legacySegOpenApiResponse.onlineSegStatus) &&
        Objects.equals(this.childSegments, legacySegOpenApiResponse.childSegments) &&
        Objects.equals(this.groupInf, legacySegOpenApiResponse.groupInf) &&
        Objects.equals(this.sourcePlatform, legacySegOpenApiResponse.sourcePlatform) &&
        Objects.equals(this.sourceModule, legacySegOpenApiResponse.sourceModule) &&
        Objects.equals(this.updatedBy, legacySegOpenApiResponse.updatedBy) &&
        Objects.equals(this.updateTime, legacySegOpenApiResponse.updateTime) &&
        Objects.equals(this.detail, legacySegOpenApiResponse.detail) &&
        Objects.equals(this.encryptionMethod, legacySegOpenApiResponse.encryptionMethod);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, desc, idType, idTypeName, subjectId, count, createdBy, path, exportAt, exportStrategy, segType, segStatus, sourceResultReady, createdAt, onlineSegStatus, childSegments, groupInf, sourcePlatform, sourceModule, updatedBy, updateTime, detail, encryptionMethod);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegacySegOpenApiResponse {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    idType: ").append(toIndentedString(idType)).append("\n");
    sb.append("    idTypeName: ").append(toIndentedString(idTypeName)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    exportAt: ").append(toIndentedString(exportAt)).append("\n");
    sb.append("    exportStrategy: ").append(toIndentedString(exportStrategy)).append("\n");
    sb.append("    segType: ").append(toIndentedString(segType)).append("\n");
    sb.append("    segStatus: ").append(toIndentedString(segStatus)).append("\n");
    sb.append("    sourceResultReady: ").append(toIndentedString(sourceResultReady)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    onlineSegStatus: ").append(toIndentedString(onlineSegStatus)).append("\n");
    sb.append("    childSegments: ").append(toIndentedString(childSegments)).append("\n");
    sb.append("    groupInf: ").append(toIndentedString(groupInf)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    sourceModule: ").append(toIndentedString(sourceModule)).append("\n");
    sb.append("    updatedBy: ").append(toIndentedString(updatedBy)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("    encryptionMethod: ").append(toIndentedString(encryptionMethod)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
