/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * NodeMoveAction
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class NodeMoveAction {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("nodeId")
  private Integer nodeId = null;

  @SerializedName("targetId")
  private Integer targetId = null;

  @SerializedName("locate")
  private String locate = null;

  public NodeMoveAction id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * ID
   * @return id
  **/
  @Schema(required = true, description = "ID")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public NodeMoveAction nodeId(Integer nodeId) {
    this.nodeId = nodeId;
    return this;
  }

   /**
   * 目标结点ID,操作对象要移动到的目标结点ID
   * @return nodeId
  **/
  @Schema(required = true, description = "目标结点ID,操作对象要移动到的目标结点ID")
  public Integer getNodeId() {
    return nodeId;
  }

  public void setNodeId(Integer nodeId) {
    this.nodeId = nodeId;
  }

  public NodeMoveAction targetId(Integer targetId) {
    this.targetId = targetId;
    return this;
  }

   /**
   * 参考对象ID,必须与操作对象同类别,作为移动相对位置的参考系,targetId不指定时默认移动到指定结点队尾
   * @return targetId
  **/
  @Schema(description = "参考对象ID,必须与操作对象同类别,作为移动相对位置的参考系,targetId不指定时默认移动到指定结点队尾")
  public Integer getTargetId() {
    return targetId;
  }

  public void setTargetId(Integer targetId) {
    this.targetId = targetId;
  }

  public NodeMoveAction locate(String locate) {
    this.locate = locate;
    return this;
  }

   /**
   * 参考相对位置,相对参考Id对应对象的 Before:上方 After:下方，不传默认最下方
   * @return locate
  **/
  @Schema(description = "参考相对位置,相对参考Id对应对象的 Before:上方 After:下方，不传默认最下方")
  public String getLocate() {
    return locate;
  }

  public void setLocate(String locate) {
    this.locate = locate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NodeMoveAction nodeMoveAction = (NodeMoveAction) o;
    return Objects.equals(this.id, nodeMoveAction.id) &&
        Objects.equals(this.nodeId, nodeMoveAction.nodeId) &&
        Objects.equals(this.targetId, nodeMoveAction.targetId) &&
        Objects.equals(this.locate, nodeMoveAction.locate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, nodeId, targetId, locate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NodeMoveAction {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
    sb.append("    targetId: ").append(toIndentedString(targetId)).append("\n");
    sb.append("    locate: ").append(toIndentedString(locate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
