/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.DataAssetConf;
import code.byted.cdp.model.OutputType;
import code.byted.cdp.model.SimpleOutputConf;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * OpenApiCreateTaskReq
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class OpenApiCreateTaskReq {
  @SerializedName("tenantId")
  private Integer tenantId = null;

  @SerializedName("taskName")
  private String taskName = null;

  @SerializedName("dataAssetConf")
  private DataAssetConf dataAssetConf = null;

  @SerializedName("outputConf")
  private Object outputConf = null;

  @SerializedName("outputType")
  private OutputType outputType = null;

  @SerializedName("platform")
  private String platform = null;

  @SerializedName("tableType")
  private String tableType = null;

  public OpenApiCreateTaskReq tenantId(Integer tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户ID
   * @return tenantId
  **/
  @Schema(required = true, description = "租户ID")
  public Integer getTenantId() {
    return tenantId;
  }

  public void setTenantId(Integer tenantId) {
    this.tenantId = tenantId;
  }

  public OpenApiCreateTaskReq taskName(String taskName) {
    this.taskName = taskName;
    return this;
  }

   /**
   * 任务名称,不可重复
   * @return taskName
  **/
  @Schema(required = true, description = "任务名称,不可重复")
  public String getTaskName() {
    return taskName;
  }

  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }

  public OpenApiCreateTaskReq dataAssetConf(DataAssetConf dataAssetConf) {
    this.dataAssetConf = dataAssetConf;
    return this;
  }

   /**
   * Get dataAssetConf
   * @return dataAssetConf
  **/
  @Schema(required = true, description = "")
  public DataAssetConf getDataAssetConf() {
    return dataAssetConf;
  }

  public void setDataAssetConf(DataAssetConf dataAssetConf) {
    this.dataAssetConf = dataAssetConf;
  }

  public OpenApiCreateTaskReq outputConf(SimpleOutputConf outputConf) {
    this.outputConf = outputConf;
    return this;
  }

   /**
   * Get outputConf
   * @return outputConf
  **/
  @Schema(required = true, description = "")
  public Object getOutputConf() {
    return outputConf;
  }

  public void setOutputConf(Object outputConf) {
    this.outputConf = outputConf;
  }

  public OpenApiCreateTaskReq outputType(OutputType outputType) {
    this.outputType = outputType;
    return this;
  }

   /**
   * Get outputType
   * @return outputType
  **/
  @Schema(required = true, description = "")
  public OutputType getOutputType() {
    return outputType;
  }

  public void setOutputType(OutputType outputType) {
    this.outputType = outputType;
  }

  public OpenApiCreateTaskReq platform(String platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 输出平台的类型，可选值: 如果输出类型是oss_storage,这里可以选择 aliOss,tencentOss,volcEngineOss;如果输出类型选择inner_storage,这里可以选择 hdfs;如果输出类型选择external_storage, 这里可以选择udfOutput
   * @return platform
  **/
  @Schema(required = true, description = "输出平台的类型，可选值: 如果输出类型是oss_storage,这里可以选择 aliOss,tencentOss,volcEngineOss;如果输出类型选择inner_storage,这里可以选择 hdfs;如果输出类型选择external_storage, 这里可以选择udfOutput")
  public String getPlatform() {
    return platform;
  }

  public void setPlatform(String platform) {
    this.platform = platform;
  }

  public OpenApiCreateTaskReq tableType(String tableType) {
    this.tableType = tableType;
    return this;
  }

   /**
   * 输出数据类型，可选值: TotalWideTable，代表全量宽表, TotalHighTable 代表全量高表
   * @return tableType
  **/
  @Schema(required = true, description = "输出数据类型，可选值: TotalWideTable，代表全量宽表, TotalHighTable 代表全量高表")
  public String getTableType() {
    return tableType;
  }

  public void setTableType(String tableType) {
    this.tableType = tableType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpenApiCreateTaskReq openApiCreateTaskReq = (OpenApiCreateTaskReq) o;
    return Objects.equals(this.tenantId, openApiCreateTaskReq.tenantId) &&
        Objects.equals(this.taskName, openApiCreateTaskReq.taskName) &&
        Objects.equals(this.dataAssetConf, openApiCreateTaskReq.dataAssetConf) &&
        Objects.equals(this.outputConf, openApiCreateTaskReq.outputConf) &&
        Objects.equals(this.outputType, openApiCreateTaskReq.outputType) &&
        Objects.equals(this.platform, openApiCreateTaskReq.platform) &&
        Objects.equals(this.tableType, openApiCreateTaskReq.tableType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantId, taskName, dataAssetConf, outputConf, outputType, platform, tableType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenApiCreateTaskReq {\n");
    
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    dataAssetConf: ").append(toIndentedString(dataAssetConf)).append("\n");
    sb.append("    outputConf: ").append(toIndentedString(outputConf)).append("\n");
    sb.append("    outputType: ").append(toIndentedString(outputType)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    tableType: ").append(toIndentedString(tableType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
