/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.SegTaskDependencySettingDetail;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * SegmentTaskConf
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class SegmentTaskConf {
  /**
   * 更新方式，默认一次性
   */
  @JsonAdapter(ScheduleTypeEnum.Adapter.class)
  public enum ScheduleTypeEnum {
    UNKNOWN("Unknown"),
    ONCE("Once"),
    DAILY("Daily"),
    TRIGGER("Trigger"),
    REALTIME("Realtime");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleTypeEnum fromValue(String input) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleType")
  private ScheduleTypeEnum scheduleType = null;

  @SerializedName("skipCheck")
  private Boolean skipCheck = null;

  @SerializedName("notAutoRun")
  private Boolean notAutoRun = null;

  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  @SerializedName("segTaskDependencySettingDetail")
  private SegTaskDependencySettingDetail segTaskDependencySettingDetail = null;

  @SerializedName("scheduleDateTimes")
  private List<String> scheduleDateTimes = null;

  public SegmentTaskConf scheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * 更新方式，默认一次性
   * @return scheduleType
  **/
  @Schema(description = "更新方式，默认一次性")
  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }

  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }

  public SegmentTaskConf skipCheck(Boolean skipCheck) {
    this.skipCheck = skipCheck;
    return this;
  }

   /**
   * 第一次运行是否跳过依赖检查
   * @return skipCheck
  **/
  @Schema(description = "第一次运行是否跳过依赖检查")
  public Boolean isSkipCheck() {
    return skipCheck;
  }

  public void setSkipCheck(Boolean skipCheck) {
    this.skipCheck = skipCheck;
  }

  public SegmentTaskConf notAutoRun(Boolean notAutoRun) {
    this.notAutoRun = notAutoRun;
    return this;
  }

   /**
   * 创建后是否不要自动运行
   * @return notAutoRun
  **/
  @Schema(description = "创建后是否不要自动运行")
  public Boolean isNotAutoRun() {
    return notAutoRun;
  }

  public void setNotAutoRun(Boolean notAutoRun) {
    this.notAutoRun = notAutoRun;
  }

  public SegmentTaskConf scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 任务执行时间，00:00格式
   * @return scheduleTime
  **/
  @Schema(description = "任务执行时间，00:00格式")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public SegmentTaskConf segTaskDependencySettingDetail(SegTaskDependencySettingDetail segTaskDependencySettingDetail) {
    this.segTaskDependencySettingDetail = segTaskDependencySettingDetail;
    return this;
  }

   /**
   * Get segTaskDependencySettingDetail
   * @return segTaskDependencySettingDetail
  **/
  @Schema(description = "")
  public SegTaskDependencySettingDetail getSegTaskDependencySettingDetail() {
    return segTaskDependencySettingDetail;
  }

  public void setSegTaskDependencySettingDetail(SegTaskDependencySettingDetail segTaskDependencySettingDetail) {
    this.segTaskDependencySettingDetail = segTaskDependencySettingDetail;
  }

  public SegmentTaskConf scheduleDateTimes(List<String> scheduleDateTimes) {
    this.scheduleDateTimes = scheduleDateTimes;
    return this;
  }

  public SegmentTaskConf addScheduleDateTimesItem(String scheduleDateTimesItem) {
    if (this.scheduleDateTimes == null) {
      this.scheduleDateTimes = new ArrayList<String>();
    }
    this.scheduleDateTimes.add(scheduleDateTimesItem);
    return this;
  }

   /**
   * 指定调度日期
   * @return scheduleDateTimes
  **/
  @Schema(description = "指定调度日期")
  public List<String> getScheduleDateTimes() {
    return scheduleDateTimes;
  }

  public void setScheduleDateTimes(List<String> scheduleDateTimes) {
    this.scheduleDateTimes = scheduleDateTimes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SegmentTaskConf segmentTaskConf = (SegmentTaskConf) o;
    return Objects.equals(this.scheduleType, segmentTaskConf.scheduleType) &&
        Objects.equals(this.skipCheck, segmentTaskConf.skipCheck) &&
        Objects.equals(this.notAutoRun, segmentTaskConf.notAutoRun) &&
        Objects.equals(this.scheduleTime, segmentTaskConf.scheduleTime) &&
        Objects.equals(this.segTaskDependencySettingDetail, segmentTaskConf.segTaskDependencySettingDetail) &&
        Objects.equals(this.scheduleDateTimes, segmentTaskConf.scheduleDateTimes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(scheduleType, skipCheck, notAutoRun, scheduleTime, segTaskDependencySettingDetail, scheduleDateTimes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SegmentTaskConf {\n");
    
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    skipCheck: ").append(toIndentedString(skipCheck)).append("\n");
    sb.append("    notAutoRun: ").append(toIndentedString(notAutoRun)).append("\n");
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    segTaskDependencySettingDetail: ").append(toIndentedString(segTaskDependencySettingDetail)).append("\n");
    sb.append("    scheduleDateTimes: ").append(toIndentedString(scheduleDateTimes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
