/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.BatchOperateEventRequest;
import code.byted.cdp.model.CommonResponseBoolean;
import code.byted.cdp.model.CommonResponseSourcePropertyValue;
import code.byted.cdp.model.CreateDataSourceReq;
import code.byted.cdp.model.CreateDataSourceResult;
import code.byted.cdp.model.DetailAttributesReq;
import code.byted.cdp.model.DetailAttributesResp;
import code.byted.cdp.model.GetPropertiesResp;
import code.byted.cdp.model.GetPropertyValuesParams;
import code.byted.cdp.model.ListCdpEventPropertyVo;
import code.byted.cdp.model.ListCdpEventVo;
import code.byted.cdp.model.ListCdpPropertyVo;
import code.byted.cdp.model.ListDataSourceListItemVo;
import code.byted.cdp.model.ListString;
import code.byted.cdp.model.ResNodeLineage;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasourceApi {
    private ApiClient apiClient;

    public DatasourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DatasourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for batchOperateEvent
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call batchOperateEventCall(BatchOperateEventRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","batchOperateEvent"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchOperateEventValidateBeforeCall(BatchOperateEventRequest body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling batchOperateEvent(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling batchOperateEvent(Async)");
        }

        com.squareup.okhttp.Call call = batchOperateEventCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 单数据源事件批量操作
     * 单数据源事件批量操作
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean batchOperateEvent(BatchOperateEventRequest body, Integer xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = batchOperateEventWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 单数据源事件批量操作
     * 单数据源事件批量操作
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> batchOperateEventWithHttpInfo(BatchOperateEventRequest body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = batchOperateEventValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 单数据源事件批量操作 (asynchronously)
     * 单数据源事件批量操作
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call batchOperateEventAsync(BatchOperateEventRequest body, Integer xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = batchOperateEventValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getDetailAttributes
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDetailAttributesCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (current != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("current", current));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("attributeId", attributeId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getDetailAttributes"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDetailAttributesValidateBeforeCall(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getDetailAttributes(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getDetailAttributes(Async)");
        }
        // verify the required parameter 'attributeId' is set
        if (attributeId == null) {
            throw new ApiException("Missing the required parameter 'attributeId' when calling getDetailAttributes(Async)");
        }

        com.squareup.okhttp.Call call = getDetailAttributesCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取明细数据源的枚举值
     * 获取明细数据源的枚举值
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @return DetailAttributesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DetailAttributesResp getDetailAttributes(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        ApiResponse<DetailAttributesResp> resp = getDetailAttributesWithHttpInfo(body, tenantCode, attributeId, keyword, current, pageSize);
        return resp.getData();
    }


    /**
     * 获取明细数据源的枚举值
     * 获取明细数据源的枚举值
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @return ApiResponse&lt;DetailAttributesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DetailAttributesResp> getDetailAttributesWithHttpInfo(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize) throws ApiException {
        com.squareup.okhttp.Call call = getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, null, null);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取明细数据源的枚举值 (asynchronously)
     * 获取明细数据源的枚举值
     * @param body  (required)
     * @param tenantCode 租户ID (required)
     * @param attributeId 要查枚举值的字段id (required)
     * @param keyword 查询关键字 (optional)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDetailAttributesAsync(DetailAttributesReq body, String tenantCode, String attributeId, String keyword, Integer current, Integer pageSize, final ApiCallback<DetailAttributesResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getDetailAttributesValidateBeforeCall(body, tenantCode, attributeId, keyword, current, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DetailAttributesResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getProperties
     * @param projectId 项目ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param datasourceId 数据源ID (optional)
     * @param subjectId 主体ID (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPropertiesCall(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (onlineStatusCode != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("online_status_code", onlineStatusCode));
        if (datasourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("datasource_id", datasourceId));
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subject_id", subjectId));

        localVarQueryParams.add(new Pair("project_id", projectId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getProperties"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPropertiesValidateBeforeCall(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getProperties(Async)");
        }

        com.squareup.okhttp.Call call = getPropertiesCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取已导入的用户属性列表
     * 获取已导入的用户属性列表
     * @param projectId 项目ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param datasourceId 数据源ID (optional)
     * @param subjectId 主体ID (optional)
     * @return GetPropertiesResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetPropertiesResp getProperties(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId) throws ApiException {
        ApiResponse<GetPropertiesResp> resp = getPropertiesWithHttpInfo(projectId, keyword, onlineStatusCode, datasourceId, subjectId);
        return resp.getData();
    }


    /**
     * 获取已导入的用户属性列表
     * 获取已导入的用户属性列表
     * @param projectId 项目ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param datasourceId 数据源ID (optional)
     * @param subjectId 主体ID (optional)
     * @return ApiResponse&lt;GetPropertiesResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetPropertiesResp> getPropertiesWithHttpInfo(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = getPropertiesValidateBeforeCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, null, null);
        Type localVarReturnType = new TypeToken<GetPropertiesResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取已导入的用户属性列表 (asynchronously)
     * 获取已导入的用户属性列表
     * @param projectId 项目ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param datasourceId 数据源ID (optional)
     * @param subjectId 主体ID (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPropertiesAsync(String projectId, String keyword, Integer onlineStatusCode, Integer datasourceId, Integer subjectId, final ApiCallback<GetPropertiesResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getPropertiesValidateBeforeCall(projectId, keyword, onlineStatusCode, datasourceId, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetPropertiesResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getPropertyValues
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPropertyValuesCall(Long xTenant, GetPropertyValuesParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getPropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPropertyValuesValidateBeforeCall(Long xTenant, GetPropertyValuesParams body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getPropertyValues(Async)");
        }

        com.squareup.okhttp.Call call = getPropertyValuesCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询数据源下属性的枚举值
     * 获取数据源属性的枚举值,包括用户、明月细、维度、事件属性  1.接口能力支持事件属性,能力包含(获取字段枚举值和获取明细数据源的枚举值) 2.finder的属性和finder数据枚der产品页面枚举值展示保持强一致
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return CommonResponseSourcePropertyValue
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseSourcePropertyValue getPropertyValues(Long xTenant, GetPropertyValuesParams body) throws ApiException {
        ApiResponse<CommonResponseSourcePropertyValue> resp = getPropertyValuesWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 查询数据源下属性的枚举值
     * 获取数据源属性的枚举值,包括用户、明月细、维度、事件属性  1.接口能力支持事件属性,能力包含(获取字段枚举值和获取明细数据源的枚举值) 2.finder的属性和finder数据枚der产品页面枚举值展示保持强一致
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseSourcePropertyValue&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseSourcePropertyValue> getPropertyValuesWithHttpInfo(Long xTenant, GetPropertyValuesParams body) throws ApiException {
        com.squareup.okhttp.Call call = getPropertyValuesValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseSourcePropertyValue>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询数据源下属性的枚举值 (asynchronously)
     * 获取数据源属性的枚举值,包括用户、明月细、维度、事件属性  1.接口能力支持事件属性,能力包含(获取字段枚举值和获取明细数据源的枚举值) 2.finder的属性和finder数据枚der产品页面枚举值展示保持强一致
     * @param xTenant 租户id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPropertyValuesAsync(Long xTenant, GetPropertyValuesParams body, final ApiCallback<CommonResponseSourcePropertyValue> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getPropertyValuesValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseSourcePropertyValue>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryDataSourceList
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourceName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sourceName", sourceName));
        if (sourceType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sourceType", sourceType));
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryDataSourceList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryDataSourceListValidateBeforeCall(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryDataSourceList(Async)");
        }

        com.squareup.okhttp.Call call = queryDataSourceListCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取数据源列表
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @return ListDataSourceListItemVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListDataSourceListItemVo queryDataSourceList(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        ApiResponse<ListDataSourceListItemVo> resp = queryDataSourceListWithHttpInfo(xTenant, sourceName, sourceType, subjectId);
        return resp.getData();
    }


    /**
     * 获取数据源列表
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @return ApiResponse&lt;ListDataSourceListItemVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListDataSourceListItemVo> queryDataSourceListWithHttpInfo(Long xTenant, String sourceName, Integer sourceType, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, null, null);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取数据源列表 (asynchronously)
     * 按租户获取数据源列表
     * @param xTenant 项目id (required)
     * @param sourceName 数据源名称 (optional)
     * @param sourceType 数据源类型,1-用户，2-明细，3-行为，4-标签结果，5-模型数据源，6-标签结果BitMap，7-标签结果Hive,8-维度表 (optional)
     * @param subjectId 主体id,注意维度数据源不区分主体 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryDataSourceListAsync(Long xTenant, String sourceName, Integer sourceType, Integer subjectId, final ApiCallback<ListDataSourceListItemVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryDataSourceListValidateBeforeCall(xTenant, sourceName, sourceType, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListDataSourceListItemVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryLineageByNid
     * @param bizType 业务类型枚举Key (required)
     * @param nativeId 业务结点原生ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryLineageByNidCall(String bizType, Long nativeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (bizType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("bizType", bizType));
        if (nativeId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("nativeId", nativeId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryLineageByNid"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryLineageByNidValidateBeforeCall(String bizType, Long nativeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'bizType' is set
        if (bizType == null) {
            throw new ApiException("Missing the required parameter 'bizType' when calling queryLineageByNid(Async)");
        }
        // verify the required parameter 'nativeId' is set
        if (nativeId == null) {
            throw new ApiException("Missing the required parameter 'nativeId' when calling queryLineageByNid(Async)");
        }

        com.squareup.okhttp.Call call = queryLineageByNidCall(bizType, nativeId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 根据业务类型&amp;原生ID查询出入度数据血缘
     * 根据业务ID&amp;业务类型查询,未查询到的结点baseId为Null
     * @param bizType 业务类型枚举Key (required)
     * @param nativeId 业务结点原生ID (required)
     * @return ResNodeLineage
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ResNodeLineage queryLineageByNid(String bizType, Long nativeId) throws ApiException {
        ApiResponse<ResNodeLineage> resp = queryLineageByNidWithHttpInfo(bizType, nativeId);
        return resp.getData();
    }


    /**
     * 根据业务类型&amp;原生ID查询出入度数据血缘
     * 根据业务ID&amp;业务类型查询,未查询到的结点baseId为Null
     * @param bizType 业务类型枚举Key (required)
     * @param nativeId 业务结点原生ID (required)
     * @return ApiResponse&lt;ResNodeLineage&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ResNodeLineage> queryLineageByNidWithHttpInfo(String bizType, Long nativeId) throws ApiException {
        com.squareup.okhttp.Call call = queryLineageByNidValidateBeforeCall(bizType, nativeId, null, null);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 根据业务类型&amp;原生ID查询出入度数据血缘 (asynchronously)
     * 根据业务ID&amp;业务类型查询,未查询到的结点baseId为Null
     * @param bizType 业务类型枚举Key (required)
     * @param nativeId 业务结点原生ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryLineageByNidAsync(String bizType, Long nativeId, final ApiCallback<ResNodeLineage> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = queryLineageByNidValidateBeforeCall(bizType, nativeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResNodeLineage>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryeventList
     * @param dataSourceId 数据源id (required)
     * @param platform 来源平台，支持多个,分割 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryeventListCall(Integer dataSourceId, String platform, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));
        if (platform != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("platform", platform));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryeventList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryeventListValidateBeforeCall(Integer dataSourceId, String platform, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling queryeventList(Async)");
        }

        com.squareup.okhttp.Call call = queryeventListCall(dataSourceId, platform, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取行为下事件列表
     * 按数据源获取事件列表
     * @param dataSourceId 数据源id (required)
     * @param platform 来源平台，支持多个,分割 (optional)
     * @return ListCdpEventVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpEventVo queryeventList(Integer dataSourceId, String platform) throws ApiException {
        ApiResponse<ListCdpEventVo> resp = queryeventListWithHttpInfo(dataSourceId, platform);
        return resp.getData();
    }


    /**
     * 获取行为下事件列表
     * 按数据源获取事件列表
     * @param dataSourceId 数据源id (required)
     * @param platform 来源平台，支持多个,分割 (optional)
     * @return ApiResponse&lt;ListCdpEventVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpEventVo> queryeventListWithHttpInfo(Integer dataSourceId, String platform) throws ApiException {
        com.squareup.okhttp.Call call = queryeventListValidateBeforeCall(dataSourceId, platform, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取行为下事件列表 (asynchronously)
     * 按数据源获取事件列表
     * @param dataSourceId 数据源id (required)
     * @param platform 来源平台，支持多个,分割 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryeventListAsync(Integer dataSourceId, String platform, final ApiCallback<ListCdpEventVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryeventListValidateBeforeCall(dataSourceId, platform, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for queryeventPropertyList
     * @param xTenant 项目id (optional)
     * @param eventId 事件id,【建议废弃，维护至1.22版本】 (optional)
     * @param dataSourceId 数据源id (optional)
     * @param eventName 事件name,【建议使用，生效1.22版本,需要与dataSourceId配合使用】 (optional)
     * @param platform 【1.23新增】，平台，数组类型逗号分隔，例：app,mp (optional)
     * @param primitive 【1.23新增】，是否SDK原始上报。1:是，0:否，不传忽略 (optional)
     * @param withCommon 是否返回公共事件属性 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryeventPropertyListCall(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (eventId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("eventId", eventId));
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));
        if (eventName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("eventName", eventName));
        if (platform != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("platform", platform));
        if (primitive != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("primitive", primitive));
        if (withCommon != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("withCommon", withCommon));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryeventPropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryeventPropertyListValidateBeforeCall(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        com.squareup.okhttp.Call call = queryeventPropertyListCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取行为事件的属性列表
     * 按事件获取事件属性列表
     * @param xTenant 项目id (optional)
     * @param eventId 事件id,【建议废弃，维护至1.22版本】 (optional)
     * @param dataSourceId 数据源id (optional)
     * @param eventName 事件name,【建议使用，生效1.22版本,需要与dataSourceId配合使用】 (optional)
     * @param platform 【1.23新增】，平台，数组类型逗号分隔，例：app,mp (optional)
     * @param primitive 【1.23新增】，是否SDK原始上报。1:是，0:否，不传忽略 (optional)
     * @param withCommon 是否返回公共事件属性 (optional)
     * @return ListCdpEventPropertyVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpEventPropertyVo queryeventPropertyList(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon) throws ApiException {
        ApiResponse<ListCdpEventPropertyVo> resp = queryeventPropertyListWithHttpInfo(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon);
        return resp.getData();
    }


    /**
     * 获取行为事件的属性列表
     * 按事件获取事件属性列表
     * @param xTenant 项目id (optional)
     * @param eventId 事件id,【建议废弃，维护至1.22版本】 (optional)
     * @param dataSourceId 数据源id (optional)
     * @param eventName 事件name,【建议使用，生效1.22版本,需要与dataSourceId配合使用】 (optional)
     * @param platform 【1.23新增】，平台，数组类型逗号分隔，例：app,mp (optional)
     * @param primitive 【1.23新增】，是否SDK原始上报。1:是，0:否，不传忽略 (optional)
     * @param withCommon 是否返回公共事件属性 (optional)
     * @return ApiResponse&lt;ListCdpEventPropertyVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpEventPropertyVo> queryeventPropertyListWithHttpInfo(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon) throws ApiException {
        com.squareup.okhttp.Call call = queryeventPropertyListValidateBeforeCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, null, null);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取行为事件的属性列表 (asynchronously)
     * 按事件获取事件属性列表
     * @param xTenant 项目id (optional)
     * @param eventId 事件id,【建议废弃，维护至1.22版本】 (optional)
     * @param dataSourceId 数据源id (optional)
     * @param eventName 事件name,【建议使用，生效1.22版本,需要与dataSourceId配合使用】 (optional)
     * @param platform 【1.23新增】，平台，数组类型逗号分隔，例：app,mp (optional)
     * @param primitive 【1.23新增】，是否SDK原始上报。1:是，0:否，不传忽略 (optional)
     * @param withCommon 是否返回公共事件属性 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryeventPropertyListAsync(Long xTenant, Integer eventId, Integer dataSourceId, String eventName, String platform, Integer primitive, Boolean withCommon, final ApiCallback<ListCdpEventPropertyVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = queryeventPropertyListValidateBeforeCall(xTenant, eventId, dataSourceId, eventName, platform, primitive, withCommon, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpEventPropertyVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for querypropertyList
     * @param dataSourceId 数据源id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call querypropertyListCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","querypropertyList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call querypropertyListValidateBeforeCall(Integer dataSourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyList(Async)");
        }

        com.squareup.okhttp.Call call = querypropertyListCall(dataSourceId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取数据源字段列表
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @return ListCdpPropertyVo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListCdpPropertyVo querypropertyList(Integer dataSourceId) throws ApiException {
        ApiResponse<ListCdpPropertyVo> resp = querypropertyListWithHttpInfo(dataSourceId);
        return resp.getData();
    }


    /**
     * 获取数据源字段列表
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @return ApiResponse&lt;ListCdpPropertyVo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListCdpPropertyVo> querypropertyListWithHttpInfo(Integer dataSourceId) throws ApiException {
        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, null, null);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取数据源字段列表 (asynchronously)
     * 按数据源id获取CDP数据源字段列表，对应CDP元数据管理中的数据源
     * @param dataSourceId 数据源id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call querypropertyListAsync(Integer dataSourceId, final ApiCallback<ListCdpPropertyVo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = querypropertyListValidateBeforeCall(dataSourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListCdpPropertyVo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for querypropertyValues
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call querypropertyValuesCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
        if (dataSourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("dataSourceId", dataSourceId));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","querypropertyValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call querypropertyValuesValidateBeforeCall(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling querypropertyValues(Async)");
        }
        // verify the required parameter 'dataSourceId' is set
        if (dataSourceId == null) {
            throw new ApiException("Missing the required parameter 'dataSourceId' when calling querypropertyValues(Async)");
        }

        com.squareup.okhttp.Call call = querypropertyValuesCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取字段枚举值
     * 按数据源和字段获取字段枚举值
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @return ListString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListString querypropertyValues(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        ApiResponse<ListString> resp = querypropertyValuesWithHttpInfo(id, dataSourceId, page, pageSize, keyword);
        return resp.getData();
    }


    /**
     * 获取字段枚举值
     * 按数据源和字段获取字段枚举值
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @return ApiResponse&lt;ListString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListString> querypropertyValuesWithHttpInfo(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword) throws ApiException {
        com.squareup.okhttp.Call call = querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取字段枚举值 (asynchronously)
     * 按数据源和字段获取字段枚举值
     * @param id 字段id (required)
     * @param dataSourceId 数据源id (required)
     * @param page 页码 (optional)
     * @param pageSize 页大小 (optional)
     * @param keyword 关键字 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call querypropertyValuesAsync(Integer id, Integer dataSourceId, Integer page, Integer pageSize, String keyword, final ApiCallback<ListString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = querypropertyValuesValidateBeforeCall(id, dataSourceId, page, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for registerSetOriginSource
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call registerSetOriginSourceCall(CreateDataSourceReq body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","registerSetOriginSource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call registerSetOriginSourceValidateBeforeCall(CreateDataSourceReq body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling registerSetOriginSource(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling registerSetOriginSource(Async)");
        }

        com.squareup.okhttp.Call call = registerSetOriginSourceCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 注册数据源
     * 用于gmp注册数据
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return CreateDataSourceResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreateDataSourceResult registerSetOriginSource(CreateDataSourceReq body, Long xTenant) throws ApiException {
        ApiResponse<CreateDataSourceResult> resp = registerSetOriginSourceWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 注册数据源
     * 用于gmp注册数据
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CreateDataSourceResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreateDataSourceResult> registerSetOriginSourceWithHttpInfo(CreateDataSourceReq body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = registerSetOriginSourceValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CreateDataSourceResult>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 注册数据源 (asynchronously)
     * 用于gmp注册数据
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call registerSetOriginSourceAsync(CreateDataSourceReq body, Long xTenant, final ApiCallback<CreateDataSourceResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = registerSetOriginSourceValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateDataSourceResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
