/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.ByteDanceResponseListChartResp;
import code.byted.cdp.model.DomainType;
import code.byted.cdp.model.SourceType;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.BaseAnalysisModuleReq;
import code.byted.cdp.model.BaseResponseWrapperAnalysisModuleWebResultResp;
import code.byted.cdp.model.BaseResponseWrapperInteger;
import code.byted.cdp.model.BaseResponseWrapperJsonNode;
import code.byted.cdp.model.BaseResponseWrapperListPortalCountObj;
import code.byted.cdp.model.BaseResponseWrapperLong;
import code.byted.cdp.model.BaseResponseWrapperPageRespAnalysisModuleObjResp;
import code.byted.cdp.model.BaseResponseWrapperSegmentation;
import code.byted.cdp.model.ByteDanceResponseCreateResourceUsagesResponse;
import code.byted.cdp.model.ByteDanceResponseDeleteResourceUsagesResponse;
import code.byted.cdp.model.CreateResourceUsagesRequest;
import code.byted.cdp.model.CreateSqlSegmentationReq;
import code.byted.cdp.model.DeleteResourceUsagesRequest;
import code.byted.cdp.model.DslCheckReq;
import code.byted.cdp.model.InlineResponse200;
import code.byted.cdp.model.InlineResponse2001;
import code.byted.cdp.model.InlineResponse2002;
import code.byted.cdp.model.InlineResponse2003;
import code.byted.cdp.model.ListQueryReq;
import code.byted.cdp.model.ListResourcesByUsageResponse;
import code.byted.cdp.model.ListUsagesByResourceResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InsightApi {
    private ApiClient apiClient;

    public InsightApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for createAnalysisModuleObj
     * @param body 查询结构体 (required)
     * @param xTenant 项目Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createAnalysisModuleObjCall(BaseAnalysisModuleReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createAnalysisModuleObj"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createAnalysisModuleObjValidateBeforeCall(BaseAnalysisModuleReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createAnalysisModuleObj(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createAnalysisModuleObj(Async)");
        }

        com.squareup.okhttp.Call call = createAnalysisModuleObjCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建指标
     * 创建指标，例：GMP创建归因指标
     * @param body 查询结构体 (required)
     * @param xTenant 项目Id (required)
     * @return BaseResponseWrapperInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperInteger createAnalysisModuleObj(BaseAnalysisModuleReq body, String xTenant) throws ApiException {
        ApiResponse<BaseResponseWrapperInteger> resp = createAnalysisModuleObjWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建指标
     * 创建指标，例：GMP创建归因指标
     * @param body 查询结构体 (required)
     * @param xTenant 项目Id (required)
     * @return ApiResponse&lt;BaseResponseWrapperInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperInteger> createAnalysisModuleObjWithHttpInfo(BaseAnalysisModuleReq body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createAnalysisModuleObjValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建指标 (asynchronously)
     * 创建指标，例：GMP创建归因指标
     * @param body 查询结构体 (required)
     * @param xTenant 项目Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createAnalysisModuleObjAsync(BaseAnalysisModuleReq body, String xTenant, final ApiCallback<BaseResponseWrapperInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = createAnalysisModuleObjValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createResourceUsages
     * @param body 注册资源请求 (required)
     * @param tenantId 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createResourceUsagesCall(CreateResourceUsagesRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createResourceUsages"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createResourceUsagesValidateBeforeCall(CreateResourceUsagesRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createResourceUsages(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling createResourceUsages(Async)");
        }

        com.squareup.okhttp.Call call = createResourceUsagesCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建资源使用记录
     * 创建资源使用记录
     * @param body 注册资源请求 (required)
     * @param tenantId 租户id (required)
     * @return ByteDanceResponseCreateResourceUsagesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseCreateResourceUsagesResponse createResourceUsages(CreateResourceUsagesRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseCreateResourceUsagesResponse> resp = createResourceUsagesWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 创建资源使用记录
     * 创建资源使用记录
     * @param body 注册资源请求 (required)
     * @param tenantId 租户id (required)
     * @return ApiResponse&lt;ByteDanceResponseCreateResourceUsagesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseCreateResourceUsagesResponse> createResourceUsagesWithHttpInfo(CreateResourceUsagesRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = createResourceUsagesValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseCreateResourceUsagesResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建资源使用记录 (asynchronously)
     * 创建资源使用记录
     * @param body 注册资源请求 (required)
     * @param tenantId 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createResourceUsagesAsync(CreateResourceUsagesRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseCreateResourceUsagesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createResourceUsagesValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseCreateResourceUsagesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteResourceUsages
     * @param body 删除记录请求 (required)
     * @param tenantId 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteResourceUsagesCall(DeleteResourceUsagesRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteResourceUsages"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteResourceUsagesValidateBeforeCall(DeleteResourceUsagesRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteResourceUsages(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling deleteResourceUsages(Async)");
        }

        com.squareup.okhttp.Call call = deleteResourceUsagesCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除CDP资源使用记录
     * 删除CDP资源使用记录
     * @param body 删除记录请求 (required)
     * @param tenantId 租户id (required)
     * @return ByteDanceResponseDeleteResourceUsagesResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseDeleteResourceUsagesResponse deleteResourceUsages(DeleteResourceUsagesRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseDeleteResourceUsagesResponse> resp = deleteResourceUsagesWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 删除CDP资源使用记录
     * 删除CDP资源使用记录
     * @param body 删除记录请求 (required)
     * @param tenantId 租户id (required)
     * @return ApiResponse&lt;ByteDanceResponseDeleteResourceUsagesResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseDeleteResourceUsagesResponse> deleteResourceUsagesWithHttpInfo(DeleteResourceUsagesRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = deleteResourceUsagesValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseDeleteResourceUsagesResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除CDP资源使用记录 (asynchronously)
     * 删除CDP资源使用记录
     * @param body 删除记录请求 (required)
     * @param tenantId 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteResourceUsagesAsync(DeleteResourceUsagesRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseDeleteResourceUsagesResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteResourceUsagesValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseDeleteResourceUsagesResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for executeAnalysisById
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 模块id (required)
     * @param body 查询结构体 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call executeAnalysisByIdCall(String xTenant, Integer analysisModuleObjId, BaseAnalysisModuleReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("analysisModuleObjId", analysisModuleObjId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","executeAnalysisById"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call executeAnalysisByIdValidateBeforeCall(String xTenant, Integer analysisModuleObjId, BaseAnalysisModuleReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling executeAnalysisById(Async)");
        }
        // verify the required parameter 'analysisModuleObjId' is set
        if (analysisModuleObjId == null) {
            throw new ApiException("Missing the required parameter 'analysisModuleObjId' when calling executeAnalysisById(Async)");
        }

        com.squareup.okhttp.Call call = executeAnalysisByIdCall(xTenant, analysisModuleObjId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 发起模块查询
     * 例：GMP查询归因指标情况
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 模块id (required)
     * @param body 查询结构体 (optional)
     * @return BaseResponseWrapperAnalysisModuleWebResultResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperAnalysisModuleWebResultResp executeAnalysisById(String xTenant, Integer analysisModuleObjId, BaseAnalysisModuleReq body) throws ApiException {
        ApiResponse<BaseResponseWrapperAnalysisModuleWebResultResp> resp = executeAnalysisByIdWithHttpInfo(xTenant, analysisModuleObjId, body);
        return resp.getData();
    }


    /**
     * 发起模块查询
     * 例：GMP查询归因指标情况
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 模块id (required)
     * @param body 查询结构体 (optional)
     * @return ApiResponse&lt;BaseResponseWrapperAnalysisModuleWebResultResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperAnalysisModuleWebResultResp> executeAnalysisByIdWithHttpInfo(String xTenant, Integer analysisModuleObjId, BaseAnalysisModuleReq body) throws ApiException {
        com.squareup.okhttp.Call call = executeAnalysisByIdValidateBeforeCall(xTenant, analysisModuleObjId, body, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperAnalysisModuleWebResultResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 发起模块查询 (asynchronously)
     * 例：GMP查询归因指标情况
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 模块id (required)
     * @param body 查询结构体 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call executeAnalysisByIdAsync(String xTenant, Integer analysisModuleObjId, BaseAnalysisModuleReq body, final ApiCallback<BaseResponseWrapperAnalysisModuleWebResultResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = executeAnalysisByIdValidateBeforeCall(xTenant, analysisModuleObjId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperAnalysisModuleWebResultResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for genExportSqlSeg
     * @param body 人群结构体+分析条件 (required)
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 指标id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call genExportSqlSegCall(CreateSqlSegmentationReq body, String xTenant, Integer analysisModuleObjId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("analysisModuleObjId", analysisModuleObjId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","genExportSqlSeg"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call genExportSqlSegValidateBeforeCall(CreateSqlSegmentationReq body, String xTenant, Integer analysisModuleObjId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling genExportSqlSeg(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling genExportSqlSeg(Async)");
        }
        // verify the required parameter 'analysisModuleObjId' is set
        if (analysisModuleObjId == null) {
            throw new ApiException("Missing the required parameter 'analysisModuleObjId' when calling genExportSqlSeg(Async)");
        }

        com.squareup.okhttp.Call call = genExportSqlSegCall(body, xTenant, analysisModuleObjId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 生成导出人群
     * 生成导出人群
     * @param body 人群结构体+分析条件 (required)
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 指标id (required)
     * @return BaseResponseWrapperSegmentation
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperSegmentation genExportSqlSeg(CreateSqlSegmentationReq body, String xTenant, Integer analysisModuleObjId) throws ApiException {
        ApiResponse<BaseResponseWrapperSegmentation> resp = genExportSqlSegWithHttpInfo(body, xTenant, analysisModuleObjId);
        return resp.getData();
    }


    /**
     * 生成导出人群
     * 生成导出人群
     * @param body 人群结构体+分析条件 (required)
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 指标id (required)
     * @return ApiResponse&lt;BaseResponseWrapperSegmentation&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperSegmentation> genExportSqlSegWithHttpInfo(CreateSqlSegmentationReq body, String xTenant, Integer analysisModuleObjId) throws ApiException {
        com.squareup.okhttp.Call call = genExportSqlSegValidateBeforeCall(body, xTenant, analysisModuleObjId, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperSegmentation>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 生成导出人群 (asynchronously)
     * 生成导出人群
     * @param body 人群结构体+分析条件 (required)
     * @param xTenant 项目Id (required)
     * @param analysisModuleObjId 指标id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call genExportSqlSegAsync(CreateSqlSegmentationReq body, String xTenant, Integer analysisModuleObjId, final ApiCallback<BaseResponseWrapperSegmentation> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = genExportSqlSegValidateBeforeCall(body, xTenant, analysisModuleObjId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperSegmentation>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getAllMetricList
     * @param xTenant 项目Id (required)
     * @param body 排序、筛选信息 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllMetricListCall(String xTenant, ListQueryReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getAllMetricList"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllMetricListValidateBeforeCall(String xTenant, ListQueryReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getAllMetricList(Async)");
        }

        com.squareup.okhttp.Call call = getAllMetricListCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 指标列表
     * 通用分析能力-获取指标列表
     * @param xTenant 项目Id (required)
     * @param body 排序、筛选信息 (optional)
     * @return BaseResponseWrapperPageRespAnalysisModuleObjResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperPageRespAnalysisModuleObjResp getAllMetricList(String xTenant, ListQueryReq body) throws ApiException {
        ApiResponse<BaseResponseWrapperPageRespAnalysisModuleObjResp> resp = getAllMetricListWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 指标列表
     * 通用分析能力-获取指标列表
     * @param xTenant 项目Id (required)
     * @param body 排序、筛选信息 (optional)
     * @return ApiResponse&lt;BaseResponseWrapperPageRespAnalysisModuleObjResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperPageRespAnalysisModuleObjResp> getAllMetricListWithHttpInfo(String xTenant, ListQueryReq body) throws ApiException {
        com.squareup.okhttp.Call call = getAllMetricListValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperPageRespAnalysisModuleObjResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 指标列表 (asynchronously)
     * 通用分析能力-获取指标列表
     * @param xTenant 项目Id (required)
     * @param body 排序、筛选信息 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllMetricListAsync(String xTenant, ListQueryReq body, final ApiCallback<BaseResponseWrapperPageRespAnalysisModuleObjResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getAllMetricListValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperPageRespAnalysisModuleObjResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getDSLByInsightKey
     * @param xTenant 项目Id (required)
     * @param key Key,获取方式见【GetDSInsightKey】 (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDSLByInsightKeyCall(String xTenant, String key, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("key", key.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getDSLByInsightKey"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDSLByInsightKeyValidateBeforeCall(String xTenant, String key, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getDSLByInsightKey(Async)");
        }
        // verify the required parameter 'key' is set
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDSLByInsightKey(Async)");
        }

        com.squareup.okhttp.Call call = getDSLByInsightKeyCall(xTenant, key, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 根据洞察跳转Key获取dsl
     * 根据洞察跳转Key获取DSL,Key获取方式见【GetDSInsightKey】
     * @param xTenant 项目Id (required)
     * @param key Key,获取方式见【GetDSInsightKey】 (required)
     * @return BaseResponseWrapperJsonNode
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperJsonNode getDSLByInsightKey(String xTenant, String key) throws ApiException {
        ApiResponse<BaseResponseWrapperJsonNode> resp = getDSLByInsightKeyWithHttpInfo(xTenant, key);
        return resp.getData();
    }


    /**
     * 根据洞察跳转Key获取dsl
     * 根据洞察跳转Key获取DSL,Key获取方式见【GetDSInsightKey】
     * @param xTenant 项目Id (required)
     * @param key Key,获取方式见【GetDSInsightKey】 (required)
     * @return ApiResponse&lt;BaseResponseWrapperJsonNode&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperJsonNode> getDSLByInsightKeyWithHttpInfo(String xTenant, String key) throws ApiException {
        com.squareup.okhttp.Call call = getDSLByInsightKeyValidateBeforeCall(xTenant, key, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperJsonNode>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 根据洞察跳转Key获取dsl (asynchronously)
     * 根据洞察跳转Key获取DSL,Key获取方式见【GetDSInsightKey】
     * @param xTenant 项目Id (required)
     * @param key Key,获取方式见【GetDSInsightKey】 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDSLByInsightKeyAsync(String xTenant, String key, final ApiCallback<BaseResponseWrapperJsonNode> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getDSLByInsightKeyValidateBeforeCall(xTenant, key, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperJsonNode>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getDSLInsightKey
     * @param body 完整的dsl结构 (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getDSLInsightKeyCall(DslCheckReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getDSLInsightKey"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getDSLInsightKeyValidateBeforeCall(DslCheckReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling getDSLInsightKey(Async)");
        }

        com.squareup.okhttp.Call call = getDSLInsightKeyCall(body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取洞察跳转key
     * 根据圈人dsl获取洞察跳转的key
     * @param body 完整的dsl结构 (required)
     * @return InlineResponse200
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse200 getDSLInsightKey(DslCheckReq body) throws ApiException {
        ApiResponse<InlineResponse200> resp = getDSLInsightKeyWithHttpInfo(body);
        return resp.getData();
    }


    /**
     * 获取洞察跳转key
     * 根据圈人dsl获取洞察跳转的key
     * @param body 完整的dsl结构 (required)
     * @return ApiResponse&lt;InlineResponse200&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse200> getDSLInsightKeyWithHttpInfo(DslCheckReq body) throws ApiException {
        com.squareup.okhttp.Call call = getDSLInsightKeyValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取洞察跳转key (asynchronously)
     * 根据圈人dsl获取洞察跳转的key
     * @param body 完整的dsl结构 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getDSLInsightKeyAsync(DslCheckReq body, final ApiCallback<InlineResponse200> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getDSLInsightKeyValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse200>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getInsightReportById
     * @param xTenant 项目id (required)
     * @param reportId 报告id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param singleValue 标签概览中的标签统计维度：False 代表从全量所有标签值选取标签占比最高的前50个标签值，True 代表每个标签分别取UV*TGI最显著的标签值，再取最多50条标签展示，默认 False。 (optional)
     * @param insightSortObj 控制对照分群差异概览结果的排序方式，可选Full、Effective； 对应的结果将按全量分群或有效分群降序排列，默认值Effective。与sortType 参数组合使用。 (optional)
     * @param sortType 控制对照分群差异概览结果的排序方式，可选Tag、Tgi、Uv。对应的结果将按标签人数、TGI、UV 降序排列，默认值 Tgi。与 insightSortObj 参数组合使用 (optional)
     * @param pDate 报告日期，YYYY-HH-MM 格式。可取值为报告列表 historyDate，默认最近一次报告日期 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInsightReportByIdCall(Long xTenant, Long reportId, String xEnv, Boolean singleValue, String insightSortObj, String sortType, String pDate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (singleValue != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("singleValue", singleValue));
        if (insightSortObj != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("insightSortObj", insightSortObj));
        if (sortType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sortType", sortType));
        if (pDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pDate", pDate));

        localVarQueryParams.add(new Pair("reportId", reportId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getInsightReportById"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        if (xEnv != null)
        localVarHeaderParams.put("X-Env", apiClient.parameterToString(xEnv));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInsightReportByIdValidateBeforeCall(Long xTenant, Long reportId, String xEnv, Boolean singleValue, String insightSortObj, String sortType, String pDate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getInsightReportById(Async)");
        }
        // verify the required parameter 'reportId' is set
        if (reportId == null) {
            throw new ApiException("Missing the required parameter 'reportId' when calling getInsightReportById(Async)");
        }

        com.squareup.okhttp.Call call = getInsightReportByIdCall(xTenant, reportId, xEnv, singleValue, insightSortObj, sortType, pDate, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取画像报告详情
     * 根据 reportId 获取画像报告详情，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param reportId 报告id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param singleValue 标签概览中的标签统计维度：False 代表从全量所有标签值选取标签占比最高的前50个标签值，True 代表每个标签分别取UV*TGI最显著的标签值，再取最多50条标签展示，默认 False。 (optional)
     * @param insightSortObj 控制对照分群差异概览结果的排序方式，可选Full、Effective； 对应的结果将按全量分群或有效分群降序排列，默认值Effective。与sortType 参数组合使用。 (optional)
     * @param sortType 控制对照分群差异概览结果的排序方式，可选Tag、Tgi、Uv。对应的结果将按标签人数、TGI、UV 降序排列，默认值 Tgi。与 insightSortObj 参数组合使用 (optional)
     * @param pDate 报告日期，YYYY-HH-MM 格式。可取值为报告列表 historyDate，默认最近一次报告日期 (optional)
     * @return InlineResponse2002
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse2002 getInsightReportById(Long xTenant, Long reportId, String xEnv, Boolean singleValue, String insightSortObj, String sortType, String pDate) throws ApiException {
        ApiResponse<InlineResponse2002> resp = getInsightReportByIdWithHttpInfo(xTenant, reportId, xEnv, singleValue, insightSortObj, sortType, pDate);
        return resp.getData();
    }


    /**
     * 获取画像报告详情
     * 根据 reportId 获取画像报告详情，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param reportId 报告id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param singleValue 标签概览中的标签统计维度：False 代表从全量所有标签值选取标签占比最高的前50个标签值，True 代表每个标签分别取UV*TGI最显著的标签值，再取最多50条标签展示，默认 False。 (optional)
     * @param insightSortObj 控制对照分群差异概览结果的排序方式，可选Full、Effective； 对应的结果将按全量分群或有效分群降序排列，默认值Effective。与sortType 参数组合使用。 (optional)
     * @param sortType 控制对照分群差异概览结果的排序方式，可选Tag、Tgi、Uv。对应的结果将按标签人数、TGI、UV 降序排列，默认值 Tgi。与 insightSortObj 参数组合使用 (optional)
     * @param pDate 报告日期，YYYY-HH-MM 格式。可取值为报告列表 historyDate，默认最近一次报告日期 (optional)
     * @return ApiResponse&lt;InlineResponse2002&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse2002> getInsightReportByIdWithHttpInfo(Long xTenant, Long reportId, String xEnv, Boolean singleValue, String insightSortObj, String sortType, String pDate) throws ApiException {
        com.squareup.okhttp.Call call = getInsightReportByIdValidateBeforeCall(xTenant, reportId, xEnv, singleValue, insightSortObj, sortType, pDate, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2002>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取画像报告详情 (asynchronously)
     * 根据 reportId 获取画像报告详情，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param reportId 报告id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param singleValue 标签概览中的标签统计维度：False 代表从全量所有标签值选取标签占比最高的前50个标签值，True 代表每个标签分别取UV*TGI最显著的标签值，再取最多50条标签展示，默认 False。 (optional)
     * @param insightSortObj 控制对照分群差异概览结果的排序方式，可选Full、Effective； 对应的结果将按全量分群或有效分群降序排列，默认值Effective。与sortType 参数组合使用。 (optional)
     * @param sortType 控制对照分群差异概览结果的排序方式，可选Tag、Tgi、Uv。对应的结果将按标签人数、TGI、UV 降序排列，默认值 Tgi。与 insightSortObj 参数组合使用 (optional)
     * @param pDate 报告日期，YYYY-HH-MM 格式。可取值为报告列表 historyDate，默认最近一次报告日期 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInsightReportByIdAsync(Long xTenant, Long reportId, String xEnv, Boolean singleValue, String insightSortObj, String sortType, String pDate, final ApiCallback<InlineResponse2002> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getInsightReportByIdValidateBeforeCall(xTenant, reportId, xEnv, singleValue, insightSortObj, sortType, pDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2002>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getInsightReportList
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认“dev” (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInsightReportListCall(Long xTenant, String xEnv, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getInsightReportList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        if (xEnv != null)
        localVarHeaderParams.put("X-Env", apiClient.parameterToString(xEnv));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInsightReportListValidateBeforeCall(Long xTenant, String xEnv, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getInsightReportList(Async)");
        }

        com.squareup.okhttp.Call call = getInsightReportListCall(xTenant, xEnv, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取画像报告列表
     * 获取用户有权限访问的画像报告列表，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认“dev” (optional)
     * @return InlineResponse2001
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse2001 getInsightReportList(Long xTenant, String xEnv) throws ApiException {
        ApiResponse<InlineResponse2001> resp = getInsightReportListWithHttpInfo(xTenant, xEnv);
        return resp.getData();
    }


    /**
     * 获取画像报告列表
     * 获取用户有权限访问的画像报告列表，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认“dev” (optional)
     * @return ApiResponse&lt;InlineResponse2001&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse2001> getInsightReportListWithHttpInfo(Long xTenant, String xEnv) throws ApiException {
        com.squareup.okhttp.Call call = getInsightReportListValidateBeforeCall(xTenant, xEnv, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取画像报告列表 (asynchronously)
     * 获取用户有权限访问的画像报告列表，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认“dev” (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInsightReportListAsync(Long xTenant, String xEnv, final ApiCallback<InlineResponse2001> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getInsightReportListValidateBeforeCall(xTenant, xEnv, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getInsightReportUsage
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param openapiOnly 项是否只统计经openapi调用画像报告次数，默认 false，统计的是报告的页面浏览和 2.5.3 接口调用；为 true 时，只统计 2.5.3 接口调用的次数目id (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getInsightReportUsageCall(Long xTenant, String xEnv, Boolean openapiOnly, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (openapiOnly != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("openapiOnly", openapiOnly));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getInsightReportUsage"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        if (xEnv != null)
        localVarHeaderParams.put("X-Env", apiClient.parameterToString(xEnv));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getInsightReportUsageValidateBeforeCall(Long xTenant, String xEnv, Boolean openapiOnly, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getInsightReportUsage(Async)");
        }

        com.squareup.okhttp.Call call = getInsightReportUsageCall(xTenant, xEnv, openapiOnly, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 统计画像报告调用次数 
     * 统计当前用户查看各画像报告的次数，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param openapiOnly 项是否只统计经openapi调用画像报告次数，默认 false，统计的是报告的页面浏览和 2.5.3 接口调用；为 true 时，只统计 2.5.3 接口调用的次数目id (optional)
     * @return InlineResponse2003
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse2003 getInsightReportUsage(Long xTenant, String xEnv, Boolean openapiOnly) throws ApiException {
        ApiResponse<InlineResponse2003> resp = getInsightReportUsageWithHttpInfo(xTenant, xEnv, openapiOnly);
        return resp.getData();
    }


    /**
     * 统计画像报告调用次数 
     * 统计当前用户查看各画像报告的次数，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param openapiOnly 项是否只统计经openapi调用画像报告次数，默认 false，统计的是报告的页面浏览和 2.5.3 接口调用；为 true 时，只统计 2.5.3 接口调用的次数目id (optional)
     * @return ApiResponse&lt;InlineResponse2003&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse2003> getInsightReportUsageWithHttpInfo(Long xTenant, String xEnv, Boolean openapiOnly) throws ApiException {
        com.squareup.okhttp.Call call = getInsightReportUsageValidateBeforeCall(xTenant, xEnv, openapiOnly, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2003>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 统计画像报告调用次数  (asynchronously)
     * 统计当前用户查看各画像报告的次数，目前只支持私域报告
     * @param xTenant 项目id (required)
     * @param xEnv 多环境下需指定环境信息，默认 “dev” (optional)
     * @param openapiOnly 项是否只统计经openapi调用画像报告次数，默认 false，统计的是报告的页面浏览和 2.5.3 接口调用；为 true 时，只统计 2.5.3 接口调用的次数目id (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getInsightReportUsageAsync(Long xTenant, String xEnv, Boolean openapiOnly, final ApiCallback<InlineResponse2003> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getInsightReportUsageValidateBeforeCall(xTenant, xEnv, openapiOnly, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2003>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getMaxUsableDay
     * @param xTenant 项目Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getMaxUsableDayCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getMaxUsableDay"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getMaxUsableDayValidateBeforeCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getMaxUsableDay(Async)");
        }

        com.squareup.okhttp.Call call = getMaxUsableDayCall(xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 最大可计算日期
     * 获取最大可计算日期接口
     * @param xTenant 项目Id (required)
     * @return BaseResponseWrapperLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperLong getMaxUsableDay(String xTenant) throws ApiException {
        ApiResponse<BaseResponseWrapperLong> resp = getMaxUsableDayWithHttpInfo(xTenant);
        return resp.getData();
    }


    /**
     * 最大可计算日期
     * 获取最大可计算日期接口
     * @param xTenant 项目Id (required)
     * @return ApiResponse&lt;BaseResponseWrapperLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperLong> getMaxUsableDayWithHttpInfo(String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getMaxUsableDayValidateBeforeCall(xTenant, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperLong>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 最大可计算日期 (asynchronously)
     * 获取最大可计算日期接口
     * @param xTenant 项目Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getMaxUsableDayAsync(String xTenant, final ApiCallback<BaseResponseWrapperLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getMaxUsableDayValidateBeforeCall(xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperLong>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getPortalEntityCnt
     * @param xTenant 项目Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getPortalEntityCntCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getPortalEntityCnt"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getPortalEntityCntValidateBeforeCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getPortalEntityCnt(Async)");
        }

        com.squareup.okhttp.Call call = getPortalEntityCntCall(xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 首页id数据统计
     * 首页id数据统计
     * @param xTenant 项目Id (required)
     * @return BaseResponseWrapperListPortalCountObj
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperListPortalCountObj getPortalEntityCnt(String xTenant) throws ApiException {
        ApiResponse<BaseResponseWrapperListPortalCountObj> resp = getPortalEntityCntWithHttpInfo(xTenant);
        return resp.getData();
    }


    /**
     * 首页id数据统计
     * 首页id数据统计
     * @param xTenant 项目Id (required)
     * @return ApiResponse&lt;BaseResponseWrapperListPortalCountObj&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperListPortalCountObj> getPortalEntityCntWithHttpInfo(String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getPortalEntityCntValidateBeforeCall(xTenant, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperListPortalCountObj>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 首页id数据统计 (asynchronously)
     * 首页id数据统计
     * @param xTenant 项目Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getPortalEntityCntAsync(String xTenant, final ApiCallback<BaseResponseWrapperListPortalCountObj> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getPortalEntityCntValidateBeforeCall(xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperListPortalCountObj>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getResultById
     * @param xTenant 项目Id (required)
     * @param resultId 计算结果id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getResultByIdCall(String xTenant, Integer resultId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("resultId", resultId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getResultById"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getResultByIdValidateBeforeCall(String xTenant, Integer resultId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getResultById(Async)");
        }
        // verify the required parameter 'resultId' is set
        if (resultId == null) {
            throw new ApiException("Missing the required parameter 'resultId' when calling getResultById(Async)");
        }

        com.squareup.okhttp.Call call = getResultByIdCall(xTenant, resultId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 历史查询结果
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param resultId 计算结果id (required)
     * @return BaseResponseWrapperAnalysisModuleWebResultResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public BaseResponseWrapperAnalysisModuleWebResultResp getResultById(String xTenant, Integer resultId) throws ApiException {
        ApiResponse<BaseResponseWrapperAnalysisModuleWebResultResp> resp = getResultByIdWithHttpInfo(xTenant, resultId);
        return resp.getData();
    }


    /**
     * 历史查询结果
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param resultId 计算结果id (required)
     * @return ApiResponse&lt;BaseResponseWrapperAnalysisModuleWebResultResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<BaseResponseWrapperAnalysisModuleWebResultResp> getResultByIdWithHttpInfo(String xTenant, Integer resultId) throws ApiException {
        com.squareup.okhttp.Call call = getResultByIdValidateBeforeCall(xTenant, resultId, null, null);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperAnalysisModuleWebResultResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 历史查询结果 (asynchronously)
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param resultId 计算结果id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getResultByIdAsync(String xTenant, Integer resultId, final ApiCallback<BaseResponseWrapperAnalysisModuleWebResultResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getResultByIdValidateBeforeCall(xTenant, resultId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<BaseResponseWrapperAnalysisModuleWebResultResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for listResourcesByUsage
     * @param tenantId 租户id (required)
     * @param usageType 使用CDP资源的业务场景 (required)
     * @param usageId 使用CDP资源的对应id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listResourcesByUsageCall(Integer tenantId, String usageType, String usageId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (usageType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("usage_type", usageType));
        if (usageId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("usage_id", usageId));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","listResourcesByUsage"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listResourcesByUsageValidateBeforeCall(Integer tenantId, String usageType, String usageId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling listResourcesByUsage(Async)");
        }
        // verify the required parameter 'usageType' is set
        if (usageType == null) {
            throw new ApiException("Missing the required parameter 'usageType' when calling listResourcesByUsage(Async)");
        }
        // verify the required parameter 'usageId' is set
        if (usageId == null) {
            throw new ApiException("Missing the required parameter 'usageId' when calling listResourcesByUsage(Async)");
        }

        com.squareup.okhttp.Call call = listResourcesByUsageCall(tenantId, usageType, usageId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取CDP资源情况
     * 获取举单个下游资源所使用的所有CDP资源
     * @param tenantId 租户id (required)
     * @param usageType 使用CDP资源的业务场景 (required)
     * @param usageId 使用CDP资源的对应id (required)
     * @return ListResourcesByUsageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListResourcesByUsageResponse listResourcesByUsage(Integer tenantId, String usageType, String usageId) throws ApiException {
        ApiResponse<ListResourcesByUsageResponse> resp = listResourcesByUsageWithHttpInfo(tenantId, usageType, usageId);
        return resp.getData();
    }


    /**
     * 获取CDP资源情况
     * 获取举单个下游资源所使用的所有CDP资源
     * @param tenantId 租户id (required)
     * @param usageType 使用CDP资源的业务场景 (required)
     * @param usageId 使用CDP资源的对应id (required)
     * @return ApiResponse&lt;ListResourcesByUsageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListResourcesByUsageResponse> listResourcesByUsageWithHttpInfo(Integer tenantId, String usageType, String usageId) throws ApiException {
        com.squareup.okhttp.Call call = listResourcesByUsageValidateBeforeCall(tenantId, usageType, usageId, null, null);
        Type localVarReturnType = new TypeToken<ListResourcesByUsageResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取CDP资源情况 (asynchronously)
     * 获取举单个下游资源所使用的所有CDP资源
     * @param tenantId 租户id (required)
     * @param usageType 使用CDP资源的业务场景 (required)
     * @param usageId 使用CDP资源的对应id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listResourcesByUsageAsync(Integer tenantId, String usageType, String usageId, final ApiCallback<ListResourcesByUsageResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = listResourcesByUsageValidateBeforeCall(tenantId, usageType, usageId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListResourcesByUsageResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for listUsagesByResource
     * @param tenantId 租户id (required)
     * @param resourceType CDP资源类型 (required)
     * @param resourceId CDP资源id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listUsagesByResourceCall(Integer tenantId, String resourceType, Integer resourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (resourceType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("resource_type", resourceType));
        if (resourceId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("resource_id", resourceId));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","listUsagesByResource"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listUsagesByResourceValidateBeforeCall(Integer tenantId, String resourceType, Integer resourceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling listUsagesByResource(Async)");
        }
        // verify the required parameter 'resourceType' is set
        if (resourceType == null) {
            throw new ApiException("Missing the required parameter 'resourceType' when calling listUsagesByResource(Async)");
        }
        // verify the required parameter 'resourceId' is set
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling listUsagesByResource(Async)");
        }

        com.squareup.okhttp.Call call = listUsagesByResourceCall(tenantId, resourceType, resourceId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取资源使用记录
     * 获取单个CDP资源的所有下游的使用记录
     * @param tenantId 租户id (required)
     * @param resourceType CDP资源类型 (required)
     * @param resourceId CDP资源id (required)
     * @return ListUsagesByResourceResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ListUsagesByResourceResponse listUsagesByResource(Integer tenantId, String resourceType, Integer resourceId) throws ApiException {
        ApiResponse<ListUsagesByResourceResponse> resp = listUsagesByResourceWithHttpInfo(tenantId, resourceType, resourceId);
        return resp.getData();
    }


    /**
     * 获取资源使用记录
     * 获取单个CDP资源的所有下游的使用记录
     * @param tenantId 租户id (required)
     * @param resourceType CDP资源类型 (required)
     * @param resourceId CDP资源id (required)
     * @return ApiResponse&lt;ListUsagesByResourceResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ListUsagesByResourceResponse> listUsagesByResourceWithHttpInfo(Integer tenantId, String resourceType, Integer resourceId) throws ApiException {
        com.squareup.okhttp.Call call = listUsagesByResourceValidateBeforeCall(tenantId, resourceType, resourceId, null, null);
        Type localVarReturnType = new TypeToken<ListUsagesByResourceResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取资源使用记录 (asynchronously)
     * 获取单个CDP资源的所有下游的使用记录
     * @param tenantId 租户id (required)
     * @param resourceType CDP资源类型 (required)
     * @param resourceId CDP资源id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listUsagesByResourceAsync(Integer tenantId, String resourceType, Integer resourceId, final ApiCallback<ListUsagesByResourceResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = listUsagesByResourceValidateBeforeCall(tenantId, resourceType, resourceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListUsagesByResourceResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for listChart
     * @param xTenant 项目Id (required)
     * @param domainType 模版类型 (required)
     * @param subjectId 主体ID
     * @param sourceType 来源类型
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call listChartCall(String xTenant, DomainType domainType, Integer subjectId, SourceType sourceType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("domainType", domainType.toString()));
        if (subjectId != null) {
            localVarQueryParams.add(new Pair("subjectId", subjectId.toString()));
        }
        if (sourceType != null) {
            localVarQueryParams.add(new Pair("sourceType", sourceType.toString()));
        }

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","listChart"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-12-04"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call listChartValidateBeforeCall(String xTenant, DomainType domainType, Integer subjectId, SourceType sourceType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getResultById(Async)");
        }
        // verify the required parameter 'resultId' is set
        if (domainType == null) {
            throw new ApiException("Missing the required parameter 'domainType' when calling getResultById(Async)");
        }

        com.squareup.okhttp.Call call = listChartCall(xTenant, domainType, subjectId, sourceType, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 历史查询结果
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param domainType 模版类型 (required)
     * @param subjectId 主体ID
     * @param sourceType 来源类型
     * @return BaseResponseWrapperAnalysisModuleWebResultResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseListChartResp listChart(String xTenant, DomainType domainType, Integer subjectId, SourceType sourceType) throws ApiException {
        ApiResponse<ByteDanceResponseListChartResp> resp = listChartWithHttpInfo(xTenant, domainType, subjectId, sourceType);
        return resp.getData();
    }


    /**
     * 历史查询结果
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param domainType 模版类型 (required)
     * @param subjectId 主体ID
     * @param sourceType 来源类型
     * @return ApiResponse&lt;BaseResponseWrapperAnalysisModuleWebResultResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseListChartResp> listChartWithHttpInfo(String xTenant, DomainType domainType, Integer subjectId, SourceType sourceType) throws ApiException {
        com.squareup.okhttp.Call call = listChartValidateBeforeCall(xTenant, domainType, subjectId, sourceType, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseListChartResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 历史查询结果 (asynchronously)
     * 根据查询结果id获取历史查询结果
     * @param xTenant 项目Id (required)
     * @param domainType 模版类型 (required)
     * @param subjectId 主体ID
     * @param sourceType 来源类型
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call listChartAsync(String xTenant, DomainType domainType, Integer subjectId, SourceType sourceType, final ApiCallback<BaseResponseWrapperAnalysisModuleWebResultResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = listChartValidateBeforeCall(xTenant, domainType, subjectId, sourceType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseListChartResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


}
