package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.CommonResponseConditionSegInfo;
import code.byted.cdp.model.CommonResponseManualSegInfo;
import code.byted.cdp.model.CommonResponseSetLong;
import code.byted.cdp.model.CommonResponseString;
import code.byted.cdp.model.CommonResponseUploadSegInfo;
import code.byted.cdp.model.CommonResponseVoid;
import code.byted.cdp.model.CreateConditionalSegReq;
import code.byted.cdp.model.CreatePercentUploadSegBySegIdReq;
import code.byted.cdp.model.CreatePercentUploadSegReq;
import code.byted.cdp.model.CreateTopUploadSegBySegIdReq;
import code.byted.cdp.model.CreateTopUploadSegReq;
import code.byted.cdp.model.ModifyManualSegmentReq;
import com.google.gson.reflect.TypeToken;

import java.io.File;
import java.io.IOException;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IpaasApi {

    private ApiClient apiClient;

    public IpaasApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IpaasApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for ipsCreateBlacklist
     *
     * @param xTenant                 项目id (required)
     * @param sourcePlatform          来源平台 (required)
     * @param sourceIdType            文件的IdType (required)
     * @param targetIdType            分群的IdType (required)
     * @param file                    对应的文件 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreateBlacklistCall(String xTenant, String sourcePlatform,
            String sourceIdType, String targetIdType, Boolean abaseEnabled, File file,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourcePlatform != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("sourcePlatform", sourcePlatform));
        }
        if (sourceIdType != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("sourceIdType", sourceIdType));
        }
        if (targetIdType != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("targetIdType", targetIdType));
        }
        if (abaseEnabled != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("abaseEnabled", abaseEnabled));
        }

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreateBlacklist"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }

        final String[] localVarContentTypes = {
                "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreateBlacklistValidateBeforeCall(String xTenant,
            String sourcePlatform, String sourceIdType, String targetIdType, Boolean abaseEnabled, File file,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (sourcePlatform == null) {
            throw new ApiException(
                    "Missing the required parameter 'sourcePlatform' when calling ipsCreateBlacklist(Async)");
        }
        if (sourceIdType == null) {
            throw new ApiException(
                    "Missing the required parameter 'sourceIdType' when calling ipsCreateBlacklist(Async)");
        }
        if (targetIdType == null) {
            throw new ApiException(
                    "Missing the required parameter 'targetIdType' when calling ipsCreateBlacklist(Async)");
        }
        if (abaseEnabled == null) {
            throw new ApiException(
                    "Missing the required parameter 'abaseEnabled' when calling ipsCreateBlacklist(Async)");
        }
        if (file == null) {
            throw new ApiException(
                    "Missing the required parameter 'file' when calling ipsCreateBlacklist(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreateBlacklistCall(xTenant, sourcePlatform, sourceIdType,
                targetIdType, abaseEnabled, file, progressListener, progressRequestListener);
        return call;


    }

    /**
     * 创建黑名单
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @param sourceIdType   文件的IdType (required)
     * @param targetIdType   分群的IdType (required)
     * @param abaseEnabled   是否开启在线服务 (required)
     * @param file           对应的文件 (required)
     * @return CommonResponseManualSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseManualSegInfo ipsCreateBlacklist(String xTenant, String sourcePlatform, String sourceIdType,
            String targetIdType, Boolean abaseEnabled, File file) throws ApiException {
        ApiResponse<CommonResponseManualSegInfo> resp = ipsCreateBlacklistWithHttpInfo(xTenant, sourcePlatform, sourceIdType,
                targetIdType, abaseEnabled, file);
        return resp.getData();
    }

    /**
     * 创建黑名单
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @param sourceIdType   文件的IdType (required)
     * @param targetIdType   分群的IdType (required)
     * @param file           对应的文件 (required)
     * @return ApiResponse&lt;CommonResponseManualSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseManualSegInfo> ipsCreateBlacklistWithHttpInfo(String xTenant,
            String sourcePlatform, String sourceIdType, String targetIdType, Boolean abaseEnabled, File file)
            throws ApiException {
        com.squareup.okhttp.Call call = ipsCreateBlacklistValidateBeforeCall(xTenant, sourcePlatform,
                sourceIdType, targetIdType, abaseEnabled, file, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseManualSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建黑名单 (asynchronously)
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @param sourceIdType   文件的IdType (required)
     * @param targetIdType   分群的IdType (required)
     * @param file           对应的文件 (required)
     * @param callback       The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreateBlacklistAsync(String xTenant, String sourcePlatform, String sourceIdType,
            String targetIdType, Boolean abaseEnabled, File file, final ApiCallback<CommonResponseManualSegInfo> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreateBlacklistValidateBeforeCall(xTenant, sourcePlatform,
                sourceIdType, targetIdType, abaseEnabled, file, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseManualSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsGetBlackList
     *
     * @param xTenant                 项目id (required)
     * @param sourcePlatform          来源平台 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsGetBlackListCall(String xTenant, String sourcePlatform,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (sourcePlatform != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("sourcePlatform", sourcePlatform));
        }

        localVarQueryParams.add(new Pair("ApiAction", "ipsGetBlackList"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsGetBlackListValidateBeforeCall(String xTenant,
            String sourcePlatform, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (sourcePlatform == null) {
            throw new ApiException(
                    "Missing the required parameter 'sourcePlatform' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsGetBlackListCall(xTenant, sourcePlatform, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 获取黑名单列表
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @return CommonResponseSetLong
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseSetLong ipsGetBlackList(String xTenant, String sourcePlatform) throws ApiException {
        ApiResponse<CommonResponseSetLong> resp = ipsGetBlackListWithHttpInfo(xTenant, sourcePlatform);
        return resp.getData();
    }

    /**
     * 获取黑名单列表
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @return ApiResponse&lt;CommonResponseSetLong&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseSetLong> ipsGetBlackListWithHttpInfo(String xTenant, String sourcePlatform)
            throws ApiException {
        com.squareup.okhttp.Call call = ipsGetBlackListValidateBeforeCall(xTenant, sourcePlatform, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseSetLong>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取黑名单列表 (asynchronously)
     *
     * @param xTenant        项目id (required)
     * @param sourcePlatform 来源平台 (required)
     * @param callback       The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsGetBlackListAsync(String xTenant, String sourcePlatform,
            final ApiCallback<CommonResponseSetLong> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsGetBlackListValidateBeforeCall(xTenant, sourcePlatform,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseSetLong>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsModifyBlacklistMember
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsModifyBlacklistMemberCall(String xTenant, Long segId,
            ModifyManualSegmentReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        localVarQueryParams.add(new Pair("ApiAction", "ipsModifyBlacklistMember"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }

        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsModifyBlacklistMemberValidateBeforeCall(String xTenant,
            Long segId, ModifyManualSegmentReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsModifyBlacklistMemberCall(xTenant, segId, body, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 修改黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid ipsModifyBlacklistMember(String xTenant, Long segId,
            ModifyManualSegmentReq body) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = ipsModifyBlacklistMemberWithHttpInfo(xTenant, segId, body);
        return resp.getData();
    }

    /**
     * 修改黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> ipsModifyBlacklistMemberWithHttpInfo(String xTenant,
            Long segId, ModifyManualSegmentReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsModifyBlacklistMemberValidateBeforeCall(xTenant, segId, body, null,
                null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 修改黑名单成员 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param body     请求体 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsModifyBlacklistMemberAsync(String xTenant, Long segId,
            ModifyManualSegmentReq body, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsModifyBlacklistMemberValidateBeforeCall(xTenant, segId, body,
                progressListener,
                progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsAddBlacklistMember
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param ids                     成员id (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsAddBlacklistMemberCall(String xTenant, Long segId, Set<String> ids,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ids;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        localVarQueryParams.add(new Pair("ApiAction", "ipsAddBlacklistMember"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsAddBlacklistMemberValidateBeforeCall(String xTenant, Long segId,
            Set<String> ids, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }
        if (ids == null) {
            throw new ApiException(
                    "Missing the required parameter 'ids' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsAddBlacklistMemberCall(xTenant, segId, ids, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 新增黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param ids     成员id (required)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid ipsAddBlacklistMember(String xTenant, Long segId, Set<String> ids)
            throws ApiException {
        ApiResponse<CommonResponseVoid> resp = ipsAddBlacklistMemberWithHttpInfo(xTenant, segId, ids);
        return resp.getData();
    }

    /**
     * 新增黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param ids     成员id (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> ipsAddBlacklistMemberWithHttpInfo(String xTenant, Long segId,
            Set<String> ids) throws ApiException {
        com.squareup.okhttp.Call call = ipsAddBlacklistMemberValidateBeforeCall(xTenant, segId, ids, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 新增黑名单成员 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param ids      成员id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsAddBlacklistMemberAsync(String xTenant, Long segId,
            Set<String> ids, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsAddBlacklistMemberValidateBeforeCall(xTenant, segId, ids,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsDeleteBlacklistMember
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param ids                     成员id (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsDeleteBlacklistMemberCall(String xTenant, Long segId,
            Set<String> ids, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = ids;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        localVarQueryParams.add(new Pair("ApiAction", "ipsDeleteBlacklistMember"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }

        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsDeleteBlacklistMemberValidateBeforeCall(String xTenant,
            Long segId, Set<String> ids, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }
        if (ids == null) {
            throw new ApiException(
                    "Missing the required parameter 'ids' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsDeleteBlacklistMemberCall(xTenant, segId, ids, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 删除黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param ids     成员id (required)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid ipsDeleteBlacklistMember(String xTenant, Long segId, Set<String> ids)
            throws ApiException {
        ApiResponse<CommonResponseVoid> resp = ipsDeleteBlacklistMemberWithHttpInfo(xTenant, segId, ids);
        return resp.getData();
    }

    /**
     * 删除黑名单成员
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param ids     成员id (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> ipsDeleteBlacklistMemberWithHttpInfo(String xTenant,
            Long segId, Set<String> ids) throws ApiException {
        com.squareup.okhttp.Call call = ipsDeleteBlacklistMemberValidateBeforeCall(xTenant, segId, ids, null,
                null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除黑名单成员 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param ids      成员id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsDeleteBlacklistMemberAsync(String xTenant, Long segId,
            Set<String> ids, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsDeleteBlacklistMemberValidateBeforeCall(xTenant, segId, ids,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for ipsReplayBlacklist
     *
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsReplayBlacklistCall(final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsReplayBlacklist"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsReplayBlacklistValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        com.squareup.okhttp.Call call = ipsReplayBlacklistCall(progressListener, progressRequestListener);
        return call;


    }

    /**
     * 重跑黑名单分群
     *
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid ipsReplayBlacklist()
            throws ApiException {
        ApiResponse<CommonResponseVoid> resp = ipsReplayBlacklistWithHttpInfo();
        return resp.getData();
    }

    /**
     * 重跑黑名单分群
     *
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> ipsReplayBlacklistWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = ipsReplayBlacklistValidateBeforeCall(null,null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 重跑黑名单分群 (asynchronously)
     *
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsReplayBlacklistAsync(final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsReplayBlacklistValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsCreateConditionalSegmentation
     *
     * @param xTenant                 项目id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreateConditionalSegmentationCall(String xTenant,
            CreateConditionalSegReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreateConditionalSegmentation"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreateConditionalSegmentationValidateBeforeCall(String xTenant,
            CreateConditionalSegReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreateConditionalSegmentationCall(xTenant, body, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 创建规则分群
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return ConditionalSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseConditionSegInfo ipsCreateConditionalSegmentation(String xTenant, CreateConditionalSegReq body)
            throws ApiException {
        ApiResponse<CommonResponseConditionSegInfo> resp = ipsCreateConditionalSegmentationWithHttpInfo(xTenant, body);
        return resp.getData();
    }

    /**
     * 创建规则分群
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;ConditionalSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseConditionSegInfo> ipsCreateConditionalSegmentationWithHttpInfo(String xTenant,
            CreateConditionalSegReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsCreateConditionalSegmentationValidateBeforeCall(xTenant, body, null,
                null);
        Type localVarReturnType = new TypeToken<CommonResponseConditionSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建规则分群 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param body     请求题 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreateConditionalSegmentationAsync(String xTenant,
            CreateConditionalSegReq body, final ApiCallback<CommonResponseConditionSegInfo> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreateConditionalSegmentationValidateBeforeCall(xTenant, body,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseConditionSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsCreatePercentUploadSegmentation
     *
     * @param xTenant                 项目id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationCall(String xTenant,
            CreatePercentUploadSegReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreatePercentUploadSegmentation"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }

        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationValidateBeforeCall(String xTenant,
            CreatePercentUploadSegReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationCall(xTenant, body, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 百分比抽样创建上传分群（基于圈选规则）
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return UploadSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseUploadSegInfo ipsCreatePercentUploadSegmentation(String xTenant,
            CreatePercentUploadSegReq body) throws ApiException {
        ApiResponse<CommonResponseUploadSegInfo> resp = ipsCreatePercentUploadSegmentationWithHttpInfo(xTenant, body);
        return resp.getData();
    }

    /**
     * 百分比抽样创建上传分群（基于圈选规则）
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;UploadSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseUploadSegInfo> ipsCreatePercentUploadSegmentationWithHttpInfo(String xTenant,
            CreatePercentUploadSegReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationValidateBeforeCall(xTenant, body, null,
                null);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 百分比抽样创建上传分群（基于圈选规则）(asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param body     请求题 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationAsync(String xTenant,
            CreatePercentUploadSegReq body, final ApiCallback<CommonResponseUploadSegInfo> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationValidateBeforeCall(xTenant, body,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsCreatePercentUploadSegmentationBySegId
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationBySegIdCall(String xTenant,
            Long segId, CreatePercentUploadSegBySegIdReq body,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreatePercentUploadSegmentationBySegId"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationBySegIdValidateBeforeCall(String xTenant,
            Long segId, CreatePercentUploadSegBySegIdReq body,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationBySegIdCall(xTenant, segId, body,
                progressListener, progressRequestListener);
        return call;


    }

    /**
     * 百分比抽样创建上传分群（基于一个已有的非实时分群）
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return UploadSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseUploadSegInfo ipsCreatePercentUploadSegmentationBySegId(String xTenant, Long segId,
            CreatePercentUploadSegBySegIdReq body) throws ApiException {
        ApiResponse<CommonResponseUploadSegInfo> resp = ipsCreatePercentUploadSegmentationBySegIdWithHttpInfo(xTenant,
                segId, body);
        return resp.getData();
    }

    /**
     * 百分比抽样创建上传分群（基于一个已有的非实时分群）
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;UploadSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseUploadSegInfo> ipsCreatePercentUploadSegmentationBySegIdWithHttpInfo(
            String xTenant, Long segId, CreatePercentUploadSegBySegIdReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationBySegIdValidateBeforeCall(xTenant,
                segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 百分比抽样创建上传分群（基于一个已有的非实时分群）(asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param body     请求题 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreatePercentUploadSegmentationBySegIdAsync(String xTenant, Long segId,
            CreatePercentUploadSegBySegIdReq body, final ApiCallback<CommonResponseUploadSegInfo> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreatePercentUploadSegmentationBySegIdValidateBeforeCall(xTenant, segId,
                body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for ipsCreateTopUploadSegmentation
     *
     * @param xTenant                 项目id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreateTopUploadSegmentationCall(String xTenant, CreateTopUploadSegReq body,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreateTopUploadSegmentation"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreateTopUploadSegmentationValidateBeforeCall(String xTenant,
            CreateTopUploadSegReq body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationCall(xTenant, body, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * TOP排序创建上传分群（基于圈选规则）
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return UploadSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseUploadSegInfo ipsCreateTopUploadSegmentation(String xTenant, CreateTopUploadSegReq body)
            throws ApiException {
        ApiResponse<CommonResponseUploadSegInfo> resp = ipsCreateTopUploadSegmentationWithHttpInfo(xTenant, body);
        return resp.getData();
    }

    /**
     * TOP排序创建上传分群（基于圈选规则）
     *
     * @param xTenant 项目id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;UploadSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseUploadSegInfo> ipsCreateTopUploadSegmentationWithHttpInfo(String xTenant,
            CreateTopUploadSegReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationValidateBeforeCall(xTenant, body, null,
                null);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * TOP排序创建上传分群（基于圈选规则）(asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param body     请求题 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreateTopUploadSegmentationAsync(String xTenant, CreateTopUploadSegReq body,
            final ApiCallback<CommonResponseUploadSegInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationValidateBeforeCall(xTenant, body,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for createTopUploadSegmentationBySegId
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param body                    请求体 (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsCreateTopUploadSegmentationBySegIdCall(String xTenant, Long segId,
            CreateTopUploadSegBySegIdReq body,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsCreateTopUploadSegmentationBySegId"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsCreateTopUploadSegmentationBySegIdValidateBeforeCall(String xTenant,
            Long segId, CreateTopUploadSegBySegIdReq body,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }
        if (body == null) {
            throw new ApiException(
                    "Missing the required parameter 'body' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationBySegIdCall(xTenant, segId, body,
                progressListener, progressRequestListener);
        return call;


    }

    /**
     * TOP排序创建上传分群（基于一个已有的非实时分群）
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return UploadSegInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseUploadSegInfo ipsCreateTopUploadSegmentationBySegId(String xTenant, Long segId,
            CreateTopUploadSegBySegIdReq body) throws ApiException {
        ApiResponse<CommonResponseUploadSegInfo> resp = ipsCreateTopUploadSegmentationBySegIdWithHttpInfo(xTenant,
                segId, body);
        return resp.getData();
    }

    /**
     * TOP排序创建上传分群（基于一个已有的非实时分群）
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @param body    请求体 (required)
     * @return ApiResponse&lt;UploadSegInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseUploadSegInfo> ipsCreateTopUploadSegmentationBySegIdWithHttpInfo(String xTenant,
            Long segId, CreateTopUploadSegBySegIdReq body) throws ApiException {
        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationBySegIdValidateBeforeCall(xTenant,
                segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * TOP排序创建上传分群（基于一个已有的非实时分群）(asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param body     请求题 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsCreateTopUploadSegmentationBySegIdAsync(String xTenant, Long segId,
            CreateTopUploadSegBySegIdReq body, final ApiCallback<CommonResponseUploadSegInfo> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsCreateTopUploadSegmentationBySegIdValidateBeforeCall(xTenant, segId,
                body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseUploadSegInfo>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


    /**
     * Build call for getSegmentStatus
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsGetSegmentStatusCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsGetSegmentStatus"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsGetSegmentStatusValidateBeforeCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsGetSegmentStatusCall(xTenant, segId, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 查看分群状态
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return CommonResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseString ipsGetSegmentStatus(String xTenant, Long segId) throws ApiException {
        ApiResponse<CommonResponseString> resp = ipsGetSegmentStatusWithHttpInfo(xTenant, segId);
        return resp.getData();
    }

    /**
     * 查看分群状态
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return ApiResponse&lt;CommonResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseString> ipsGetSegmentStatusWithHttpInfo(String xTenant, Long segId)
            throws ApiException {
        com.squareup.okhttp.Call call = ipsGetSegmentStatusValidateBeforeCall(xTenant, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseString>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查看分群状态 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsGetSegmentStatusAsync(String xTenant, Long segId,
            final ApiCallback<CommonResponseString> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsGetSegmentStatusValidateBeforeCall(xTenant, segId, progressListener,
                progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseString>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for deleteSegmentation
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsDeleteSegmentationCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsDeleteSegmentation"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsDeleteSegmentationValidateBeforeCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsDeleteSegmentationCall(xTenant, segId, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 删除分群
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return CommonResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid ipsDeleteSegmentation(String xTenant, Long segId) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = ipsDeleteSegmentationWithHttpInfo(xTenant, segId);
        return resp.getData();
    }

    /**
     * 删除分群
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> ipsDeleteSegmentationWithHttpInfo(String xTenant, Long segId)
            throws ApiException {
        com.squareup.okhttp.Call call = ipsDeleteSegmentationValidateBeforeCall(xTenant, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除分群 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsDeleteSegmentationAsync(String xTenant, Long segId,
            final ApiCallback<CommonResponseVoid> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsDeleteSegmentationValidateBeforeCall(xTenant, segId, progressListener,
                progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for refreshSegmentation
     *
     * @param xTenant                 项目id (required)
     * @param segId                   分群id (required)
     * @param progressListener        Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call ipsRefreshSegmentationCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("ApiAction", "ipsRefreshSegmentation"));
        localVarQueryParams.add(new Pair("ApiVersion", "2024-07-26"));
        if (segId != null) {
            localVarQueryParams.addAll(apiClient.parameterToPair("segId", segId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (xTenant != null) {
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));
        }
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain)
                        throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[]{};
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call ipsRefreshSegmentationValidateBeforeCall(String xTenant, Long segId,
            final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xTenant == null) {
            throw new ApiException(
                    "Missing the required parameter 'xTenant' when calling ipsGetBlackList(Async)");
        }
        if (segId == null) {
            throw new ApiException(
                    "Missing the required parameter 'segId' when calling ipsGetBlackList(Async)");
        }

        com.squareup.okhttp.Call call = ipsRefreshSegmentationCall(xTenant, segId, progressListener,
                progressRequestListener);
        return call;


    }

    /**
     * 更新单个分群包
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return CommonResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseString ipsRefreshSegmentation(String xTenant, Long segId) throws ApiException {
        ApiResponse<CommonResponseString> resp = ipsRefreshSegmentationWithHttpInfo(xTenant, segId);
        return resp.getData();
    }

    /**
     * 更新单个分群包
     *
     * @param xTenant 项目id (required)
     * @param segId   分群id (required)
     * @return ApiResponse&lt;CommonResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseString> ipsRefreshSegmentationWithHttpInfo(String xTenant, Long segId)
            throws ApiException {
        com.squareup.okhttp.Call call = ipsRefreshSegmentationValidateBeforeCall(xTenant, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseString>() {
        }.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新单个分群包 (asynchronously)
     *
     * @param xTenant  项目id (required)
     * @param segId    分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call ipsRefreshSegmentationAsync(String xTenant, Long segId,
            final ApiCallback<CommonResponseString> callback)
            throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = ipsRefreshSegmentationValidateBeforeCall(xTenant, segId, progressListener,
                progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseString>() {
        }.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }


}