/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.BatchGetSegsRequest;
import code.byted.cdp.model.ByteDanceResponseBatchRefreshResponse;
import code.byted.cdp.model.SegPreviewRequest;
import code.byted.cdp.model.ServiceRespBitmapPreviewOpenApiResponse;
import code.byted.cdp.model.UploadSegUpdateRequest;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.ByteDanceResponseLegacySegOpenApiInfoResponse;
import code.byted.cdp.model.ByteDanceResponsePageResponseSegInnerResponse;
import code.byted.cdp.model.ByteDanceResponseRecordSegShardInfoResp;
import code.byted.cdp.model.ByteDanceResponseSegInnerResponse;
import code.byted.cdp.model.ByteDanceResponseSegmentationListResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableReq;
import code.byted.cdp.model.ByteDanceResponseSegmentationOnlineServiceEnableResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationRefreshResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationResp;
import code.byted.cdp.model.ByteDanceResponseSegmentationUploadResp;
import code.byted.cdp.model.CommonResponse;
import code.byted.cdp.model.CommonResponseVoid;
import code.byted.cdp.model.DslCheckResp;
import code.byted.cdp.model.DslReq;
import java.io.File;
import code.byted.cdp.model.LegacyCopySegmentRequest;
import code.byted.cdp.model.LegacyManualSegCreateRequest;
import code.byted.cdp.model.LegacyManualSegUpdateRequest;
import code.byted.cdp.model.LegacyUploadedSegCreateRequest;
import code.byted.cdp.model.ModifySegUpdateStrategyInnerRequest;
import code.byted.cdp.model.PreviewResp;
import code.byted.cdp.model.SegmentListRequest;
import code.byted.cdp.model.SimplifiedSegCreateOrUpdateRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SegmentationApi {
    private ApiClient apiClient;

    public SegmentationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for batchRefreshSegs
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call batchRefreshSegsCall(String xTenant, BatchGetSegsRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","batchRefreshSegs"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call batchRefreshSegsValidateBeforeCall(String xTenant, BatchGetSegsRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling batchRefreshSegs(Async)");
        }

        com.squareup.okhttp.Call call = batchRefreshSegsCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 按依赖分群批量重跑
     * 按依赖分群批量重跑
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ByteDanceResponseBatchRefreshResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseBatchRefreshResponse batchRefreshSegs(String xTenant, BatchGetSegsRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseBatchRefreshResponse> resp = batchRefreshSegsWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 按依赖分群批量重跑
     * 按依赖分群批量重跑
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponseBatchRefreshResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseBatchRefreshResponse> batchRefreshSegsWithHttpInfo(String xTenant, BatchGetSegsRequest body) throws ApiException {
        com.squareup.okhttp.Call call = batchRefreshSegsValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseBatchRefreshResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 按依赖分群批量重跑 (asynchronously)
     * 按依赖分群批量重跑
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call batchRefreshSegsAsync(String xTenant, BatchGetSegsRequest body, final ApiCallback<ByteDanceResponseBatchRefreshResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = batchRefreshSegsValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseBatchRefreshResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for previewAsset
     * @param body  (required)
     * @param tenant 租户id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call previewAssetCall(SegPreviewRequest body, String tenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenant", tenant.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","previewAsset"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call previewAssetValidateBeforeCall(SegPreviewRequest body, String tenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewAsset(Async)");
        }
        // verify the required parameter 'tenant' is set
        if (tenant == null) {
            throw new ApiException("Missing the required parameter 'tenant' when calling previewAsset(Async)");
        }

        com.squareup.okhttp.Call call = previewAssetCall(body, tenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 资产预估接口
     * 资产预估接口，目前只支持分群
     * @param body  (required)
     * @param tenant 租户id (required)
     * @return ServiceRespBitmapPreviewOpenApiResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ServiceRespBitmapPreviewOpenApiResponse previewAsset(SegPreviewRequest body, String tenant) throws ApiException {
        ApiResponse<ServiceRespBitmapPreviewOpenApiResponse> resp = previewAssetWithHttpInfo(body, tenant);
        return resp.getData();
    }

    /**
     * 资产预估接口
     * 资产预估接口，目前只支持分群
     * @param body  (required)
     * @param tenant 租户id (required)
     * @return ApiResponse&lt;ServiceRespBitmapPreviewOpenApiResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ServiceRespBitmapPreviewOpenApiResponse> previewAssetWithHttpInfo(SegPreviewRequest body, String tenant) throws ApiException {
        com.squareup.okhttp.Call call = previewAssetValidateBeforeCall(body, tenant, null, null);
        Type localVarReturnType = new TypeToken<ServiceRespBitmapPreviewOpenApiResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 资产预估接口 (asynchronously)
     * 资产预估接口，目前只支持分群
     * @param body  (required)
     * @param tenant 租户id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call previewAssetAsync(SegPreviewRequest body, String tenant, final ApiCallback<ServiceRespBitmapPreviewOpenApiResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = previewAssetValidateBeforeCall(body, tenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ServiceRespBitmapPreviewOpenApiResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for copySegment
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copySegmentCall(Long xTenant, LegacyCopySegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","copySegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copySegmentValidateBeforeCall(Long xTenant, LegacyCopySegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling copySegment(Async)");
        }

        com.squareup.okhttp.Call call = copySegmentCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 复制人群包
     * 根据现有的规则人群复制人群包【只支持规则人群】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ByteDanceResponseLegacySegOpenApiInfoResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseLegacySegOpenApiInfoResponse copySegment(Long xTenant, LegacyCopySegmentRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseLegacySegOpenApiInfoResponse> resp = copySegmentWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 复制人群包
     * 根据现有的规则人群复制人群包【只支持规则人群】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponseLegacySegOpenApiInfoResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseLegacySegOpenApiInfoResponse> copySegmentWithHttpInfo(Long xTenant, LegacyCopySegmentRequest body) throws ApiException {
        com.squareup.okhttp.Call call = copySegmentValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseLegacySegOpenApiInfoResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 复制人群包 (asynchronously)
     * 根据现有的规则人群复制人群包【只支持规则人群】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call copySegmentAsync(Long xTenant, LegacyCopySegmentRequest body, final ApiCallback<ByteDanceResponseLegacySegOpenApiInfoResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = copySegmentValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseLegacySegOpenApiInfoResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createConditionalSegment
     * @param tenantId 租户Code (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createConditionalSegmentCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createConditionalSegmentValidateBeforeCall(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling createConditionalSegment(Async)");
        }

        com.squareup.okhttp.Call call = createConditionalSegmentCall(tenantId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建离线规则分群接口
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param body  (optional)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp createConditionalSegment(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = createConditionalSegmentWithHttpInfo(tenantId, body);
        return resp.getData();
    }


    /**
     * 创建离线规则分群接口
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> createConditionalSegmentWithHttpInfo(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = createConditionalSegmentValidateBeforeCall(tenantId, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建离线规则分群接口 (asynchronously)
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createConditionalSegmentAsync(Integer tenantId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createConditionalSegmentValidateBeforeCall(tenantId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for downloadSegFile
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (optional)
     * @param needEncrypt 是否需要AES加密，默认否（AES密钥在idmapping页面管理） (optional)
     * @param filterSuccess 是否过滤结果为成功的数据，默认为false，不过滤 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadSegFileCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, Boolean filterSuccess, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (formatType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("formatType", formatType));
        if (needEncrypt != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("needEncrypt", needEncrypt));
        if (filterSuccess != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("filterSuccess", filterSuccess));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","downloadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadSegFileValidateBeforeCall(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, Boolean filterSuccess, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling downloadSegFile(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling downloadSegFile(Async)");
        }

        com.squareup.okhttp.Call call = downloadSegFileCall(tenantId, segId, formatType, needEncrypt, filterSuccess, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 下载分群包
     * 根据租户code和分群包id下载对应分群包数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (optional)
     * @param needEncrypt 是否需要AES加密，默认否（AES密钥在idmapping页面管理） (optional)
     * @param filterSuccess 是否过滤结果为成功的数据，默认为false，不过滤 (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File downloadSegFile(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, Boolean filterSuccess) throws ApiException {
        ApiResponse<File> resp = downloadSegFileWithHttpInfo(tenantId, segId, formatType, needEncrypt, filterSuccess);
        return resp.getData();
    }
    public File downloadSegFile(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt) throws ApiException {
        ApiResponse<File> resp = downloadSegFileWithHttpInfo(tenantId, segId, formatType, needEncrypt, false);
        return resp.getData();
    }


    /**
     * 下载分群包
     * 根据租户code和分群包id下载对应分群包数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (optional)
     * @param needEncrypt 是否需要AES加密，默认否（AES密钥在idmapping页面管理） (optional)
     * @param filterSuccess 是否过滤结果为成功的数据，默认为false，不过滤 (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> downloadSegFileWithHttpInfo(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, Boolean filterSuccess) throws ApiException {
        com.squareup.okhttp.Call call = downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, filterSuccess, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();

        String[] localVarAccepts = {
            "application/octet-stream", "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 下载分群包 (asynchronously)
     * 根据租户code和分群包id下载对应分群包数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param formatType 文件格式，GZ, TXT, CSV 可选 (optional)
     * @param needEncrypt 是否需要AES加密，默认否（AES密钥在idmapping页面管理） (optional)
     * @param filterSuccess 是否过滤结果为成功的数据，默认为false，不过滤 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call downloadSegFileAsync(Integer tenantId, Integer segId, String formatType, Boolean needEncrypt, Boolean filterSuccess, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/octet-stream", "application/json"
        };

        com.squareup.okhttp.Call call = downloadSegFileValidateBeforeCall(tenantId, segId, formatType, needEncrypt, filterSuccess, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for dslCheck
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call dslCheckCall(DslReq body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","dslCheck"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call dslCheckValidateBeforeCall(DslReq body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling dslCheck(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling dslCheck(Async)");
        }

        com.squareup.okhttp.Call call = dslCheckCall(body, tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群规则校验接口
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return DslCheckResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DslCheckResp dslCheck(DslReq body, String tenantCode) throws ApiException {
        ApiResponse<DslCheckResp> resp = dslCheckWithHttpInfo(body, tenantCode);
        return resp.getData();
    }


    /**
     * 分群规则校验接口
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;DslCheckResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DslCheckResp> dslCheckWithHttpInfo(DslReq body, String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = dslCheckValidateBeforeCall(body, tenantCode, null, null);
        Type localVarReturnType = new TypeToken<DslCheckResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群规则校验接口 (asynchronously)
     * 简化创建离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call dslCheckAsync(DslReq body, String tenantCode, final ApiCallback<DslCheckResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = dslCheckValidateBeforeCall(body, tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DslCheckResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getSegment
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSegmentCall(String xTenant, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSegmentValidateBeforeCall(String xTenant, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling getSegment(Async)");
        }

        com.squareup.okhttp.Call call = getSegmentCall(xTenant, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群详情查询
     * 查看分群详情
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @return ByteDanceResponseSegInnerResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegInnerResponse getSegment(String xTenant, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegInnerResponse> resp = getSegmentWithHttpInfo(xTenant, segId);
        return resp.getData();
    }


    /**
     * 分群详情查询
     * 查看分群详情
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;ByteDanceResponseSegInnerResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegInnerResponse> getSegmentWithHttpInfo(String xTenant, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = getSegmentValidateBeforeCall(xTenant, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegInnerResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群详情查询 (asynchronously)
     * 查看分群详情
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSegmentAsync(String xTenant, Integer segId, final ApiCallback<ByteDanceResponseSegInnerResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getSegmentValidateBeforeCall(xTenant, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegInnerResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getSegmentListV2
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getSegmentListV2Call(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getSegmentListV2"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getSegmentListV2ValidateBeforeCall(String xTenant, SegmentListRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getSegmentListV2(Async)");
        }

        com.squareup.okhttp.Call call = getSegmentListV2Call(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群列表V2
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ByteDanceResponsePageResponseSegInnerResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponsePageResponseSegInnerResponse getSegmentListV2(String xTenant, SegmentListRequest body) throws ApiException {
        ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> resp = getSegmentListV2WithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 分群列表V2
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;ByteDanceResponsePageResponseSegInnerResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponsePageResponseSegInnerResponse> getSegmentListV2WithHttpInfo(String xTenant, SegmentListRequest body) throws ApiException {
        com.squareup.okhttp.Call call = getSegmentListV2ValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群列表V2 (asynchronously)
     * 拉取分群列表
     * @param xTenant 项目id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getSegmentListV2Async(String xTenant, SegmentListRequest body, final ApiCallback<ByteDanceResponsePageResponseSegInnerResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getSegmentListV2ValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponsePageResponseSegInnerResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyCreateManualSegment
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyCreateManualSegmentCall(LegacyManualSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyCreateManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyCreateManualSegmentValidateBeforeCall(LegacyManualSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateManualSegment(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateManualSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyCreateManualSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 人工分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp legacyCreateManualSegment(LegacyManualSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = legacyCreateManualSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }

    public ByteDanceResponseSegmentationResp legacyCreateManualSegment(Integer tenantId, LegacyManualSegCreateRequest body) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = legacyCreateManualSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 人工分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> legacyCreateManualSegmentWithHttpInfo(LegacyManualSegCreateRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = legacyCreateManualSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 人工分群包-导入 (asynchronously)
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyCreateManualSegmentAsync(LegacyManualSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = legacyCreateManualSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyCreateUploadSegment
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyCreateUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyCreateUploadSegmentValidateBeforeCall(LegacyUploadedSegCreateRequest body, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling legacyCreateUploadSegment(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyCreateUploadSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentCall(body, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseRecordSegShardInfoResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseRecordSegShardInfoResp legacyCreateUploadSegment(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseRecordSegShardInfoResp> resp = legacyCreateUploadSegmentWithHttpInfo(body, tenantId);
        return resp.getData();
    }


    /**
     * 上传分群包-导入
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseRecordSegShardInfoResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseRecordSegShardInfoResp> legacyCreateUploadSegmentWithHttpInfo(LegacyUploadedSegCreateRequest body, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传分群包-导入 (asynchronously)
     * 从hdfs导入成分群包
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyCreateUploadSegmentAsync(LegacyUploadedSegCreateRequest body, Integer tenantId, final ApiCallback<ByteDanceResponseRecordSegShardInfoResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyCreateUploadSegmentValidateBeforeCall(body, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseRecordSegShardInfoResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyDeleteSegment
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyDeleteSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyDeleteSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyDeleteSegmentValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyDeleteSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyDeleteSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyDeleteSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除单个分群包
     * 删除指定分群包
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid legacyDeleteSegment(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = legacyDeleteSegmentWithHttpInfo(tenantId, segId);
        return resp.getData();
    }


    /**
     * 删除单个分群包
     * 删除指定分群包
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> legacyDeleteSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = legacyDeleteSegmentValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除单个分群包 (asynchronously)
     * 删除指定分群包
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyDeleteSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = legacyDeleteSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyGetSegment
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyGetSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyGetSegmentValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyGetSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyGetSegmentCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询单个分群包详细信息
     * 根据各种参数筛选获取分群包列表
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ByteDanceResponseSegmentationResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationResp legacyGetSegment(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationResp> resp = legacyGetSegmentWithHttpInfo(tenantId, segId);
        return resp.getData();
    }


    /**
     * 查询单个分群包详细信息
     * 根据各种参数筛选获取分群包列表
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationResp> legacyGetSegmentWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = legacyGetSegmentValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询单个分群包详细信息 (asynchronously)
     * 根据各种参数筛选获取分群包列表
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyGetSegmentValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyGetSegmentList
     * @param tenantId 租户Code (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param domainType 公私域类型 (optional)
     * @param viewer 查看人，需要 admin 身份调用才能生效 (optional)
     * @param segIds 分群id，逗号分隔 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentListCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, String domainType, String viewer, String segIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (current != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("current", current));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (isSelfSee != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isSelfSee", isSelfSee));
        if (isOnlySourceReady != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isOnlySourceReady", isOnlySourceReady));
        if (idType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("idType", idType));
        if (segTypes != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("segTypes", segTypes));
        if (sourcePlatform != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sourcePlatform", sourcePlatform));
        if (isAbaseAvailable != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isAbaseAvailable", isAbaseAvailable));
        if (isAbaseEnabled != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("isAbaseEnabled", isAbaseEnabled));
        if (domainType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("domainType", domainType));
        if (viewer != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("viewer", viewer));
        if (segIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("segIds", segIds));

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyGetSegmentList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyGetSegmentListValidateBeforeCall(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, String domainType, String viewer, String segIds, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyGetSegmentList(Async)");
        }

        com.squareup.okhttp.Call call = legacyGetSegmentListCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, domainType, viewer, segIds, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取分群包列表
     * 根据各种参数筛选获取分群包列表,（1.17不返回子包信息,1.18会返回子包信息）
     * @param tenantId 租户Code (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param domainType 公私域类型 (optional)
     * @param viewer 查看人，需要 admin 身份调用才能生效 (optional)
     * @param segIds 分群id，逗号分隔 (optional)
     * @return ByteDanceResponseSegmentationListResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationListResp legacyGetSegmentList(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, String domainType, String viewer, String segIds) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationListResp> resp = legacyGetSegmentListWithHttpInfo(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, domainType, viewer, segIds);
        return resp.getData();
    }

    public ByteDanceResponseSegmentationListResp legacyGetSegmentList(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationListResp> resp = legacyGetSegmentListWithHttpInfo(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, null, null, null);
        return resp.getData();
    }


    /**
     * 获取分群包列表
     * 根据各种参数筛选获取分群包列表,（1.17不返回子包信息,1.18会返回子包信息）
     * @param tenantId 租户Code (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param domainType 公私域类型 (optional)
     * @param viewer 查看人，需要 admin 身份调用才能生效 (optional)
     * @param segIds 分群id，逗号分隔 (optional)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationListResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationListResp> legacyGetSegmentListWithHttpInfo(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, String domainType, String viewer, String segIds) throws ApiException {
        com.squareup.okhttp.Call call = legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, domainType, viewer, segIds, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取分群包列表 (asynchronously)
     * 根据各种参数筛选获取分群包列表,（1.17不返回子包信息,1.18会返回子包信息）
     * @param tenantId 租户Code (required)
     * @param current 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词，模糊搜索分群名称和创建人 (optional)
     * @param isSelfSee 是否只看自己创建的 (optional)
     * @param isOnlySourceReady 是否分群就绪的（文件+洞察） (optional)
     * @param idType 实体类型code (optional)
     * @param segTypes 分群类型，逗号分隔，多选 (optional)
     * @param sourcePlatform 来源平台 (optional)
     * @param isAbaseAvailable 筛选在线服务是否可用 (optional)
     * @param isAbaseEnabled 筛选在线服务配置开启 (optional)
     * @param domainType 公私域类型 (optional)
     * @param viewer 查看人，需要 admin 身份调用才能生效 (optional)
     * @param segIds 分群id，逗号分隔 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyGetSegmentListAsync(Integer tenantId, Integer current, Integer pageSize, String keyword, Boolean isSelfSee, Boolean isOnlySourceReady, String idType, String segTypes, String sourcePlatform, Boolean isAbaseAvailable, Boolean isAbaseEnabled, String domainType, String viewer, String segIds, final ApiCallback<ByteDanceResponseSegmentationListResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = legacyGetSegmentListValidateBeforeCall(tenantId, current, pageSize, keyword, isSelfSee, isOnlySourceReady, idType, segTypes, sourcePlatform, isAbaseAvailable, isAbaseEnabled, domainType, viewer, segIds, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationListResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for legacyModifyManualSegment
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentCall(Integer tenantId, Integer segId, LegacyManualSegUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyModifyManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyModifyManualSegmentValidateBeforeCall(Integer tenantId, Integer segId, LegacyManualSegUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyModifyManualSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyModifyManualSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyModifyManualSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 人工分群包-修改
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid legacyModifyManualSegment(Integer tenantId, Integer segId, LegacyManualSegUpdateRequest body) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = legacyModifyManualSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }


    /**
     * 人工分群包-修改
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> legacyModifyManualSegmentWithHttpInfo(Integer tenantId, Integer segId, LegacyManualSegUpdateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 人工分群包-修改 (asynchronously)
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentAsync(Integer tenantId, Integer segId, LegacyManualSegUpdateRequest body, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for legacyModifyManualSegment
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","legacyModifyManualSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call legacyModifyManualSegmentValidateBeforeCall(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ProgressResponseBody.ProgressListener progressListener,
            final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling legacyModifyManualSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling legacyModifyManualSegment(Async)");
        }

        com.squareup.okhttp.Call call = legacyModifyManualSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;
    }

    /**
     * 人工分群包-修改
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid legacyModifyManualSegment(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = legacyModifyManualSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }


    /**
     * 人工分群包-修改
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> legacyModifyManualSegmentWithHttpInfo(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 人工分群包-修改 (asynchronously)
     * 修改人工分群
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call legacyModifyManualSegmentAsync(Integer tenantId, Integer segId, LegacyManualSegCreateRequest body, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = legacyModifyManualSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for modifyConditionalSegment
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modifyConditionalSegmentCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","modifyConditionalSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modifyConditionalSegmentValidateBeforeCall(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyConditionalSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyConditionalSegment(Async)");
        }

        com.squareup.okhttp.Call call = modifyConditionalSegmentCall(tenantId, segId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 编辑离线规则分群接口
     * 编辑离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return CommonResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponse modifyConditionalSegment(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        ApiResponse<CommonResponse> resp = modifyConditionalSegmentWithHttpInfo(tenantId, segId, body);
        return resp.getData();
    }


    /**
     * 编辑离线规则分群接口
     * 编辑离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponse> modifyConditionalSegmentWithHttpInfo(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body) throws ApiException {
        com.squareup.okhttp.Call call = modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 编辑离线规则分群接口 (asynchronously)
     * 编辑离线规则分群接口，包含：id 类型，规则dsl，更新频率，名称
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modifyConditionalSegmentAsync(Integer tenantId, Integer segId, SimplifiedSegCreateOrUpdateRequest body, final ApiCallback<CommonResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = modifyConditionalSegmentValidateBeforeCall(tenantId, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for modifySegUpdateStrategy
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modifySegUpdateStrategyCall(String xTenant, Integer segId, ModifySegUpdateStrategyInnerRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","modifySegUpdateStrategy"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modifySegUpdateStrategyValidateBeforeCall(String xTenant, Integer segId, ModifySegUpdateStrategyInnerRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling modifySegUpdateStrategy(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifySegUpdateStrategy(Async)");
        }

        com.squareup.okhttp.Call call = modifySegUpdateStrategyCall(xTenant, segId, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 设置分群更新周期
     * 设置分群更新周期
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return CommonResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponse modifySegUpdateStrategy(String xTenant, Integer segId, ModifySegUpdateStrategyInnerRequest body) throws ApiException {
        ApiResponse<CommonResponse> resp = modifySegUpdateStrategyWithHttpInfo(xTenant, segId, body);
        return resp.getData();
    }


    /**
     * 设置分群更新周期
     * 设置分群更新周期
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponse> modifySegUpdateStrategyWithHttpInfo(String xTenant, Integer segId, ModifySegUpdateStrategyInnerRequest body) throws ApiException {
        com.squareup.okhttp.Call call = modifySegUpdateStrategyValidateBeforeCall(xTenant, segId, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 设置分群更新周期 (asynchronously)
     * 设置分群更新周期
     * @param xTenant 项目id (required)
     * @param segId 分群id (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modifySegUpdateStrategyAsync(String xTenant, Integer segId, ModifySegUpdateStrategyInnerRequest body, final ApiCallback<CommonResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = modifySegUpdateStrategyValidateBeforeCall(xTenant, segId, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for previewDSL
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call previewDSLCall(DslReq body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","previewDSL"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call previewDSLValidateBeforeCall(DslReq body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling previewDSL(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling previewDSL(Async)");
        }

        com.squareup.okhttp.Call call = previewDSLCall(body, tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 分群预估接口
     * 查询服务圈选预估
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return PreviewResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public PreviewResp previewDSL(DslReq body, String tenantCode) throws ApiException {
        ApiResponse<PreviewResp> resp = previewDSLWithHttpInfo(body, tenantCode);
        return resp.getData();
    }


    /**
     * 分群预估接口
     * 查询服务圈选预估
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;PreviewResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<PreviewResp> previewDSLWithHttpInfo(DslReq body, String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = previewDSLValidateBeforeCall(body, tenantCode, null, null);
        Type localVarReturnType = new TypeToken<PreviewResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 分群预估接口 (asynchronously)
     * 查询服务圈选预估
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call previewDSLAsync(DslReq body, String tenantCode, final ApiCallback<PreviewResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = previewDSLValidateBeforeCall(body, tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PreviewResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for refreshSeg
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call refreshSegCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","refreshSeg"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call refreshSegValidateBeforeCall(Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling refreshSeg(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling refreshSeg(Async)");
        }

        com.squareup.okhttp.Call call = refreshSegCall(tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 更新单个分群包
     * 根据租户code和分群包id更新对应分群包的数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ByteDanceResponseSegmentationRefreshResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationRefreshResp refreshSeg(Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationRefreshResp> resp = refreshSegWithHttpInfo(tenantId, segId);
        return resp.getData();
    }


    /**
     * 更新单个分群包
     * 根据租户code和分群包id更新对应分群包的数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationRefreshResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationRefreshResp> refreshSegWithHttpInfo(Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = refreshSegValidateBeforeCall(tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新单个分群包 (asynchronously)
     * 根据租户code和分群包id更新对应分群包的数据
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call refreshSegAsync(Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationRefreshResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = refreshSegValidateBeforeCall(tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationRefreshResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for segmentOnlineServiceEnable
     * @param body  (required)
     * @param tenantId 租户ID (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call segmentOnlineServiceEnableCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","segmentOnlineServiceEnable"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call segmentOnlineServiceEnableValidateBeforeCall(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling segmentOnlineServiceEnable(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling segmentOnlineServiceEnable(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling segmentOnlineServiceEnable(Async)");
        }

        com.squareup.okhttp.Call call = segmentOnlineServiceEnableCall(body, tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 单个分群在线服务开启/关闭
     * 开启/关闭某个分群的在线导入任务
     * @param body  (required)
     * @param tenantId 租户ID (required)
     * @param segId 分群id (required)
     * @return ByteDanceResponseSegmentationOnlineServiceEnableResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationOnlineServiceEnableResp segmentOnlineServiceEnable(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> resp = segmentOnlineServiceEnableWithHttpInfo(body, tenantId, segId);
        return resp.getData();
    }


    /**
     * 单个分群在线服务开启/关闭
     * 开启/关闭某个分群的在线导入任务
     * @param body  (required)
     * @param tenantId 租户ID (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationOnlineServiceEnableResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationOnlineServiceEnableResp> segmentOnlineServiceEnableWithHttpInfo(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 单个分群在线服务开启/关闭 (asynchronously)
     * 开启/关闭某个分群的在线导入任务
     * @param body  (required)
     * @param tenantId 租户ID (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call segmentOnlineServiceEnableAsync(ByteDanceResponseSegmentationOnlineServiceEnableReq body, Integer tenantId, Integer segId, final ApiCallback<ByteDanceResponseSegmentationOnlineServiceEnableResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = segmentOnlineServiceEnableValidateBeforeCall(body, tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationOnlineServiceEnableResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadSegFile
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadSegFile"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadSegFileValidateBeforeCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFile(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFile(Async)");
        }

        com.squareup.okhttp.Call call = uploadSegFileCall(file, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传分群包-上传
     * 上传对应的分群包文件到hdfs
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseSegmentationUploadResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationUploadResp uploadSegFile(File file, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationUploadResp> resp = uploadSegFileWithHttpInfo(file, tenantId);
        return resp.getData();
    }


    /**
     * 上传分群包-上传
     * 上传对应的分群包文件到hdfs
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationUploadResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationUploadResp> uploadSegFileWithHttpInfo(File file, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = uploadSegFileValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传分群包-上传 (asynchronously)
     * 上传对应的分群包文件到hdfs
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileAsync(File file, Integer tenantId, final ApiCallback<ByteDanceResponseSegmentationUploadResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = uploadSegFileValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadSegFileToCh
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadSegFileToCh"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadSegFileToChValidateBeforeCall(File file, Integer tenantId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadSegFileToCh(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling uploadSegFileToCh(Async)");
        }

        com.squareup.okhttp.Call call = uploadSegFileToChCall(file, tenantId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 人工分群包-上传
     * 上传对应的分群包文件到hdfs&amp;临时表(1.单个上传文件大小为1G，超出后接口报错,2.传为同步接口，上传完成后返回,3.传为同步接口，上传完成后返回)
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @return ByteDanceResponseSegmentationUploadResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseSegmentationUploadResp uploadSegFileToCh(File file, Integer tenantId) throws ApiException {
        ApiResponse<ByteDanceResponseSegmentationUploadResp> resp = uploadSegFileToChWithHttpInfo(file, tenantId);
        return resp.getData();
    }


    /**
     * 人工分群包-上传
     * 上传对应的分群包文件到hdfs&amp;临时表(1.单个上传文件大小为1G，超出后接口报错,2.传为同步接口，上传完成后返回,3.传为同步接口，上传完成后返回)
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @return ApiResponse&lt;ByteDanceResponseSegmentationUploadResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseSegmentationUploadResp> uploadSegFileToChWithHttpInfo(File file, Integer tenantId) throws ApiException {
        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(file, tenantId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 人工分群包-上传 (asynchronously)
     * 上传对应的分群包文件到hdfs&amp;临时表(1.单个上传文件大小为1G，超出后接口报错,2.传为同步接口，上传完成后返回,3.传为同步接口，上传完成后返回)
     * @param file  (required)
     * @param tenantId 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadSegFileToChAsync(File file, Integer tenantId, final ApiCallback<ByteDanceResponseSegmentationUploadResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = uploadSegFileToChValidateBeforeCall(file, tenantId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseSegmentationUploadResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for modifyUploadSegment
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call modifyUploadSegmentCall(UploadSegUpdateRequest body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantId", tenantId.toString()));
        localVarQueryParams.add(new Pair("segId", segId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","modifyUploadSegment"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call modifyUploadSegmentValidateBeforeCall(UploadSegUpdateRequest body, Integer tenantId, Integer segId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling modifyUploadSegment(Async)");
        }
        // verify the required parameter 'tenantId' is set
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling modifyUploadSegment(Async)");
        }
        // verify the required parameter 'segId' is set
        if (segId == null) {
            throw new ApiException("Missing the required parameter 'segId' when calling modifyUploadSegment(Async)");
        }

        com.squareup.okhttp.Call call = modifyUploadSegmentCall(body, tenantId, segId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 编辑上传分群接口
     * 编辑上传分群接口
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return CommonResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponse modifyUploadSegment(UploadSegUpdateRequest body, Integer tenantId, Integer segId) throws ApiException {
        ApiResponse<CommonResponse> resp = modifyUploadSegmentWithHttpInfo(body, tenantId, segId);
        return resp.getData();
    }


    /**
     * 编辑上传分群接口
     * 编辑上传分群接口
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @return ApiResponse&lt;CommonResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponse> modifyUploadSegmentWithHttpInfo(UploadSegUpdateRequest body, Integer tenantId, Integer segId) throws ApiException {
        com.squareup.okhttp.Call call = modifyUploadSegmentValidateBeforeCall(body, tenantId, segId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 编辑上传分群接口 (asynchronously)
     * 编辑上传分群接口
     * @param body  (required)
     * @param tenantId 租户Code (required)
     * @param segId 分群id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call modifyUploadSegmentAsync(UploadSegUpdateRequest body, Integer tenantId, Integer segId, final ApiCallback<CommonResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = modifyUploadSegmentValidateBeforeCall(body, tenantId, segId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
