/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * DatasetCreateRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class DatasetCreateRequest {
  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("dbName")
  private String dbName = null;

  @SerializedName("tableName")
  private String tableName = null;

  @SerializedName("oneIdField")
  private String oneIdField = null;

  @SerializedName("dataFormat")
  private String dataFormat = null;

  public DatasetCreateRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(required = true, description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DatasetCreateRequest desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * Get desc
   * @return desc
  **/
  @Schema(description = "")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public DatasetCreateRequest dbName(String dbName) {
    this.dbName = dbName;
    return this;
  }

   /**
   * Get dbName
   * @return dbName
  **/
  @Schema(required = true, description = "")
  public String getDbName() {
    return dbName;
  }

  public void setDbName(String dbName) {
    this.dbName = dbName;
  }

  public DatasetCreateRequest tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

   /**
   * Get tableName
   * @return tableName
  **/
  @Schema(required = true, description = "")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public DatasetCreateRequest oneIdField(String oneIdField) {
    this.oneIdField = oneIdField;
    return this;
  }

   /**
   * 代表id列的字段，要求字段是数字类型
   * @return oneIdField
  **/
  @Schema(required = true, description = "代表id列的字段，要求字段是数字类型")
  public String getOneIdField() {
    return oneIdField;
  }

  public void setOneIdField(String oneIdField) {
    this.oneIdField = oneIdField;
  }

  public DatasetCreateRequest dataFormat(String dataFormat) {
    this.dataFormat = dataFormat;
    return this;
  }

   /**
   * 日期的schema, ${DATE}或者${date}
   * @return dataFormat
  **/
  @Schema(required = true, description = "日期的schema, ${DATE}或者${date}")
  public String getDataFormat() {
    return dataFormat;
  }

  public void setDataFormat(String dataFormat) {
    this.dataFormat = dataFormat;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DatasetCreateRequest datasetCreateRequest = (DatasetCreateRequest) o;
    return Objects.equals(this.name, datasetCreateRequest.name) &&
        Objects.equals(this.desc, datasetCreateRequest.desc) &&
        Objects.equals(this.dbName, datasetCreateRequest.dbName) &&
        Objects.equals(this.tableName, datasetCreateRequest.tableName) &&
        Objects.equals(this.oneIdField, datasetCreateRequest.oneIdField) &&
        Objects.equals(this.dataFormat, datasetCreateRequest.dataFormat);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, desc, dbName, tableName, oneIdField, dataFormat);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DatasetCreateRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    dbName: ").append(toIndentedString(dbName)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    oneIdField: ").append(toIndentedString(oneIdField)).append("\n");
    sb.append("    dataFormat: ").append(toIndentedString(dataFormat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
