/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.CustomTgi;
import code.byted.inter.model.TagRule;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * GraphRule
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:37:04.708+08:00[Asia/Shanghai]")
public class GraphRule {
  @SerializedName("tagRule")
  private TagRule tagRule = null;

  /**
   * 图表查询类型
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    CUSTOMANALYSIS("CustomAnalysis"),
    CROSSANALYSIS("CrossAnalysis"),
    PUBLICCUSTOMANALYSIS("PublicCustomAnalysis");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("horizontalTagRule")
  private TagRule horizontalTagRule = null;

  @SerializedName("verticalTagRule")
  private TagRule verticalTagRule = null;

  @SerializedName("tgiConfig")
  private CustomTgi tgiConfig = null;

  public GraphRule tagRule(TagRule tagRule) {
    this.tagRule = tagRule;
    return this;
  }

   /**
   * Get tagRule
   * @return tagRule
  **/
  @Schema(description = "")
  public TagRule getTagRule() {
    return tagRule;
  }

  public void setTagRule(TagRule tagRule) {
    this.tagRule = tagRule;
  }

  public GraphRule type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * 图表查询类型
   * @return type
  **/
  @Schema(required = true, description = "图表查询类型")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public GraphRule horizontalTagRule(TagRule horizontalTagRule) {
    this.horizontalTagRule = horizontalTagRule;
    return this;
  }

   /**
   * Get horizontalTagRule
   * @return horizontalTagRule
  **/
  @Schema(required = true, description = "")
  public TagRule getHorizontalTagRule() {
    return horizontalTagRule;
  }

  public void setHorizontalTagRule(TagRule horizontalTagRule) {
    this.horizontalTagRule = horizontalTagRule;
  }

  public GraphRule verticalTagRule(TagRule verticalTagRule) {
    this.verticalTagRule = verticalTagRule;
    return this;
  }

   /**
   * Get verticalTagRule
   * @return verticalTagRule
  **/
  @Schema(required = true, description = "")
  public TagRule getVerticalTagRule() {
    return verticalTagRule;
  }

  public void setVerticalTagRule(TagRule verticalTagRule) {
    this.verticalTagRule = verticalTagRule;
  }

  public GraphRule tgiConfig(CustomTgi tgiConfig) {
    this.tgiConfig = tgiConfig;
    return this;
  }

   /**
   * Get tgiConfig
   * @return tgiConfig
  **/
  @Schema(description = "")
  public CustomTgi getTgiConfig() {
    return tgiConfig;
  }

  public void setTgiConfig(CustomTgi tgiConfig) {
    this.tgiConfig = tgiConfig;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphRule graphRule = (GraphRule) o;
    return Objects.equals(this.tagRule, graphRule.tagRule) &&
        Objects.equals(this.type, graphRule.type) &&
        Objects.equals(this.horizontalTagRule, graphRule.horizontalTagRule) &&
        Objects.equals(this.verticalTagRule, graphRule.verticalTagRule) &&
        Objects.equals(this.tgiConfig, graphRule.tgiConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagRule, type, horizontalTagRule, verticalTagRule, tgiConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphRule {\n");
    
    sb.append("    tagRule: ").append(toIndentedString(tagRule)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    horizontalTagRule: ").append(toIndentedString(horizontalTagRule)).append("\n");
    sb.append("    verticalTagRule: ").append(toIndentedString(verticalTagRule)).append("\n");
    sb.append("    tgiConfig: ").append(toIndentedString(tgiConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
