/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.LocalDate;
/**
 * HiveSqlSegCreateOrUpdateRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-17T12:51:37.014+08:00[Asia/Shanghai]")
public class HiveSqlSegCreateOrUpdateRequest {
  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("appId")
  private Integer appId = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  /**
   * 调度类型，Trigger/Daily 默认为 Trigger，按需调度
   */
  @JsonAdapter(ScheduleTypeEnum.Adapter.class)
  public enum ScheduleTypeEnum {
    UNKNOWN("Unknown"),
    TRIGGER("Trigger"),
    DAILY("Daily");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleTypeEnum fromValue(String input) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleType")
  private ScheduleTypeEnum scheduleType = ScheduleTypeEnum.TRIGGER;

  @SerializedName("sql")
  private String sql = null;

  @SerializedName("segResourceSecurityLevel")
  private Integer segResourceSecurityLevel = 2;

  @SerializedName("productKey")
  private String productKey = null;

  @SerializedName("targetIdTypeId")
  private Integer targetIdTypeId = null;

  @SerializedName("onlineServiceEnabled")
  private Boolean onlineServiceEnabled = true;

  @SerializedName("runOnCreationOrUpdate")
  private Boolean runOnCreationOrUpdate = true;

  @SerializedName("pDate")
  private LocalDate pDate = null;

  @SerializedName("depTaskIds")
  private List<Long> depTaskIds = null;

  public HiveSqlSegCreateOrUpdateRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public HiveSqlSegCreateOrUpdateRequest desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 分群描述
   * @return desc
  **/
  @Schema(description = "分群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public HiveSqlSegCreateOrUpdateRequest appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 业务线 id
   * @return appId
  **/
  @Schema(required = true, description = "业务线 id")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  public HiveSqlSegCreateOrUpdateRequest sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 源平台
   * @return sourcePlatform
  **/
  @Schema(description = "源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public HiveSqlSegCreateOrUpdateRequest scheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * 调度类型，Trigger/Daily 默认为 Trigger，按需调度
   * @return scheduleType
  **/
  @Schema(description = "调度类型，Trigger/Daily 默认为 Trigger，按需调度")
  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }

  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }

  public HiveSqlSegCreateOrUpdateRequest sql(String sql) {
    this.sql = sql;
    return this;
  }

   /**
   * Hive SQL语句，支持变量${DATE} ${date}
   * @return sql
  **/
  @Schema(required = true, description = "Hive SQL语句，支持变量${DATE} ${date}")
  public String getSql() {
    return sql;
  }

  public void setSql(String sql) {
    this.sql = sql;
  }

  public HiveSqlSegCreateOrUpdateRequest segResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
    return this;
  }

   /**
   * Kani 资源安全级别，默认为 2
   * @return segResourceSecurityLevel
  **/
  @Schema(description = "Kani 资源安全级别，默认为 2")
  public Integer getSegResourceSecurityLevel() {
    return segResourceSecurityLevel;
  }

  public void setSegResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
  }

  public HiveSqlSegCreateOrUpdateRequest productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

   /**
   * 所属部门，kani 登记为 4 必填
   * @return productKey
  **/
  @Schema(description = "所属部门，kani 登记为 4 必填")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public HiveSqlSegCreateOrUpdateRequest targetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
    return this;
  }

   /**
   * 目标ID类型ID
   * @return targetIdTypeId
  **/
  @Schema(required = true, description = "目标ID类型ID")
  public Integer getTargetIdTypeId() {
    return targetIdTypeId;
  }

  public void setTargetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
  }

  public HiveSqlSegCreateOrUpdateRequest onlineServiceEnabled(Boolean onlineServiceEnabled) {
    this.onlineServiceEnabled = onlineServiceEnabled;
    return this;
  }

   /**
   * 是否开启在线导入（导入 abase），默认为开
   * @return onlineServiceEnabled
  **/
  @Schema(description = "是否开启在线导入（导入 abase），默认为开")
  public Boolean isOnlineServiceEnabled() {
    return onlineServiceEnabled;
  }

  public void setOnlineServiceEnabled(Boolean onlineServiceEnabled) {
    this.onlineServiceEnabled = onlineServiceEnabled;
  }

  public HiveSqlSegCreateOrUpdateRequest runOnCreationOrUpdate(Boolean runOnCreationOrUpdate) {
    this.runOnCreationOrUpdate = runOnCreationOrUpdate;
    return this;
  }

   /**
   * 是否立即回溯运行，默认为 true
   * @return runOnCreationOrUpdate
  **/
  @Schema(description = "是否立即回溯运行，默认为 true")
  public Boolean isRunOnCreationOrUpdate() {
    return runOnCreationOrUpdate;
  }

  public void setRunOnCreationOrUpdate(Boolean runOnCreationOrUpdate) {
    this.runOnCreationOrUpdate = runOnCreationOrUpdate;
  }

  public HiveSqlSegCreateOrUpdateRequest pDate(LocalDate pDate) {
    this.pDate = pDate;
    return this;
  }

   /**
   * 如果立即回溯，回溯日期. 默认为 t-1
   * @return pDate
  **/
  @Schema(description = "如果立即回溯，回溯日期. 默认为 t-1")
  public LocalDate getPDate() {
    return pDate;
  }

  public void setPDate(LocalDate pDate) {
    this.pDate = pDate;
  }

  public HiveSqlSegCreateOrUpdateRequest depTaskIds(List<Long> depTaskIds) {
    this.depTaskIds = depTaskIds;
    return this;
  }

  public HiveSqlSegCreateOrUpdateRequest addDepTaskIdsItem(Long depTaskIdsItem) {
    if (this.depTaskIds == null) {
      this.depTaskIds = new ArrayList<Long>();
    }
    this.depTaskIds.add(depTaskIdsItem);
    return this;
  }

   /**
   * 传 null 或者不传：表示对所有上游建立依赖；传 []: 不建立依赖；目前只支持对上游天粒度例行任务建立依赖
   * @return depTaskIds
  **/
  @Schema(description = "传 null 或者不传：表示对所有上游建立依赖；传 []: 不建立依赖；目前只支持对上游天粒度例行任务建立依赖")
  public List<Long> getDepTaskIds() {
    return depTaskIds;
  }

  public void setDepTaskIds(List<Long> depTaskIds) {
    this.depTaskIds = depTaskIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HiveSqlSegCreateOrUpdateRequest hiveSqlSegCreateOrUpdateRequest = (HiveSqlSegCreateOrUpdateRequest) o;
    return Objects.equals(this.name, hiveSqlSegCreateOrUpdateRequest.name) &&
        Objects.equals(this.desc, hiveSqlSegCreateOrUpdateRequest.desc) &&
        Objects.equals(this.appId, hiveSqlSegCreateOrUpdateRequest.appId) &&
        Objects.equals(this.sourcePlatform, hiveSqlSegCreateOrUpdateRequest.sourcePlatform) &&
        Objects.equals(this.scheduleType, hiveSqlSegCreateOrUpdateRequest.scheduleType) &&
        Objects.equals(this.sql, hiveSqlSegCreateOrUpdateRequest.sql) &&
        Objects.equals(this.segResourceSecurityLevel, hiveSqlSegCreateOrUpdateRequest.segResourceSecurityLevel) &&
        Objects.equals(this.productKey, hiveSqlSegCreateOrUpdateRequest.productKey) &&
        Objects.equals(this.targetIdTypeId, hiveSqlSegCreateOrUpdateRequest.targetIdTypeId) &&
        Objects.equals(this.onlineServiceEnabled, hiveSqlSegCreateOrUpdateRequest.onlineServiceEnabled) &&
        Objects.equals(this.runOnCreationOrUpdate, hiveSqlSegCreateOrUpdateRequest.runOnCreationOrUpdate) &&
        Objects.equals(this.pDate, hiveSqlSegCreateOrUpdateRequest.pDate) &&
        Objects.equals(this.depTaskIds, hiveSqlSegCreateOrUpdateRequest.depTaskIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, desc, appId, sourcePlatform, scheduleType, sql, segResourceSecurityLevel, productKey, targetIdTypeId, onlineServiceEnabled, runOnCreationOrUpdate, pDate, depTaskIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HiveSqlSegCreateOrUpdateRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    sql: ").append(toIndentedString(sql)).append("\n");
    sb.append("    segResourceSecurityLevel: ").append(toIndentedString(segResourceSecurityLevel)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("    targetIdTypeId: ").append(toIndentedString(targetIdTypeId)).append("\n");
    sb.append("    onlineServiceEnabled: ").append(toIndentedString(onlineServiceEnabled)).append("\n");
    sb.append("    runOnCreationOrUpdate: ").append(toIndentedString(runOnCreationOrUpdate)).append("\n");
    sb.append("    pDate: ").append(toIndentedString(pDate)).append("\n");
    sb.append("    depTaskIds: ").append(toIndentedString(depTaskIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
