/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * LabelSetting
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-20T17:15:42.591+08:00[Asia/Shanghai]")
public class LabelSetting {
  @SerializedName("labelId")
  private Integer labelId = null;

  @SerializedName("topN")
  private Integer topN = null;

  /**
   * 排序方式
   */
  @JsonAdapter(OrderEnum.Adapter.class)
  public enum OrderEnum {
    UNKNOWN("Unknown"),
    DESC("desc"),
    ASC("asc");

    private String value;

    OrderEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static OrderEnum fromValue(String input) {
      for (OrderEnum b : OrderEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<OrderEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OrderEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public OrderEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return OrderEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("order")
  private OrderEnum order = null;

  public LabelSetting labelId(Integer labelId) {
    this.labelId = labelId;
    return this;
  }

   /**
   * 标签ID
   * @return labelId
  **/
  @Schema(required = true, description = "标签ID")
  public Integer getLabelId() {
    return labelId;
  }

  public void setLabelId(Integer labelId) {
    this.labelId = labelId;
  }

  public LabelSetting topN(Integer topN) {
    this.topN = topN;
    return this;
  }

   /**
   * topN数量
   * @return topN
  **/
  @Schema(required = true, description = "topN数量")
  public Integer getTopN() {
    return topN;
  }

  public void setTopN(Integer topN) {
    this.topN = topN;
  }

  public LabelSetting order(OrderEnum order) {
    this.order = order;
    return this;
  }

   /**
   * 排序方式
   * @return order
  **/
  @Schema(required = true, description = "排序方式")
  public OrderEnum getOrder() {
    return order;
  }

  public void setOrder(OrderEnum order) {
    this.order = order;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LabelSetting labelSetting = (LabelSetting) o;
    return Objects.equals(this.labelId, labelSetting.labelId) &&
        Objects.equals(this.topN, labelSetting.topN) &&
        Objects.equals(this.order, labelSetting.order);
  }

  @Override
  public int hashCode() {
    return Objects.hash(labelId, topN, order);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LabelSetting {\n");
    
    sb.append("    labelId: ").append(toIndentedString(labelId)).append("\n");
    sb.append("    topN: ").append(toIndentedString(topN)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
