/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.ListProjectItems;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * 项目详情
 */
@Schema(description = "项目详情")
@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:30:21.574+08:00[Asia/Shanghai]")
public class ListProject {
  @SerializedName("current")
  private Integer current = null;

  @SerializedName("page_size")
  private Integer pageSize = null;

  @SerializedName("total")
  private Long total = null;

  @SerializedName("items")
  private List<ListProjectItems> items = null;

  public ListProject current(Integer current) {
    this.current = current;
    return this;
  }

   /**
   * 当前页码
   * @return current
  **/
  @Schema(description = "当前页码")
  public Integer getCurrent() {
    return current;
  }

  public void setCurrent(Integer current) {
    this.current = current;
  }

  public ListProject pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页个数
   * @return pageSize
  **/
  @Schema(description = "一页个数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public ListProject total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @Schema(description = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  public ListProject items(List<ListProjectItems> items) {
    this.items = items;
    return this;
  }

  public ListProject addItemsItem(ListProjectItems itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<ListProjectItems>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Get items
   * @return items
  **/
  @Schema(description = "")
  public List<ListProjectItems> getItems() {
    return items;
  }

  public void setItems(List<ListProjectItems> items) {
    this.items = items;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListProject listProject = (ListProject) o;
    return Objects.equals(this.current, listProject.current) &&
        Objects.equals(this.pageSize, listProject.pageSize) &&
        Objects.equals(this.total, listProject.total) &&
        Objects.equals(this.items, listProject.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(current, pageSize, total, items);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListProject {\n");
    
    sb.append("    current: ").append(toIndentedString(current)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
