/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.InsightMeta;
import code.byted.inter.model.MultipleHorizontalResult;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * MultipleCrossAnalysisResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-10T15:38:33.157+08:00[Asia/Shanghai]")
public class MultipleCrossAnalysisResult {
  @SerializedName("mauCount")
  private Long mauCount = null;

  @SerializedName("insightMeta")
  private InsightMeta insightMeta = null;

  @SerializedName("segName")
  private String segName = null;

  @SerializedName("segCount")
  private Long segCount = null;

  @SerializedName("segValidProportion")
  private Double segValidProportion = null;

  @SerializedName("tagSumInSeg")
  private Long tagSumInSeg = null;

  @SerializedName("horizontalResults")
  private List<MultipleHorizontalResult> horizontalResults = new ArrayList<MultipleHorizontalResult>();

  @SerializedName("anchor")
  private String anchor = null;

  public MultipleCrossAnalysisResult mauCount(Long mauCount) {
    this.mauCount = mauCount;
    return this;
  }

   /**
   * 系统全量人群数量
   * @return mauCount
  **/
  @Schema(required = true, description = "系统全量人群数量")
  public Long getMauCount() {
    return mauCount;
  }

  public void setMauCount(Long mauCount) {
    this.mauCount = mauCount;
  }

  public MultipleCrossAnalysisResult insightMeta(InsightMeta insightMeta) {
    this.insightMeta = insightMeta;
    return this;
  }

   /**
   * Get insightMeta
   * @return insightMeta
  **/
  @Schema(required = true, description = "")
  public InsightMeta getInsightMeta() {
    return insightMeta;
  }

  public void setInsightMeta(InsightMeta insightMeta) {
    this.insightMeta = insightMeta;
  }

  public MultipleCrossAnalysisResult segName(String segName) {
    this.segName = segName;
    return this;
  }

   /**
   * 人群名称
   * @return segName
  **/
  @Schema(required = true, description = "人群名称")
  public String getSegName() {
    return segName;
  }

  public void setSegName(String segName) {
    this.segName = segName;
  }

  public MultipleCrossAnalysisResult segCount(Long segCount) {
    this.segCount = segCount;
    return this;
  }

   /**
   * 人群数量
   * @return segCount
  **/
  @Schema(required = true, description = "人群数量")
  public Long getSegCount() {
    return segCount;
  }

  public void setSegCount(Long segCount) {
    this.segCount = segCount;
  }

  public MultipleCrossAnalysisResult segValidProportion(Double segValidProportion) {
    this.segValidProportion = segValidProportion;
    return this;
  }

   /**
   * 有效占比
   * @return segValidProportion
  **/
  @Schema(required = true, description = "有效占比")
  public Double getSegValidProportion() {
    return segValidProportion;
  }

  public void setSegValidProportion(Double segValidProportion) {
    this.segValidProportion = segValidProportion;
  }

  public MultipleCrossAnalysisResult tagSumInSeg(Long tagSumInSeg) {
    this.tagSumInSeg = tagSumInSeg;
    return this;
  }

   /**
   * 标签在所选人群中的总人数
   * @return tagSumInSeg
  **/
  @Schema(required = true, description = "标签在所选人群中的总人数")
  public Long getTagSumInSeg() {
    return tagSumInSeg;
  }

  public void setTagSumInSeg(Long tagSumInSeg) {
    this.tagSumInSeg = tagSumInSeg;
  }

  public MultipleCrossAnalysisResult horizontalResults(List<MultipleHorizontalResult> horizontalResults) {
    this.horizontalResults = horizontalResults;
    return this;
  }

  public MultipleCrossAnalysisResult addHorizontalResultsItem(MultipleHorizontalResult horizontalResultsItem) {
    this.horizontalResults.add(horizontalResultsItem);
    return this;
  }

   /**
   * 横坐标洞察结果
   * @return horizontalResults
  **/
  @Schema(required = true, description = "横坐标洞察结果")
  public List<MultipleHorizontalResult> getHorizontalResults() {
    return horizontalResults;
  }

  public void setHorizontalResults(List<MultipleHorizontalResult> horizontalResults) {
    this.horizontalResults = horizontalResults;
  }

  public MultipleCrossAnalysisResult anchor(String anchor) {
    this.anchor = anchor;
    return this;
  }

   /**
   * Get anchor
   * @return anchor
  **/
  @Schema(description = "")
  public String getAnchor() {
    return anchor;
  }

  public void setAnchor(String anchor) {
    this.anchor = anchor;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultipleCrossAnalysisResult multipleCrossAnalysisResult = (MultipleCrossAnalysisResult) o;
    return Objects.equals(this.mauCount, multipleCrossAnalysisResult.mauCount) &&
        Objects.equals(this.insightMeta, multipleCrossAnalysisResult.insightMeta) &&
        Objects.equals(this.segName, multipleCrossAnalysisResult.segName) &&
        Objects.equals(this.segCount, multipleCrossAnalysisResult.segCount) &&
        Objects.equals(this.segValidProportion, multipleCrossAnalysisResult.segValidProportion) &&
        Objects.equals(this.tagSumInSeg, multipleCrossAnalysisResult.tagSumInSeg) &&
        Objects.equals(this.horizontalResults, multipleCrossAnalysisResult.horizontalResults) &&
        Objects.equals(this.anchor, multipleCrossAnalysisResult.anchor);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mauCount, insightMeta, segName, segCount, segValidProportion, tagSumInSeg, horizontalResults, anchor);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultipleCrossAnalysisResult {\n");
    
    sb.append("    mauCount: ").append(toIndentedString(mauCount)).append("\n");
    sb.append("    insightMeta: ").append(toIndentedString(insightMeta)).append("\n");
    sb.append("    segName: ").append(toIndentedString(segName)).append("\n");
    sb.append("    segCount: ").append(toIndentedString(segCount)).append("\n");
    sb.append("    segValidProportion: ").append(toIndentedString(segValidProportion)).append("\n");
    sb.append("    tagSumInSeg: ").append(toIndentedString(tagSumInSeg)).append("\n");
    sb.append("    horizontalResults: ").append(toIndentedString(horizontalResults)).append("\n");
    sb.append("    anchor: ").append(toIndentedString(anchor)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
