/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.MultipleHorizontalResult;
import code.byted.inter.model.MultipleVerticalResult;
import code.byted.inter.model.TagDateRange;
import code.byted.inter.model.TagDateTimeRange;
import code.byted.inter.model.TagDecimalRange;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.LocalDate;
/**
 * MultipleHorizontalResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-10T15:38:33.157+08:00[Asia/Shanghai]")
public class MultipleHorizontalResult {
  @SerializedName("tagId")
  private Integer tagId = null;

  @SerializedName("tagName")
  private String tagName = null;

  @SerializedName("children")
  private List<MultipleHorizontalResult> children = null;

  @SerializedName("verticalResults")
  private List<MultipleVerticalResult> verticalResults = null;

  @SerializedName("tagShowValue")
  private String tagShowValue = null;

  @SerializedName("tagDateRange")
  private TagDateRange tagDateRange = null;

  @SerializedName("tagDecimalRange")
  private TagDecimalRange tagDecimalRange = null;

  @SerializedName("tagDecimalValue")
  private Double tagDecimalValue = null;

  @SerializedName("tagStringValue")
  private String tagStringValue = null;

  @SerializedName("tagDateTimeRange")
  private TagDateTimeRange tagDateTimeRange = null;

  @SerializedName("tagDateValue")
  private LocalDate tagDateValue = null;

  @SerializedName("tagDateTimeValue")
  private String tagDateTimeValue = null;

  public MultipleHorizontalResult tagId(Integer tagId) {
    this.tagId = tagId;
    return this;
  }

   /**
   * 标签id
   * @return tagId
  **/
  @Schema(description = "标签id")
  public Integer getTagId() {
    return tagId;
  }

  public void setTagId(Integer tagId) {
    this.tagId = tagId;
  }

  public MultipleHorizontalResult tagName(String tagName) {
    this.tagName = tagName;
    return this;
  }

   /**
   * 标签名称
   * @return tagName
  **/
  @Schema(description = "标签名称")
  public String getTagName() {
    return tagName;
  }

  public void setTagName(String tagName) {
    this.tagName = tagName;
  }

  public MultipleHorizontalResult children(List<MultipleHorizontalResult> children) {
    this.children = children;
    return this;
  }

  public MultipleHorizontalResult addChildrenItem(MultipleHorizontalResult childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<MultipleHorizontalResult>();
    }
    this.children.add(childrenItem);
    return this;
  }

   /**
   * 子节点
   * @return children
  **/
  @Schema(description = "子节点")
  public List<MultipleHorizontalResult> getChildren() {
    return children;
  }

  public void setChildren(List<MultipleHorizontalResult> children) {
    this.children = children;
  }

  public MultipleHorizontalResult verticalResults(List<MultipleVerticalResult> verticalResults) {
    this.verticalResults = verticalResults;
    return this;
  }

  public MultipleHorizontalResult addVerticalResultsItem(MultipleVerticalResult verticalResultsItem) {
    if (this.verticalResults == null) {
      this.verticalResults = new ArrayList<MultipleVerticalResult>();
    }
    this.verticalResults.add(verticalResultsItem);
    return this;
  }

   /**
   * 纵坐标结果
   * @return verticalResults
  **/
  @Schema(description = "纵坐标结果")
  public List<MultipleVerticalResult> getVerticalResults() {
    return verticalResults;
  }

  public void setVerticalResults(List<MultipleVerticalResult> verticalResults) {
    this.verticalResults = verticalResults;
  }

  public MultipleHorizontalResult tagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
    return this;
  }

   /**
   * 标签值展示值
   * @return tagShowValue
  **/
  @Schema(required = true, description = "标签值展示值")
  public String getTagShowValue() {
    return tagShowValue;
  }

  public void setTagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
  }

  public MultipleHorizontalResult tagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
    return this;
  }

   /**
   * Get tagDateRange
   * @return tagDateRange
  **/
  @Schema(description = "")
  public TagDateRange getTagDateRange() {
    return tagDateRange;
  }

  public void setTagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
  }

  public MultipleHorizontalResult tagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
    return this;
  }

   /**
   * Get tagDecimalRange
   * @return tagDecimalRange
  **/
  @Schema(description = "")
  public TagDecimalRange getTagDecimalRange() {
    return tagDecimalRange;
  }

  public void setTagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
  }

  public MultipleHorizontalResult tagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
    return this;
  }

   /**
   * 数值型标签值
   * @return tagDecimalValue
  **/
  @Schema(description = "数值型标签值")
  public Double getTagDecimalValue() {
    return tagDecimalValue;
  }

  public void setTagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
  }

  public MultipleHorizontalResult tagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
    return this;
  }

   /**
   * 字符型标签值
   * @return tagStringValue
  **/
  @Schema(description = "字符型标签值")
  public String getTagStringValue() {
    return tagStringValue;
  }

  public void setTagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
  }

  public MultipleHorizontalResult tagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
    return this;
  }

   /**
   * Get tagDateTimeRange
   * @return tagDateTimeRange
  **/
  @Schema(description = "")
  public TagDateTimeRange getTagDateTimeRange() {
    return tagDateTimeRange;
  }

  public void setTagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
  }

  public MultipleHorizontalResult tagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
    return this;
  }

   /**
   * 特定日期
   * @return tagDateValue
  **/
  @Schema(description = "特定日期")
  public LocalDate getTagDateValue() {
    return tagDateValue;
  }

  public void setTagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
  }

  public MultipleHorizontalResult tagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
    return this;
  }

   /**
   * 特定日期时间
   * @return tagDateTimeValue
  **/
  @Schema(description = "特定日期时间")
  public String getTagDateTimeValue() {
    return tagDateTimeValue;
  }

  public void setTagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultipleHorizontalResult multipleHorizontalResult = (MultipleHorizontalResult) o;
    return Objects.equals(this.tagId, multipleHorizontalResult.tagId) &&
        Objects.equals(this.tagName, multipleHorizontalResult.tagName) &&
        Objects.equals(this.children, multipleHorizontalResult.children) &&
        Objects.equals(this.verticalResults, multipleHorizontalResult.verticalResults) &&
        Objects.equals(this.tagShowValue, multipleHorizontalResult.tagShowValue) &&
        Objects.equals(this.tagDateRange, multipleHorizontalResult.tagDateRange) &&
        Objects.equals(this.tagDecimalRange, multipleHorizontalResult.tagDecimalRange) &&
        Objects.equals(this.tagDecimalValue, multipleHorizontalResult.tagDecimalValue) &&
        Objects.equals(this.tagStringValue, multipleHorizontalResult.tagStringValue) &&
        Objects.equals(this.tagDateTimeRange, multipleHorizontalResult.tagDateTimeRange) &&
        Objects.equals(this.tagDateValue, multipleHorizontalResult.tagDateValue) &&
        Objects.equals(this.tagDateTimeValue, multipleHorizontalResult.tagDateTimeValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagId, tagName, children, verticalResults, tagShowValue, tagDateRange, tagDecimalRange, tagDecimalValue, tagStringValue, tagDateTimeRange, tagDateValue, tagDateTimeValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultipleHorizontalResult {\n");
    
    sb.append("    tagId: ").append(toIndentedString(tagId)).append("\n");
    sb.append("    tagName: ").append(toIndentedString(tagName)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    verticalResults: ").append(toIndentedString(verticalResults)).append("\n");
    sb.append("    tagShowValue: ").append(toIndentedString(tagShowValue)).append("\n");
    sb.append("    tagDateRange: ").append(toIndentedString(tagDateRange)).append("\n");
    sb.append("    tagDecimalRange: ").append(toIndentedString(tagDecimalRange)).append("\n");
    sb.append("    tagDecimalValue: ").append(toIndentedString(tagDecimalValue)).append("\n");
    sb.append("    tagStringValue: ").append(toIndentedString(tagStringValue)).append("\n");
    sb.append("    tagDateTimeRange: ").append(toIndentedString(tagDateTimeRange)).append("\n");
    sb.append("    tagDateValue: ").append(toIndentedString(tagDateValue)).append("\n");
    sb.append("    tagDateTimeValue: ").append(toIndentedString(tagDateTimeValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
