/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * QueryOnlineResourceV2Request
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2024-12-17T15:05:09.675+08:00[Asia/Shanghai]")
public class QueryOnlineResourceV2Request {
  @SerializedName("current")
  private Integer current = null;

  @SerializedName("pageSize")
  private Integer pageSize = null;

  @SerializedName("resourceType")
  private String resourceType = null;

  @SerializedName("matchProjectId")
  private Integer matchProjectId = null;

  @SerializedName("matchAppId")
  private List<Integer> matchAppId = null;

  @SerializedName("currentUser")
  private String currentUser = null;

  @SerializedName("keyword")
  private String keyword = null;

  @SerializedName("matchAnyRegion")
  private List<String> matchAnyRegion = null;

  @SerializedName("matchAnysubGroupId")
  private Integer matchAnysubGroupId = null;

  public QueryOnlineResourceV2Request current(Integer current) {
    this.current = current;
    return this;
  }

   /**
   * 当前页码
   * @return current
  **/
  @Schema(description = "当前页码")
  public Integer getCurrent() {
    return current;
  }

  public void setCurrent(Integer current) {
    this.current = current;
  }

  public QueryOnlineResourceV2Request pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @Schema(description = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public QueryOnlineResourceV2Request resourceType(String resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源类型
   * @return resourceType
  **/
  @Schema(description = "资源类型")
  public String getResourceType() {
    return resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }

  public QueryOnlineResourceV2Request matchProjectId(Integer matchProjectId) {
    this.matchProjectId = matchProjectId;
    return this;
  }

   /**
   * 匹配的项目ID
   * @return matchProjectId
  **/
  @Schema(description = "匹配的项目ID")
  public Integer getMatchProjectId() {
    return matchProjectId;
  }

  public void setMatchProjectId(Integer matchProjectId) {
    this.matchProjectId = matchProjectId;
  }

  public QueryOnlineResourceV2Request matchAppId(List<Integer> matchAppId) {
    this.matchAppId = matchAppId;
    return this;
  }

  public QueryOnlineResourceV2Request addMatchAppIdItem(Integer matchAppIdItem) {
    if (this.matchAppId == null) {
      this.matchAppId = new ArrayList<Integer>();
    }
    this.matchAppId.add(matchAppIdItem);
    return this;
  }

   /**
   * 匹配的应用ID
   * @return matchAppId
  **/
  @Schema(description = "匹配的应用ID")
  public List<Integer> getMatchAppId() {
    return matchAppId;
  }

  public void setMatchAppId(List<Integer> matchAppId) {
    this.matchAppId = matchAppId;
  }

  public QueryOnlineResourceV2Request currentUser(String currentUser) {
    this.currentUser = currentUser;
    return this;
  }

   /**
   * 当前用户
   * @return currentUser
  **/
  @Schema(description = "当前用户")
  public String getCurrentUser() {
    return currentUser;
  }

  public void setCurrentUser(String currentUser) {
    this.currentUser = currentUser;
  }

  public QueryOnlineResourceV2Request keyword(String keyword) {
    this.keyword = keyword;
    return this;
  }

   /**
   * 关键字
   * @return keyword
  **/
  @Schema(description = "关键字")
  public String getKeyword() {
    return keyword;
  }

  public void setKeyword(String keyword) {
    this.keyword = keyword;
  }

  public QueryOnlineResourceV2Request matchAnyRegion(List<String> matchAnyRegion) {
    this.matchAnyRegion = matchAnyRegion;
    return this;
  }

  public QueryOnlineResourceV2Request addMatchAnyRegionItem(String matchAnyRegionItem) {
    if (this.matchAnyRegion == null) {
      this.matchAnyRegion = new ArrayList<String>();
    }
    this.matchAnyRegion.add(matchAnyRegionItem);
    return this;
  }

   /**
   * 匹配任意地区
   * @return matchAnyRegion
  **/
  @Schema(description = "匹配任意地区")
  public List<String> getMatchAnyRegion() {
    return matchAnyRegion;
  }

  public void setMatchAnyRegion(List<String> matchAnyRegion) {
    this.matchAnyRegion = matchAnyRegion;
  }

  public QueryOnlineResourceV2Request matchAnysubGroupId(Integer matchAnysubGroupId) {
    this.matchAnysubGroupId = matchAnysubGroupId;
    return this;
  }

   /**
   * 匹配任意子分组ID
   * @return matchAnysubGroupId
  **/
  @Schema(description = "匹配任意子分组ID")
  public Integer getMatchAnysubGroupId() {
    return matchAnysubGroupId;
  }

  public void setMatchAnysubGroupId(Integer matchAnysubGroupId) {
    this.matchAnysubGroupId = matchAnysubGroupId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryOnlineResourceV2Request queryOnlineResourceV2Request = (QueryOnlineResourceV2Request) o;
    return Objects.equals(this.current, queryOnlineResourceV2Request.current) &&
        Objects.equals(this.pageSize, queryOnlineResourceV2Request.pageSize) &&
        Objects.equals(this.resourceType, queryOnlineResourceV2Request.resourceType) &&
        Objects.equals(this.matchProjectId, queryOnlineResourceV2Request.matchProjectId) &&
        Objects.equals(this.matchAppId, queryOnlineResourceV2Request.matchAppId) &&
        Objects.equals(this.currentUser, queryOnlineResourceV2Request.currentUser) &&
        Objects.equals(this.keyword, queryOnlineResourceV2Request.keyword) &&
        Objects.equals(this.matchAnyRegion, queryOnlineResourceV2Request.matchAnyRegion) &&
        Objects.equals(this.matchAnysubGroupId, queryOnlineResourceV2Request.matchAnysubGroupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(current, pageSize, resourceType, matchProjectId, matchAppId, currentUser, keyword, matchAnyRegion, matchAnysubGroupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryOnlineResourceV2Request {\n");
    
    sb.append("    current: ").append(toIndentedString(current)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    matchProjectId: ").append(toIndentedString(matchProjectId)).append("\n");
    sb.append("    matchAppId: ").append(toIndentedString(matchAppId)).append("\n");
    sb.append("    currentUser: ").append(toIndentedString(currentUser)).append("\n");
    sb.append("    keyword: ").append(toIndentedString(keyword)).append("\n");
    sb.append("    matchAnyRegion: ").append(toIndentedString(matchAnyRegion)).append("\n");
    sb.append("    matchAnysubGroupId: ").append(toIndentedString(matchAnysubGroupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
