/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * RelationResponse
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:30:21.574+08:00[Asia/Shanghai]")
public class RelationResponse {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("app_ids")
  private List<Long> appIds = null;

  public RelationResponse id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * CDP项目id
   * @return id
  **/
  @Schema(description = "CDP项目id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public RelationResponse name(String name) {
    this.name = name;
    return this;
  }

   /**
   * CDP项目名
   * @return name
  **/
  @Schema(description = "CDP项目名")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RelationResponse appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public RelationResponse addAppIdsItem(Long appIdsItem) {
    if (this.appIds == null) {
      this.appIds = new ArrayList<Long>();
    }
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * CDP该项目关联AppId列表
   * @return appIds
  **/
  @Schema(description = "CDP该项目关联AppId列表")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelationResponse relationResponse = (RelationResponse) o;
    return Objects.equals(this.id, relationResponse.id) &&
        Objects.equals(this.name, relationResponse.name) &&
        Objects.equals(this.appIds, relationResponse.appIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, appIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelationResponse {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
