/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * SegRule
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:37:04.708+08:00[Asia/Shanghai]")
public class SegRule {
  @SerializedName("segName")
  private String segName = null;

  @SerializedName("filter")
  private JsonNode filter = null;

  @SerializedName("segOnly")
  private Boolean segOnly = null;

  @SerializedName("segId")
  private Integer segId = null;

  @SerializedName("isExperimental")
  private Boolean isExperimental = null;

  @SerializedName("count")
  private Long count = null;

  @SerializedName("computeDate")
  private String computeDate = null;

  @SerializedName("tagDate")
  private String tagDate = null;

  public SegRule segName(String segName) {
    this.segName = segName;
    return this;
  }

   /**
   * 人群名称
   * @return segName
  **/
  @Schema(required = true, description = "人群名称")
  public String getSegName() {
    return segName;
  }

  public void setSegName(String segName) {
    this.segName = segName;
  }

  public SegRule filter(JsonNode filter) {
    this.filter = filter;
    return this;
  }

   /**
   * Get filter
   * @return filter
  **/
  @Schema(required = true, description = "")
  public JsonNode getFilter() {
    return filter;
  }

  public void setFilter(JsonNode filter) {
    this.filter = filter;
  }

  public SegRule segOnly(Boolean segOnly) {
    this.segOnly = segOnly;
    return this;
  }

   /**
   * 是否是已有人群
   * @return segOnly
  **/
  @Schema(description = "是否是已有人群")
  public Boolean isSegOnly() {
    return segOnly;
  }

  public void setSegOnly(Boolean segOnly) {
    this.segOnly = segOnly;
  }

  public SegRule segId(Integer segId) {
    this.segId = segId;
    return this;
  }

   /**
   * 已有人群Id
   * @return segId
  **/
  @Schema(description = "已有人群Id")
  public Integer getSegId() {
    return segId;
  }

  public void setSegId(Integer segId) {
    this.segId = segId;
  }

  public SegRule isExperimental(Boolean isExperimental) {
    this.isExperimental = isExperimental;
    return this;
  }

   /**
   * 是否是实验组
   * @return isExperimental
  **/
  @Schema(description = "是否是实验组")
  public Boolean isIsExperimental() {
    return isExperimental;
  }

  public void setIsExperimental(Boolean isExperimental) {
    this.isExperimental = isExperimental;
  }

  public SegRule count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * 人群数量
   * @return count
  **/
  @Schema(description = "人群数量")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public SegRule computeDate(String computeDate) {
    this.computeDate = computeDate;
    return this;
  }

   /**
   * 计算日期
   * @return computeDate
  **/
  @Schema(description = "计算日期")
  public String getComputeDate() {
    return computeDate;
  }

  public void setComputeDate(String computeDate) {
    this.computeDate = computeDate;
  }

  public SegRule tagDate(String tagDate) {
    this.tagDate = tagDate;
    return this;
  }

   /**
   * 指定标签日期
   * @return tagDate
  **/
  @Schema(description = "指定标签日期")
  public String getTagDate() {
    return tagDate;
  }

  public void setTagDate(String tagDate) {
    this.tagDate = tagDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SegRule segRule = (SegRule) o;
    return Objects.equals(this.segName, segRule.segName) &&
        Objects.equals(this.filter, segRule.filter) &&
        Objects.equals(this.segOnly, segRule.segOnly) &&
        Objects.equals(this.segId, segRule.segId) &&
        Objects.equals(this.isExperimental, segRule.isExperimental) &&
        Objects.equals(this.count, segRule.count) &&
        Objects.equals(this.computeDate, segRule.computeDate) &&
        Objects.equals(this.tagDate, segRule.tagDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(segName, filter, segOnly, segId, isExperimental, count, computeDate, tagDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SegRule {\n");
    
    sb.append("    segName: ").append(toIndentedString(segName)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    segOnly: ").append(toIndentedString(segOnly)).append("\n");
    sb.append("    segId: ").append(toIndentedString(segId)).append("\n");
    sb.append("    isExperimental: ").append(toIndentedString(isExperimental)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    computeDate: ").append(toIndentedString(computeDate)).append("\n");
    sb.append("    tagDate: ").append(toIndentedString(tagDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
