/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.SegmentExtraCondition;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * SegmentCondition
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-20T17:15:42.591+08:00[Asia/Shanghai]")
public class SegmentCondition {
  @SerializedName("targetIdTypeId")
  private Integer targetIdTypeId = null;

  @SerializedName("majorIdValues")
  private List<String> majorIdValues = null;

  /**
   * 加密方式，None值仅在查询使用，创建和修改时勿用！！！
   */
  @JsonAdapter(EncryptionMethodEnum.Adapter.class)
  public enum EncryptionMethodEnum {
    UNKNOWN("Unknown"),
    SHA256("SHA256"),
    MD5("MD5"),
    AES256("AES256"),
    NONE("None");

    private String value;

    EncryptionMethodEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static EncryptionMethodEnum fromValue(String input) {
      for (EncryptionMethodEnum b : EncryptionMethodEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<EncryptionMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EncryptionMethodEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public EncryptionMethodEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return EncryptionMethodEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("encryptionMethod")
  private EncryptionMethodEnum encryptionMethod = null;

  @SerializedName("onlineServiceEnabled")
  private Boolean onlineServiceEnabled = null;

  @SerializedName("extraCondition")
  private SegmentExtraCondition extraCondition = null;

  @SerializedName("realtimeEnabled")
  private Boolean realtimeEnabled = null;

  @SerializedName("sampleLimit")
  private Integer sampleLimit = null;

  public SegmentCondition targetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
    return this;
  }

   /**
   * 导出实体id，公域写死0
   * @return targetIdTypeId
  **/
  @Schema(required = true, description = "导出实体id，公域写死0")
  public Integer getTargetIdTypeId() {
    return targetIdTypeId;
  }

  public void setTargetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
  }

  public SegmentCondition majorIdValues(List<String> majorIdValues) {
    this.majorIdValues = majorIdValues;
    return this;
  }

  public SegmentCondition addMajorIdValuesItem(String majorIdValuesItem) {
    if (this.majorIdValues == null) {
      this.majorIdValues = new ArrayList<String>();
    }
    this.majorIdValues.add(majorIdValuesItem);
    return this;
  }

   /**
   * 组合id主id筛选项
   * @return majorIdValues
  **/
  @Schema(description = "组合id主id筛选项")
  public List<String> getMajorIdValues() {
    return majorIdValues;
  }

  public void setMajorIdValues(List<String> majorIdValues) {
    this.majorIdValues = majorIdValues;
  }

  public SegmentCondition encryptionMethod(EncryptionMethodEnum encryptionMethod) {
    this.encryptionMethod = encryptionMethod;
    return this;
  }

   /**
   * 加密方式，None值仅在查询使用，创建和修改时勿用！！！
   * @return encryptionMethod
  **/
  @Schema(description = "加密方式，None值仅在查询使用，创建和修改时勿用！！！")
  public EncryptionMethodEnum getEncryptionMethod() {
    return encryptionMethod;
  }

  public void setEncryptionMethod(EncryptionMethodEnum encryptionMethod) {
    this.encryptionMethod = encryptionMethod;
  }

  public SegmentCondition onlineServiceEnabled(Boolean onlineServiceEnabled) {
    this.onlineServiceEnabled = onlineServiceEnabled;
    return this;
  }

   /**
   * 在线服务开关是否开启
   * @return onlineServiceEnabled
  **/
  @Schema(description = "在线服务开关是否开启")
  public Boolean isOnlineServiceEnabled() {
    return onlineServiceEnabled;
  }

  public void setOnlineServiceEnabled(Boolean onlineServiceEnabled) {
    this.onlineServiceEnabled = onlineServiceEnabled;
  }

  public SegmentCondition extraCondition(SegmentExtraCondition extraCondition) {
    this.extraCondition = extraCondition;
    return this;
  }

   /**
   * Get extraCondition
   * @return extraCondition
  **/
  @Schema(description = "")
  public SegmentExtraCondition getExtraCondition() {
    return extraCondition;
  }

  public void setExtraCondition(SegmentExtraCondition extraCondition) {
    this.extraCondition = extraCondition;
  }

  public SegmentCondition realtimeEnabled(Boolean realtimeEnabled) {
    this.realtimeEnabled = realtimeEnabled;
    return this;
  }

   /**
   * 实时任务是否开启
   * @return realtimeEnabled
  **/
  @Schema(description = "实时任务是否开启")
  public Boolean isRealtimeEnabled() {
    return realtimeEnabled;
  }

  public void setRealtimeEnabled(Boolean realtimeEnabled) {
    this.realtimeEnabled = realtimeEnabled;
  }

  public SegmentCondition sampleLimit(Integer sampleLimit) {
    this.sampleLimit = sampleLimit;
    return this;
  }

   /**
   * 抽样数量
   * @return sampleLimit
  **/
  @Schema(description = "抽样数量")
  public Integer getSampleLimit() {
    return sampleLimit;
  }

  public void setSampleLimit(Integer sampleLimit) {
    this.sampleLimit = sampleLimit;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SegmentCondition segmentCondition = (SegmentCondition) o;
    return Objects.equals(this.targetIdTypeId, segmentCondition.targetIdTypeId) &&
        Objects.equals(this.majorIdValues, segmentCondition.majorIdValues) &&
        Objects.equals(this.encryptionMethod, segmentCondition.encryptionMethod) &&
        Objects.equals(this.onlineServiceEnabled, segmentCondition.onlineServiceEnabled) &&
        Objects.equals(this.extraCondition, segmentCondition.extraCondition) &&
        Objects.equals(this.realtimeEnabled, segmentCondition.realtimeEnabled) &&
        Objects.equals(this.sampleLimit, segmentCondition.sampleLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targetIdTypeId, majorIdValues, encryptionMethod, onlineServiceEnabled, extraCondition, realtimeEnabled, sampleLimit);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SegmentCondition {\n");
    
    sb.append("    targetIdTypeId: ").append(toIndentedString(targetIdTypeId)).append("\n");
    sb.append("    majorIdValues: ").append(toIndentedString(majorIdValues)).append("\n");
    sb.append("    encryptionMethod: ").append(toIndentedString(encryptionMethod)).append("\n");
    sb.append("    onlineServiceEnabled: ").append(toIndentedString(onlineServiceEnabled)).append("\n");
    sb.append("    extraCondition: ").append(toIndentedString(extraCondition)).append("\n");
    sb.append("    realtimeEnabled: ").append(toIndentedString(realtimeEnabled)).append("\n");
    sb.append("    sampleLimit: ").append(toIndentedString(sampleLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
