/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * SegmentTaskResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-20T17:15:42.591+08:00[Asia/Shanghai]")
public class SegmentTaskResult {
  @SerializedName("taskTime")
  private String taskTime = null;

  @SerializedName("startTime")
  private String startTime = null;

  @SerializedName("endTime")
  private String endTime = null;

  /**
   * 任务状态
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    UNKNOWN("Unknown"),
    CREATED("Created"),
    PENDING("Pending"),
    RUNNING("Running"),
    SUCCESS("Success"),
    FAILED("Failed"),
    NOTCREATED("NotCreated"),
    WAITING("Waiting"),
    STOPPED("Stopped");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static StatusEnum fromValue(String input) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return StatusEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("status")
  private StatusEnum status = null;

  /**
   * 任务类型
   */
  @JsonAdapter(TaskTypeEnum.Adapter.class)
  public enum TaskTypeEnum {
    UNKNOWN("Unknown"),
    FILETASK("FileTask"),
    BITMAPTASK("BitmapTask"),
    ONLINESERVICETASK("OnlineServiceTask"),
    PUBLICTASK("PublicTask"),
    REALTIMETASK("RealtimeTask"),
    FILEUPLOADTASK("FileUploadTask");

    private String value;

    TaskTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TaskTypeEnum fromValue(String input) {
      for (TaskTypeEnum b : TaskTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TaskTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TaskTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TaskTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TaskTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("taskType")
  private TaskTypeEnum taskType = null;

  @SerializedName("errMsg")
  private String errMsg = null;

  @SerializedName("elapseTime")
  private Long elapseTime = null;

  @SerializedName("count")
  private Long count = null;

  @SerializedName("filePath")
  private String filePath = null;

  public SegmentTaskResult taskTime(String taskTime) {
    this.taskTime = taskTime;
    return this;
  }

   /**
   * 任务业务时间
   * @return taskTime
  **/
  @Schema(required = true, description = "任务业务时间")
  public String getTaskTime() {
    return taskTime;
  }

  public void setTaskTime(String taskTime) {
    this.taskTime = taskTime;
  }

  public SegmentTaskResult startTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

   /**
   * 任务开始时间
   * @return startTime
  **/
  @Schema(required = true, description = "任务开始时间")
  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public SegmentTaskResult endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

   /**
   * 任务结束时间
   * @return endTime
  **/
  @Schema(required = true, description = "任务结束时间")
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public SegmentTaskResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * 任务状态
   * @return status
  **/
  @Schema(required = true, description = "任务状态")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public SegmentTaskResult taskType(TaskTypeEnum taskType) {
    this.taskType = taskType;
    return this;
  }

   /**
   * 任务类型
   * @return taskType
  **/
  @Schema(required = true, description = "任务类型")
  public TaskTypeEnum getTaskType() {
    return taskType;
  }

  public void setTaskType(TaskTypeEnum taskType) {
    this.taskType = taskType;
  }

  public SegmentTaskResult errMsg(String errMsg) {
    this.errMsg = errMsg;
    return this;
  }

   /**
   * 错误类型
   * @return errMsg
  **/
  @Schema(description = "错误类型")
  public String getErrMsg() {
    return errMsg;
  }

  public void setErrMsg(String errMsg) {
    this.errMsg = errMsg;
  }

  public SegmentTaskResult elapseTime(Long elapseTime) {
    this.elapseTime = elapseTime;
    return this;
  }

   /**
   * 执行时间
   * @return elapseTime
  **/
  @Schema(required = true, description = "执行时间")
  public Long getElapseTime() {
    return elapseTime;
  }

  public void setElapseTime(Long elapseTime) {
    this.elapseTime = elapseTime;
  }

  public SegmentTaskResult count(Long count) {
    this.count = count;
    return this;
  }

   /**
   * Get count
   * @return count
  **/
  @Schema(description = "")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public SegmentTaskResult filePath(String filePath) {
    this.filePath = filePath;
    return this;
  }

   /**
   * Get filePath
   * @return filePath
  **/
  @Schema(description = "")
  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SegmentTaskResult segmentTaskResult = (SegmentTaskResult) o;
    return Objects.equals(this.taskTime, segmentTaskResult.taskTime) &&
        Objects.equals(this.startTime, segmentTaskResult.startTime) &&
        Objects.equals(this.endTime, segmentTaskResult.endTime) &&
        Objects.equals(this.status, segmentTaskResult.status) &&
        Objects.equals(this.taskType, segmentTaskResult.taskType) &&
        Objects.equals(this.errMsg, segmentTaskResult.errMsg) &&
        Objects.equals(this.elapseTime, segmentTaskResult.elapseTime) &&
        Objects.equals(this.count, segmentTaskResult.count) &&
        Objects.equals(this.filePath, segmentTaskResult.filePath);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taskTime, startTime, endTime, status, taskType, errMsg, elapseTime, count, filePath);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SegmentTaskResult {\n");
    
    sb.append("    taskTime: ").append(toIndentedString(taskTime)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    taskType: ").append(toIndentedString(taskType)).append("\n");
    sb.append("    errMsg: ").append(toIndentedString(errMsg)).append("\n");
    sb.append("    elapseTime: ").append(toIndentedString(elapseTime)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    filePath: ").append(toIndentedString(filePath)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
