/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.LabelSetting;
import code.byted.inter.model.TosAuthSetting;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * SimplifiedSegCreateOrUpdateRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-20T17:15:42.591+08:00[Asia/Shanghai]")
public class SimplifiedSegCreateOrUpdateRequest {
  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("targetIdTypeId")
  private Integer targetIdTypeId = null;

  @SerializedName("filter")
  private Object filter = null;

  /**
   * 更新方式，默认一次性
   */
  @JsonAdapter(ScheduleTypeEnum.Adapter.class)
  public enum ScheduleTypeEnum {
    UNKNOWN("Unknown"),
    DAILY("Daily"),
    TRIGGER("Trigger"),
    REALTIME("Realtime");

    private String value;

    ScheduleTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleTypeEnum fromValue(String input) {
      for (ScheduleTypeEnum b : ScheduleTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleType")
  private ScheduleTypeEnum scheduleType = null;

  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  @SerializedName("isHidden")
  private Boolean isHidden = null;

  @SerializedName("appId")
  private Long appId = null;

  @SerializedName("segResourceSecurityLevel")
  private Integer segResourceSecurityLevel = null;

  @SerializedName("productKey")
  private String productKey = null;

  @SerializedName("sampleLimit")
  private Integer sampleLimit = null;

  @SerializedName("labelSetting")
  private LabelSetting labelSetting = null;

  @SerializedName("tosAuthSetting")
  private TosAuthSetting tosAuthSetting = null;

  /**
   * Gets or Sets dependencyResourceTypes
   */
  @JsonAdapter(DependencyResourceTypesEnum.Adapter.class)
  public enum DependencyResourceTypesEnum {
    UNKNOWN("Unknown"),
    LABEL("label"),
    ID("id"),
    SEGMENT("segment"),
    EVENT("event"),
    USERPROPERTY("userProperty"),
    DETAILDATA("detailData");

    private String value;

    DependencyResourceTypesEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static DependencyResourceTypesEnum fromValue(String input) {
      for (DependencyResourceTypesEnum b : DependencyResourceTypesEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<DependencyResourceTypesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DependencyResourceTypesEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public DependencyResourceTypesEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return DependencyResourceTypesEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("dependencyResourceTypes")
  private List<DependencyResourceTypesEnum> dependencyResourceTypes = null;

  public SimplifiedSegCreateOrUpdateRequest name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 分群名称
   * @return name
  **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public SimplifiedSegCreateOrUpdateRequest desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 分群描述
   * @return desc
  **/
  @Schema(description = "分群描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public SimplifiedSegCreateOrUpdateRequest targetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
    return this;
  }

   /**
   * 导出实体id，公域写死0
   * @return targetIdTypeId
  **/
  @Schema(required = true, description = "导出实体id，公域写死0")
  public Integer getTargetIdTypeId() {
    return targetIdTypeId;
  }

  public void setTargetIdTypeId(Integer targetIdTypeId) {
    this.targetIdTypeId = targetIdTypeId;
  }

  public SimplifiedSegCreateOrUpdateRequest filter(Object filter) {
    this.filter = filter;
    return this;
  }

   /**
   * 圈人条件
   * @return filter
  **/
  @Schema(required = true, description = "圈人条件")
  public Object getFilter() {
    return filter;
  }

  public void setFilter(Object filter) {
    this.filter = filter;
  }

  public SimplifiedSegCreateOrUpdateRequest scheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
    return this;
  }

   /**
   * 更新方式，默认一次性
   * @return scheduleType
  **/
  @Schema(description = "更新方式，默认一次性")
  public ScheduleTypeEnum getScheduleType() {
    return scheduleType;
  }

  public void setScheduleType(ScheduleTypeEnum scheduleType) {
    this.scheduleType = scheduleType;
  }

  public SimplifiedSegCreateOrUpdateRequest scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 任务执行时间，00:00格式
   * @return scheduleTime
  **/
  @Schema(description = "任务执行时间，00:00格式")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public SimplifiedSegCreateOrUpdateRequest sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

   /**
   * 来源平台
   * @return sourcePlatform
  **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public SimplifiedSegCreateOrUpdateRequest isHidden(Boolean isHidden) {
    this.isHidden = isHidden;
    return this;
  }

   /**
   * 是否为隐藏分群
   * @return isHidden
  **/
  @Schema(description = "是否为隐藏分群")
  public Boolean isIsHidden() {
    return isHidden;
  }

  public void setIsHidden(Boolean isHidden) {
    this.isHidden = isHidden;
  }

  public SimplifiedSegCreateOrUpdateRequest appId(Long appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 【域内】产品线id
   * @return appId
  **/
  @Schema(description = "【域内】产品线id")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  public SimplifiedSegCreateOrUpdateRequest segResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
    return this;
  }

   /**
   * 域内：kani 权限等级，L1,L2 支持主动授权, 默认不传为L2
   * @return segResourceSecurityLevel
  **/
  @Schema(description = "域内：kani 权限等级，L1,L2 支持主动授权, 默认不传为L2")
  public Integer getSegResourceSecurityLevel() {
    return segResourceSecurityLevel;
  }

  public void setSegResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
  }

  public SimplifiedSegCreateOrUpdateRequest productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

   /**
   * 域内：部门唯一键，安全等级为L4时必传，前端会调权限服务获取，业务方直接透传即可
   * @return productKey
  **/
  @Schema(description = "域内：部门唯一键，安全等级为L4时必传，前端会调权限服务获取，业务方直接透传即可")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public SimplifiedSegCreateOrUpdateRequest sampleLimit(Integer sampleLimit) {
    this.sampleLimit = sampleLimit;
    return this;
  }

   /**
   * 抽样数量，和 labelSetting 二选一传入
   * @return sampleLimit
  **/
  @Schema(description = "抽样数量，和 labelSetting 二选一传入")
  public Integer getSampleLimit() {
    return sampleLimit;
  }

  public void setSampleLimit(Integer sampleLimit) {
    this.sampleLimit = sampleLimit;
  }

  public SimplifiedSegCreateOrUpdateRequest labelSetting(LabelSetting labelSetting) {
    this.labelSetting = labelSetting;
    return this;
  }

   /**
   * Get labelSetting
   * @return labelSetting
  **/
  @Schema(description = "")
  public LabelSetting getLabelSetting() {
    return labelSetting;
  }

  public void setLabelSetting(LabelSetting labelSetting) {
    this.labelSetting = labelSetting;
  }

  public SimplifiedSegCreateOrUpdateRequest tosAuthSetting(TosAuthSetting tosAuthSetting) {
    this.tosAuthSetting = tosAuthSetting;
    return this;
  }

   /**
   * Get tosAuthSetting
   * @return tosAuthSetting
  **/
  @Schema(description = "")
  public TosAuthSetting getTosAuthSetting() {
    return tosAuthSetting;
  }

  public void setTosAuthSetting(TosAuthSetting tosAuthSetting) {
    this.tosAuthSetting = tosAuthSetting;
  }

  public SimplifiedSegCreateOrUpdateRequest dependencyResourceTypes(List<DependencyResourceTypesEnum> dependencyResourceTypes) {
    this.dependencyResourceTypes = dependencyResourceTypes;
    return this;
  }

  public SimplifiedSegCreateOrUpdateRequest addDependencyResourceTypesItem(DependencyResourceTypesEnum dependencyResourceTypesItem) {
    if (this.dependencyResourceTypes == null) {
      this.dependencyResourceTypes = new ArrayList<DependencyResourceTypesEnum>();
    }
    this.dependencyResourceTypes.add(dependencyResourceTypesItem);
    return this;
  }

   /**
   * 依赖资源类型, 传 null 标识按照默认依赖资源类型， 传 [] 标识不依赖
   * @return dependencyResourceTypes
  **/
  @Schema(description = "依赖资源类型, 传 null 标识按照默认依赖资源类型， 传 [] 标识不依赖")
  public List<DependencyResourceTypesEnum> getDependencyResourceTypes() {
    return dependencyResourceTypes;
  }

  public void setDependencyResourceTypes(List<DependencyResourceTypesEnum> dependencyResourceTypes) {
    this.dependencyResourceTypes = dependencyResourceTypes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SimplifiedSegCreateOrUpdateRequest simplifiedSegCreateOrUpdateRequest = (SimplifiedSegCreateOrUpdateRequest) o;
    return Objects.equals(this.name, simplifiedSegCreateOrUpdateRequest.name) &&
        Objects.equals(this.desc, simplifiedSegCreateOrUpdateRequest.desc) &&
        Objects.equals(this.targetIdTypeId, simplifiedSegCreateOrUpdateRequest.targetIdTypeId) &&
        Objects.equals(this.filter, simplifiedSegCreateOrUpdateRequest.filter) &&
        Objects.equals(this.scheduleType, simplifiedSegCreateOrUpdateRequest.scheduleType) &&
        Objects.equals(this.scheduleTime, simplifiedSegCreateOrUpdateRequest.scheduleTime) &&
        Objects.equals(this.sourcePlatform, simplifiedSegCreateOrUpdateRequest.sourcePlatform) &&
        Objects.equals(this.isHidden, simplifiedSegCreateOrUpdateRequest.isHidden) &&
        Objects.equals(this.appId, simplifiedSegCreateOrUpdateRequest.appId) &&
        Objects.equals(this.segResourceSecurityLevel, simplifiedSegCreateOrUpdateRequest.segResourceSecurityLevel) &&
        Objects.equals(this.productKey, simplifiedSegCreateOrUpdateRequest.productKey) &&
        Objects.equals(this.sampleLimit, simplifiedSegCreateOrUpdateRequest.sampleLimit) &&
        Objects.equals(this.labelSetting, simplifiedSegCreateOrUpdateRequest.labelSetting) &&
        Objects.equals(this.tosAuthSetting, simplifiedSegCreateOrUpdateRequest.tosAuthSetting) &&
        Objects.equals(this.dependencyResourceTypes, simplifiedSegCreateOrUpdateRequest.dependencyResourceTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, desc, targetIdTypeId, filter, scheduleType, scheduleTime, sourcePlatform, isHidden, appId, segResourceSecurityLevel, productKey, sampleLimit, labelSetting, tosAuthSetting, dependencyResourceTypes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SimplifiedSegCreateOrUpdateRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    targetIdTypeId: ").append(toIndentedString(targetIdTypeId)).append("\n");
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    scheduleType: ").append(toIndentedString(scheduleType)).append("\n");
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    isHidden: ").append(toIndentedString(isHidden)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    segResourceSecurityLevel: ").append(toIndentedString(segResourceSecurityLevel)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("    sampleLimit: ").append(toIndentedString(sampleLimit)).append("\n");
    sb.append("    labelSetting: ").append(toIndentedString(labelSetting)).append("\n");
    sb.append("    tosAuthSetting: ").append(toIndentedString(tosAuthSetting)).append("\n");
    sb.append("    dependencyResourceTypes: ").append(toIndentedString(dependencyResourceTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
