/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * SourcePermission
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class SourcePermission {
  @SerializedName("securityLevel")
  private Integer securityLevel = null;

  @SerializedName("personalDataRelated")
  private Integer personalDataRelated = null;

  @SerializedName("dataRegion")
  private List<String> dataRegion = null;

  public SourcePermission securityLevel(Integer securityLevel) {
    this.securityLevel = securityLevel;
    return this;
  }

   /**
   * 安全等级: 1,2,3,4 默认3
   * @return securityLevel
  **/
  @Schema(description = "安全等级: 1,2,3,4 默认3")
  public Integer getSecurityLevel() {
    return securityLevel;
  }

  public void setSecurityLevel(Integer securityLevel) {
    this.securityLevel = securityLevel;
  }

  public SourcePermission personalDataRelated(Integer personalDataRelated) {
    this.personalDataRelated = personalDataRelated;
    return this;
  }

   /**
   * 是否包含用户个人数据, 1为包含，0为不包含，不传默认为0
   * @return personalDataRelated
  **/
  @Schema(description = "是否包含用户个人数据, 1为包含，0为不包含，不传默认为0")
  public Integer getPersonalDataRelated() {
    return personalDataRelated;
  }

  public void setPersonalDataRelated(Integer personalDataRelated) {
    this.personalDataRelated = personalDataRelated;
  }

  public SourcePermission dataRegion(List<String> dataRegion) {
    this.dataRegion = dataRegion;
    return this;
  }

  public SourcePermission addDataRegionItem(String dataRegionItem) {
    if (this.dataRegion == null) {
      this.dataRegion = new ArrayList<String>();
    }
    this.dataRegion.add(dataRegionItem);
    return this;
  }

   /**
   * 用户信息所属区域, 只有以下4个枚举: CN/EUR/US/ROW，分别表示中国大陆，欧洲，美国，其他国家和地区，personal_data_related为1时必传，且不为空
   * @return dataRegion
  **/
  @Schema(description = "用户信息所属区域, 只有以下4个枚举: CN/EUR/US/ROW，分别表示中国大陆，欧洲，美国，其他国家和地区，personal_data_related为1时必传，且不为空")
  public List<String> getDataRegion() {
    return dataRegion;
  }

  public void setDataRegion(List<String> dataRegion) {
    this.dataRegion = dataRegion;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SourcePermission sourcePermission = (SourcePermission) o;
    return Objects.equals(this.securityLevel, sourcePermission.securityLevel) &&
        Objects.equals(this.personalDataRelated, sourcePermission.personalDataRelated) &&
        Objects.equals(this.dataRegion, sourcePermission.dataRegion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(securityLevel, personalDataRelated, dataRegion);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SourcePermission {\n");
    
    sb.append("    securityLevel: ").append(toIndentedString(securityLevel)).append("\n");
    sb.append("    personalDataRelated: ").append(toIndentedString(personalDataRelated)).append("\n");
    sb.append("    dataRegion: ").append(toIndentedString(dataRegion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
