/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.AppInfoVO;
import code.byted.inter.model.EventParams;
import code.byted.inter.model.FieldList;
import code.byted.inter.model.SourcePermission;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * UpdateDataSourceRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class UpdateDataSourceRequest {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("sourceName")
  private String sourceName = null;

  @SerializedName("sourceDesc")
  private String sourceDesc = null;

  @SerializedName("entityType")
  private String entityType = null;

  @SerializedName("entityIdField")
  private String entityIdField = null;

  @SerializedName("fieldList")
  private List<FieldList> fieldList = null;

  @SerializedName("eventParams")
  private EventParams eventParams = null;

  @SerializedName("sourcePermission")
  private SourcePermission sourcePermission = null;

  @SerializedName("sourceScope")
  private AppInfoVO sourceScope = null;

  public UpdateDataSourceRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 数据档案id
   * @return id
  **/
  @Schema(description = "数据档案id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public UpdateDataSourceRequest sourceName(String sourceName) {
    this.sourceName = sourceName;
    return this;
  }

   /**
   * 档案名
   * @return sourceName
  **/
  @Schema(description = "档案名")
  public String getSourceName() {
    return sourceName;
  }

  public void setSourceName(String sourceName) {
    this.sourceName = sourceName;
  }

  public UpdateDataSourceRequest sourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
    return this;
  }

   /**
   * 档案描述
   * @return sourceDesc
  **/
  @Schema(description = "档案描述")
  public String getSourceDesc() {
    return sourceDesc;
  }

  public void setSourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
  }

  public UpdateDataSourceRequest entityType(String entityType) {
    this.entityType = entityType;
    return this;
  }

   /**
   * 主体类型
   * @return entityType
  **/
  @Schema(description = "主体类型")
  public String getEntityType() {
    return entityType;
  }

  public void setEntityType(String entityType) {
    this.entityType = entityType;
  }

  public UpdateDataSourceRequest entityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
    return this;
  }

   /**
   * 基准ID字段
   * @return entityIdField
  **/
  @Schema(description = "基准ID字段")
  public String getEntityIdField() {
    return entityIdField;
  }

  public void setEntityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
  }

  public UpdateDataSourceRequest fieldList(List<FieldList> fieldList) {
    this.fieldList = fieldList;
    return this;
  }

  public UpdateDataSourceRequest addFieldListItem(FieldList fieldListItem) {
    if (this.fieldList == null) {
      this.fieldList = new ArrayList<FieldList>();
    }
    this.fieldList.add(fieldListItem);
    return this;
  }

   /**
   * 表字段信息
   * @return fieldList
  **/
  @Schema(description = "表字段信息")
  public List<FieldList> getFieldList() {
    return fieldList;
  }

  public void setFieldList(List<FieldList> fieldList) {
    this.fieldList = fieldList;
  }

  public UpdateDataSourceRequest eventParams(EventParams eventParams) {
    this.eventParams = eventParams;
    return this;
  }

   /**
   * Get eventParams
   * @return eventParams
  **/
  @Schema(description = "")
  public EventParams getEventParams() {
    return eventParams;
  }

  public void setEventParams(EventParams eventParams) {
    this.eventParams = eventParams;
  }

  public UpdateDataSourceRequest sourcePermission(SourcePermission sourcePermission) {
    this.sourcePermission = sourcePermission;
    return this;
  }

   /**
   * Get sourcePermission
   * @return sourcePermission
  **/
  @Schema(description = "")
  public SourcePermission getSourcePermission() {
    return sourcePermission;
  }

  public void setSourcePermission(SourcePermission sourcePermission) {
    this.sourcePermission = sourcePermission;
  }

  public UpdateDataSourceRequest sourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
    return this;
  }

   /**
   * Get sourceScope
   * @return sourceScope
  **/
  @Schema(description = "")
  public AppInfoVO getSourceScope() {
    return sourceScope;
  }

  public void setSourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateDataSourceRequest updateDataSourceRequest = (UpdateDataSourceRequest) o;
    return Objects.equals(this.id, updateDataSourceRequest.id) &&
        Objects.equals(this.sourceName, updateDataSourceRequest.sourceName) &&
        Objects.equals(this.sourceDesc, updateDataSourceRequest.sourceDesc) &&
        Objects.equals(this.entityType, updateDataSourceRequest.entityType) &&
        Objects.equals(this.entityIdField, updateDataSourceRequest.entityIdField) &&
        Objects.equals(this.fieldList, updateDataSourceRequest.fieldList) &&
        Objects.equals(this.eventParams, updateDataSourceRequest.eventParams) &&
        Objects.equals(this.sourcePermission, updateDataSourceRequest.sourcePermission) &&
        Objects.equals(this.sourceScope, updateDataSourceRequest.sourceScope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sourceName, sourceDesc, entityType, entityIdField, fieldList, eventParams, sourcePermission, sourceScope);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateDataSourceRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    sourceName: ").append(toIndentedString(sourceName)).append("\n");
    sb.append("    sourceDesc: ").append(toIndentedString(sourceDesc)).append("\n");
    sb.append("    entityType: ").append(toIndentedString(entityType)).append("\n");
    sb.append("    entityIdField: ").append(toIndentedString(entityIdField)).append("\n");
    sb.append("    fieldList: ").append(toIndentedString(fieldList)).append("\n");
    sb.append("    eventParams: ").append(toIndentedString(eventParams)).append("\n");
    sb.append("    sourcePermission: ").append(toIndentedString(sourcePermission)).append("\n");
    sb.append("    sourceScope: ").append(toIndentedString(sourceScope)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
