/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.TagDateRange;
import code.byted.inter.model.TagDateTimeRange;
import code.byted.inter.model.TagDecimalRange;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import org.threeten.bp.LocalDate;

/**
 * VerticalResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-14T16:15:54.436+08:00[Asia/Shanghai]")
public class VerticalResult {
  @SerializedName("tagId")
  private Integer tagId = null;

  @SerializedName("tagName")
  private String tagName = null;

  @SerializedName("countInSeg")
  private Long countInSeg = null;

  @SerializedName("tagProportion")
  private Double tagProportion = null;

  @SerializedName("tagShowValue")
  private String tagShowValue = null;

  @SerializedName("tagDateRange")
  private TagDateRange tagDateRange = null;

  @SerializedName("tagDecimalRange")
  private TagDecimalRange tagDecimalRange = null;

  @SerializedName("tagDecimalValue")
  private Double tagDecimalValue = null;

  @SerializedName("tagStringValue")
  private String tagStringValue = null;

  @SerializedName("tagDateTimeRange")
  private TagDateTimeRange tagDateTimeRange = null;

  @SerializedName("tagDateValue")
  private LocalDate tagDateValue = null;

  @SerializedName("tagDateTimeValue")
  private String tagDateTimeValue = null;

  public VerticalResult tagId(Integer tagId) {
    this.tagId = tagId;
    return this;
  }

   /**
   * 标签id
   * @return tagId
  **/
  @Schema(description = "标签id")
  public Integer getTagId() {
    return tagId;
  }

  public void setTagId(Integer tagId) {
    this.tagId = tagId;
  }

  public VerticalResult tagName(String tagName) {
    this.tagName = tagName;
    return this;
  }

   /**
   * 标签名称
   * @return tagName
  **/
  @Schema(description = "标签名称")
  public String getTagName() {
    return tagName;
  }

  public void setTagName(String tagName) {
    this.tagName = tagName;
  }

  public VerticalResult countInSeg(Long countInSeg) {
    this.countInSeg = countInSeg;
    return this;
  }

   /**
   * 标签值在所选人群中的数量
   * @return countInSeg
  **/
  @Schema(required = true, description = "标签值在所选人群中的数量")
  public Long getCountInSeg() {
    return countInSeg;
  }

  public void setCountInSeg(Long countInSeg) {
    this.countInSeg = countInSeg;
  }

  public VerticalResult tagProportion(Double tagProportion) {
    this.tagProportion = tagProportion;
    return this;
  }

   /**
   * 占比
   * @return tagProportion
  **/
  @Schema(required = true, description = "占比")
  public Double getTagProportion() {
    return tagProportion;
  }

  public void setTagProportion(Double tagProportion) {
    this.tagProportion = tagProportion;
  }

  public VerticalResult tagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
    return this;
  }

   /**
   * 标签值展示值
   * @return tagShowValue
  **/
  @Schema(required = true, description = "标签值展示值")
  public String getTagShowValue() {
    return tagShowValue;
  }

  public void setTagShowValue(String tagShowValue) {
    this.tagShowValue = tagShowValue;
  }

  public VerticalResult tagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
    return this;
  }

   /**
   * Get tagDateRange
   * @return tagDateRange
  **/
  @Schema(description = "")
  public TagDateRange getTagDateRange() {
    return tagDateRange;
  }

  public void setTagDateRange(TagDateRange tagDateRange) {
    this.tagDateRange = tagDateRange;
  }

  public VerticalResult tagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
    return this;
  }

   /**
   * Get tagDecimalRange
   * @return tagDecimalRange
  **/
  @Schema(description = "")
  public TagDecimalRange getTagDecimalRange() {
    return tagDecimalRange;
  }

  public void setTagDecimalRange(TagDecimalRange tagDecimalRange) {
    this.tagDecimalRange = tagDecimalRange;
  }

  public VerticalResult tagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
    return this;
  }

   /**
   * 数值型标签值
   * @return tagDecimalValue
  **/
  @Schema(description = "数值型标签值")
  public Double getTagDecimalValue() {
    return tagDecimalValue;
  }

  public void setTagDecimalValue(Double tagDecimalValue) {
    this.tagDecimalValue = tagDecimalValue;
  }

  public VerticalResult tagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
    return this;
  }

   /**
   * 字符型标签值
   * @return tagStringValue
  **/
  @Schema(description = "字符型标签值")
  public String getTagStringValue() {
    return tagStringValue;
  }

  public void setTagStringValue(String tagStringValue) {
    this.tagStringValue = tagStringValue;
  }

  public VerticalResult tagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
    return this;
  }

   /**
   * Get tagDateTimeRange
   * @return tagDateTimeRange
  **/
  @Schema(description = "")
  public TagDateTimeRange getTagDateTimeRange() {
    return tagDateTimeRange;
  }

  public void setTagDateTimeRange(TagDateTimeRange tagDateTimeRange) {
    this.tagDateTimeRange = tagDateTimeRange;
  }

  public VerticalResult tagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
    return this;
  }

   /**
   * 特定日期
   * @return tagDateValue
  **/
  @Schema(description = "特定日期")
  public LocalDate getTagDateValue() {
    return tagDateValue;
  }

  public void setTagDateValue(LocalDate tagDateValue) {
    this.tagDateValue = tagDateValue;
  }

  public VerticalResult tagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
    return this;
  }

   /**
   * 特定日期时间
   * @return tagDateTimeValue
  **/
  @Schema(description = "特定日期时间")
  public String getTagDateTimeValue() {
    return tagDateTimeValue;
  }

  public void setTagDateTimeValue(String tagDateTimeValue) {
    this.tagDateTimeValue = tagDateTimeValue;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VerticalResult verticalResult = (VerticalResult) o;
    return Objects.equals(this.tagId, verticalResult.tagId) &&
        Objects.equals(this.tagName, verticalResult.tagName) &&
        Objects.equals(this.countInSeg, verticalResult.countInSeg) &&
        Objects.equals(this.tagProportion, verticalResult.tagProportion) &&
        Objects.equals(this.tagShowValue, verticalResult.tagShowValue) &&
        Objects.equals(this.tagDateRange, verticalResult.tagDateRange) &&
        Objects.equals(this.tagDecimalRange, verticalResult.tagDecimalRange) &&
        Objects.equals(this.tagDecimalValue, verticalResult.tagDecimalValue) &&
        Objects.equals(this.tagStringValue, verticalResult.tagStringValue) &&
        Objects.equals(this.tagDateTimeRange, verticalResult.tagDateTimeRange) &&
        Objects.equals(this.tagDateValue, verticalResult.tagDateValue) &&
        Objects.equals(this.tagDateTimeValue, verticalResult.tagDateTimeValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagId, tagName, countInSeg, tagProportion, tagShowValue, tagDateRange, tagDecimalRange, tagDecimalValue, tagStringValue, tagDateTimeRange, tagDateValue, tagDateTimeValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VerticalResult {\n");
    
    sb.append("    tagId: ").append(toIndentedString(tagId)).append("\n");
    sb.append("    tagName: ").append(toIndentedString(tagName)).append("\n");
    sb.append("    countInSeg: ").append(toIndentedString(countInSeg)).append("\n");
    sb.append("    tagProportion: ").append(toIndentedString(tagProportion)).append("\n");
    sb.append("    tagShowValue: ").append(toIndentedString(tagShowValue)).append("\n");
    sb.append("    tagDateRange: ").append(toIndentedString(tagDateRange)).append("\n");
    sb.append("    tagDecimalRange: ").append(toIndentedString(tagDecimalRange)).append("\n");
    sb.append("    tagDecimalValue: ").append(toIndentedString(tagDecimalValue)).append("\n");
    sb.append("    tagStringValue: ").append(toIndentedString(tagStringValue)).append("\n");
    sb.append("    tagDateTimeRange: ").append(toIndentedString(tagDateTimeRange)).append("\n");
    sb.append("    tagDateValue: ").append(toIndentedString(tagDateValue)).append("\n");
    sb.append("    tagDateTimeValue: ").append(toIndentedString(tagDateTimeValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
