/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.openapi;

import code.byted.inter.ApiCallback;
import code.byted.inter.ApiClient;
import code.byted.inter.ApiException;
import code.byted.inter.ApiResponse;
import code.byted.inter.Configuration;
import code.byted.inter.Pair;
import code.byted.inter.ProgressRequestBody;
import code.byted.inter.ProgressResponseBody;

import code.byted.inter.model.SimpleTimeSeriesReportRequest;
import code.byted.inter.model.SimpleTimeSeriesReportResponse;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.inter.model.ByteDanceResponseGraphRealtimeQueryResult;
import code.byted.inter.model.GraphRealtimeQueryReq;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InsightApi {
    private ApiClient apiClient;

    public InsightApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InsightApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for graphRealtimeQuery
     * @param body 图表实时查询参数 (required)
     * @param xTenant  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call graphRealtimeQueryCall(GraphRealtimeQueryReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","graphRealtimeQuery"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-10-12"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call graphRealtimeQueryValidateBeforeCall(GraphRealtimeQueryReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling graphRealtimeQuery(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling graphRealtimeQuery(Async)");
        }

        com.squareup.okhttp.Call call = graphRealtimeQueryCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 图表实时查询
     * 图表实时查询
     * @param body 图表实时查询参数 (required)
     * @param xTenant  (required)
     * @return ByteDanceResponseGraphRealtimeQueryResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceResponseGraphRealtimeQueryResult graphRealtimeQuery(GraphRealtimeQueryReq body, Integer xTenant) throws ApiException {
        ApiResponse<ByteDanceResponseGraphRealtimeQueryResult> resp = graphRealtimeQueryWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 图表实时查询
     * 图表实时查询
     * @param body 图表实时查询参数 (required)
     * @param xTenant  (required)
     * @return ApiResponse&lt;ByteDanceResponseGraphRealtimeQueryResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceResponseGraphRealtimeQueryResult> graphRealtimeQueryWithHttpInfo(GraphRealtimeQueryReq body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = graphRealtimeQueryValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceResponseGraphRealtimeQueryResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 图表实时查询 (asynchronously)
     * 图表实时查询
     * @param body 图表实时查询参数 (required)
     * @param xTenant  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call graphRealtimeQueryAsync(GraphRealtimeQueryReq body, Integer xTenant, final ApiCallback<ByteDanceResponseGraphRealtimeQueryResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = graphRealtimeQueryValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceResponseGraphRealtimeQueryResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTimeSeriesTagReportA
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTimeSeriesTagReportACall(SimpleTimeSeriesReportRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTimeSeriesTagReportA"));
        localVarQueryParams.add(new Pair("ApiVersion","2025-06-13"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTimeSeriesTagReportAValidateBeforeCall(SimpleTimeSeriesReportRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        com.squareup.okhttp.Call call = getTimeSeriesTagReportACall(body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 按天按标签按指标查询
     *
     * @param body  (optional)
     * @return SimpleTimeSeriesReportResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SimpleTimeSeriesReportResponse getTimeSeriesTagReportA(SimpleTimeSeriesReportRequest body) throws ApiException {
        ApiResponse<SimpleTimeSeriesReportResponse> resp = getTimeSeriesTagReportAWithHttpInfo(body);
        return resp.getData();
    }


    /**
     * 按天按标签按指标查询
     *
     * @param body  (optional)
     * @return ApiResponse&lt;SimpleTimeSeriesReportResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SimpleTimeSeriesReportResponse> getTimeSeriesTagReportAWithHttpInfo(SimpleTimeSeriesReportRequest body) throws ApiException {
        com.squareup.okhttp.Call call = getTimeSeriesTagReportAValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<SimpleTimeSeriesReportResponse>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 按天按标签按指标查询 (asynchronously)
     *
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTimeSeriesTagReportAAsync(SimpleTimeSeriesReportRequest body, final ApiCallback<SimpleTimeSeriesReportResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getTimeSeriesTagReportAValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SimpleTimeSeriesReportResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

}
