/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.AnalysisCommonDomainSimpleVO;
import code.byted.cdp.model.AnalysisModuleObjBelong;
import code.byted.cdp.model.BaseDimension;
import code.byted.cdp.model.BaseMetrics;
import code.byted.cdp.model.BasePeriod;
import code.byted.cdp.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * AnalysisModuleObjResp
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class AnalysisModuleObjResp {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("analysisModuleObjId")
  private Integer analysisModuleObjId = null;

  @SerializedName("analysisModuleObjName")
  private String analysisModuleObjName = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("descr")
  private String descr = null;

  @SerializedName("seg")
  private JsonNode seg = null;

  @SerializedName("dimension")
  private BaseDimension dimension = null;

  @SerializedName("period")
  private BasePeriod period = null;

  @SerializedName("metrics")
  private BaseMetrics metrics = null;

  @SerializedName("segRequired")
  private Boolean segRequired = null;

  @SerializedName("dimensionRequired")
  private Boolean dimensionRequired = null;

  @SerializedName("periodRequired")
  private Boolean periodRequired = null;

  @SerializedName("metricsRequired")
  private Boolean metricsRequired = null;

  /**
   * 计算类型
   */
  @JsonAdapter(AnalysisTypeEnum.Adapter.class)
  public enum AnalysisTypeEnum {
    UNKNOWN("Unknown"),
    USER_TENDENCY("USER_TENDENCY"),
    TRANS("TRANS"),
    ATTRIBUTION("ATTRIBUTION"),
    ATTRIBUTION_COLUMN("ATTRIBUTION_COLUMN"),
    NORMAL("NORMAL"),
    NORMAL_COLUMN("NORMAL_COLUMN"),
    CROSS_DIMENSION("CROSS_DIMENSION"),
    NORMAL_COLUMN_LINKAGE("NORMAL_COLUMN_LINKAGE"),
    NORMAL_COUNT("NORMAL_COUNT"),
    CROSS_DIMENSION_MERGE("CROSS_DIMENSION_MERGE"),
    EXTRA("EXTRA");

    private String value;

    AnalysisTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static AnalysisTypeEnum fromValue(String input) {
      for (AnalysisTypeEnum b : AnalysisTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<AnalysisTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AnalysisTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public AnalysisTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return AnalysisTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("analysisType")
  private AnalysisTypeEnum analysisType = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("analysisModuleObjCreator")
  private String analysisModuleObjCreator = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("updater")
  private String updater = null;

  /**
   * 公私域类型
   */
  @JsonAdapter(DomainTypeEnum.Adapter.class)
  public enum DomainTypeEnum {
    UNKNOWN("Unknown"),
    PRIVATE("Private"),
    PUBLIC("Public");

    private String value;

    DomainTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static DomainTypeEnum fromValue(String input) {
      for (DomainTypeEnum b : DomainTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<DomainTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DomainTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public DomainTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return DomainTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("domainType")
  private DomainTypeEnum domainType = null;

  @SerializedName("authFilter")
  private Boolean authFilter = null;

  @SerializedName("displayConfig")
  private JsonNode displayConfig = null;

  @SerializedName("cdpModules")
  private List<AnalysisModuleObjBelong> cdpModules = null;

  @SerializedName("periodShow")
  private String periodShow = null;

  @SerializedName("attributionModelType")
  private String attributionModelType = null;

  @SerializedName("platform")
  private String platform = null;

  @SerializedName("active")
  private Boolean active = null;

  @SerializedName("scheduleTime")
  private String scheduleTime = null;

  /**
   * Gets or Sets scheduleRange
   */
  @JsonAdapter(ScheduleRangeEnum.Adapter.class)
  public enum ScheduleRangeEnum {
    UNKNOWN("Unknown"),
    MANUAL("MANUAL"),
    DAILY("DAILY"),
    WEEKLY("WEEKLY"),
    MONTHLY("MONTHLY");

    private String value;

    ScheduleRangeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static ScheduleRangeEnum fromValue(String input) {
      for (ScheduleRangeEnum b : ScheduleRangeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<ScheduleRangeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ScheduleRangeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public ScheduleRangeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return ScheduleRangeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("scheduleRange")
  private ScheduleRangeEnum scheduleRange = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("usableCdpModules")
  private List<String> usableCdpModules = null;

  @SerializedName("editAble")
  private Boolean editAble = null;

  @SerializedName("deleteAble")
  private Boolean deleteAble = null;

  @SerializedName("message")
  private String message = null;

  @SerializedName("bookmark")
  private Boolean bookmark = null;

  @SerializedName("domainInfos")
  private List<AnalysisCommonDomainSimpleVO> domainInfos = null;

  @SerializedName("authSchema")
  private JsonNode authSchema = null;

  @SerializedName("panelId")
  private Integer panelId = null;

  public AnalysisModuleObjResp id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public AnalysisModuleObjResp analysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
    return this;
  }

   /**
   * Get analysisModuleObjId
   * @return analysisModuleObjId
  **/
  @Schema(description = "")
  public Integer getAnalysisModuleObjId() {
    return analysisModuleObjId;
  }

  public void setAnalysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
  }

  public AnalysisModuleObjResp analysisModuleObjName(String analysisModuleObjName) {
    this.analysisModuleObjName = analysisModuleObjName;
    return this;
  }

   /**
   * 指标名称
   * @return analysisModuleObjName
  **/
  @Schema(required = true, description = "指标名称")
  public String getAnalysisModuleObjName() {
    return analysisModuleObjName;
  }

  public void setAnalysisModuleObjName(String analysisModuleObjName) {
    this.analysisModuleObjName = analysisModuleObjName;
  }

  public AnalysisModuleObjResp name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AnalysisModuleObjResp descr(String descr) {
    this.descr = descr;
    return this;
  }

   /**
   * 指标描述
   * @return descr
  **/
  @Schema(required = true, description = "指标描述")
  public String getDescr() {
    return descr;
  }

  public void setDescr(String descr) {
    this.descr = descr;
  }

  public AnalysisModuleObjResp seg(JsonNode seg) {
    this.seg = seg;
    return this;
  }

   /**
   * Get seg
   * @return seg
  **/
  @Schema(description = "")
  public JsonNode getSeg() {
    return seg;
  }

  public void setSeg(JsonNode seg) {
    this.seg = seg;
  }

  public AnalysisModuleObjResp dimension(BaseDimension dimension) {
    this.dimension = dimension;
    return this;
  }

   /**
   * Get dimension
   * @return dimension
  **/
  @Schema(description = "")
  public BaseDimension getDimension() {
    return dimension;
  }

  public void setDimension(BaseDimension dimension) {
    this.dimension = dimension;
  }

  public AnalysisModuleObjResp period(BasePeriod period) {
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @Schema(description = "")
  public BasePeriod getPeriod() {
    return period;
  }

  public void setPeriod(BasePeriod period) {
    this.period = period;
  }

  public AnalysisModuleObjResp metrics(BaseMetrics metrics) {
    this.metrics = metrics;
    return this;
  }

   /**
   * Get metrics
   * @return metrics
  **/
  @Schema(description = "")
  public BaseMetrics getMetrics() {
    return metrics;
  }

  public void setMetrics(BaseMetrics metrics) {
    this.metrics = metrics;
  }

  public AnalysisModuleObjResp segRequired(Boolean segRequired) {
    this.segRequired = segRequired;
    return this;
  }

   /**
   * 是否需要传入人群条件
   * @return segRequired
  **/
  @Schema(required = true, description = "是否需要传入人群条件")
  public Boolean isSegRequired() {
    return segRequired;
  }

  public void setSegRequired(Boolean segRequired) {
    this.segRequired = segRequired;
  }

  public AnalysisModuleObjResp dimensionRequired(Boolean dimensionRequired) {
    this.dimensionRequired = dimensionRequired;
    return this;
  }

   /**
   * 是否需要传入维度条件
   * @return dimensionRequired
  **/
  @Schema(required = true, description = "是否需要传入维度条件")
  public Boolean isDimensionRequired() {
    return dimensionRequired;
  }

  public void setDimensionRequired(Boolean dimensionRequired) {
    this.dimensionRequired = dimensionRequired;
  }

  public AnalysisModuleObjResp periodRequired(Boolean periodRequired) {
    this.periodRequired = periodRequired;
    return this;
  }

   /**
   * 是否需要传入时间周期
   * @return periodRequired
  **/
  @Schema(required = true, description = "是否需要传入时间周期")
  public Boolean isPeriodRequired() {
    return periodRequired;
  }

  public void setPeriodRequired(Boolean periodRequired) {
    this.periodRequired = periodRequired;
  }

  public AnalysisModuleObjResp metricsRequired(Boolean metricsRequired) {
    this.metricsRequired = metricsRequired;
    return this;
  }

   /**
   * 是否需要传入指标条件
   * @return metricsRequired
  **/
  @Schema(required = true, description = "是否需要传入指标条件")
  public Boolean isMetricsRequired() {
    return metricsRequired;
  }

  public void setMetricsRequired(Boolean metricsRequired) {
    this.metricsRequired = metricsRequired;
  }

  public AnalysisModuleObjResp analysisType(AnalysisTypeEnum analysisType) {
    this.analysisType = analysisType;
    return this;
  }

   /**
   * 计算类型
   * @return analysisType
  **/
  @Schema(required = true, description = "计算类型")
  public AnalysisTypeEnum getAnalysisType() {
    return analysisType;
  }

  public void setAnalysisType(AnalysisTypeEnum analysisType) {
    this.analysisType = analysisType;
  }

  public AnalysisModuleObjResp createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @Schema(required = true, description = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public AnalysisModuleObjResp analysisModuleObjCreator(String analysisModuleObjCreator) {
    this.analysisModuleObjCreator = analysisModuleObjCreator;
    return this;
  }

   /**
   * 创建人
   * @return analysisModuleObjCreator
  **/
  @Schema(required = true, description = "创建人")
  public String getAnalysisModuleObjCreator() {
    return analysisModuleObjCreator;
  }

  public void setAnalysisModuleObjCreator(String analysisModuleObjCreator) {
    this.analysisModuleObjCreator = analysisModuleObjCreator;
  }

  public AnalysisModuleObjResp updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 最近更新时间
   * @return updateTime
  **/
  @Schema(required = true, description = "最近更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public AnalysisModuleObjResp updater(String updater) {
    this.updater = updater;
    return this;
  }

   /**
   * 最近更新人
   * @return updater
  **/
  @Schema(required = true, description = "最近更新人")
  public String getUpdater() {
    return updater;
  }

  public void setUpdater(String updater) {
    this.updater = updater;
  }

  public AnalysisModuleObjResp domainType(DomainTypeEnum domainType) {
    this.domainType = domainType;
    return this;
  }

   /**
   * 公私域类型
   * @return domainType
  **/
  @Schema(required = true, description = "公私域类型")
  public DomainTypeEnum getDomainType() {
    return domainType;
  }

  public void setDomainType(DomainTypeEnum domainType) {
    this.domainType = domainType;
  }

  public AnalysisModuleObjResp authFilter(Boolean authFilter) {
    this.authFilter = authFilter;
    return this;
  }

   /**
   * 是否使用行权限
   * @return authFilter
  **/
  @Schema(required = true, description = "是否使用行权限")
  public Boolean isAuthFilter() {
    return authFilter;
  }

  public void setAuthFilter(Boolean authFilter) {
    this.authFilter = authFilter;
  }

  public AnalysisModuleObjResp displayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
    return this;
  }

   /**
   * Get displayConfig
   * @return displayConfig
  **/
  @Schema(description = "")
  public JsonNode getDisplayConfig() {
    return displayConfig;
  }

  public void setDisplayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
  }

  public AnalysisModuleObjResp cdpModules(List<AnalysisModuleObjBelong> cdpModules) {
    this.cdpModules = cdpModules;
    return this;
  }

  public AnalysisModuleObjResp addCdpModulesItem(AnalysisModuleObjBelong cdpModulesItem) {
    if (this.cdpModules == null) {
      this.cdpModules = new ArrayList<AnalysisModuleObjBelong>();
    }
    this.cdpModules.add(cdpModulesItem);
    return this;
  }

   /**
   * 模块
   * @return cdpModules
  **/
  @Schema(description = "模块")
  public List<AnalysisModuleObjBelong> getCdpModules() {
    return cdpModules;
  }

  public void setCdpModules(List<AnalysisModuleObjBelong> cdpModules) {
    this.cdpModules = cdpModules;
  }

  public AnalysisModuleObjResp periodShow(String periodShow) {
    this.periodShow = periodShow;
    return this;
  }

   /**
   * 归因窗口
   * @return periodShow
  **/
  @Schema(description = "归因窗口")
  public String getPeriodShow() {
    return periodShow;
  }

  public void setPeriodShow(String periodShow) {
    this.periodShow = periodShow;
  }

  public AnalysisModuleObjResp attributionModelType(String attributionModelType) {
    this.attributionModelType = attributionModelType;
    return this;
  }

   /**
   * 归因方式
   * @return attributionModelType
  **/
  @Schema(description = "归因方式")
  public String getAttributionModelType() {
    return attributionModelType;
  }

  public void setAttributionModelType(String attributionModelType) {
    this.attributionModelType = attributionModelType;
  }

  public AnalysisModuleObjResp platform(String platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 数据来源平台
   * @return platform
  **/
  @Schema(description = "数据来源平台")
  public String getPlatform() {
    return platform;
  }

  public void setPlatform(String platform) {
    this.platform = platform;
  }

  public AnalysisModuleObjResp active(Boolean active) {
    this.active = active;
    return this;
  }

   /**
   * 是否开启
   * @return active
  **/
  @Schema(description = "是否开启")
  public Boolean isActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public AnalysisModuleObjResp scheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
    return this;
  }

   /**
   * 定时任务最近修改时间
   * @return scheduleTime
  **/
  @Schema(description = "定时任务最近修改时间")
  public String getScheduleTime() {
    return scheduleTime;
  }

  public void setScheduleTime(String scheduleTime) {
    this.scheduleTime = scheduleTime;
  }

  public AnalysisModuleObjResp scheduleRange(ScheduleRangeEnum scheduleRange) {
    this.scheduleRange = scheduleRange;
    return this;
  }

   /**
   * Get scheduleRange
   * @return scheduleRange
  **/
  @Schema(description = "")
  public ScheduleRangeEnum getScheduleRange() {
    return scheduleRange;
  }

  public void setScheduleRange(ScheduleRangeEnum scheduleRange) {
    this.scheduleRange = scheduleRange;
  }

  public AnalysisModuleObjResp subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(description = "主体id")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public AnalysisModuleObjResp usableCdpModules(List<String> usableCdpModules) {
    this.usableCdpModules = usableCdpModules;
    return this;
  }

  public AnalysisModuleObjResp addUsableCdpModulesItem(String usableCdpModulesItem) {
    if (this.usableCdpModules == null) {
      this.usableCdpModules = new ArrayList<String>();
    }
    this.usableCdpModules.add(usableCdpModulesItem);
    return this;
  }

   /**
   * 可使用的cdp模块
   * @return usableCdpModules
  **/
  @Schema(description = "可使用的cdp模块")
  public List<String> getUsableCdpModules() {
    return usableCdpModules;
  }

  public void setUsableCdpModules(List<String> usableCdpModules) {
    this.usableCdpModules = usableCdpModules;
  }

  public AnalysisModuleObjResp editAble(Boolean editAble) {
    this.editAble = editAble;
    return this;
  }

   /**
   * 是否可编辑
   * @return editAble
  **/
  @Schema(description = "是否可编辑")
  public Boolean isEditAble() {
    return editAble;
  }

  public void setEditAble(Boolean editAble) {
    this.editAble = editAble;
  }

  public AnalysisModuleObjResp deleteAble(Boolean deleteAble) {
    this.deleteAble = deleteAble;
    return this;
  }

   /**
   * 是否可删除
   * @return deleteAble
  **/
  @Schema(description = "是否可删除")
  public Boolean isDeleteAble() {
    return deleteAble;
  }

  public void setDeleteAble(Boolean deleteAble) {
    this.deleteAble = deleteAble;
  }

  public AnalysisModuleObjResp message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 描述说明
   * @return message
  **/
  @Schema(description = "描述说明")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public AnalysisModuleObjResp bookmark(Boolean bookmark) {
    this.bookmark = bookmark;
    return this;
  }

   /**
   * 是否收藏
   * @return bookmark
  **/
  @Schema(description = "是否收藏")
  public Boolean isBookmark() {
    return bookmark;
  }

  public void setBookmark(Boolean bookmark) {
    this.bookmark = bookmark;
  }

  public AnalysisModuleObjResp domainInfos(List<AnalysisCommonDomainSimpleVO> domainInfos) {
    this.domainInfos = domainInfos;
    return this;
  }

  public AnalysisModuleObjResp addDomainInfosItem(AnalysisCommonDomainSimpleVO domainInfosItem) {
    if (this.domainInfos == null) {
      this.domainInfos = new ArrayList<AnalysisCommonDomainSimpleVO>();
    }
    this.domainInfos.add(domainInfosItem);
    return this;
  }

   /**
   * 分组id
   * @return domainInfos
  **/
  @Schema(description = "分组id")
  public List<AnalysisCommonDomainSimpleVO> getDomainInfos() {
    return domainInfos;
  }

  public void setDomainInfos(List<AnalysisCommonDomainSimpleVO> domainInfos) {
    this.domainInfos = domainInfos;
  }

  public AnalysisModuleObjResp authSchema(JsonNode authSchema) {
    this.authSchema = authSchema;
    return this;
  }

   /**
   * Get authSchema
   * @return authSchema
  **/
  @Schema(description = "")
  public JsonNode getAuthSchema() {
    return authSchema;
  }

  public void setAuthSchema(JsonNode authSchema) {
    this.authSchema = authSchema;
  }

  public AnalysisModuleObjResp panelId(Integer panelId) {
    this.panelId = panelId;
    return this;
  }

   /**
   * panelId，可能为空
   * @return panelId
  **/
  @Schema(description = "panelId，可能为空")
  public Integer getPanelId() {
    return panelId;
  }

  public void setPanelId(Integer panelId) {
    this.panelId = panelId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalysisModuleObjResp analysisModuleObjResp = (AnalysisModuleObjResp) o;
    return Objects.equals(this.id, analysisModuleObjResp.id) &&
        Objects.equals(this.analysisModuleObjId, analysisModuleObjResp.analysisModuleObjId) &&
        Objects.equals(this.analysisModuleObjName, analysisModuleObjResp.analysisModuleObjName) &&
        Objects.equals(this.name, analysisModuleObjResp.name) &&
        Objects.equals(this.descr, analysisModuleObjResp.descr) &&
        Objects.equals(this.seg, analysisModuleObjResp.seg) &&
        Objects.equals(this.dimension, analysisModuleObjResp.dimension) &&
        Objects.equals(this.period, analysisModuleObjResp.period) &&
        Objects.equals(this.metrics, analysisModuleObjResp.metrics) &&
        Objects.equals(this.segRequired, analysisModuleObjResp.segRequired) &&
        Objects.equals(this.dimensionRequired, analysisModuleObjResp.dimensionRequired) &&
        Objects.equals(this.periodRequired, analysisModuleObjResp.periodRequired) &&
        Objects.equals(this.metricsRequired, analysisModuleObjResp.metricsRequired) &&
        Objects.equals(this.analysisType, analysisModuleObjResp.analysisType) &&
        Objects.equals(this.createTime, analysisModuleObjResp.createTime) &&
        Objects.equals(this.analysisModuleObjCreator, analysisModuleObjResp.analysisModuleObjCreator) &&
        Objects.equals(this.updateTime, analysisModuleObjResp.updateTime) &&
        Objects.equals(this.updater, analysisModuleObjResp.updater) &&
        Objects.equals(this.domainType, analysisModuleObjResp.domainType) &&
        Objects.equals(this.authFilter, analysisModuleObjResp.authFilter) &&
        Objects.equals(this.displayConfig, analysisModuleObjResp.displayConfig) &&
        Objects.equals(this.cdpModules, analysisModuleObjResp.cdpModules) &&
        Objects.equals(this.periodShow, analysisModuleObjResp.periodShow) &&
        Objects.equals(this.attributionModelType, analysisModuleObjResp.attributionModelType) &&
        Objects.equals(this.platform, analysisModuleObjResp.platform) &&
        Objects.equals(this.active, analysisModuleObjResp.active) &&
        Objects.equals(this.scheduleTime, analysisModuleObjResp.scheduleTime) &&
        Objects.equals(this.scheduleRange, analysisModuleObjResp.scheduleRange) &&
        Objects.equals(this.subjectId, analysisModuleObjResp.subjectId) &&
        Objects.equals(this.usableCdpModules, analysisModuleObjResp.usableCdpModules) &&
        Objects.equals(this.editAble, analysisModuleObjResp.editAble) &&
        Objects.equals(this.deleteAble, analysisModuleObjResp.deleteAble) &&
        Objects.equals(this.message, analysisModuleObjResp.message) &&
        Objects.equals(this.bookmark, analysisModuleObjResp.bookmark) &&
        Objects.equals(this.domainInfos, analysisModuleObjResp.domainInfos) &&
        Objects.equals(this.authSchema, analysisModuleObjResp.authSchema) &&
        Objects.equals(this.panelId, analysisModuleObjResp.panelId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, analysisModuleObjId, analysisModuleObjName, name, descr, seg, dimension, period, metrics, segRequired, dimensionRequired, periodRequired, metricsRequired, analysisType, createTime, analysisModuleObjCreator, updateTime, updater, domainType, authFilter, displayConfig, cdpModules, periodShow, attributionModelType, platform, active, scheduleTime, scheduleRange, subjectId, usableCdpModules, editAble, deleteAble, message, bookmark, domainInfos, authSchema, panelId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnalysisModuleObjResp {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    analysisModuleObjId: ").append(toIndentedString(analysisModuleObjId)).append("\n");
    sb.append("    analysisModuleObjName: ").append(toIndentedString(analysisModuleObjName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descr: ").append(toIndentedString(descr)).append("\n");
    sb.append("    seg: ").append(toIndentedString(seg)).append("\n");
    sb.append("    dimension: ").append(toIndentedString(dimension)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    segRequired: ").append(toIndentedString(segRequired)).append("\n");
    sb.append("    dimensionRequired: ").append(toIndentedString(dimensionRequired)).append("\n");
    sb.append("    periodRequired: ").append(toIndentedString(periodRequired)).append("\n");
    sb.append("    metricsRequired: ").append(toIndentedString(metricsRequired)).append("\n");
    sb.append("    analysisType: ").append(toIndentedString(analysisType)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    analysisModuleObjCreator: ").append(toIndentedString(analysisModuleObjCreator)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    updater: ").append(toIndentedString(updater)).append("\n");
    sb.append("    domainType: ").append(toIndentedString(domainType)).append("\n");
    sb.append("    authFilter: ").append(toIndentedString(authFilter)).append("\n");
    sb.append("    displayConfig: ").append(toIndentedString(displayConfig)).append("\n");
    sb.append("    cdpModules: ").append(toIndentedString(cdpModules)).append("\n");
    sb.append("    periodShow: ").append(toIndentedString(periodShow)).append("\n");
    sb.append("    attributionModelType: ").append(toIndentedString(attributionModelType)).append("\n");
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    scheduleTime: ").append(toIndentedString(scheduleTime)).append("\n");
    sb.append("    scheduleRange: ").append(toIndentedString(scheduleRange)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    usableCdpModules: ").append(toIndentedString(usableCdpModules)).append("\n");
    sb.append("    editAble: ").append(toIndentedString(editAble)).append("\n");
    sb.append("    deleteAble: ").append(toIndentedString(deleteAble)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    bookmark: ").append(toIndentedString(bookmark)).append("\n");
    sb.append("    domainInfos: ").append(toIndentedString(domainInfos)).append("\n");
    sb.append("    authSchema: ").append(toIndentedString(authSchema)).append("\n");
    sb.append("    panelId: ").append(toIndentedString(panelId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
