/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.cdp.model.BaseAnalysisResultObj;
import code.byted.cdp.model.BaseDimension;
import code.byted.cdp.model.BaseMetrics;
import code.byted.cdp.model.BasePeriod;
import code.byted.cdp.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * AnalysisModuleWebResultResp
 */

@javax.annotation.Generated(value = "code.byted.cdp.client.JavaClientCodegen", date = "2024-06-28T14:28:12.947+08:00[Asia/Shanghai]")
public class AnalysisModuleWebResultResp {
  @SerializedName("seg")
  private JsonNode seg = null;

  @SerializedName("dimension")
  private BaseDimension dimension = null;

  @SerializedName("period")
  private BasePeriod period = null;

  @SerializedName("metrics")
  private BaseMetrics metrics = null;

  /**
   * 分析类型
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    USER_TENDENCY("USER_TENDENCY"),
    TRANS("TRANS"),
    ATTRIBUTION("ATTRIBUTION"),
    ATTRIBUTION_COLUMN("ATTRIBUTION_COLUMN"),
    NORMAL("NORMAL"),
    NORMAL_COLUMN("NORMAL_COLUMN"),
    CROSS_DIMENSION("CROSS_DIMENSION"),
    NORMAL_COLUMN_LINKAGE("NORMAL_COLUMN_LINKAGE"),
    NORMAL_COUNT("NORMAL_COUNT"),
    CROSS_DIMENSION_MERGE("CROSS_DIMENSION_MERGE"),
    EXTRA("EXTRA");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("analysisModuleObjId")
  private Integer analysisModuleObjId = null;

  @SerializedName("resultId")
  private Integer resultId = null;

  @SerializedName("result")
  private List<BaseAnalysisResultObj> result = null;

  /**
   * 计算状态
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    UNKNOWN("Unknown"),
    CREATED("Created"),
    RUNNING("Running"),
    SUCCEED("Succeed"),
    FAILED("Failed"),
    FORBIDDEN("Forbidden"),
    EMPTY("Empty"),
    TIMEOUT("Timeout"),
    ABANDONED("Abandoned"),
    METAFAILED("MetaFailed"),
    CANCELED("Canceled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static StatusEnum fromValue(String input) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return StatusEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("status")
  private StatusEnum status = null;

  @SerializedName("msg")
  private String msg = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("descr")
  private String descr = null;

  @SerializedName("displayConfig")
  private JsonNode displayConfig = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("extraJson")
  private JsonNode extraJson = null;

  public AnalysisModuleWebResultResp seg(JsonNode seg) {
    this.seg = seg;
    return this;
  }

   /**
   * Get seg
   * @return seg
  **/
  @Schema(description = "")
  public JsonNode getSeg() {
    return seg;
  }

  public void setSeg(JsonNode seg) {
    this.seg = seg;
  }

  public AnalysisModuleWebResultResp dimension(BaseDimension dimension) {
    this.dimension = dimension;
    return this;
  }

   /**
   * Get dimension
   * @return dimension
  **/
  @Schema(description = "")
  public BaseDimension getDimension() {
    return dimension;
  }

  public void setDimension(BaseDimension dimension) {
    this.dimension = dimension;
  }

  public AnalysisModuleWebResultResp period(BasePeriod period) {
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @Schema(description = "")
  public BasePeriod getPeriod() {
    return period;
  }

  public void setPeriod(BasePeriod period) {
    this.period = period;
  }

  public AnalysisModuleWebResultResp metrics(BaseMetrics metrics) {
    this.metrics = metrics;
    return this;
  }

   /**
   * Get metrics
   * @return metrics
  **/
  @Schema(description = "")
  public BaseMetrics getMetrics() {
    return metrics;
  }

  public void setMetrics(BaseMetrics metrics) {
    this.metrics = metrics;
  }

  public AnalysisModuleWebResultResp type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * 分析类型
   * @return type
  **/
  @Schema(description = "分析类型")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AnalysisModuleWebResultResp analysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
    return this;
  }

   /**
   * 模块id
   * @return analysisModuleObjId
  **/
  @Schema(description = "模块id")
  public Integer getAnalysisModuleObjId() {
    return analysisModuleObjId;
  }

  public void setAnalysisModuleObjId(Integer analysisModuleObjId) {
    this.analysisModuleObjId = analysisModuleObjId;
  }

  public AnalysisModuleWebResultResp resultId(Integer resultId) {
    this.resultId = resultId;
    return this;
  }

   /**
   * 结果id
   * @return resultId
  **/
  @Schema(required = true, description = "结果id")
  public Integer getResultId() {
    return resultId;
  }

  public void setResultId(Integer resultId) {
    this.resultId = resultId;
  }

  public AnalysisModuleWebResultResp result(List<BaseAnalysisResultObj> result) {
    this.result = result;
    return this;
  }

  public AnalysisModuleWebResultResp addResultItem(BaseAnalysisResultObj resultItem) {
    if (this.result == null) {
      this.result = new ArrayList<BaseAnalysisResultObj>();
    }
    this.result.add(resultItem);
    return this;
  }

   /**
   * 计算结果
   * @return result
  **/
  @Schema(description = "计算结果")
  public List<BaseAnalysisResultObj> getResult() {
    return result;
  }

  public void setResult(List<BaseAnalysisResultObj> result) {
    this.result = result;
  }

  public AnalysisModuleWebResultResp status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * 计算状态
   * @return status
  **/
  @Schema(required = true, description = "计算状态")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public AnalysisModuleWebResultResp msg(String msg) {
    this.msg = msg;
    return this;
  }

   /**
   * 异常信息
   * @return msg
  **/
  @Schema(description = "异常信息")
  public String getMsg() {
    return msg;
  }

  public void setMsg(String msg) {
    this.msg = msg;
  }

  public AnalysisModuleWebResultResp name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 指标名称
   * @return name
  **/
  @Schema(description = "指标名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AnalysisModuleWebResultResp descr(String descr) {
    this.descr = descr;
    return this;
  }

   /**
   * 指标描述
   * @return descr
  **/
  @Schema(description = "指标描述")
  public String getDescr() {
    return descr;
  }

  public void setDescr(String descr) {
    this.descr = descr;
  }

  public AnalysisModuleWebResultResp displayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
    return this;
  }

   /**
   * Get displayConfig
   * @return displayConfig
  **/
  @Schema(description = "")
  public JsonNode getDisplayConfig() {
    return displayConfig;
  }

  public void setDisplayConfig(JsonNode displayConfig) {
    this.displayConfig = displayConfig;
  }

  public AnalysisModuleWebResultResp subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * Get subjectId
   * @return subjectId
  **/
  @Schema(description = "")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public AnalysisModuleWebResultResp extraJson(JsonNode extraJson) {
    this.extraJson = extraJson;
    return this;
  }

   /**
   * Get extraJson
   * @return extraJson
  **/
  @Schema(description = "")
  public JsonNode getExtraJson() {
    return extraJson;
  }

  public void setExtraJson(JsonNode extraJson) {
    this.extraJson = extraJson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AnalysisModuleWebResultResp analysisModuleWebResultResp = (AnalysisModuleWebResultResp) o;
    return Objects.equals(this.seg, analysisModuleWebResultResp.seg) &&
        Objects.equals(this.dimension, analysisModuleWebResultResp.dimension) &&
        Objects.equals(this.period, analysisModuleWebResultResp.period) &&
        Objects.equals(this.metrics, analysisModuleWebResultResp.metrics) &&
        Objects.equals(this.type, analysisModuleWebResultResp.type) &&
        Objects.equals(this.analysisModuleObjId, analysisModuleWebResultResp.analysisModuleObjId) &&
        Objects.equals(this.resultId, analysisModuleWebResultResp.resultId) &&
        Objects.equals(this.result, analysisModuleWebResultResp.result) &&
        Objects.equals(this.status, analysisModuleWebResultResp.status) &&
        Objects.equals(this.msg, analysisModuleWebResultResp.msg) &&
        Objects.equals(this.name, analysisModuleWebResultResp.name) &&
        Objects.equals(this.descr, analysisModuleWebResultResp.descr) &&
        Objects.equals(this.displayConfig, analysisModuleWebResultResp.displayConfig) &&
        Objects.equals(this.subjectId, analysisModuleWebResultResp.subjectId) &&
        Objects.equals(this.extraJson, analysisModuleWebResultResp.extraJson);
  }

  @Override
  public int hashCode() {
    return Objects.hash(seg, dimension, period, metrics, type, analysisModuleObjId, resultId, result, status, msg, name, descr, displayConfig, subjectId, extraJson);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AnalysisModuleWebResultResp {\n");
    
    sb.append("    seg: ").append(toIndentedString(seg)).append("\n");
    sb.append("    dimension: ").append(toIndentedString(dimension)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    analysisModuleObjId: ").append(toIndentedString(analysisModuleObjId)).append("\n");
    sb.append("    resultId: ").append(toIndentedString(resultId)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    msg: ").append(toIndentedString(msg)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    descr: ").append(toIndentedString(descr)).append("\n");
    sb.append("    displayConfig: ").append(toIndentedString(displayConfig)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    extraJson: ").append(toIndentedString(extraJson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
