package code.byted.cdp.model;

import java.time.LocalDateTime;
import java.util.List;
import lombok.Data;

@Data
public class ChartInfo {

    private Integer id; // ID
    private String name; // 名称
    private String desc; // 描述
    private SourceType sourceType; // 来源
    private DomainType type; // 主题类型
    private List<ChartSimpleInfo> chartInfo; // 图表信息
    private Boolean editable; // 是否可编辑
    private Boolean deletable; // 是否可删除
    private String creator; // 创建人
    private Integer subjectId; // 主体Id
    private Integer appId; // 产品线Id
    private String appName; // 产品线名称
    private String createTime; // 创建时间
    private String updateTime; // 更新时间

    @Data
    class ChartSimpleInfo {

        private Integer chartId; // 图表Id
        private String chartName; // 图表名称
    }

}
