package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
@Schema(description = "人工分群附加状况")
public class ManualSegmentExtraCondition {

    @Schema(description = "分群类型", required = true)
    private SegmentType type;
    @Schema(description = "文件指代的实体id", required = true)
    Integer originIdTypeId;
    @Schema(description = "上传任务id", required = true)
    Integer uploadTaskId;
    @Schema(description = "分群id")
    Integer segmentId;
    @Schema(description = "上传文件是否需要加密")
    Boolean needEncryption = false;
    @Schema(description = "是否和idMapping已有数据求交", required = true)
    Boolean idMappingFilterEnable = true;
    @Schema(description = "更新模式", required = true)
    UpdateMode updateMode = UpdateMode.ADD;
    @Schema(description = "资源类型", required = true)
    ResourceType resourceType = ResourceType.SEGMENT;
    @Schema(description = "是否支持写入不识别ID")
    Boolean supportSaveUnknownId = false;
}
