package code.byted.cdp.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import lombok.Data;

@Data
@Schema(description = "标签/属性 二选一")
public class OrderBy {

    @Schema(description = "标签ID")
    private Integer tagId;
    @Schema(description = "属性")
    private Property property;
    @Schema(description = "是否倒序")
    private Boolean desc = true;


    @Data
    public static class Property {

        @Schema(description = "数据源ID")
        private Integer dataSourceId;
        @Schema(description = "实体ID")
        private Integer entityId;
    }
}
