/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.ByteDanceCirceResponseString;
import code.byted.cdp.model.CirceActionResponseBoolean;
import code.byted.cdp.model.CirceActionResponseCircePageDataDataAssetListResp;
import code.byted.cdp.model.CirceActionResponseCircePageDataOpenApiHdfsResult;
import code.byted.cdp.model.CirceActionResponseInt;
import java.io.File;
import code.byted.cdp.model.OpenApiCreateTaskReq;
import code.byted.cdp.model.OpenApiDataAssetTaskReq;
import code.byted.cdp.model.OpenApiDeleteTasksRequest;
import code.byted.cdp.model.OpenApiPreviewTableReq;
import code.byted.cdp.model.OpenApiReRunTasksRequest;
import code.byted.cdp.model.OpenApiStopTasksRequest;
import code.byted.cdp.model.ResponseOpenApiHdfsResult;
import code.byted.cdp.model.SeqFileDataTaskSimpleResult;
import code.byted.cdp.model.TableSchemaPreviewResp;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataAssetApi {
    private ApiClient apiClient;

    public DataAssetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataAssetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for assetTablePreview
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call assetTablePreviewCall(OpenApiPreviewTableReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","assetTablePreview"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call assetTablePreviewValidateBeforeCall(OpenApiPreviewTableReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling assetTablePreview(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling assetTablePreview(Async)");
        }

        com.squareup.okhttp.Call call = assetTablePreviewCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 输出任务结构预览
     * 创建资产输出任务结构预览，配合【创建第三方输出任务】使用(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return TableSchemaPreviewResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TableSchemaPreviewResp assetTablePreview(OpenApiPreviewTableReq body, String xTenant) throws ApiException {
        ApiResponse<TableSchemaPreviewResp> resp = assetTablePreviewWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 输出任务结构预览
     * 创建资产输出任务结构预览，配合【创建第三方输出任务】使用(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;TableSchemaPreviewResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TableSchemaPreviewResp> assetTablePreviewWithHttpInfo(OpenApiPreviewTableReq body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = assetTablePreviewValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<TableSchemaPreviewResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 输出任务结构预览 (asynchronously)
     * 创建资产输出任务结构预览，配合【创建第三方输出任务】使用(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call assetTablePreviewAsync(OpenApiPreviewTableReq body, String xTenant, final ApiCallback<TableSchemaPreviewResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = assetTablePreviewValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TableSchemaPreviewResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for assetTaskCreate
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call assetTaskCreateCall(OpenApiDataAssetTaskReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","assetTaskCreate"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call assetTaskCreateValidateBeforeCall(OpenApiDataAssetTaskReq body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling assetTaskCreate(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling assetTaskCreate(Async)");
        }

        com.squareup.okhttp.Call call = assetTaskCreateCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建第三方输出任务
     * 创建资产输出任务到oss存储(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ByteDanceCirceResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceCirceResponseString assetTaskCreate(OpenApiDataAssetTaskReq body, String xTenant) throws ApiException {
        ApiResponse<ByteDanceCirceResponseString> resp = assetTaskCreateWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建第三方输出任务
     * 创建资产输出任务到oss存储(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;ByteDanceCirceResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceCirceResponseString> assetTaskCreateWithHttpInfo(OpenApiDataAssetTaskReq body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = assetTaskCreateValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceCirceResponseString>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     *  (asynchronously)
     *
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call assetTaskCreateAsync(OpenApiDataAssetTaskReq body, String xTenant, final ApiCallback<ByteDanceCirceResponseString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = assetTaskCreateValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceCirceResponseString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createAssetTaskV2
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createAssetTaskV2Call(OpenApiCreateTaskReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createAssetTaskV2"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createAssetTaskV2ValidateBeforeCall(OpenApiCreateTaskReq body, Integer xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createAssetTaskV2(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createAssetTaskV2(Async)");
        }

        com.squareup.okhttp.Call call = createAssetTaskV2Call(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建资产输出任务(v2)
     *
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ResponseOpenApiHdfsResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ResponseOpenApiHdfsResult createAssetTaskV2(OpenApiCreateTaskReq body, Integer xTenant) throws ApiException {
        ApiResponse<ResponseOpenApiHdfsResult> resp = createAssetTaskV2WithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建资产输出任务(v2)
     *
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;ResponseOpenApiHdfsResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ResponseOpenApiHdfsResult> createAssetTaskV2WithHttpInfo(OpenApiCreateTaskReq body, Integer xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createAssetTaskV2ValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<ResponseOpenApiHdfsResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建资产输出任务(v2) (asynchronously)
     *
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createAssetTaskV2Async(OpenApiCreateTaskReq body, Integer xTenant, final ApiCallback<ResponseOpenApiHdfsResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = createAssetTaskV2ValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ResponseOpenApiHdfsResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteOpenapiDataAssetTaskDeleteByIds
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteOpenapiDataAssetTaskDeleteByIdsCall(OpenApiDeleteTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteOpenapiData_assetTaskDeleteByIds"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-09-30"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteOpenapiDataAssetTaskDeleteByIdsValidateBeforeCall(OpenApiDeleteTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteOpenapiDataAssetTaskDeleteByIds(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteOpenapiDataAssetTaskDeleteByIds(Async)");
        }

        com.squareup.okhttp.Call call = deleteOpenapiDataAssetTaskDeleteByIdsCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 按照ID列表删除任务
     * 按照ID列表删除任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return CirceActionResponseInt
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseInt deleteOpenapiDataAssetTaskDeleteByIds(OpenApiDeleteTasksRequest body, String xTenant) throws ApiException {
        ApiResponse<CirceActionResponseInt> resp = deleteOpenapiDataAssetTaskDeleteByIdsWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 按照ID列表删除任务
     * 按照ID列表删除任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;CirceActionResponseInt&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseInt> deleteOpenapiDataAssetTaskDeleteByIdsWithHttpInfo(OpenApiDeleteTasksRequest body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = deleteOpenapiDataAssetTaskDeleteByIdsValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 按照ID列表删除任务 (asynchronously)
     * 按照ID列表删除任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteOpenapiDataAssetTaskDeleteByIdsAsync(OpenApiDeleteTasksRequest body, String xTenant, final ApiCallback<CirceActionResponseInt> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = deleteOpenapiDataAssetTaskDeleteByIdsValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for downloadAssetTaskV2
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (required)
     * @param filePath 文件路径 (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadAssetTaskV2Call(Integer xTenant, Long taskId, String filePath, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filePath != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("filePath", filePath));

        localVarQueryParams.add(new Pair("task_id", taskId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","downloadAssetTaskV2"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/octet-stream"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadAssetTaskV2ValidateBeforeCall(Integer xTenant, Long taskId, String filePath, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling downloadAssetTaskV2(Async)");
        }
        // verify the required parameter 'taskId' is set
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling downloadAssetTaskV2(Async)");
        }
        // verify the required parameter 'filePath' is set
        if (filePath == null) {
            throw new ApiException("Missing the required parameter 'filePath' when calling downloadAssetTaskV2(Async)");
        }

        com.squareup.okhttp.Call call = downloadAssetTaskV2Call(xTenant, taskId, filePath, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 下载资产输出hdfs文件(v2)
     * 只有csv格式的文件可以被下载,其他格式的文件不支持下载
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (required)
     * @param filePath 文件路径 (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File downloadAssetTaskV2(Integer xTenant, Long taskId, String filePath) throws ApiException {
        ApiResponse<File> resp = downloadAssetTaskV2WithHttpInfo(xTenant, taskId, filePath);
        return resp.getData();
    }


    /**
     * 下载资产输出hdfs文件(v2)
     * 只有csv格式的文件可以被下载,其他格式的文件不支持下载
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (required)
     * @param filePath 文件路径 (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> downloadAssetTaskV2WithHttpInfo(Integer xTenant, Long taskId, String filePath) throws ApiException {
        com.squareup.okhttp.Call call = downloadAssetTaskV2ValidateBeforeCall(xTenant, taskId, filePath, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();

        String[] localVarAccepts = {
                "application/octet-stream", "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 下载资产输出hdfs文件(v2) (asynchronously)
     * 只有csv格式的文件可以被下载,其他格式的文件不支持下载
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (required)
     * @param filePath 文件路径 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call downloadAssetTaskV2Async(Integer xTenant, Long taskId, String filePath, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/octet-stream", "application/json"
        };

        com.squareup.okhttp.Call call = downloadAssetTaskV2ValidateBeforeCall(xTenant, taskId, filePath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for downloadFileDateAsset
     * @param xTenant 项目id (required)
     * @param taskId 任务id (required)
     * @param filePath 文件路径 (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call downloadFileDateAssetCall(String xTenant, Integer taskId, String filePath, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (filePath != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("filePath", filePath));

        localVarQueryParams.add(new Pair("taskId", taskId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","downloadFileDateAsset"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/octet-stream"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call downloadFileDateAssetValidateBeforeCall(String xTenant, Integer taskId, String filePath, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling downloadFileDateAsset(Async)");
        }
        // verify the required parameter 'taskId' is set
        if (taskId == null) {
            throw new ApiException("Missing the required parameter 'taskId' when calling downloadFileDateAsset(Async)");
        }
        // verify the required parameter 'filePath' is set
        if (filePath == null) {
            throw new ApiException("Missing the required parameter 'filePath' when calling downloadFileDateAsset(Async)");
        }

        com.squareup.okhttp.Call call = downloadFileDateAssetCall(xTenant, taskId, filePath, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 下载分群明细
     * 下载分群明细(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @param taskId 任务id (required)
     * @param filePath 文件路径 (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File downloadFileDateAsset(String xTenant, Integer taskId, String filePath) throws ApiException {
        ApiResponse<File> resp = downloadFileDateAssetWithHttpInfo(xTenant, taskId, filePath);
        return resp.getData();
    }


    /**
     * 下载分群明细
     * 下载分群明细(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @param taskId 任务id (required)
     * @param filePath 文件路径 (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> downloadFileDateAssetWithHttpInfo(String xTenant, Integer taskId, String filePath) throws ApiException {
        com.squareup.okhttp.Call call = downloadFileDateAssetValidateBeforeCall(xTenant, taskId, filePath, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();

        String[] localVarAccepts = {
                "application/octet-stream", "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 下载分群明细 (asynchronously)
     * 下载分群明细(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @param taskId 任务id (required)
     * @param filePath 文件路径 (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call downloadFileDateAssetAsync(String xTenant, Integer taskId, String filePath, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/octet-stream", "application/json"
        };

        com.squareup.okhttp.Call call = downloadFileDateAssetValidateBeforeCall(xTenant, taskId, filePath, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getFileDateAssetTaskList
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFileDateAssetTaskListCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getFileDateAssetTaskList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFileDateAssetTaskListValidateBeforeCall(String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getFileDateAssetTaskList(Async)");
        }

        com.squareup.okhttp.Call call = getFileDateAssetTaskListCall(xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取分群明细任务列表
     * 获取分群明细任务列表(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @return SeqFileDataTaskSimpleResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SeqFileDataTaskSimpleResult getFileDateAssetTaskList(String xTenant) throws ApiException {
        ApiResponse<SeqFileDataTaskSimpleResult> resp = getFileDateAssetTaskListWithHttpInfo(xTenant);
        return resp.getData();
    }


    /**
     * 获取分群明细任务列表
     * 获取分群明细任务列表(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;SeqFileDataTaskSimpleResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SeqFileDataTaskSimpleResult> getFileDateAssetTaskListWithHttpInfo(String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getFileDateAssetTaskListValidateBeforeCall(xTenant, null, null);
        Type localVarReturnType = new TypeToken<SeqFileDataTaskSimpleResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取分群明细任务列表 (asynchronously)
     * 获取分群明细任务列表(从1.23开始建议使用新版资产输出接口，该接口逐步废弃)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFileDateAssetTaskListAsync(String xTenant, final ApiCallback<SeqFileDataTaskSimpleResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getFileDateAssetTaskListValidateBeforeCall(xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SeqFileDataTaskSimpleResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getOpenapiDataAssetTaskDownloadTasklist
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (optional)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskDownloadTasklistCall(Integer xTenant, Long taskId, Long pageNum, Long pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (taskId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));
        if (pageNum != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("pageNum", pageNum));
        if (pageSize != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getOpenapiData_assetTaskDownloadTasklist"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOpenapiDataAssetTaskDownloadTasklistValidateBeforeCall(Integer xTenant, Long taskId, Long pageNum, Long pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getOpenapiDataAssetTaskDownloadTasklist(Async)");
        }

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskDownloadTasklistCall(xTenant, taskId, pageNum, pageSize, keyword, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取hdfs任务列表(v2)
     * 任务ID
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (optional)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词 (optional)
     * @return CirceActionResponseCircePageDataOpenApiHdfsResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseCircePageDataOpenApiHdfsResult getOpenapiDataAssetTaskDownloadTasklist(Integer xTenant, Long taskId, Long pageNum, Long pageSize, String keyword) throws ApiException {
        ApiResponse<CirceActionResponseCircePageDataOpenApiHdfsResult> resp = getOpenapiDataAssetTaskDownloadTasklistWithHttpInfo(xTenant, taskId, pageNum, pageSize, keyword);
        return resp.getData();
    }


    /**
     * 获取hdfs任务列表(v2)
     * 任务ID
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (optional)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词 (optional)
     * @return ApiResponse&lt;CirceActionResponseCircePageDataOpenApiHdfsResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseCircePageDataOpenApiHdfsResult> getOpenapiDataAssetTaskDownloadTasklistWithHttpInfo(Integer xTenant, Long taskId, Long pageNum, Long pageSize, String keyword) throws ApiException {
        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskDownloadTasklistValidateBeforeCall(xTenant, taskId, pageNum, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseCircePageDataOpenApiHdfsResult>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取hdfs任务列表(v2) (asynchronously)
     * 任务ID
     * @param xTenant 项目id (required)
     * @param taskId 任务ID (optional)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页大小 (optional)
     * @param keyword 关键词 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskDownloadTasklistAsync(Integer xTenant, Long taskId, Long pageNum, Long pageSize, String keyword, final ApiCallback<CirceActionResponseCircePageDataOpenApiHdfsResult> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskDownloadTasklistValidateBeforeCall(xTenant, taskId, pageNum, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseCircePageDataOpenApiHdfsResult>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getOpenapiDataAssetTaskTaskNameExists
     * @param xTenant 项目id (required)
     * @param name 任务名称 (required)
     * @param taskId 任务ID. 如果传了, 会忽略ID对应的任务名, 不传则表示新建任务 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskTaskNameExistsCall(String xTenant, String name, Long taskId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (name != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
        if (taskId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("taskId", taskId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getOpenapiData_assetTaskTaskNameExists"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-09-30"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOpenapiDataAssetTaskTaskNameExistsValidateBeforeCall(String xTenant, String name, Long taskId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getOpenapiDataAssetTaskTaskNameExists(Async)");
        }
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getOpenapiDataAssetTaskTaskNameExists(Async)");
        }

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTaskNameExistsCall(xTenant, name, taskId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 检查任务是否重名
     * 检查任务是否重名
     * @param xTenant 项目id (required)
     * @param name 任务名称 (required)
     * @param taskId 任务ID. 如果传了, 会忽略ID对应的任务名, 不传则表示新建任务 (optional)
     * @return CirceActionResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseBoolean getOpenapiDataAssetTaskTaskNameExists(String xTenant, String name, Long taskId) throws ApiException {
        ApiResponse<CirceActionResponseBoolean> resp = getOpenapiDataAssetTaskTaskNameExistsWithHttpInfo(xTenant, name, taskId);
        return resp.getData();
    }


    /**
     * 检查任务是否重名
     * 检查任务是否重名
     * @param xTenant 项目id (required)
     * @param name 任务名称 (required)
     * @param taskId 任务ID. 如果传了, 会忽略ID对应的任务名, 不传则表示新建任务 (optional)
     * @return ApiResponse&lt;CirceActionResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseBoolean> getOpenapiDataAssetTaskTaskNameExistsWithHttpInfo(String xTenant, String name, Long taskId) throws ApiException {
        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTaskNameExistsValidateBeforeCall(xTenant, name, taskId, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 检查任务是否重名 (asynchronously)
     * 检查任务是否重名
     * @param xTenant 项目id (required)
     * @param name 任务名称 (required)
     * @param taskId 任务ID. 如果传了, 会忽略ID对应的任务名, 不传则表示新建任务 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskTaskNameExistsAsync(String xTenant, String name, Long taskId, final ApiCallback<CirceActionResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTaskNameExistsValidateBeforeCall(xTenant, name, taskId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getOpenapiDataAssetTaskTasklist
     * @param xTenant 项目id (required)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页数量 (optional)
     * @param keyword 关键词 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskTasklistCall(Integer xTenant, Long pageNum, Long pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pageNum != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("pageNum", pageNum));
        if (pageSize != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (keyword != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getOpenapiData_assetTaskTasklist"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOpenapiDataAssetTaskTasklistValidateBeforeCall(Integer xTenant, Long pageNum, Long pageSize, String keyword, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getOpenapiDataAssetTaskTasklist(Async)");
        }

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTasklistCall(xTenant, pageNum, pageSize, keyword, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取任务列表(v2)
     *
     * @param xTenant 项目id (required)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页数量 (optional)
     * @param keyword 关键词 (optional)
     * @return CirceActionResponseCircePageDataDataAssetListResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseCircePageDataDataAssetListResp getOpenapiDataAssetTaskTasklist(Integer xTenant, Long pageNum, Long pageSize, String keyword) throws ApiException {
        ApiResponse<CirceActionResponseCircePageDataDataAssetListResp> resp = getOpenapiDataAssetTaskTasklistWithHttpInfo(xTenant, pageNum, pageSize, keyword);
        return resp.getData();
    }


    /**
     * 获取任务列表(v2)
     *
     * @param xTenant 项目id (required)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页数量 (optional)
     * @param keyword 关键词 (optional)
     * @return ApiResponse&lt;CirceActionResponseCircePageDataDataAssetListResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseCircePageDataDataAssetListResp> getOpenapiDataAssetTaskTasklistWithHttpInfo(Integer xTenant, Long pageNum, Long pageSize, String keyword) throws ApiException {
        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTasklistValidateBeforeCall(xTenant, pageNum, pageSize, keyword, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseCircePageDataDataAssetListResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取任务列表(v2) (asynchronously)
     *
     * @param xTenant 项目id (required)
     * @param pageNum 页码 (optional)
     * @param pageSize 每页数量 (optional)
     * @param keyword 关键词 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getOpenapiDataAssetTaskTasklistAsync(Integer xTenant, Long pageNum, Long pageSize, String keyword, final ApiCallback<CirceActionResponseCircePageDataDataAssetListResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getOpenapiDataAssetTaskTasklistValidateBeforeCall(xTenant, pageNum, pageSize, keyword, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseCircePageDataDataAssetListResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postOpenapiDataAssetTaskRerun
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postOpenapiDataAssetTaskRerunCall(OpenApiReRunTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postOpenapiData_assetTaskRerun"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-09-30"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postOpenapiDataAssetTaskRerunValidateBeforeCall(OpenApiReRunTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postOpenapiDataAssetTaskRerun(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postOpenapiDataAssetTaskRerun(Async)");
        }

        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskRerunCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 重跑任务
     * 重跑任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return CirceActionResponseInt
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseInt postOpenapiDataAssetTaskRerun(OpenApiReRunTasksRequest body, String xTenant) throws ApiException {
        ApiResponse<CirceActionResponseInt> resp = postOpenapiDataAssetTaskRerunWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 重跑任务
     * 重跑任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;CirceActionResponseInt&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseInt> postOpenapiDataAssetTaskRerunWithHttpInfo(OpenApiReRunTasksRequest body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskRerunValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 重跑任务 (asynchronously)
     * 重跑任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postOpenapiDataAssetTaskRerunAsync(OpenApiReRunTasksRequest body, String xTenant, final ApiCallback<CirceActionResponseInt> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskRerunValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postOpenapiDataAssetTaskStop
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postOpenapiDataAssetTaskStopCall(OpenApiStopTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postOpenapiData_assetTaskStop"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-09-30"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postOpenapiDataAssetTaskStopValidateBeforeCall(OpenApiStopTasksRequest body, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling postOpenapiDataAssetTaskStop(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postOpenapiDataAssetTaskStop(Async)");
        }

        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskStopCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 结束任务
     * 结束任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return CirceActionResponseInt
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CirceActionResponseInt postOpenapiDataAssetTaskStop(OpenApiStopTasksRequest body, String xTenant) throws ApiException {
        ApiResponse<CirceActionResponseInt> resp = postOpenapiDataAssetTaskStopWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 结束任务
     * 结束任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @return ApiResponse&lt;CirceActionResponseInt&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CirceActionResponseInt> postOpenapiDataAssetTaskStopWithHttpInfo(OpenApiStopTasksRequest body, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskStopValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 结束任务 (asynchronously)
     * 结束任务
     * @param body  (required)
     * @param xTenant 项目id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postOpenapiDataAssetTaskStopAsync(OpenApiStopTasksRequest body, String xTenant, final ApiCallback<CirceActionResponseInt> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = postOpenapiDataAssetTaskStopValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CirceActionResponseInt>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
