/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.cdp.openapi;

import code.byted.cdp.ApiCallback;
import code.byted.cdp.ApiClient;
import code.byted.cdp.ApiException;
import code.byted.cdp.ApiResponse;
import code.byted.cdp.Configuration;
import code.byted.cdp.Pair;
import code.byted.cdp.ProgressRequestBody;
import code.byted.cdp.ProgressResponseBody;

import code.byted.cdp.model.ByteDanceSeqResponseLabelPerformanceResp;
import code.byted.cdp.model.QueryUserProfileRequest;
import code.byted.cdp.model.QueryUserProfileResp;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import code.byted.cdp.model.AccessCoreStatisticsReq;
import code.byted.cdp.model.AddLabelDomainEvent;
import code.byted.cdp.model.ApprovalUpdateReq;
import code.byted.cdp.model.ByteDanceNormalResponseString;
import code.byted.cdp.model.ByteDanceSeqResponseOpenApiManualTagInfo;
import code.byted.cdp.model.ByteDanceSeqResponseSeqDomainGroupedTags;
import code.byted.cdp.model.ByteDanceSeqResponseTagValueResp;
import code.byted.cdp.model.CommonBoolean;
import code.byted.cdp.model.CommonDataModelId;
import code.byted.cdp.model.CommonLabelId;
import code.byted.cdp.model.CommonLabelResultData;
import code.byted.cdp.model.CommonListLabelMetaInfo;
import code.byted.cdp.model.CommonListLabelResultData;
import code.byted.cdp.model.CommonListObject;
import code.byted.cdp.model.CommonOnlineTagInfoResp;
import code.byted.cdp.model.CommonResponseBoolean;
import code.byted.cdp.model.CommonResponseDetailTableResp;
import code.byted.cdp.model.CommonResponseInteger;
import code.byted.cdp.model.CommonResponseLabelMetaSimpleInfo;
import code.byted.cdp.model.CommonResponseListAccessCoreStatisticsResp;
import code.byted.cdp.model.CommonResponseListLabelTreeNode;
import code.byted.cdp.model.CommonResponseListTendencyStatisticsResp;
import code.byted.cdp.model.CommonResponseVoid;
import code.byted.cdp.model.CommonString;
import code.byted.cdp.model.CreateImportLabelEvent;
import code.byted.cdp.model.DeleteLabelDomainEvent;
import code.byted.cdp.model.DetailTableReq;
import code.byted.cdp.model.DomainMoveAction;
import java.io.File;
import code.byted.cdp.model.LabelQueryRequest;
import code.byted.cdp.model.ManualLabelCreateReq;
import code.byted.cdp.model.ManualPersonTagRequest;
import code.byted.cdp.model.NodeMoveAction;
import code.byted.cdp.model.RealtimeTagReq;
import code.byted.cdp.model.RerunRequest;
import code.byted.cdp.model.TagPageResp;
import code.byted.cdp.model.TendencyStatisticsReq;
import code.byted.cdp.model.UpdateImportLabelEvent;
import code.byted.cdp.model.UpdateLabelDomainEvent;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LabelApi {
    private ApiClient apiClient;

    public LabelApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LabelApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for queryUserProfile
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call queryUserProfileCall(QueryUserProfileRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","queryUserProfile"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
                "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call queryUserProfileValidateBeforeCall(QueryUserProfileRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling queryUserProfile(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling queryUserProfile(Async)");
        }

        com.squareup.okhttp.Call call = queryUserProfileCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 跨查询用户标签和属性
     * 跨主体查询用户标签和属性
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return QueryUserProfileResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public QueryUserProfileResp queryUserProfile(QueryUserProfileRequest body, Long xTenant) throws ApiException {
        ApiResponse<QueryUserProfileResp> resp = queryUserProfileWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 跨查询用户标签和属性
     * 跨主体查询用户标签和属性
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;QueryUserProfileResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<QueryUserProfileResp> queryUserProfileWithHttpInfo(QueryUserProfileRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = queryUserProfileValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<QueryUserProfileResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 跨查询用户标签和属性 (asynchronously)
     * 跨主体查询用户标签和属性
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call queryUserProfileAsync(QueryUserProfileRequest body, Long xTenant, final ApiCallback<QueryUserProfileResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = queryUserProfileValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<QueryUserProfileResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }

    /**
     * Build call for getLabelPerformance
     * @param xTenant 项目id (required)
     * @param labelId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelPerformanceCall(String xTenant, Integer labelId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (labelId != null)
            localVarQueryParams.addAll(apiClient.parameterToPair("labelId", labelId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelPerformance"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-08-05"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
            localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelPerformanceValidateBeforeCall(String xTenant, Integer labelId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelPerformance(Async)");
        }
        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getLabelPerformance(Async)");
        }

        com.squareup.okhttp.Call call = getLabelPerformanceCall(xTenant, labelId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取标签性能-关注度、稳定性、安全性、优化率
     * 获取标签性能-关注度、稳定性、安全性、优化率
     * @param xTenant 项目id (required)
     * @param labelId 标签id (required)
     * @return ByteDanceSeqResponseLabelPerformanceResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseLabelPerformanceResp getLabelPerformance(String xTenant, Integer labelId) throws ApiException {
        ApiResponse<ByteDanceSeqResponseLabelPerformanceResp> resp = getLabelPerformanceWithHttpInfo(xTenant, labelId);
        return resp.getData();
    }


    /**
     * 获取标签性能-关注度、稳定性、安全性、优化率
     * 获取标签性能-关注度、稳定性、安全性、优化率
     * @param xTenant 项目id (required)
     * @param labelId 标签id (required)
     * @return ApiResponse&lt;ByteDanceSeqResponseLabelPerformanceResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseLabelPerformanceResp> getLabelPerformanceWithHttpInfo(String xTenant, Integer labelId) throws ApiException {
        com.squareup.okhttp.Call call = getLabelPerformanceValidateBeforeCall(xTenant, labelId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseLabelPerformanceResp>(){}.getType();

        String[] localVarAccepts = {
                "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取标签性能-关注度、稳定性、安全性、优化率 (asynchronously)
     * 获取标签性能-关注度、稳定性、安全性、优化率
     * @param xTenant 项目id (required)
     * @param labelId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelPerformanceAsync(String xTenant, Integer labelId, final ApiCallback<ByteDanceSeqResponseLabelPerformanceResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
                "application/json"
        };

        com.squareup.okhttp.Call call = getLabelPerformanceValidateBeforeCall(xTenant, labelId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseLabelPerformanceResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for addLabelDomain
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addLabelDomainCall(AddLabelDomainEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","addLabelDomain"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addLabelDomainValidateBeforeCall(AddLabelDomainEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addLabelDomain(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling addLabelDomain(Async)");
        }

        com.squareup.okhttp.Call call = addLabelDomainCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建标签文件夹
     * 创建标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger addLabelDomain(AddLabelDomainEvent body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = addLabelDomainWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建标签文件夹
     * 创建标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> addLabelDomainWithHttpInfo(AddLabelDomainEvent body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = addLabelDomainValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建标签文件夹 (asynchronously)
     * 创建标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addLabelDomainAsync(AddLabelDomainEvent body, Long xTenant, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = addLabelDomainValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for addOrModifyManualTags
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addOrModifyManualTagsCall(ManualPersonTagRequest body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","addOrModifyManualTags"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addOrModifyManualTagsValidateBeforeCall(ManualPersonTagRequest body, String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addOrModifyManualTags(Async)");
        }
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling addOrModifyManualTags(Async)");
        }

        com.squareup.okhttp.Call call = addOrModifyManualTagsCall(body, tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ByteDanceNormalResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceNormalResponseString addOrModifyManualTags(ManualPersonTagRequest body, String tenantCode) throws ApiException {
        ApiResponse<ByteDanceNormalResponseString> resp = addOrModifyManualTagsWithHttpInfo(body, tenantCode);
        return resp.getData();
    }


    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;ByteDanceNormalResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceNormalResponseString> addOrModifyManualTagsWithHttpInfo(ManualPersonTagRequest body, String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = addOrModifyManualTagsValidateBeforeCall(body, tenantCode, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 添加或者修改某个用户身上的人工标签 (asynchronously)
     * 添加或者修改某个用户身上的人工标签
     * @param body  (required)
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addOrModifyManualTagsAsync(ManualPersonTagRequest body, String tenantCode, final ApiCallback<ByteDanceNormalResponseString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = addOrModifyManualTagsValidateBeforeCall(body, tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for approvalUpdate
     * @param body 编辑审批请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call approvalUpdateCall(ApprovalUpdateReq body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","approvalUpdate"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call approvalUpdateValidateBeforeCall(ApprovalUpdateReq body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling approvalUpdate(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling approvalUpdate(Async)");
        }

        com.squareup.okhttp.Call call = approvalUpdateCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 更新标签审批状态
     * 标签审批状态更新
     * @param body 编辑审批请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean approvalUpdate(ApprovalUpdateReq body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = approvalUpdateWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 更新标签审批状态
     * 标签审批状态更新
     * @param body 编辑审批请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> approvalUpdateWithHttpInfo(ApprovalUpdateReq body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = approvalUpdateValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 更新标签审批状态 (asynchronously)
     * 标签审批状态更新
     * @param body 编辑审批请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call approvalUpdateAsync(ApprovalUpdateReq body, Long xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = approvalUpdateValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createImportLabel
     * @param body 创建导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createImportLabelCall(CreateImportLabelEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createImportLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createImportLabelValidateBeforeCall(CreateImportLabelEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createImportLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling createImportLabel(Async)");
        }

        com.squareup.okhttp.Call call = createImportLabelCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建导入标签
     * 创建导入标签
     * @param body 创建导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger createImportLabel(CreateImportLabelEvent body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = createImportLabelWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 创建导入标签
     * 创建导入标签
     * @param body 创建导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> createImportLabelWithHttpInfo(CreateImportLabelEvent body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = createImportLabelValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建导入标签 (asynchronously)
     * 创建导入标签
     * @param body 创建导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createImportLabelAsync(CreateImportLabelEvent body, Long xTenant, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = createImportLabelValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for createManualLabel
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call createManualLabelCall(ManualLabelCreateReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","createManualLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call createManualLabelValidateBeforeCall(ManualLabelCreateReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createManualLabel(Async)");
        }

        com.squareup.okhttp.Call call = createManualLabelCall(body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 创建人工标签
     * 创建人工标签
     * @param body  (required)
     * @return CommonLabelId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonLabelId createManualLabel(ManualLabelCreateReq body) throws ApiException {
        ApiResponse<CommonLabelId> resp = createManualLabelWithHttpInfo(body);
        return resp.getData();
    }


    /**
     * 创建人工标签
     * 创建人工标签
     * @param body  (required)
     * @return ApiResponse&lt;CommonLabelId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonLabelId> createManualLabelWithHttpInfo(ManualLabelCreateReq body) throws ApiException {
        com.squareup.okhttp.Call call = createManualLabelValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<CommonLabelId>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 创建人工标签 (asynchronously)
     * 创建人工标签
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call createManualLabelAsync(ManualLabelCreateReq body, final ApiCallback<CommonLabelId> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = createManualLabelValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonLabelId>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteLabel
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLabelCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-10-19"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLabelValidateBeforeCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteLabel(Async)");
        }

        com.squareup.okhttp.Call call = deleteLabelCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除标签
     * 删除标签 （拥有操作该标签的管理权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseVoid
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseVoid deleteLabel(Integer id, String xTenant) throws ApiException {
        ApiResponse<CommonResponseVoid> resp = deleteLabelWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 删除标签
     * 删除标签 （拥有操作该标签的管理权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseVoid&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseVoid> deleteLabelWithHttpInfo(Integer id, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = deleteLabelValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除标签 (asynchronously)
     * 删除标签 （拥有操作该标签的管理权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLabelAsync(Integer id, String xTenant, final ApiCallback<CommonResponseVoid> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteLabelValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseVoid>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteLabelDomain
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteLabelDomainCall(DeleteLabelDomainEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteLabelDomain"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteLabelDomainValidateBeforeCall(DeleteLabelDomainEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteLabelDomain(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteLabelDomain(Async)");
        }

        com.squareup.okhttp.Call call = deleteLabelDomainCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除标签文件夹
     * 删除标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger deleteLabelDomain(DeleteLabelDomainEvent body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = deleteLabelDomainWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 删除标签文件夹
     * 删除标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> deleteLabelDomainWithHttpInfo(DeleteLabelDomainEvent body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = deleteLabelDomainValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除标签文件夹 (asynchronously)
     * 删除标签文件夹
     * @param body 文件夹操作请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteLabelDomainAsync(DeleteLabelDomainEvent body, Long xTenant, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteLabelDomainValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteManualTagsInUser
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteManualTagsInUserCall(String tenantCode, Long baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tagId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tagId", tagId));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("baseId", baseId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteManualTagsInUser"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteManualTagsInUserValidateBeforeCall(String tenantCode, Long baseId, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling deleteManualTagsInUser(Async)");
        }
        // verify the required parameter 'baseId' is set
        if (baseId == null) {
            throw new ApiException("Missing the required parameter 'baseId' when calling deleteManualTagsInUser(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteManualTagsInUser(Async)");
        }

        com.squareup.okhttp.Call call = deleteManualTagsInUserCall(tenantCode, baseId, tagId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签计划逐步下线，建议使用 DeleteRealtimeTagData
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @return ByteDanceNormalResponseString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceNormalResponseString deleteManualTagsInUser(String tenantCode, Long baseId, Integer tagId) throws ApiException {
        ApiResponse<ByteDanceNormalResponseString> resp = deleteManualTagsInUserWithHttpInfo(tenantCode, baseId, tagId);
        return resp.getData();
    }


    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签计划逐步下线，建议使用 DeleteRealtimeTagData
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @return ApiResponse&lt;ByteDanceNormalResponseString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceNormalResponseString> deleteManualTagsInUserWithHttpInfo(String tenantCode, Long baseId, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = deleteManualTagsInUserValidateBeforeCall(tenantCode, baseId, tagId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除某个用户身上的人工标签 (asynchronously)
     * 删除某个用户身上的人工标签计划逐步下线，建议使用 DeleteRealtimeTagData
     * @param tenantCode 租户Code (required)
     * @param baseId 基准ID (required)
     * @param tagId 人工标签ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteManualTagsInUserAsync(String tenantCode, Long baseId, Integer tagId, final ApiCallback<ByteDanceNormalResponseString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteManualTagsInUserValidateBeforeCall(tenantCode, baseId, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceNormalResponseString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for deleteRealtimeTagData
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteRealtimeTagDataCall(Long xTenant, Long baseId, Integer tagId,
            final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tagId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tagId", tagId));

        localVarQueryParams.add(new Pair("baseId", baseId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","deleteRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));


        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteRealtimeTagDataValidateBeforeCall(Long xTenant, Long baseId, Integer tagId
            , final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling deleteRealtimeTagData(Async)");
        }
        // verify the required parameter 'baseId' is set
        if (baseId == null) {
            throw new ApiException("Missing the required parameter 'baseId' when calling deleteRealtimeTagData(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling deleteRealtimeTagData(Async)");
        }

        com.squareup.okhttp.Call call = deleteRealtimeTagDataCall(xTenant, baseId, tagId, progressListener,
                progressRequestListener);
        return call;





    }

    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @return CommonString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonString deleteRealtimeTagData(Long xTenant, Long baseId, Integer tagId) throws ApiException {
        ApiResponse<CommonString> resp = deleteRealtimeTagDataWithHttpInfo(xTenant, baseId, tagId);
        return resp.getData();
    }


    /**
     * 删除某个用户身上的人工标签
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @return ApiResponse&lt;CommonString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonString> deleteRealtimeTagDataWithHttpInfo(Long xTenant, Long baseId, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = deleteRealtimeTagDataValidateBeforeCall(xTenant, baseId, tagId, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 删除某个用户身上的人工标签 (asynchronously)
     * 删除某个用户身上的人工标签，该接口可替换接口【删除某个用户身上的人工标签】
     * @param baseId 基准id (required)
     * @param tagId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteRealtimeTagDataAsync(Long xTenant, Long baseId, Integer tagId,
            final ApiCallback<CommonString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = deleteRealtimeTagDataValidateBeforeCall(xTenant, baseId, tagId,
                progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getAccessCoreStatistics
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccessCoreStatisticsCall(Long xTenant, AccessCoreStatisticsReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getAccessCoreStatistics"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccessCoreStatisticsValidateBeforeCall(Long xTenant, AccessCoreStatisticsReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getAccessCoreStatistics(Async)");
        }

        com.squareup.okhttp.Call call = getAccessCoreStatisticsCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取访问统计-核心指标
     * 获取项目中心-访问统计-核心指标
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return CommonResponseListAccessCoreStatisticsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListAccessCoreStatisticsResp getAccessCoreStatistics(Long xTenant, AccessCoreStatisticsReq body) throws ApiException {
        ApiResponse<CommonResponseListAccessCoreStatisticsResp> resp = getAccessCoreStatisticsWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 获取访问统计-核心指标
     * 获取项目中心-访问统计-核心指标
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseListAccessCoreStatisticsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListAccessCoreStatisticsResp> getAccessCoreStatisticsWithHttpInfo(Long xTenant, AccessCoreStatisticsReq body) throws ApiException {
        com.squareup.okhttp.Call call = getAccessCoreStatisticsValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListAccessCoreStatisticsResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取访问统计-核心指标 (asynchronously)
     * 获取项目中心-访问统计-核心指标
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccessCoreStatisticsAsync(Long xTenant, AccessCoreStatisticsReq body, final ApiCallback<CommonResponseListAccessCoreStatisticsResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getAccessCoreStatisticsValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListAccessCoreStatisticsResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getAccessCoreTendencyStatistics
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAccessCoreTendencyStatisticsCall(Long xTenant, TendencyStatisticsReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getAccessCoreTendencyStatistics"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAccessCoreTendencyStatisticsValidateBeforeCall(Long xTenant, TendencyStatisticsReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getAccessCoreTendencyStatistics(Async)");
        }

        com.squareup.okhttp.Call call = getAccessCoreTendencyStatisticsCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取访问统计-核心指标趋势图
     * 获取项目中心-访问统计-核心指标趋势图
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return CommonResponseListTendencyStatisticsResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListTendencyStatisticsResp getAccessCoreTendencyStatistics(Long xTenant, TendencyStatisticsReq body) throws ApiException {
        ApiResponse<CommonResponseListTendencyStatisticsResp> resp = getAccessCoreTendencyStatisticsWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 获取访问统计-核心指标趋势图
     * 获取项目中心-访问统计-核心指标趋势图
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseListTendencyStatisticsResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListTendencyStatisticsResp> getAccessCoreTendencyStatisticsWithHttpInfo(Long xTenant, TendencyStatisticsReq body) throws ApiException {
        com.squareup.okhttp.Call call = getAccessCoreTendencyStatisticsValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListTendencyStatisticsResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取访问统计-核心指标趋势图 (asynchronously)
     * 获取项目中心-访问统计-核心指标趋势图
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAccessCoreTendencyStatisticsAsync(Long xTenant, TendencyStatisticsReq body, final ApiCallback<CommonResponseListTendencyStatisticsResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getAccessCoreTendencyStatisticsValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListTendencyStatisticsResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getHistoryData
     * @param id 标签id (required)
     * @param startDate 开始日期 (required)
     * @param endDate 结束日期 (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getHistoryDataCall(Integer id, String startDate, String endDate, Integer showNum, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
        if (startDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
        if (endDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
        if (showNum != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("showNum", showNum));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getHistoryData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getHistoryDataValidateBeforeCall(Integer id, String startDate, String endDate, Integer showNum, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoryData(Async)");
        }
        // verify the required parameter 'startDate' is set
        if (startDate == null) {
            throw new ApiException("Missing the required parameter 'startDate' when calling getHistoryData(Async)");
        }
        // verify the required parameter 'endDate' is set
        if (endDate == null) {
            throw new ApiException("Missing the required parameter 'endDate' when calling getHistoryData(Async)");
        }
        // verify the required parameter 'showNum' is set
        if (showNum == null) {
            throw new ApiException("Missing the required parameter 'showNum' when calling getHistoryData(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getHistoryData(Async)");
        }

        com.squareup.okhttp.Call call = getHistoryDataCall(id, startDate, endDate, showNum, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询标签历史计算结果
     * 根据标签id获取标签历史计算结果
     * @param id 标签id (required)
     * @param startDate 开始日期 (required)
     * @param endDate 结束日期 (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @return CommonListLabelResultData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListLabelResultData getHistoryData(Integer id, String startDate, String endDate, Integer showNum, Long xTenant) throws ApiException {
        ApiResponse<CommonListLabelResultData> resp = getHistoryDataWithHttpInfo(id, startDate, endDate, showNum, xTenant);
        return resp.getData();
    }


    /**
     * 查询标签历史计算结果
     * 根据标签id获取标签历史计算结果
     * @param id 标签id (required)
     * @param startDate 开始日期 (required)
     * @param endDate 结束日期 (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonListLabelResultData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListLabelResultData> getHistoryDataWithHttpInfo(Integer id, String startDate, String endDate, Integer showNum, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getHistoryDataValidateBeforeCall(id, startDate, endDate, showNum, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelResultData>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询标签历史计算结果 (asynchronously)
     * 根据标签id获取标签历史计算结果
     * @param id 标签id (required)
     * @param startDate 开始日期 (required)
     * @param endDate 结束日期 (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getHistoryDataAsync(Integer id, String startDate, String endDate, Integer showNum, Long xTenant, final ApiCallback<CommonListLabelResultData> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getHistoryDataValidateBeforeCall(id, startDate, endDate, showNum, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelResultData>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLabelDesc
     * @param id 标签ID (required)
     * @param xTenant 租户ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelDescCall(Integer id, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelDesc"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelDescValidateBeforeCall(Integer id, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLabelDesc(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelDesc(Async)");
        }

        com.squareup.okhttp.Call call = getLabelDescCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取标签信息
     * 查询标签信息（标签最近同步结束时间、标签描述、标签所属标签树）
     * @param id 标签ID (required)
     * @param xTenant 租户ID (required)
     * @return CommonResponseLabelMetaSimpleInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseLabelMetaSimpleInfo getLabelDesc(Integer id, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseLabelMetaSimpleInfo> resp = getLabelDescWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 获取标签信息
     * 查询标签信息（标签最近同步结束时间、标签描述、标签所属标签树）
     * @param id 标签ID (required)
     * @param xTenant 租户ID (required)
     * @return ApiResponse&lt;CommonResponseLabelMetaSimpleInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseLabelMetaSimpleInfo> getLabelDescWithHttpInfo(Integer id, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getLabelDescValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseLabelMetaSimpleInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取标签信息 (asynchronously)
     * 查询标签信息（标签最近同步结束时间、标签描述、标签所属标签树）
     * @param id 标签ID (required)
     * @param xTenant 租户ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelDescAsync(Integer id, Long xTenant, final ApiCallback<CommonResponseLabelMetaSimpleInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLabelDescValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseLabelMetaSimpleInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLabelTree
     * @param xTenant 租户ID (required)
     * @param subjectId 主体ID (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelTreeCall(Long xTenant, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelTree"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelTreeValidateBeforeCall(Long xTenant, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelTree(Async)");
        }

        com.squareup.okhttp.Call call = getLabelTreeCall(xTenant, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取标签树信息
     * 获取标签树信息
     * @param xTenant 租户ID (required)
     * @param subjectId 主体ID (optional)
     * @return CommonResponseListLabelTreeNode
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseListLabelTreeNode getLabelTree(Long xTenant, Integer subjectId) throws ApiException {
        ApiResponse<CommonResponseListLabelTreeNode> resp = getLabelTreeWithHttpInfo(xTenant, subjectId);
        return resp.getData();
    }


    /**
     * 获取标签树信息
     * 获取标签树信息
     * @param xTenant 租户ID (required)
     * @param subjectId 主体ID (optional)
     * @return ApiResponse&lt;CommonResponseListLabelTreeNode&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseListLabelTreeNode> getLabelTreeWithHttpInfo(Long xTenant, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = getLabelTreeValidateBeforeCall(xTenant, subjectId, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelTreeNode>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取标签树信息 (asynchronously)
     * 获取标签树信息
     * @param xTenant 租户ID (required)
     * @param subjectId 主体ID (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelTreeAsync(Long xTenant, Integer subjectId, final ApiCallback<CommonResponseListLabelTreeNode> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLabelTreeValidateBeforeCall(xTenant, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseListLabelTreeNode>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLabelValues
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (labelId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("labelId", labelId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabelValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelValuesValidateBeforeCall(Integer labelId, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'labelId' is set
        if (labelId == null) {
            throw new ApiException("Missing the required parameter 'labelId' when calling getLabelValues(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabelValues(Async)");
        }

        com.squareup.okhttp.Call call = getLabelValuesCall(labelId, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return CommonListObject
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListObject getLabelValues(Integer labelId, Long xTenant) throws ApiException {
        ApiResponse<CommonListObject> resp = getLabelValuesWithHttpInfo(labelId, xTenant);
        return resp.getData();
    }


    /**
     * 获取某个标签的取值
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonListObject&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListObject> getLabelValuesWithHttpInfo(Integer labelId, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取某个标签的取值 (asynchronously)
     * 获取标签取值（最新导入的标签结果，支持标签类型：date, array_date, datetime, array_datetime, string, array_string），该接口可替换接口【获取某个标签的取值】
     * @param labelId 标签id (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelValuesAsync(Integer labelId, Long xTenant, final ApiCallback<CommonListObject> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLabelValuesValidateBeforeCall(labelId, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListObject>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLabels
     * @param xTenant 项目ID (required)
     * @param subjectId 主体ID (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLabelsCall(Long xTenant, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLabels"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLabelsValidateBeforeCall(Long xTenant, Integer subjectId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLabels(Async)");
        }

        com.squareup.okhttp.Call call = getLabelsCall(xTenant, subjectId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询项目下标签列表
     * 根据项目id获取项目下标签列表
     * @param xTenant 项目ID (required)
     * @param subjectId 主体ID (optional)
     * @return CommonListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListLabelMetaInfo getLabels(Long xTenant, Integer subjectId) throws ApiException {
        ApiResponse<CommonListLabelMetaInfo> resp = getLabelsWithHttpInfo(xTenant, subjectId);
        return resp.getData();
    }


    /**
     * 查询项目下标签列表
     * 根据项目id获取项目下标签列表
     * @param xTenant 项目ID (required)
     * @param subjectId 主体ID (optional)
     * @return ApiResponse&lt;CommonListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListLabelMetaInfo> getLabelsWithHttpInfo(Long xTenant, Integer subjectId) throws ApiException {
        com.squareup.okhttp.Call call = getLabelsValidateBeforeCall(xTenant, subjectId, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询项目下标签列表 (asynchronously)
     * 根据项目id获取项目下标签列表
     * @param xTenant 项目ID (required)
     * @param subjectId 主体ID (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLabelsAsync(Long xTenant, Integer subjectId, final ApiCallback<CommonListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLabelsValidateBeforeCall(xTenant, subjectId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getLatestHistoryData
     * @param id 标签id (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getLatestHistoryDataCall(Integer id, Integer showNum, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (id != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("id", id));
        if (showNum != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("showNum", showNum));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getLatestHistoryData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getLatestHistoryDataValidateBeforeCall(Integer id, Integer showNum, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getLatestHistoryData(Async)");
        }
        // verify the required parameter 'showNum' is set
        if (showNum == null) {
            throw new ApiException("Missing the required parameter 'showNum' when calling getLatestHistoryData(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getLatestHistoryData(Async)");
        }

        com.squareup.okhttp.Call call = getLatestHistoryDataCall(id, showNum, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 查询标签最新结果
     * 根据标签id获取标签最新计算结果
     * @param id 标签id (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @return CommonLabelResultData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonLabelResultData getLatestHistoryData(Integer id, Integer showNum, Long xTenant) throws ApiException {
        ApiResponse<CommonLabelResultData> resp = getLatestHistoryDataWithHttpInfo(id, showNum, xTenant);
        return resp.getData();
    }


    /**
     * 查询标签最新结果
     * 根据标签id获取标签最新计算结果
     * @param id 标签id (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonLabelResultData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonLabelResultData> getLatestHistoryDataWithHttpInfo(Integer id, Integer showNum, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = getLatestHistoryDataValidateBeforeCall(id, showNum, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonLabelResultData>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 查询标签最新结果 (asynchronously)
     * 根据标签id获取标签最新计算结果
     * @param id 标签id (required)
     * @param showNum 展示数量 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getLatestHistoryDataAsync(Integer id, Integer showNum, Long xTenant, final ApiCallback<CommonLabelResultData> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getLatestHistoryDataValidateBeforeCall(id, showNum, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonLabelResultData>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getManualTagsList
     * @param tenantCode 租户Code (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getManualTagsListCall(String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getManualTagsList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getManualTagsListValidateBeforeCall(String tenantCode, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getManualTagsList(Async)");
        }

        com.squareup.okhttp.Call call = getManualTagsListCall(tenantCode, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取人工标签列表
     * 根据租户code获取该租户下所有人工标签
     * @param tenantCode 租户Code (required)
     * @return ByteDanceSeqResponseOpenApiManualTagInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseOpenApiManualTagInfo getManualTagsList(String tenantCode) throws ApiException {
        ApiResponse<ByteDanceSeqResponseOpenApiManualTagInfo> resp = getManualTagsListWithHttpInfo(tenantCode);
        return resp.getData();
    }


    /**
     * 获取人工标签列表
     * 根据租户code获取该租户下所有人工标签
     * @param tenantCode 租户Code (required)
     * @return ApiResponse&lt;ByteDanceSeqResponseOpenApiManualTagInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseOpenApiManualTagInfo> getManualTagsListWithHttpInfo(String tenantCode) throws ApiException {
        com.squareup.okhttp.Call call = getManualTagsListValidateBeforeCall(tenantCode, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseOpenApiManualTagInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取人工标签列表 (asynchronously)
     * 根据租户code获取该租户下所有人工标签
     * @param tenantCode 租户Code (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getManualTagsListAsync(String tenantCode, final ApiCallback<ByteDanceSeqResponseOpenApiManualTagInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getManualTagsListValidateBeforeCall(tenantCode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseOpenApiManualTagInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getOnlineTagsProp
     * @param tenantCode 租户ID (required)
     * @param infoType 查询类型取值：label、property、behavior、detail (required)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param idType id类型 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getOnlineTagsPropCall(String tenantCode, String infoType, Integer current, Integer pageSize, Integer idType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (current != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("current", current));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("pageSize", pageSize));
        if (idType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("idType", idType));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("infoType", infoType.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getOnlineTagsProp"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getOnlineTagsPropValidateBeforeCall(String tenantCode, String infoType, Integer current, Integer pageSize, Integer idType, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getOnlineTagsProp(Async)");
        }
        // verify the required parameter 'infoType' is set
        if (infoType == null) {
            throw new ApiException("Missing the required parameter 'infoType' when calling getOnlineTagsProp(Async)");
        }

        com.squareup.okhttp.Call call = getOnlineTagsPropCall(tenantCode, infoType, current, pageSize, idType, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取所有在线可用的标签/属性/明细/行为事件列表
     * 按租户获取在线可用的标签/属性/明细/行为列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户ID (required)
     * @param infoType 查询类型取值：label、property、behavior、detail (required)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param idType id类型 (optional)
     * @return CommonOnlineTagInfoResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonOnlineTagInfoResp getOnlineTagsProp(String tenantCode, String infoType, Integer current, Integer pageSize, Integer idType) throws ApiException {
        ApiResponse<CommonOnlineTagInfoResp> resp = getOnlineTagsPropWithHttpInfo(tenantCode, infoType, current, pageSize, idType);
        return resp.getData();
    }


    /**
     * 获取所有在线可用的标签/属性/明细/行为事件列表
     * 按租户获取在线可用的标签/属性/明细/行为列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户ID (required)
     * @param infoType 查询类型取值：label、property、behavior、detail (required)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param idType id类型 (optional)
     * @return ApiResponse&lt;CommonOnlineTagInfoResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonOnlineTagInfoResp> getOnlineTagsPropWithHttpInfo(String tenantCode, String infoType, Integer current, Integer pageSize, Integer idType) throws ApiException {
        com.squareup.okhttp.Call call = getOnlineTagsPropValidateBeforeCall(tenantCode, infoType, current, pageSize, idType, null, null);
        Type localVarReturnType = new TypeToken<CommonOnlineTagInfoResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取所有在线可用的标签/属性/明细/行为事件列表 (asynchronously)
     * 按租户获取在线可用的标签/属性/明细/行为列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户ID (required)
     * @param infoType 查询类型取值：label、property、behavior、detail (required)
     * @param current 当前页 (optional)
     * @param pageSize 分页大小 (optional)
     * @param idType id类型 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getOnlineTagsPropAsync(String tenantCode, String infoType, Integer current, Integer pageSize, Integer idType, final ApiCallback<CommonOnlineTagInfoResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getOnlineTagsPropValidateBeforeCall(tenantCode, infoType, current, pageSize, idType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonOnlineTagInfoResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getResourceTable
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getResourceTableCall(Long xTenant, DetailTableReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getResourceTable"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-08-08"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getResourceTableValidateBeforeCall(Long xTenant, DetailTableReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling getResourceTable(Async)");
        }

        com.squareup.okhttp.Call call = getResourceTableCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 资产价值评估报表
     * 拉取资产价值评估报表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return CommonResponseDetailTableResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseDetailTableResp getResourceTable(Long xTenant, DetailTableReq body) throws ApiException {
        ApiResponse<CommonResponseDetailTableResp> resp = getResourceTableWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 资产价值评估报表
     * 拉取资产价值评估报表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonResponseDetailTableResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseDetailTableResp> getResourceTableWithHttpInfo(Long xTenant, DetailTableReq body) throws ApiException {
        com.squareup.okhttp.Call call = getResourceTableValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseDetailTableResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 资产价值评估报表 (asynchronously)
     * 拉取资产价值评估报表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getResourceTableAsync(Long xTenant, DetailTableReq body, final ApiCallback<CommonResponseDetailTableResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getResourceTableValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseDetailTableResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTagValues
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTagValuesCall(String tenantCode, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));
        localVarQueryParams.add(new Pair("tagId", tagId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTagValues"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTagValuesValidateBeforeCall(String tenantCode, Integer tagId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getTagValues(Async)");
        }
        // verify the required parameter 'tagId' is set
        if (tagId == null) {
            throw new ApiException("Missing the required parameter 'tagId' when calling getTagValues(Async)");
        }

        com.squareup.okhttp.Call call = getTagValuesCall(tenantCode, tagId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取某个标签的取值
     * 按租户获取标签取值，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @return ByteDanceSeqResponseTagValueResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseTagValueResp getTagValues(String tenantCode, Integer tagId) throws ApiException {
        ApiResponse<ByteDanceSeqResponseTagValueResp> resp = getTagValuesWithHttpInfo(tenantCode, tagId);
        return resp.getData();
    }


    /**
     * 获取某个标签的取值
     * 按租户获取标签取值，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @return ApiResponse&lt;ByteDanceSeqResponseTagValueResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseTagValueResp> getTagValuesWithHttpInfo(String tenantCode, Integer tagId) throws ApiException {
        com.squareup.okhttp.Call call = getTagValuesValidateBeforeCall(tenantCode, tagId, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取某个标签的取值 (asynchronously)
     * 按租户获取标签取值，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param tagId 标签id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTagValuesAsync(String tenantCode, Integer tagId, final ApiCallback<ByteDanceSeqResponseTagValueResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getTagValuesValidateBeforeCall(tenantCode, tagId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseTagValueResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTags
     * @param projectId 项目ID (required)
     * @param subjectId 主体ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param userName 用户名称 (optional)
     * @param page 当前页 (optional)
     * @param pageSize 页大小 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTagsCall(String projectId, Integer subjectId, String keyword, Integer onlineStatusCode, String userName, Integer page, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (keyword != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("keyword", keyword));
        if (onlineStatusCode != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("online_status_code", onlineStatusCode));
        if (userName != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("user_name", userName));
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subject_id", subjectId));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("page_size", pageSize));

        localVarQueryParams.add(new Pair("project_id", projectId.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTags"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-05-22"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTagsValidateBeforeCall(String projectId, Integer subjectId, String keyword, Integer onlineStatusCode, String userName, Integer page, Integer pageSize, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'projectId' is set
        if (projectId == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getTags(Async)");
        }
        // verify the required parameter 'subjectId' is set
        if (subjectId == null) {
            throw new ApiException("Missing the required parameter 'subjectId' when calling getTags(Async)");
        }

        com.squareup.okhttp.Call call = getTagsCall(projectId, subjectId, keyword, onlineStatusCode, userName, page, pageSize, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取已导入的标签列表
     * 获取已导入的标签列表
     * @param projectId 项目ID (required)
     * @param subjectId 主体ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param userName 用户名称 (optional)
     * @param page 当前页 (optional)
     * @param pageSize 页大小 (optional)
     * @return TagPageResp
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TagPageResp getTags(String projectId, Integer subjectId, String keyword, Integer onlineStatusCode, String userName, Integer page, Integer pageSize) throws ApiException {
        ApiResponse<TagPageResp> resp = getTagsWithHttpInfo(projectId, subjectId, keyword, onlineStatusCode, userName, page, pageSize);
        return resp.getData();
    }


    /**
     * 获取已导入的标签列表
     * 获取已导入的标签列表
     * @param projectId 项目ID (required)
     * @param subjectId 主体ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param userName 用户名称 (optional)
     * @param page 当前页 (optional)
     * @param pageSize 页大小 (optional)
     * @return ApiResponse&lt;TagPageResp&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TagPageResp> getTagsWithHttpInfo(String projectId, Integer subjectId, String keyword, Integer onlineStatusCode, String userName, Integer page, Integer pageSize) throws ApiException {
        com.squareup.okhttp.Call call = getTagsValidateBeforeCall(projectId, subjectId, keyword, onlineStatusCode, userName, page, pageSize, null, null);
        Type localVarReturnType = new TypeToken<TagPageResp>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取已导入的标签列表 (asynchronously)
     * 获取已导入的标签列表
     * @param projectId 项目ID (required)
     * @param subjectId 主体ID (required)
     * @param keyword 关键字 (optional)
     * @param onlineStatusCode 在线状态，0-未开启，1-开启，但数据未就绪，2-开启且数据就绪过，注意：这里不代表已经是最新的数据，只是成功过 (optional)
     * @param userName 用户名称 (optional)
     * @param page 当前页 (optional)
     * @param pageSize 页大小 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTagsAsync(String projectId, Integer subjectId, String keyword, Integer onlineStatusCode, String userName, Integer page, Integer pageSize, final ApiCallback<TagPageResp> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = getTagsValidateBeforeCall(projectId, subjectId, keyword, onlineStatusCode, userName, page, pageSize, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TagPageResp>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for getTagsList
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主体下的base_id类型的ID (required)
     * @param discardValue 是否移除标签取值。默认是false (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getTagsListCall(String tenantCode, Integer idType, Boolean discardValue, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (idType != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("idType", idType));
        if (discardValue != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("discardValue", discardValue));

        localVarQueryParams.add(new Pair("tenantCode", tenantCode.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","getTagsList"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-02-10"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getTagsListValidateBeforeCall(String tenantCode, Integer idType, Boolean discardValue, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'tenantCode' is set
        if (tenantCode == null) {
            throw new ApiException("Missing the required parameter 'tenantCode' when calling getTagsList(Async)");
        }
        // verify the required parameter 'idType' is set
        if (idType == null) {
            throw new ApiException("Missing the required parameter 'idType' when calling getTagsList(Async)");
        }

        com.squareup.okhttp.Call call = getTagsListCall(tenantCode, idType, discardValue, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 获取所有标签列表，包含各个标签的取值
     * 按租户获取标签列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主体下的base_id类型的ID (required)
     * @param discardValue 是否移除标签取值。默认是false (optional)
     * @return ByteDanceSeqResponseSeqDomainGroupedTags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ByteDanceSeqResponseSeqDomainGroupedTags getTagsList(String tenantCode, Integer idType, Boolean discardValue) throws ApiException {
        ApiResponse<ByteDanceSeqResponseSeqDomainGroupedTags> resp = getTagsListWithHttpInfo(tenantCode, idType, discardValue);
        return resp.getData();
    }


    /**
     * 获取所有标签列表，包含各个标签的取值
     * 按租户获取标签列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主体下的base_id类型的ID (required)
     * @param discardValue 是否移除标签取值。默认是false (optional)
     * @return ApiResponse&lt;ByteDanceSeqResponseSeqDomainGroupedTags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ByteDanceSeqResponseSeqDomainGroupedTags> getTagsListWithHttpInfo(String tenantCode, Integer idType, Boolean discardValue) throws ApiException {
        com.squareup.okhttp.Call call = getTagsListValidateBeforeCall(tenantCode, idType, discardValue, null, null);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseSeqDomainGroupedTags>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 获取所有标签列表，包含各个标签的取值 (asynchronously)
     * 按租户获取标签列表，在sass环境，租户和集团关联，会自动按租户绑定的集团过滤
     * @param tenantCode 租户Code (required)
     * @param idType 标签的idType，传每个主体下的base_id类型的ID (required)
     * @param discardValue 是否移除标签取值。默认是false (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getTagsListAsync(String tenantCode, Integer idType, Boolean discardValue, final ApiCallback<ByteDanceSeqResponseSeqDomainGroupedTags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = getTagsListValidateBeforeCall(tenantCode, idType, discardValue, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ByteDanceSeqResponseSeqDomainGroupedTags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for moveLabelDomain
     * @param body 文件夹移动请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call moveLabelDomainCall(DomainMoveAction body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","moveLabelDomain"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call moveLabelDomainValidateBeforeCall(DomainMoveAction body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling moveLabelDomain(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling moveLabelDomain(Async)");
        }

        com.squareup.okhttp.Call call = moveLabelDomainCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 移动标签文件夹
     * 移动标签文件夹
     * @param body 文件夹移动请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger moveLabelDomain(DomainMoveAction body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = moveLabelDomainWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 移动标签文件夹
     * 移动标签文件夹
     * @param body 文件夹移动请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> moveLabelDomainWithHttpInfo(DomainMoveAction body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = moveLabelDomainValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 移动标签文件夹 (asynchronously)
     * 移动标签文件夹
     * @param body 文件夹移动请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call moveLabelDomainAsync(DomainMoveAction body, Long xTenant, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = moveLabelDomainValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for moveLabelToDomain
     * @param xTenant 项目ID (required)
     * @param body 标签移动请求 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call moveLabelToDomainCall(Long xTenant, NodeMoveAction body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","moveLabelToDomain"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call moveLabelToDomainValidateBeforeCall(Long xTenant, NodeMoveAction body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling moveLabelToDomain(Async)");
        }

        com.squareup.okhttp.Call call = moveLabelToDomainCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 移动标签
     * 移动标签
     * @param xTenant 项目ID (required)
     * @param body 标签移动请求 (optional)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger moveLabelToDomain(Long xTenant, NodeMoveAction body) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = moveLabelToDomainWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 移动标签
     * 移动标签
     * @param xTenant 项目ID (required)
     * @param body 标签移动请求 (optional)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> moveLabelToDomainWithHttpInfo(Long xTenant, NodeMoveAction body) throws ApiException {
        com.squareup.okhttp.Call call = moveLabelToDomainValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 移动标签 (asynchronously)
     * 移动标签
     * @param xTenant 项目ID (required)
     * @param body 标签移动请求 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call moveLabelToDomainAsync(Long xTenant, NodeMoveAction body, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = moveLabelToDomainValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for postLabels
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postLabelsCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subjectId != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("subjectId", subjectId));
        if (type != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("type", type));


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","postLabels"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postLabelsValidateBeforeCall(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling postLabels(Async)");
        }

        com.squareup.okhttp.Call call = postLabelsCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @return CommonListLabelMetaInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonListLabelMetaInfo postLabels(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        ApiResponse<CommonListLabelMetaInfo> resp = postLabelsWithHttpInfo(xTenant, body, subjectId, type);
        return resp.getData();
    }


    /**
     * 标签列表高级查询
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @return ApiResponse&lt;CommonListLabelMetaInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonListLabelMetaInfo> postLabelsWithHttpInfo(Long xTenant, LabelQueryRequest body, Integer subjectId, String type) throws ApiException {
        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, null, null);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 标签列表高级查询 (asynchronously)
     * 根据项目id获取项目下标签列表，该接口可替换接口【获取所有标签列表，包含各个标签的取值】和【获取人工标签列表
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param subjectId 主体id (optional)
     * @param type 类型 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postLabelsAsync(Long xTenant, LabelQueryRequest body, Integer subjectId, String type, final ApiCallback<CommonListLabelMetaInfo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = postLabelsValidateBeforeCall(xTenant, body, subjectId, type, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonListLabelMetaInfo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for publishLabel
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call publishLabelCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","publishLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-10-19"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call publishLabelValidateBeforeCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling publishLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling publishLabel(Async)");
        }

        com.squareup.okhttp.Call call = publishLabelCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上架标签
     * 上架标签 （开启标签上下架功能开关且拥有操作该标签的读权限)
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean publishLabel(Integer id, String xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = publishLabelWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 上架标签
     * 上架标签 （开启标签上下架功能开关且拥有操作该标签的读权限)
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> publishLabelWithHttpInfo(Integer id, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = publishLabelValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上架标签 (asynchronously)
     * 上架标签 （开启标签上下架功能开关且拥有操作该标签的读权限)
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call publishLabelAsync(Integer id, String xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = publishLabelValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for rerunLabel
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call rerunLabelCall(RerunRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","rerunLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call rerunLabelValidateBeforeCall(RerunRequest body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling rerunLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling rerunLabel(Async)");
        }

        com.squareup.okhttp.Call call = rerunLabelCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 触发标签计算
     * 根据标签id触发标签计算
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return CommonBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonBoolean rerunLabel(RerunRequest body, Long xTenant) throws ApiException {
        ApiResponse<CommonBoolean> resp = rerunLabelWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 触发标签计算
     * 根据标签id触发标签计算
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonBoolean> rerunLabelWithHttpInfo(RerunRequest body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = rerunLabelValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 触发标签计算 (asynchronously)
     * 根据标签id触发标签计算
     * @param body  (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call rerunLabelAsync(RerunRequest body, Long xTenant, final ApiCallback<CommonBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = rerunLabelValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for unPublishLabel
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unPublishLabelCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        localVarQueryParams.add(new Pair("id", id.toString()));

        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","unPublishLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-10-19"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unPublishLabelValidateBeforeCall(Integer id, String xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling unPublishLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling unPublishLabel(Async)");
        }

        com.squareup.okhttp.Call call = unPublishLabelCall(id, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 下架标签
     * 下架标签 （开启标签上下架功能开关且拥有操作该标签的读权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseBoolean
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseBoolean unPublishLabel(Integer id, String xTenant) throws ApiException {
        ApiResponse<CommonResponseBoolean> resp = unPublishLabelWithHttpInfo(id, xTenant);
        return resp.getData();
    }


    /**
     * 下架标签
     * 下架标签 （开启标签上下架功能开关且拥有操作该标签的读权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseBoolean&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseBoolean> unPublishLabelWithHttpInfo(Integer id, String xTenant) throws ApiException {
        com.squareup.okhttp.Call call = unPublishLabelValidateBeforeCall(id, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 下架标签 (asynchronously)
     * 下架标签 （开启标签上下架功能开关且拥有操作该标签的读权限）
     * @param id 标签ID (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unPublishLabelAsync(Integer id, String xTenant, final ApiCallback<CommonResponseBoolean> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = unPublishLabelValidateBeforeCall(id, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseBoolean>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for updateImportLabel
     * @param body 编辑导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateImportLabelCall(UpdateImportLabelEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateImportLabel"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateImportLabelValidateBeforeCall(UpdateImportLabelEvent body, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateImportLabel(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateImportLabel(Async)");
        }

        com.squareup.okhttp.Call call = updateImportLabelCall(body, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 编辑导入标签
     * 编辑导入标签
     * @param body 编辑导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger updateImportLabel(UpdateImportLabelEvent body, Long xTenant) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = updateImportLabelWithHttpInfo(body, xTenant);
        return resp.getData();
    }


    /**
     * 编辑导入标签
     * 编辑导入标签
     * @param body 编辑导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> updateImportLabelWithHttpInfo(UpdateImportLabelEvent body, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = updateImportLabelValidateBeforeCall(body, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 编辑导入标签 (asynchronously)
     * 编辑导入标签
     * @param body 编辑导入标签请求 (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateImportLabelAsync(UpdateImportLabelEvent body, Long xTenant, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = updateImportLabelValidateBeforeCall(body, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for updateLabelDomain
     * @param xTenant 项目ID (required)
     * @param body 文件夹操作请求 (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateLabelDomainCall(Long xTenant, UpdateLabelDomainEvent body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateLabelDomain"));
        localVarQueryParams.add(new Pair("ApiVersion","2024-01-25"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateLabelDomainValidateBeforeCall(Long xTenant, UpdateLabelDomainEvent body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateLabelDomain(Async)");
        }

        com.squareup.okhttp.Call call = updateLabelDomainCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 修改标签文件夹
     * 修改标签文件夹
     * @param xTenant 项目ID (required)
     * @param body 文件夹操作请求 (optional)
     * @return CommonResponseInteger
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonResponseInteger updateLabelDomain(Long xTenant, UpdateLabelDomainEvent body) throws ApiException {
        ApiResponse<CommonResponseInteger> resp = updateLabelDomainWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 修改标签文件夹
     * 修改标签文件夹
     * @param xTenant 项目ID (required)
     * @param body 文件夹操作请求 (optional)
     * @return ApiResponse&lt;CommonResponseInteger&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonResponseInteger> updateLabelDomainWithHttpInfo(Long xTenant, UpdateLabelDomainEvent body) throws ApiException {
        com.squareup.okhttp.Call call = updateLabelDomainValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 修改标签文件夹 (asynchronously)
     * 修改标签文件夹
     * @param xTenant 项目ID (required)
     * @param body 文件夹操作请求 (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateLabelDomainAsync(Long xTenant, UpdateLabelDomainEvent body, final ApiCallback<CommonResponseInteger> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = updateLabelDomainValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonResponseInteger>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for updateRealtimeTagData
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateRealtimeTagDataCall(Long xTenant, RealtimeTagReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","updateRealtimeTagData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-07-03"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateRealtimeTagDataValidateBeforeCall(Long xTenant, RealtimeTagReq body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling updateRealtimeTagData(Async)");
        }

        com.squareup.okhttp.Call call = updateRealtimeTagDataCall(xTenant, body, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return CommonString
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonString updateRealtimeTagData(Long xTenant, RealtimeTagReq body) throws ApiException {
        ApiResponse<CommonString> resp = updateRealtimeTagDataWithHttpInfo(xTenant, body);
        return resp.getData();
    }


    /**
     * 添加或者修改某个用户身上的人工标签
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @return ApiResponse&lt;CommonString&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonString> updateRealtimeTagDataWithHttpInfo(Long xTenant, RealtimeTagReq body) throws ApiException {
        com.squareup.okhttp.Call call = updateRealtimeTagDataValidateBeforeCall(xTenant, body, null, null);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();

        String[] localVarAccepts = {
            "application/json"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 添加或者修改某个用户身上的人工标签 (asynchronously)
     * 添加或者修改某个用户身上的人工标签，该接口可替换接口【添加或者修改某个用户身上的人工标签】和【添加或者修改某个用户身上的实时标签】
     * @param xTenant 项目ID (required)
     * @param body  (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateRealtimeTagDataAsync(Long xTenant, RealtimeTagReq body, final ApiCallback<CommonString> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json"
        };

        com.squareup.okhttp.Call call = updateRealtimeTagDataValidateBeforeCall(xTenant, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonString>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
    /**
     * Build call for uploadLabelData
     * @param file  (required)
     * @param xTenant 项目ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call uploadLabelDataCall(File file, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();


        localVarQueryParams.add(new Pair("Action","QueryOpenPlatformOpenApi"));
        localVarQueryParams.add(new Pair("Version","2021-12-16"));
        localVarQueryParams.add(new Pair("ApiAction","uploadLabelData"));
        localVarQueryParams.add(new Pair("ApiVersion","2023-06-20"));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xTenant != null)
        localVarHeaderParams.put("X-Tenant", apiClient.parameterToString(xTenant));

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null)
        localVarFormParams.put("file", file);

        final String[] localVarAccepts = {
            "application/json", "text/plain"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call uploadLabelDataValidateBeforeCall(File file, Long xTenant, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        // verify the required parameter 'file' is set
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadLabelData(Async)");
        }
        // verify the required parameter 'xTenant' is set
        if (xTenant == null) {
            throw new ApiException("Missing the required parameter 'xTenant' when calling uploadLabelData(Async)");
        }

        com.squareup.okhttp.Call call = uploadLabelDataCall(file, xTenant, progressListener, progressRequestListener);
        return call;





    }

    /**
     * 上传标签数据
     * 上传标签数据文件
     * @param file  (required)
     * @param xTenant 项目ID (required)
     * @return CommonDataModelId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CommonDataModelId uploadLabelData(File file, Long xTenant) throws ApiException {
        ApiResponse<CommonDataModelId> resp = uploadLabelDataWithHttpInfo(file, xTenant);
        return resp.getData();
    }


    /**
     * 上传标签数据
     * 上传标签数据文件
     * @param file  (required)
     * @param xTenant 项目ID (required)
     * @return ApiResponse&lt;CommonDataModelId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CommonDataModelId> uploadLabelDataWithHttpInfo(File file, Long xTenant) throws ApiException {
        com.squareup.okhttp.Call call = uploadLabelDataValidateBeforeCall(file, xTenant, null, null);
        Type localVarReturnType = new TypeToken<CommonDataModelId>(){}.getType();

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        return apiClient.execute(call, localVarReturnType, localVarAccepts);
    }

    /**
     * 上传标签数据 (asynchronously)
     * 上传标签数据文件
     * @param file  (required)
     * @param xTenant 项目ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call uploadLabelDataAsync(File file, Long xTenant, final ApiCallback<CommonDataModelId> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        String[] localVarAccepts = {
            "application/json", "text/plain"
        };

        com.squareup.okhttp.Call call = uploadLabelDataValidateBeforeCall(file, xTenant, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CommonDataModelId>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, localVarAccepts, callback);
        return call;
    }
}
