/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.AppItem;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * AppInfoVO
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class AppInfoVO {
  /**
   * 应用类型
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    UNKNOWN("Unknown"),
    _0("0"),
    _1("1"),
    _2("2"),
    _3("3");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static TypeEnum fromValue(String input) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return TypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("appField")
  private String appField = null;

  @SerializedName("appIds")
  private List<Long> appIds = null;

  @SerializedName("apps")
  private List<AppItem> apps = null;

  public AppInfoVO type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * 应用类型
   * @return type
  **/
  @Schema(description = "应用类型")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AppInfoVO appField(String appField) {
    this.appField = appField;
    return this;
  }

   /**
   * 应用信息字段
   * @return appField
  **/
  @Schema(description = "应用信息字段")
  public String getAppField() {
    return appField;
  }

  public void setAppField(String appField) {
    this.appField = appField;
  }

  public AppInfoVO appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public AppInfoVO addAppIdsItem(Long appIdsItem) {
    if (this.appIds == null) {
      this.appIds = new ArrayList<Long>();
    }
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * 关联应用id列表
   * @return appIds
  **/
  @Schema(description = "关联应用id列表")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }

  public AppInfoVO apps(List<AppItem> apps) {
    this.apps = apps;
    return this;
  }

  public AppInfoVO addAppsItem(AppItem appsItem) {
    if (this.apps == null) {
      this.apps = new ArrayList<AppItem>();
    }
    this.apps.add(appsItem);
    return this;
  }

   /**
   * 关联应用信息
   * @return apps
  **/
  @Schema(description = "关联应用信息")
  public List<AppItem> getApps() {
    return apps;
  }

  public void setApps(List<AppItem> apps) {
    this.apps = apps;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppInfoVO appInfoVO = (AppInfoVO) o;
    return Objects.equals(this.type, appInfoVO.type) &&
        Objects.equals(this.appField, appInfoVO.appField) &&
        Objects.equals(this.appIds, appInfoVO.appIds) &&
        Objects.equals(this.apps, appInfoVO.apps);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, appField, appIds, apps);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppInfoVO {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    appField: ").append(toIndentedString(appField)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("    apps: ").append(toIndentedString(apps)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
