/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * 库表连接信息
 */
@Schema(description = "库表连接信息")
@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class ConnectInfo {
  /**
   * 底表驱动类型
   */
  @JsonAdapter(DriverNameEnum.Adapter.class)
  public enum DriverNameEnum {
    UNKNOWN("Unknown"),
    HIVE("hive"),
    CLICK_HOUSE("click_house");

    private String value;

    DriverNameEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static DriverNameEnum fromValue(String input) {
      for (DriverNameEnum b : DriverNameEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<DriverNameEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DriverNameEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public DriverNameEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return DriverNameEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("driverName")
  private DriverNameEnum driverName = null;

  @SerializedName("region")
  private String region = null;

  @SerializedName("cluster")
  private String cluster = null;

  @SerializedName("db")
  private String db = null;

  @SerializedName("table")
  private String table = null;

  @SerializedName("doradoTaskIds")
  private List<Long> doradoTaskIds = null;

  public ConnectInfo driverName(DriverNameEnum driverName) {
    this.driverName = driverName;
    return this;
  }

   /**
   * 底表驱动类型
   * @return driverName
  **/
  @Schema(description = "底表驱动类型")
  public DriverNameEnum getDriverName() {
    return driverName;
  }

  public void setDriverName(DriverNameEnum driverName) {
    this.driverName = driverName;
  }

  public ConnectInfo region(String region) {
    this.region = region;
    return this;
  }

   /**
   * 区域
   * @return region
  **/
  @Schema(description = "区域")
  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public ConnectInfo cluster(String cluster) {
    this.cluster = cluster;
    return this;
  }

   /**
   * 集群
   * @return cluster
  **/
  @Schema(description = "集群")
  public String getCluster() {
    return cluster;
  }

  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  public ConnectInfo db(String db) {
    this.db = db;
    return this;
  }

   /**
   * 库名
   * @return db
  **/
  @Schema(description = "库名")
  public String getDb() {
    return db;
  }

  public void setDb(String db) {
    this.db = db;
  }

  public ConnectInfo table(String table) {
    this.table = table;
    return this;
  }

   /**
   * 表名
   * @return table
  **/
  @Schema(description = "表名")
  public String getTable() {
    return table;
  }

  public void setTable(String table) {
    this.table = table;
  }

  public ConnectInfo doradoTaskIds(List<Long> doradoTaskIds) {
    this.doradoTaskIds = doradoTaskIds;
    return this;
  }

  public ConnectInfo addDoradoTaskIdsItem(Long doradoTaskIdsItem) {
    if (this.doradoTaskIds == null) {
      this.doradoTaskIds = new ArrayList<Long>();
    }
    this.doradoTaskIds.add(doradoTaskIdsItem);
    return this;
  }

   /**
   * 依赖dorado任务id数组名，最多20个
   * @return doradoTaskIds
  **/
  @Schema(description = "依赖dorado任务id数组名，最多20个")
  public List<Long> getDoradoTaskIds() {
    return doradoTaskIds;
  }

  public void setDoradoTaskIds(List<Long> doradoTaskIds) {
    this.doradoTaskIds = doradoTaskIds;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConnectInfo connectInfo = (ConnectInfo) o;
    return Objects.equals(this.driverName, connectInfo.driverName) &&
        Objects.equals(this.region, connectInfo.region) &&
        Objects.equals(this.cluster, connectInfo.cluster) &&
        Objects.equals(this.db, connectInfo.db) &&
        Objects.equals(this.table, connectInfo.table) &&
        Objects.equals(this.doradoTaskIds, connectInfo.doradoTaskIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(driverName, region, cluster, db, table, doradoTaskIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConnectInfo {\n");
    
    sb.append("    driverName: ").append(toIndentedString(driverName)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    cluster: ").append(toIndentedString(cluster)).append("\n");
    sb.append("    db: ").append(toIndentedString(db)).append("\n");
    sb.append("    table: ").append(toIndentedString(table)).append("\n");
    sb.append("    doradoTaskIds: ").append(toIndentedString(doradoTaskIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
