/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.AppInfoVO;
import code.byted.inter.model.EventParams;
import code.byted.inter.model.SourcePermission;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * CreateDataSourceRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class CreateDataSourceRequest {
  @SerializedName("projectId")
  private Long projectId = null;

  @SerializedName("subjectId")
  private Long subjectId = null;

  @SerializedName("sourceName")
  private String sourceName = null;

  @SerializedName("sourceDesc")
  private String sourceDesc = null;

  /**
   * 数据源类型 1-用户,2-明细,3-行为,8-维度
   */
  @JsonAdapter(SourceTypeEnum.Adapter.class)
  public enum SourceTypeEnum {
    UNKNOWN("Unknown"),
    _1("1"),
    _2("2"),
    _3("3"),
    _8("8");

    private String value;

    SourceTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SourceTypeEnum fromValue(String input) {
      for (SourceTypeEnum b : SourceTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SourceTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SourceTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SourceTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SourceTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("sourceType")
  private SourceTypeEnum sourceType = null;

  @SerializedName("owner")
  private String owner = null;

  @SerializedName("entityIdField")
  private String entityIdField = null;

  @SerializedName("dataUpdateType")
  private String dataUpdateType = null;

  @SerializedName("timeField")
  private String timeField = null;

  @SerializedName("eventField")
  private String eventField = null;

  @SerializedName("eventParams")
  private EventParams eventParams = null;

  @SerializedName("dataSetId")
  private Integer dataSetId = null;

  @SerializedName("pdateField")
  private String pdateField = null;

  @SerializedName("pdateFormat")
  private String pdateFormat = null;

  @SerializedName("sourcePermission")
  private SourcePermission sourcePermission = null;

  @SerializedName("sourceScope")
  private AppInfoVO sourceScope = null;

  public CreateDataSourceRequest projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目id
   * @return projectId
  **/
  @Schema(description = "项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public CreateDataSourceRequest subjectId(Long subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体id
   * @return subjectId
  **/
  @Schema(description = "主体id")
  public Long getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Long subjectId) {
    this.subjectId = subjectId;
  }

  public CreateDataSourceRequest sourceName(String sourceName) {
    this.sourceName = sourceName;
    return this;
  }

   /**
   * 数据源名
   * @return sourceName
  **/
  @Schema(description = "数据源名")
  public String getSourceName() {
    return sourceName;
  }

  public void setSourceName(String sourceName) {
    this.sourceName = sourceName;
  }

  public CreateDataSourceRequest sourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
    return this;
  }

   /**
   * 数据源描述
   * @return sourceDesc
  **/
  @Schema(description = "数据源描述")
  public String getSourceDesc() {
    return sourceDesc;
  }

  public void setSourceDesc(String sourceDesc) {
    this.sourceDesc = sourceDesc;
  }

  public CreateDataSourceRequest sourceType(SourceTypeEnum sourceType) {
    this.sourceType = sourceType;
    return this;
  }

   /**
   * 数据源类型 1-用户,2-明细,3-行为,8-维度
   * @return sourceType
  **/
  @Schema(description = "数据源类型 1-用户,2-明细,3-行为,8-维度")
  public SourceTypeEnum getSourceType() {
    return sourceType;
  }

  public void setSourceType(SourceTypeEnum sourceType) {
    this.sourceType = sourceType;
  }

  public CreateDataSourceRequest owner(String owner) {
    this.owner = owner;
    return this;
  }

   /**
   * 创建人
   * @return owner
  **/
  @Schema(description = "创建人")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public CreateDataSourceRequest entityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
    return this;
  }

   /**
   * 基准ID字段
   * @return entityIdField
  **/
  @Schema(description = "基准ID字段")
  public String getEntityIdField() {
    return entityIdField;
  }

  public void setEntityIdField(String entityIdField) {
    this.entityIdField = entityIdField;
  }

  public CreateDataSourceRequest dataUpdateType(String dataUpdateType) {
    this.dataUpdateType = dataUpdateType;
    return this;
  }

   /**
   * 数据更新方式: incr-增量,full全量
   * @return dataUpdateType
  **/
  @Schema(description = "数据更新方式: incr-增量,full全量")
  public String getDataUpdateType() {
    return dataUpdateType;
  }

  public void setDataUpdateType(String dataUpdateType) {
    this.dataUpdateType = dataUpdateType;
  }

  public CreateDataSourceRequest timeField(String timeField) {
    this.timeField = timeField;
    return this;
  }

   /**
   * 行为时间字段
   * @return timeField
  **/
  @Schema(description = "行为时间字段")
  public String getTimeField() {
    return timeField;
  }

  public void setTimeField(String timeField) {
    this.timeField = timeField;
  }

  public CreateDataSourceRequest eventField(String eventField) {
    this.eventField = eventField;
    return this;
  }

   /**
   * 行为字段
   * @return eventField
  **/
  @Schema(description = "行为字段")
  public String getEventField() {
    return eventField;
  }

  public void setEventField(String eventField) {
    this.eventField = eventField;
  }

  public CreateDataSourceRequest eventParams(EventParams eventParams) {
    this.eventParams = eventParams;
    return this;
  }

   /**
   * Get eventParams
   * @return eventParams
  **/
  @Schema(description = "")
  public EventParams getEventParams() {
    return eventParams;
  }

  public void setEventParams(EventParams eventParams) {
    this.eventParams = eventParams;
  }

  public CreateDataSourceRequest dataSetId(Integer dataSetId) {
    this.dataSetId = dataSetId;
    return this;
  }

   /**
   * 数据集id
   * @return dataSetId
  **/
  @Schema(description = "数据集id")
  public Integer getDataSetId() {
    return dataSetId;
  }

  public void setDataSetId(Integer dataSetId) {
    this.dataSetId = dataSetId;
  }

  public CreateDataSourceRequest pdateField(String pdateField) {
    this.pdateField = pdateField;
    return this;
  }

   /**
   * 分区字段
   * @return pdateField
  **/
  @Schema(description = "分区字段")
  public String getPdateField() {
    return pdateField;
  }

  public void setPdateField(String pdateField) {
    this.pdateField = pdateField;
  }

  public CreateDataSourceRequest pdateFormat(String pdateFormat) {
    this.pdateFormat = pdateFormat;
    return this;
  }

   /**
   * 分区字段格式化参数
   * @return pdateFormat
  **/
  @Schema(description = "分区字段格式化参数")
  public String getPdateFormat() {
    return pdateFormat;
  }

  public void setPdateFormat(String pdateFormat) {
    this.pdateFormat = pdateFormat;
  }

  public CreateDataSourceRequest sourcePermission(SourcePermission sourcePermission) {
    this.sourcePermission = sourcePermission;
    return this;
  }

   /**
   * Get sourcePermission
   * @return sourcePermission
  **/
  @Schema(description = "")
  public SourcePermission getSourcePermission() {
    return sourcePermission;
  }

  public void setSourcePermission(SourcePermission sourcePermission) {
    this.sourcePermission = sourcePermission;
  }

  public CreateDataSourceRequest sourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
    return this;
  }

   /**
   * Get sourceScope
   * @return sourceScope
  **/
  @Schema(description = "")
  public AppInfoVO getSourceScope() {
    return sourceScope;
  }

  public void setSourceScope(AppInfoVO sourceScope) {
    this.sourceScope = sourceScope;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateDataSourceRequest createDataSourceRequest = (CreateDataSourceRequest) o;
    return Objects.equals(this.projectId, createDataSourceRequest.projectId) &&
        Objects.equals(this.subjectId, createDataSourceRequest.subjectId) &&
        Objects.equals(this.sourceName, createDataSourceRequest.sourceName) &&
        Objects.equals(this.sourceDesc, createDataSourceRequest.sourceDesc) &&
        Objects.equals(this.sourceType, createDataSourceRequest.sourceType) &&
        Objects.equals(this.owner, createDataSourceRequest.owner) &&
        Objects.equals(this.entityIdField, createDataSourceRequest.entityIdField) &&
        Objects.equals(this.dataUpdateType, createDataSourceRequest.dataUpdateType) &&
        Objects.equals(this.timeField, createDataSourceRequest.timeField) &&
        Objects.equals(this.eventField, createDataSourceRequest.eventField) &&
        Objects.equals(this.eventParams, createDataSourceRequest.eventParams) &&
        Objects.equals(this.dataSetId, createDataSourceRequest.dataSetId) &&
        Objects.equals(this.pdateField, createDataSourceRequest.pdateField) &&
        Objects.equals(this.pdateFormat, createDataSourceRequest.pdateFormat) &&
        Objects.equals(this.sourcePermission, createDataSourceRequest.sourcePermission) &&
        Objects.equals(this.sourceScope, createDataSourceRequest.sourceScope);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, subjectId, sourceName, sourceDesc, sourceType, owner, entityIdField, dataUpdateType, timeField, eventField, eventParams, dataSetId, pdateField, pdateFormat, sourcePermission, sourceScope);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateDataSourceRequest {\n");
    
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    sourceName: ").append(toIndentedString(sourceName)).append("\n");
    sb.append("    sourceDesc: ").append(toIndentedString(sourceDesc)).append("\n");
    sb.append("    sourceType: ").append(toIndentedString(sourceType)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    entityIdField: ").append(toIndentedString(entityIdField)).append("\n");
    sb.append("    dataUpdateType: ").append(toIndentedString(dataUpdateType)).append("\n");
    sb.append("    timeField: ").append(toIndentedString(timeField)).append("\n");
    sb.append("    eventField: ").append(toIndentedString(eventField)).append("\n");
    sb.append("    eventParams: ").append(toIndentedString(eventParams)).append("\n");
    sb.append("    dataSetId: ").append(toIndentedString(dataSetId)).append("\n");
    sb.append("    pdateField: ").append(toIndentedString(pdateField)).append("\n");
    sb.append("    pdateFormat: ").append(toIndentedString(pdateFormat)).append("\n");
    sb.append("    sourcePermission: ").append(toIndentedString(sourcePermission)).append("\n");
    sb.append("    sourceScope: ").append(toIndentedString(sourceScope)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
