/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;

/**
 * CustomTgi
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:37:04.708+08:00[Asia/Shanghai]")
public class CustomTgi {
  @SerializedName("id")
  private Integer id = null;

  @SerializedName("tenantId")
  private Integer tenantId = null;

  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("appId")
  private Integer appId = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("den")
  private String den = null;

  @SerializedName("denRule")
  private JsonNode denRule = null;

  /**
   * Gets or Sets numRule
   */
  @JsonAdapter(NumRuleEnum.Adapter.class)
  public enum NumRuleEnum {
    UNKNOWN("Unknown"),
    PROPORTION("proportion"),
    VALIDPROPORTION("validProportion");

    private String value;

    NumRuleEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static NumRuleEnum fromValue(String input) {
      for (NumRuleEnum b : NumRuleEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<NumRuleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final NumRuleEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public NumRuleEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return NumRuleEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("numRule")
  private NumRuleEnum numRule = null;

  @SerializedName("creator")
  private String creator = null;

  @SerializedName("isPreset")
  private Boolean isPreset = null;

  @SerializedName("deleted")
  private Boolean deleted = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("updateTime")
  private String updateTime = null;

  @SerializedName("authFilterAdded")
  private Boolean authFilterAdded = null;

  public CustomTgi id(Integer id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @Schema(description = "")
  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public CustomTgi tenantId(Integer tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * Get tenantId
   * @return tenantId
  **/
  @Schema(description = "")
  public Integer getTenantId() {
    return tenantId;
  }

  public void setTenantId(Integer tenantId) {
    this.tenantId = tenantId;
  }

  public CustomTgi subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * Get subjectId
   * @return subjectId
  **/
  @Schema(description = "")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public CustomTgi appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * Get appId
   * @return appId
  **/
  @Schema(description = "")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  public CustomTgi name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @Schema(description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CustomTgi desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * Get desc
   * @return desc
  **/
  @Schema(description = "")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public CustomTgi den(String den) {
    this.den = den;
    return this;
  }

   /**
   * Get den
   * @return den
  **/
  @Schema(description = "")
  public String getDen() {
    return den;
  }

  public void setDen(String den) {
    this.den = den;
  }

  public CustomTgi denRule(JsonNode denRule) {
    this.denRule = denRule;
    return this;
  }

   /**
   * Get denRule
   * @return denRule
  **/
  @Schema(description = "")
  public JsonNode getDenRule() {
    return denRule;
  }

  public void setDenRule(JsonNode denRule) {
    this.denRule = denRule;
  }

  public CustomTgi numRule(NumRuleEnum numRule) {
    this.numRule = numRule;
    return this;
  }

   /**
   * Get numRule
   * @return numRule
  **/
  @Schema(description = "")
  public NumRuleEnum getNumRule() {
    return numRule;
  }

  public void setNumRule(NumRuleEnum numRule) {
    this.numRule = numRule;
  }

  public CustomTgi creator(String creator) {
    this.creator = creator;
    return this;
  }

   /**
   * Get creator
   * @return creator
  **/
  @Schema(description = "")
  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public CustomTgi isPreset(Boolean isPreset) {
    this.isPreset = isPreset;
    return this;
  }

   /**
   * Get isPreset
   * @return isPreset
  **/
  @Schema(description = "")
  public Boolean isIsPreset() {
    return isPreset;
  }

  public void setIsPreset(Boolean isPreset) {
    this.isPreset = isPreset;
  }

  public CustomTgi deleted(Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @Schema(description = "")
  public Boolean isDeleted() {
    return deleted;
  }

  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  public CustomTgi createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * Get createTime
   * @return createTime
  **/
  @Schema(description = "")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public CustomTgi updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * Get updateTime
   * @return updateTime
  **/
  @Schema(description = "")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public CustomTgi authFilterAdded(Boolean authFilterAdded) {
    this.authFilterAdded = authFilterAdded;
    return this;
  }

   /**
   * Get authFilterAdded
   * @return authFilterAdded
  **/
  @Schema(description = "")
  public Boolean isAuthFilterAdded() {
    return authFilterAdded;
  }

  public void setAuthFilterAdded(Boolean authFilterAdded) {
    this.authFilterAdded = authFilterAdded;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomTgi customTgi = (CustomTgi) o;
    return Objects.equals(this.id, customTgi.id) &&
        Objects.equals(this.tenantId, customTgi.tenantId) &&
        Objects.equals(this.subjectId, customTgi.subjectId) &&
        Objects.equals(this.appId, customTgi.appId) &&
        Objects.equals(this.name, customTgi.name) &&
        Objects.equals(this.desc, customTgi.desc) &&
        Objects.equals(this.den, customTgi.den) &&
        Objects.equals(this.denRule, customTgi.denRule) &&
        Objects.equals(this.numRule, customTgi.numRule) &&
        Objects.equals(this.creator, customTgi.creator) &&
        Objects.equals(this.isPreset, customTgi.isPreset) &&
        Objects.equals(this.deleted, customTgi.deleted) &&
        Objects.equals(this.createTime, customTgi.createTime) &&
        Objects.equals(this.updateTime, customTgi.updateTime) &&
        Objects.equals(this.authFilterAdded, customTgi.authFilterAdded);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, tenantId, subjectId, appId, name, desc, den, denRule, numRule, creator, isPreset, deleted, createTime, updateTime, authFilterAdded);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomTgi {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    den: ").append(toIndentedString(den)).append("\n");
    sb.append("    denRule: ").append(toIndentedString(denRule)).append("\n");
    sb.append("    numRule: ").append(toIndentedString(numRule)).append("\n");
    sb.append("    creator: ").append(toIndentedString(creator)).append("\n");
    sb.append("    isPreset: ").append(toIndentedString(isPreset)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    authFilterAdded: ").append(toIndentedString(authFilterAdded)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
