/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
/**
 * GraphRealtimeQueryReq
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-10T15:38:33.157+08:00[Asia/Shanghai]")
public class GraphRealtimeQueryReq {
  @SerializedName("subjectId")
  private Integer subjectId = null;

  @SerializedName("tenantId")
  private Integer tenantId = null;

  @SerializedName("appId")
  private Integer appId = null;

  @SerializedName("segRule")
  private RealtimeSegRule segRule = null;

  @SerializedName("tgiSegRule")
  private RealtimeSegRule tgiSegRule = null;

  @SerializedName("tagRuleList")
  private List<RealtimeTagRule> tagRuleList = null;

  @SerializedName("horizontalTagRule")
  private RealtimeTagRule horizontalTagRule = null;

  @SerializedName("verticalTagRule")
  private RealtimeTagRule verticalTagRule = null;

  @SerializedName("horizontalTagRuleList")
  private List<RealtimeTagRule> horizontalTagRuleList = null;

  @SerializedName("verticalTagRuleList")
  private List<RealtimeTagRule> verticalTagRuleList = null;

  public GraphRealtimeQueryReq subjectId(Integer subjectId) {
    this.subjectId = subjectId;
    return this;
  }

   /**
   * 主体ID
   * @return subjectId
  **/
  @Schema(required = true, description = "主体ID")
  public Integer getSubjectId() {
    return subjectId;
  }

  public void setSubjectId(Integer subjectId) {
    this.subjectId = subjectId;
  }

  public GraphRealtimeQueryReq tenantId(Integer tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 项目ID
   * @return tenantId
  **/
  @Schema(required = true, description = "项目ID")
  public Integer getTenantId() {
    return tenantId;
  }

  public void setTenantId(Integer tenantId) {
    this.tenantId = tenantId;
  }

  public GraphRealtimeQueryReq appId(Integer appId) {
    this.appId = appId;
    return this;
  }

   /**
   * 产品线ID
   * @return appId
  **/
  @Schema(required = true, description = "产品线ID")
  public Integer getAppId() {
    return appId;
  }

  public void setAppId(Integer appId) {
    this.appId = appId;
  }

  public GraphRealtimeQueryReq segRule(RealtimeSegRule segRule) {
    this.segRule = segRule;
    return this;
  }

   /**
   * Get segRule
   * @return segRule
  **/
  @Schema(required = true, description = "")
  public RealtimeSegRule getSegRule() {
    return segRule;
  }

  public void setSegRule(RealtimeSegRule segRule) {
    this.segRule = segRule;
  }

  public GraphRealtimeQueryReq tgiSegRule(RealtimeSegRule tgiSegRule) {
    this.tgiSegRule = tgiSegRule;
    return this;
  }

   /**
   * Get tgiSegRule
   * @return tgiSegRule
  **/
  @Schema(description = "")
  public RealtimeSegRule getTgiSegRule() {
    return tgiSegRule;
  }

  public void setTgiSegRule(RealtimeSegRule tgiSegRule) {
    this.tgiSegRule = tgiSegRule;
  }

  public GraphRealtimeQueryReq tagRuleList(List<RealtimeTagRule> tagRuleList) {
    this.tagRuleList = tagRuleList;
    return this;
  }

  public GraphRealtimeQueryReq addTagRuleListItem(RealtimeTagRule tagRuleListItem) {
    if (this.tagRuleList == null) {
      this.tagRuleList = new ArrayList<RealtimeTagRule>();
    }
    this.tagRuleList.add(tagRuleListItem);
    return this;
  }

   /**
   * 单维度分析标签规则列表,不可大于9个,与交叉分析标签规则不可同时为空,两者都有值时,默认为单维分析
   * @return tagRuleList
  **/
  @Schema(description = "单维度分析标签规则列表,不可大于9个,与交叉分析标签规则不可同时为空,两者都有值时,默认为单维分析")
  public List<RealtimeTagRule> getTagRuleList() {
    return tagRuleList;
  }

  public void setTagRuleList(List<RealtimeTagRule> tagRuleList) {
    this.tagRuleList = tagRuleList;
  }

  public GraphRealtimeQueryReq horizontalTagRule(RealtimeTagRule horizontalTagRule) {
    this.horizontalTagRule = horizontalTagRule;
    return this;
  }

   /**
   * Get horizontalTagRule
   * @return horizontalTagRule
  **/
  @Schema(description = "")
  public RealtimeTagRule getHorizontalTagRule() {
    return horizontalTagRule;
  }

  public void setHorizontalTagRule(RealtimeTagRule horizontalTagRule) {
    this.horizontalTagRule = horizontalTagRule;
  }

  public GraphRealtimeQueryReq verticalTagRule(RealtimeTagRule verticalTagRule) {
    this.verticalTagRule = verticalTagRule;
    return this;
  }

   /**
   * Get verticalTagRule
   * @return verticalTagRule
  **/
  @Schema(description = "")
  public RealtimeTagRule getVerticalTagRule() {
    return verticalTagRule;
  }

  public void setVerticalTagRule(RealtimeTagRule verticalTagRule) {
    this.verticalTagRule = verticalTagRule;
  }

  public GraphRealtimeQueryReq horizontalTagRuleList(List<RealtimeTagRule> horizontalTagRuleList) {
    this.horizontalTagRuleList = horizontalTagRuleList;
    return this;
  }

  public GraphRealtimeQueryReq addHorizontalTagRuleListItem(RealtimeTagRule horizontalTagRuleListItem) {
    if (this.horizontalTagRuleList == null) {
      this.horizontalTagRuleList = new ArrayList<RealtimeTagRule>();
    }
    this.horizontalTagRuleList.add(horizontalTagRuleListItem);
    return this;
  }

   /**
   * 多维交叉分析-横坐标标签规则列表
   * @return horizontalTagRuleList
  **/
  @Schema(description = "多维交叉分析-横坐标标签规则列表")
  public List<RealtimeTagRule> getHorizontalTagRuleList() {
    return horizontalTagRuleList;
  }

  public void setHorizontalTagRuleList(List<RealtimeTagRule> horizontalTagRuleList) {
    this.horizontalTagRuleList = horizontalTagRuleList;
  }

  public GraphRealtimeQueryReq verticalTagRuleList(List<RealtimeTagRule> verticalTagRuleList) {
    this.verticalTagRuleList = verticalTagRuleList;
    return this;
  }

  public GraphRealtimeQueryReq addVerticalTagRuleListItem(RealtimeTagRule verticalTagRuleListItem) {
    if (this.verticalTagRuleList == null) {
      this.verticalTagRuleList = new ArrayList<RealtimeTagRule>();
    }
    this.verticalTagRuleList.add(verticalTagRuleListItem);
    return this;
  }

   /**
   * 多维交叉分析-纵坐标标签规则列表
   * @return verticalTagRuleList
  **/
  @Schema(description = "多维交叉分析-纵坐标标签规则列表")
  public List<RealtimeTagRule> getVerticalTagRuleList() {
    return verticalTagRuleList;
  }

  public void setVerticalTagRuleList(List<RealtimeTagRule> verticalTagRuleList) {
    this.verticalTagRuleList = verticalTagRuleList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphRealtimeQueryReq graphRealtimeQueryReq = (GraphRealtimeQueryReq) o;
    return Objects.equals(this.subjectId, graphRealtimeQueryReq.subjectId) &&
        Objects.equals(this.tenantId, graphRealtimeQueryReq.tenantId) &&
        Objects.equals(this.appId, graphRealtimeQueryReq.appId) &&
        Objects.equals(this.segRule, graphRealtimeQueryReq.segRule) &&
        Objects.equals(this.tgiSegRule, graphRealtimeQueryReq.tgiSegRule) &&
        Objects.equals(this.tagRuleList, graphRealtimeQueryReq.tagRuleList) &&
        Objects.equals(this.horizontalTagRule, graphRealtimeQueryReq.horizontalTagRule) &&
        Objects.equals(this.verticalTagRule, graphRealtimeQueryReq.verticalTagRule) &&
        Objects.equals(this.horizontalTagRuleList, graphRealtimeQueryReq.horizontalTagRuleList) &&
        Objects.equals(this.verticalTagRuleList, graphRealtimeQueryReq.verticalTagRuleList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjectId, tenantId, appId, segRule, tgiSegRule, tagRuleList, horizontalTagRule, verticalTagRule, horizontalTagRuleList, verticalTagRuleList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphRealtimeQueryReq {\n");
    
    sb.append("    subjectId: ").append(toIndentedString(subjectId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    segRule: ").append(toIndentedString(segRule)).append("\n");
    sb.append("    tgiSegRule: ").append(toIndentedString(tgiSegRule)).append("\n");
    sb.append("    tagRuleList: ").append(toIndentedString(tagRuleList)).append("\n");
    sb.append("    horizontalTagRule: ").append(toIndentedString(horizontalTagRule)).append("\n");
    sb.append("    verticalTagRule: ").append(toIndentedString(verticalTagRule)).append("\n");
    sb.append("    horizontalTagRuleList: ").append(toIndentedString(horizontalTagRuleList)).append("\n");
    sb.append("    verticalTagRuleList: ").append(toIndentedString(verticalTagRuleList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
