/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.CrossAnalysisResult;
import code.byted.inter.model.CustomAnalysisResult;
import code.byted.inter.model.MultipleCrossAnalysisResult;
import code.byted.inter.model.TagSimpleInfo;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * GraphRealtimeQueryResult
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-10T15:38:33.157+08:00[Asia/Shanghai]")
public class GraphRealtimeQueryResult {
  @SerializedName("customAnalysisResultList")
  private List<CustomAnalysisResult> customAnalysisResultList = null;

  @SerializedName("crossAnalysisResult")
  private CrossAnalysisResult crossAnalysisResult = null;

  @SerializedName("multipleCrossAnalysisResult")
  private MultipleCrossAnalysisResult multipleCrossAnalysisResult = null;

  @SerializedName("tagInfos")
  private List<TagSimpleInfo> tagInfos = null;

  public GraphRealtimeQueryResult customAnalysisResultList(List<CustomAnalysisResult> customAnalysisResultList) {
    this.customAnalysisResultList = customAnalysisResultList;
    return this;
  }

  public GraphRealtimeQueryResult addCustomAnalysisResultListItem(CustomAnalysisResult customAnalysisResultListItem) {
    if (this.customAnalysisResultList == null) {
      this.customAnalysisResultList = new ArrayList<CustomAnalysisResult>();
    }
    this.customAnalysisResultList.add(customAnalysisResultListItem);
    return this;
  }

   /**
   * 单维度分析结果列表
   * @return customAnalysisResultList
  **/
  @Schema(description = "单维度分析结果列表")
  public List<CustomAnalysisResult> getCustomAnalysisResultList() {
    return customAnalysisResultList;
  }

  public void setCustomAnalysisResultList(List<CustomAnalysisResult> customAnalysisResultList) {
    this.customAnalysisResultList = customAnalysisResultList;
  }

  public GraphRealtimeQueryResult crossAnalysisResult(CrossAnalysisResult crossAnalysisResult) {
    this.crossAnalysisResult = crossAnalysisResult;
    return this;
  }

   /**
   * Get crossAnalysisResult
   * @return crossAnalysisResult
  **/
  @Schema(description = "")
  public CrossAnalysisResult getCrossAnalysisResult() {
    return crossAnalysisResult;
  }

  public void setCrossAnalysisResult(CrossAnalysisResult crossAnalysisResult) {
    this.crossAnalysisResult = crossAnalysisResult;
  }

  public GraphRealtimeQueryResult multipleCrossAnalysisResult(MultipleCrossAnalysisResult multipleCrossAnalysisResult) {
    this.multipleCrossAnalysisResult = multipleCrossAnalysisResult;
    return this;
  }

   /**
   * Get multipleCrossAnalysisResult
   * @return multipleCrossAnalysisResult
  **/
  @Schema(description = "")
  public MultipleCrossAnalysisResult getMultipleCrossAnalysisResult() {
    return multipleCrossAnalysisResult;
  }

  public void setMultipleCrossAnalysisResult(MultipleCrossAnalysisResult multipleCrossAnalysisResult) {
    this.multipleCrossAnalysisResult = multipleCrossAnalysisResult;
  }

  public GraphRealtimeQueryResult tagInfos(List<TagSimpleInfo> tagInfos) {
    this.tagInfos = tagInfos;
    return this;
  }

  public GraphRealtimeQueryResult addTagInfosItem(TagSimpleInfo tagInfosItem) {
    if (this.tagInfos == null) {
      this.tagInfos = new ArrayList<TagSimpleInfo>();
    }
    this.tagInfos.add(tagInfosItem);
    return this;
  }

   /**
   * 标签元信息
   * @return tagInfos
  **/
  @Schema(description = "标签元信息")
  public List<TagSimpleInfo> getTagInfos() {
    return tagInfos;
  }

  public void setTagInfos(List<TagSimpleInfo> tagInfos) {
    this.tagInfos = tagInfos;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphRealtimeQueryResult graphRealtimeQueryResult = (GraphRealtimeQueryResult) o;
    return Objects.equals(this.customAnalysisResultList, graphRealtimeQueryResult.customAnalysisResultList) &&
        Objects.equals(this.crossAnalysisResult, graphRealtimeQueryResult.crossAnalysisResult) &&
        Objects.equals(this.multipleCrossAnalysisResult, graphRealtimeQueryResult.multipleCrossAnalysisResult) &&
        Objects.equals(this.tagInfos, graphRealtimeQueryResult.tagInfos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customAnalysisResultList, crossAnalysisResult, multipleCrossAnalysisResult, tagInfos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphRealtimeQueryResult {\n");
    
    sb.append("    customAnalysisResultList: ").append(toIndentedString(customAnalysisResultList)).append("\n");
    sb.append("    crossAnalysisResult: ").append(toIndentedString(crossAnalysisResult)).append("\n");
    sb.append("    multipleCrossAnalysisResult: ").append(toIndentedString(multipleCrossAnalysisResult)).append("\n");
    sb.append("    tagInfos: ").append(toIndentedString(tagInfos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
