/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.InsightTagSortBy;
import code.byted.inter.model.JsonNode;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * 洞察元数据
 */
@Schema(description = "洞察元数据")
@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:02:15.483+08:00[Asia/Shanghai]")

public class InsightMeta {
  @SerializedName("sortBy")
  private InsightTagSortBy sortBy = null;

  /**
   * 排序方式(DEPRECATED)
   */
  @JsonAdapter(SortTypeEnum.Adapter.class)
  public enum SortTypeEnum {
    UNKNOWN("Unknown"),
    TAG("Tag"),
    TGI("Tgi"),
    UV("Uv"),
    TAGVALUE("TagValue"),
    TAGASC("TagAsc"),
    TAGDESC("TagDesc"),
    TGIASC("TgiAsc"),
    TGIDESC("TgiDesc"),
    UVASC("UvAsc"),
    UVDESC("UvDesc"),
    TAGVALUEASC("TagValueAsc"),
    TAGVALUEDESC("TagValueDesc");

    private String value;

    SortTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SortTypeEnum fromValue(String input) {
      for (SortTypeEnum b : SortTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SortTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SortTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SortTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SortTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("sortType")
  private SortTypeEnum sortType = null;

  /**
   * 排序对象：Full&#x3D;全量，Effective&#x3D;有效，Custom&#x3D;自定义
   */
  @JsonAdapter(SortObjEnum.Adapter.class)
  public enum SortObjEnum {
    UNKNOWN("Unknown"),
    FULL("Full"),
    EFFECTIVE("Effective"),
    CUSTOM("Custom");

    private String value;

    SortObjEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static SortObjEnum fromValue(String input) {
      for (SortObjEnum b : SortObjEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<SortObjEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SortObjEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public SortObjEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return SortObjEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("sortObj")
  private SortObjEnum sortObj = null;

  @SerializedName("authFilter")
  private JsonNode authFilter = null;

  public InsightMeta sortBy(InsightTagSortBy sortBy) {
    this.sortBy = sortBy;
    return this;
  }

   /**
   * Get sortBy
   * @return sortBy
  **/
  @Schema(description = "")
  public InsightTagSortBy getSortBy() {
    return sortBy;
  }

  public void setSortBy(InsightTagSortBy sortBy) {
    this.sortBy = sortBy;
  }

  public InsightMeta sortType(SortTypeEnum sortType) {
    this.sortType = sortType;
    return this;
  }

   /**
   * 排序方式(DEPRECATED)
   * @return sortType
  **/
  @Schema(description = "排序方式(DEPRECATED)")
  public SortTypeEnum getSortType() {
    return sortType;
  }

  public void setSortType(SortTypeEnum sortType) {
    this.sortType = sortType;
  }

  public InsightMeta sortObj(SortObjEnum sortObj) {
    this.sortObj = sortObj;
    return this;
  }

   /**
   * 排序对象：Full&#x3D;全量，Effective&#x3D;有效，Custom&#x3D;自定义
   * @return sortObj
  **/
  @Schema(description = "排序对象：Full=全量，Effective=有效，Custom=自定义")
  public SortObjEnum getSortObj() {
    return sortObj;
  }

  public void setSortObj(SortObjEnum sortObj) {
    this.sortObj = sortObj;
  }

  public InsightMeta authFilter(JsonNode authFilter) {
    this.authFilter = authFilter;
    return this;
  }

   /**
   * Get authFilter
   * @return authFilter
  **/
  @Schema(description = "")
  public JsonNode getAuthFilter() {
    return authFilter;
  }

  public void setAuthFilter(JsonNode authFilter) {
    this.authFilter = authFilter;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InsightMeta insightMeta = (InsightMeta) o;
    return Objects.equals(this.sortBy, insightMeta.sortBy) &&
        Objects.equals(this.sortType, insightMeta.sortType) &&
        Objects.equals(this.sortObj, insightMeta.sortObj) &&
        Objects.equals(this.authFilter, insightMeta.authFilter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sortBy, sortType, sortObj, authFilter);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InsightMeta {\n");
    
    sb.append("    sortBy: ").append(toIndentedString(sortBy)).append("\n");
    sb.append("    sortType: ").append(toIndentedString(sortType)).append("\n");
    sb.append("    sortObj: ").append(toIndentedString(sortObj)).append("\n");
    sb.append("    authFilter: ").append(toIndentedString(authFilter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
