/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * LabelQueryRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class LabelQueryRequest {
  @SerializedName("projectId")
  private Long projectId = null;

  @SerializedName("ids")
  private List<Integer> ids = null;

  @SerializedName("labelTypes")
  private List<String> labelTypes = null;

  @SerializedName("entityIds")
  private List<Integer> entityIds = null;

  @SerializedName("domainIds")
  private List<Integer> domainIds = null;

  @SerializedName("domainNames")
  private List<String> domainNames = null;

  @SerializedName("nameLike")
  private String nameLike = null;

  @SerializedName("statuses")
  private List<Integer> statuses = null;

  @SerializedName("taskIds")
  private List<Integer> taskIds = null;

  @SerializedName("computeTypes")
  private List<String> computeTypes = null;

  @SerializedName("filterOrigin")
  private Boolean filterOrigin = null;

  @SerializedName("owners")
  private List<String> owners = null;

  @SerializedName("updaters")
  private List<String> updaters = null;

  @SerializedName("createTime")
  private String createTime = null;

  @SerializedName("frequencies")
  private List<String> frequencies = null;

  @SerializedName("syncTypes")
  private List<Integer> syncTypes = null;

  @SerializedName("latestRunDate")
  private String latestRunDate = null;

  @SerializedName("filterOnlineService")
  private Boolean filterOnlineService = null;

  @SerializedName("userNum")
  private Integer userNum = null;

  @SerializedName("fieldMapIdList")
  private List<Integer> fieldMapIdList = null;

  @SerializedName("withAuth")
  private Boolean withAuth = null;

  public LabelQueryRequest projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目id
   * @return projectId
  **/
  @Schema(description = "项目id")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public LabelQueryRequest ids(List<Integer> ids) {
    this.ids = ids;
    return this;
  }

  public LabelQueryRequest addIdsItem(Integer idsItem) {
    if (this.ids == null) {
      this.ids = new ArrayList<Integer>();
    }
    this.ids.add(idsItem);
    return this;
  }

   /**
   * id列表
   * @return ids
  **/
  @Schema(description = "id列表")
  public List<Integer> getIds() {
    return ids;
  }

  public void setIds(List<Integer> ids) {
    this.ids = ids;
  }

  public LabelQueryRequest labelTypes(List<String> labelTypes) {
    this.labelTypes = labelTypes;
    return this;
  }

  public LabelQueryRequest addLabelTypesItem(String labelTypesItem) {
    if (this.labelTypes == null) {
      this.labelTypes = new ArrayList<String>();
    }
    this.labelTypes.add(labelTypesItem);
    return this;
  }

   /**
   * 标签类型表
   * @return labelTypes
  **/
  @Schema(description = "标签类型表")
  public List<String> getLabelTypes() {
    return labelTypes;
  }

  public void setLabelTypes(List<String> labelTypes) {
    this.labelTypes = labelTypes;
  }

  public LabelQueryRequest entityIds(List<Integer> entityIds) {
    this.entityIds = entityIds;
    return this;
  }

  public LabelQueryRequest addEntityIdsItem(Integer entityIdsItem) {
    if (this.entityIds == null) {
      this.entityIds = new ArrayList<Integer>();
    }
    this.entityIds.add(entityIdsItem);
    return this;
  }

   /**
   * 实体id列表
   * @return entityIds
  **/
  @Schema(description = "实体id列表")
  public List<Integer> getEntityIds() {
    return entityIds;
  }

  public void setEntityIds(List<Integer> entityIds) {
    this.entityIds = entityIds;
  }

  public LabelQueryRequest domainIds(List<Integer> domainIds) {
    this.domainIds = domainIds;
    return this;
  }

  public LabelQueryRequest addDomainIdsItem(Integer domainIdsItem) {
    if (this.domainIds == null) {
      this.domainIds = new ArrayList<Integer>();
    }
    this.domainIds.add(domainIdsItem);
    return this;
  }

   /**
   * 目录id表
   * @return domainIds
  **/
  @Schema(description = "目录id表")
  public List<Integer> getDomainIds() {
    return domainIds;
  }

  public void setDomainIds(List<Integer> domainIds) {
    this.domainIds = domainIds;
  }

  public LabelQueryRequest domainNames(List<String> domainNames) {
    this.domainNames = domainNames;
    return this;
  }

  public LabelQueryRequest addDomainNamesItem(String domainNamesItem) {
    if (this.domainNames == null) {
      this.domainNames = new ArrayList<String>();
    }
    this.domainNames.add(domainNamesItem);
    return this;
  }

   /**
   * 目录名
   * @return domainNames
  **/
  @Schema(description = "目录名")
  public List<String> getDomainNames() {
    return domainNames;
  }

  public void setDomainNames(List<String> domainNames) {
    this.domainNames = domainNames;
  }

  public LabelQueryRequest nameLike(String nameLike) {
    this.nameLike = nameLike;
    return this;
  }

   /**
   * 模糊搜索
   * @return nameLike
  **/
  @Schema(description = "模糊搜索")
  public String getNameLike() {
    return nameLike;
  }

  public void setNameLike(String nameLike) {
    this.nameLike = nameLike;
  }

  public LabelQueryRequest statuses(List<Integer> statuses) {
    this.statuses = statuses;
    return this;
  }

  public LabelQueryRequest addStatusesItem(Integer statusesItem) {
    if (this.statuses == null) {
      this.statuses = new ArrayList<Integer>();
    }
    this.statuses.add(statusesItem);
    return this;
  }

   /**
   * 标签状态
   * @return statuses
  **/
  @Schema(description = "标签状态")
  public List<Integer> getStatuses() {
    return statuses;
  }

  public void setStatuses(List<Integer> statuses) {
    this.statuses = statuses;
  }

  public LabelQueryRequest taskIds(List<Integer> taskIds) {
    this.taskIds = taskIds;
    return this;
  }

  public LabelQueryRequest addTaskIdsItem(Integer taskIdsItem) {
    if (this.taskIds == null) {
      this.taskIds = new ArrayList<Integer>();
    }
    this.taskIds.add(taskIdsItem);
    return this;
  }

   /**
   * 任务id
   * @return taskIds
  **/
  @Schema(description = "任务id")
  public List<Integer> getTaskIds() {
    return taskIds;
  }

  public void setTaskIds(List<Integer> taskIds) {
    this.taskIds = taskIds;
  }

  public LabelQueryRequest computeTypes(List<String> computeTypes) {
    this.computeTypes = computeTypes;
    return this;
  }

  public LabelQueryRequest addComputeTypesItem(String computeTypesItem) {
    if (this.computeTypes == null) {
      this.computeTypes = new ArrayList<String>();
    }
    this.computeTypes.add(computeTypesItem);
    return this;
  }

   /**
   * 计算类型
   * @return computeTypes
  **/
  @Schema(description = "计算类型")
  public List<String> getComputeTypes() {
    return computeTypes;
  }

  public void setComputeTypes(List<String> computeTypes) {
    this.computeTypes = computeTypes;
  }

  public LabelQueryRequest filterOrigin(Boolean filterOrigin) {
    this.filterOrigin = filterOrigin;
    return this;
  }

   /**
   * 是否过滤原表标签
   * @return filterOrigin
  **/
  @Schema(description = "是否过滤原表标签")
  public Boolean isFilterOrigin() {
    return filterOrigin;
  }

  public void setFilterOrigin(Boolean filterOrigin) {
    this.filterOrigin = filterOrigin;
  }

  public LabelQueryRequest owners(List<String> owners) {
    this.owners = owners;
    return this;
  }

  public LabelQueryRequest addOwnersItem(String ownersItem) {
    if (this.owners == null) {
      this.owners = new ArrayList<String>();
    }
    this.owners.add(ownersItem);
    return this;
  }

   /**
   * owners
   * @return owners
  **/
  @Schema(description = "owners")
  public List<String> getOwners() {
    return owners;
  }

  public void setOwners(List<String> owners) {
    this.owners = owners;
  }

  public LabelQueryRequest updaters(List<String> updaters) {
    this.updaters = updaters;
    return this;
  }

  public LabelQueryRequest addUpdatersItem(String updatersItem) {
    if (this.updaters == null) {
      this.updaters = new ArrayList<String>();
    }
    this.updaters.add(updatersItem);
    return this;
  }

   /**
   * updaters
   * @return updaters
  **/
  @Schema(description = "updaters")
  public List<String> getUpdaters() {
    return updaters;
  }

  public void setUpdaters(List<String> updaters) {
    this.updaters = updaters;
  }

  public LabelQueryRequest createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * createTime
   * @return createTime
  **/
  @Schema(description = "createTime")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public LabelQueryRequest frequencies(List<String> frequencies) {
    this.frequencies = frequencies;
    return this;
  }

  public LabelQueryRequest addFrequenciesItem(String frequenciesItem) {
    if (this.frequencies == null) {
      this.frequencies = new ArrayList<String>();
    }
    this.frequencies.add(frequenciesItem);
    return this;
  }

   /**
   * 运行周期
   * @return frequencies
  **/
  @Schema(description = "运行周期")
  public List<String> getFrequencies() {
    return frequencies;
  }

  public void setFrequencies(List<String> frequencies) {
    this.frequencies = frequencies;
  }

  public LabelQueryRequest syncTypes(List<Integer> syncTypes) {
    this.syncTypes = syncTypes;
    return this;
  }

  public LabelQueryRequest addSyncTypesItem(Integer syncTypesItem) {
    if (this.syncTypes == null) {
      this.syncTypes = new ArrayList<Integer>();
    }
    this.syncTypes.add(syncTypesItem);
    return this;
  }

   /**
   * 调度类型
   * @return syncTypes
  **/
  @Schema(description = "调度类型")
  public List<Integer> getSyncTypes() {
    return syncTypes;
  }

  public void setSyncTypes(List<Integer> syncTypes) {
    this.syncTypes = syncTypes;
  }

  public LabelQueryRequest latestRunDate(String latestRunDate) {
    this.latestRunDate = latestRunDate;
    return this;
  }

   /**
   * 最近运行日期
   * @return latestRunDate
  **/
  @Schema(description = "最近运行日期")
  public String getLatestRunDate() {
    return latestRunDate;
  }

  public void setLatestRunDate(String latestRunDate) {
    this.latestRunDate = latestRunDate;
  }

  public LabelQueryRequest filterOnlineService(Boolean filterOnlineService) {
    this.filterOnlineService = filterOnlineService;
    return this;
  }

   /**
   * 是否在线导入
   * @return filterOnlineService
  **/
  @Schema(description = "是否在线导入")
  public Boolean isFilterOnlineService() {
    return filterOnlineService;
  }

  public void setFilterOnlineService(Boolean filterOnlineService) {
    this.filterOnlineService = filterOnlineService;
  }

  public LabelQueryRequest userNum(Integer userNum) {
    this.userNum = userNum;
    return this;
  }

   /**
   * 覆盖人数大于等于（仅作用于metaInfo）
   * @return userNum
  **/
  @Schema(description = "覆盖人数大于等于（仅作用于metaInfo）")
  public Integer getUserNum() {
    return userNum;
  }

  public void setUserNum(Integer userNum) {
    this.userNum = userNum;
  }

  public LabelQueryRequest fieldMapIdList(List<Integer> fieldMapIdList) {
    this.fieldMapIdList = fieldMapIdList;
    return this;
  }

  public LabelQueryRequest addFieldMapIdListItem(Integer fieldMapIdListItem) {
    if (this.fieldMapIdList == null) {
      this.fieldMapIdList = new ArrayList<Integer>();
    }
    this.fieldMapIdList.add(fieldMapIdListItem);
    return this;
  }

   /**
   * 上游字段id过滤
   * @return fieldMapIdList
  **/
  @Schema(description = "上游字段id过滤")
  public List<Integer> getFieldMapIdList() {
    return fieldMapIdList;
  }

  public void setFieldMapIdList(List<Integer> fieldMapIdList) {
    this.fieldMapIdList = fieldMapIdList;
  }

  public LabelQueryRequest withAuth(Boolean withAuth) {
    this.withAuth = withAuth;
    return this;
  }

   /**
   * 是否权限过滤
   * @return withAuth
  **/
  @Schema(description = "是否权限过滤")
  public Boolean isWithAuth() {
    return withAuth;
  }

  public void setWithAuth(Boolean withAuth) {
    this.withAuth = withAuth;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LabelQueryRequest labelQueryRequest = (LabelQueryRequest) o;
    return Objects.equals(this.projectId, labelQueryRequest.projectId) &&
        Objects.equals(this.ids, labelQueryRequest.ids) &&
        Objects.equals(this.labelTypes, labelQueryRequest.labelTypes) &&
        Objects.equals(this.entityIds, labelQueryRequest.entityIds) &&
        Objects.equals(this.domainIds, labelQueryRequest.domainIds) &&
        Objects.equals(this.domainNames, labelQueryRequest.domainNames) &&
        Objects.equals(this.nameLike, labelQueryRequest.nameLike) &&
        Objects.equals(this.statuses, labelQueryRequest.statuses) &&
        Objects.equals(this.taskIds, labelQueryRequest.taskIds) &&
        Objects.equals(this.computeTypes, labelQueryRequest.computeTypes) &&
        Objects.equals(this.filterOrigin, labelQueryRequest.filterOrigin) &&
        Objects.equals(this.owners, labelQueryRequest.owners) &&
        Objects.equals(this.updaters, labelQueryRequest.updaters) &&
        Objects.equals(this.createTime, labelQueryRequest.createTime) &&
        Objects.equals(this.frequencies, labelQueryRequest.frequencies) &&
        Objects.equals(this.syncTypes, labelQueryRequest.syncTypes) &&
        Objects.equals(this.latestRunDate, labelQueryRequest.latestRunDate) &&
        Objects.equals(this.filterOnlineService, labelQueryRequest.filterOnlineService) &&
        Objects.equals(this.userNum, labelQueryRequest.userNum) &&
        Objects.equals(this.fieldMapIdList, labelQueryRequest.fieldMapIdList) &&
        Objects.equals(this.withAuth, labelQueryRequest.withAuth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(projectId, ids, labelTypes, entityIds, domainIds, domainNames, nameLike, statuses, taskIds, computeTypes, filterOrigin, owners, updaters, createTime, frequencies, syncTypes, latestRunDate, filterOnlineService, userNum, fieldMapIdList, withAuth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LabelQueryRequest {\n");
    
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("    labelTypes: ").append(toIndentedString(labelTypes)).append("\n");
    sb.append("    entityIds: ").append(toIndentedString(entityIds)).append("\n");
    sb.append("    domainIds: ").append(toIndentedString(domainIds)).append("\n");
    sb.append("    domainNames: ").append(toIndentedString(domainNames)).append("\n");
    sb.append("    nameLike: ").append(toIndentedString(nameLike)).append("\n");
    sb.append("    statuses: ").append(toIndentedString(statuses)).append("\n");
    sb.append("    taskIds: ").append(toIndentedString(taskIds)).append("\n");
    sb.append("    computeTypes: ").append(toIndentedString(computeTypes)).append("\n");
    sb.append("    filterOrigin: ").append(toIndentedString(filterOrigin)).append("\n");
    sb.append("    owners: ").append(toIndentedString(owners)).append("\n");
    sb.append("    updaters: ").append(toIndentedString(updaters)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    frequencies: ").append(toIndentedString(frequencies)).append("\n");
    sb.append("    syncTypes: ").append(toIndentedString(syncTypes)).append("\n");
    sb.append("    latestRunDate: ").append(toIndentedString(latestRunDate)).append("\n");
    sb.append("    filterOnlineService: ").append(toIndentedString(filterOnlineService)).append("\n");
    sb.append("    userNum: ").append(toIndentedString(userNum)).append("\n");
    sb.append("    fieldMapIdList: ").append(toIndentedString(fieldMapIdList)).append("\n");
    sb.append("    withAuth: ").append(toIndentedString(withAuth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
