/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.LegacyUploadedSegCreateRequestTosAuthSetting;
import code.byted.inter.model.LegacyUploadedSegmentDetail;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * LegacyUploadedSegCreateRequest
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-21T14:57:29.072+08:00[Asia/Shanghai]")
public class LegacyUploadedSegCreateRequest {
  @SerializedName("name")
  private String name = null;

  @SerializedName("idType")
  private String idType = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("abaseEnabled")
  private Boolean abaseEnabled = null;

  @SerializedName("sourcePlatform")
  private String sourcePlatform = null;

  @SerializedName("appId")
  private Long appId = null;

  /**
   * 上传类型
   */
  @JsonAdapter(UploadFileTypeEnum.Adapter.class)
  public enum UploadFileTypeEnum {
    UNKNOWN("Unknown"),
    HDFSLOAD("HdfsLoad"),
    AEOLUSLOAD("AeolusLoad"),
    LOCALFILELOAD("localFileLoad");

    private String value;

    UploadFileTypeEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static UploadFileTypeEnum fromValue(String input) {
      for (UploadFileTypeEnum b : UploadFileTypeEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<UploadFileTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final UploadFileTypeEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public UploadFileTypeEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return UploadFileTypeEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("uploadFileType")
  private UploadFileTypeEnum uploadFileType = null;

  @SerializedName("detail")
  private LegacyUploadedSegmentDetail detail = null;

  @SerializedName("segResourceSecurityLevel")
  private Integer segResourceSecurityLevel = null;

  @SerializedName("productKey")
  private String productKey = null;

  @SerializedName("idMappingFilterEnable")
  private Boolean idMappingFilterEnable = null;

  @SerializedName("tosAuthSetting")
  private LegacyUploadedSegCreateRequestTosAuthSetting tosAuthSetting = null;

  public LegacyUploadedSegCreateRequest name(String name) {
    this.name = name;
    return this;
  }

  /**
   * 分群名称
   * @return name
   **/
  @Schema(required = true, description = "分群名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public LegacyUploadedSegCreateRequest idType(String idType) {
    this.idType = idType;
    return this;
  }

  /**
   * 分群名称
   * @return idType
   **/
  @Schema(required = true, description = "分群名称")
  public String getIdType() {
    return idType;
  }

  public void setIdType(String idType) {
    this.idType = idType;
  }

  public LegacyUploadedSegCreateRequest description(String description) {
    this.description = description;
    return this;
  }

  /**
   * 分群描述
   * @return description
   **/
  @Schema(description = "分群描述")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public LegacyUploadedSegCreateRequest abaseEnabled(Boolean abaseEnabled) {
    this.abaseEnabled = abaseEnabled;
    return this;
  }

  /**
   * 是否开启分群在线服务
   * @return abaseEnabled
   **/
  @Schema(description = "是否开启分群在线服务")
  public Boolean isAbaseEnabled() {
    return abaseEnabled;
  }

  public void setAbaseEnabled(Boolean abaseEnabled) {
    this.abaseEnabled = abaseEnabled;
  }

  public LegacyUploadedSegCreateRequest sourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
    return this;
  }

  /**
   * 来源平台
   * @return sourcePlatform
   **/
  @Schema(description = "来源平台")
  public String getSourcePlatform() {
    return sourcePlatform;
  }

  public void setSourcePlatform(String sourcePlatform) {
    this.sourcePlatform = sourcePlatform;
  }

  public LegacyUploadedSegCreateRequest appId(Long appId) {
    this.appId = appId;
    return this;
  }

  /**
   * Get appId
   * @return appId
   **/
  @Schema(required = true, description = "")
  public Long getAppId() {
    return appId;
  }

  public void setAppId(Long appId) {
    this.appId = appId;
  }

  public LegacyUploadedSegCreateRequest uploadFileType(UploadFileTypeEnum uploadFileType) {
    this.uploadFileType = uploadFileType;
    return this;
  }

  /**
   * 上传类型
   * @return uploadFileType
   **/
  @Schema(description = "上传类型")
  public UploadFileTypeEnum getUploadFileType() {
    return uploadFileType;
  }

  public void setUploadFileType(UploadFileTypeEnum uploadFileType) {
    this.uploadFileType = uploadFileType;
  }

  public LegacyUploadedSegCreateRequest detail(LegacyUploadedSegmentDetail detail) {
    this.detail = detail;
    return this;
  }

  /**
   * Get detail
   * @return detail
   **/
  @Schema(required = true, description = "")
  public LegacyUploadedSegmentDetail getDetail() {
    return detail;
  }

  public void setDetail(LegacyUploadedSegmentDetail detail) {
    this.detail = detail;
  }

  public LegacyUploadedSegCreateRequest segResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
    return this;
  }

  /**
   * 域内：kani 权限等级，L1,L2 支持主动授权, 默认为 L2
   * @return segResourceSecurityLevel
   **/
  @Schema(description = "域内：kani 权限等级，L1,L2 支持主动授权, 默认为 L2")
  public Integer getSegResourceSecurityLevel() {
    return segResourceSecurityLevel;
  }

  public void setSegResourceSecurityLevel(Integer segResourceSecurityLevel) {
    this.segResourceSecurityLevel = segResourceSecurityLevel;
  }

  public LegacyUploadedSegCreateRequest productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

  /**
   * 域内：部门唯一键，安全等级为L4时必传，前端会调权限服务获取，业务方直接透传即可
   * @return productKey
   **/
  @Schema(description = "域内：部门唯一键，安全等级为L4时必传，前端会调权限服务获取，业务方直接透传即可")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public LegacyUploadedSegCreateRequest idMappingFilterEnable(Boolean idMappingFilterEnable) {
    this.idMappingFilterEnable = idMappingFilterEnable;
    return this;
  }

  /**
   * 是否默认与全量标签求交
   * @return idMappingFilterEnable
   **/
  @Schema(description = "是否默认与全量标签求交")
  public Boolean isIdMappingFilterEnable() {
    return idMappingFilterEnable;
  }

  public void setIdMappingFilterEnable(Boolean idMappingFilterEnable) {
    this.idMappingFilterEnable = idMappingFilterEnable;
  }

  public LegacyUploadedSegCreateRequest tosAuthSetting(LegacyUploadedSegCreateRequestTosAuthSetting tosAuthSetting) {
    this.tosAuthSetting = tosAuthSetting;
    return this;
  }

   /**
   * Get tosAuthSetting
   * @return tosAuthSetting
  **/
  @Schema(description = "")
  public LegacyUploadedSegCreateRequestTosAuthSetting getTosAuthSetting() {
    return tosAuthSetting;
  }

  public void setTosAuthSetting(LegacyUploadedSegCreateRequestTosAuthSetting tosAuthSetting) {
    this.tosAuthSetting = tosAuthSetting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LegacyUploadedSegCreateRequest legacyUploadedSegCreateRequest = (LegacyUploadedSegCreateRequest) o;
    return Objects.equals(this.name, legacyUploadedSegCreateRequest.name) &&
        Objects.equals(this.idType, legacyUploadedSegCreateRequest.idType) &&
        Objects.equals(this.description, legacyUploadedSegCreateRequest.description) &&
        Objects.equals(this.abaseEnabled, legacyUploadedSegCreateRequest.abaseEnabled) &&
        Objects.equals(this.sourcePlatform, legacyUploadedSegCreateRequest.sourcePlatform) &&
        Objects.equals(this.appId, legacyUploadedSegCreateRequest.appId) &&
        Objects.equals(this.uploadFileType, legacyUploadedSegCreateRequest.uploadFileType) &&
        Objects.equals(this.detail, legacyUploadedSegCreateRequest.detail) &&
        Objects.equals(this.segResourceSecurityLevel, legacyUploadedSegCreateRequest.segResourceSecurityLevel) &&
        Objects.equals(this.productKey, legacyUploadedSegCreateRequest.productKey) &&
        Objects.equals(this.idMappingFilterEnable, legacyUploadedSegCreateRequest.idMappingFilterEnable) &&
        Objects.equals(this.tosAuthSetting, legacyUploadedSegCreateRequest.tosAuthSetting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, idType, description, abaseEnabled, sourcePlatform, appId, uploadFileType, detail, segResourceSecurityLevel, productKey, idMappingFilterEnable, tosAuthSetting);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LegacyUploadedSegCreateRequest {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    idType: ").append(toIndentedString(idType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    abaseEnabled: ").append(toIndentedString(abaseEnabled)).append("\n");
    sb.append("    sourcePlatform: ").append(toIndentedString(sourcePlatform)).append("\n");
    sb.append("    appId: ").append(toIndentedString(appId)).append("\n");
    sb.append("    uploadFileType: ").append(toIndentedString(uploadFileType)).append("\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    sb.append("    segResourceSecurityLevel: ").append(toIndentedString(segResourceSecurityLevel)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("    idMappingFilterEnable: ").append(toIndentedString(idMappingFilterEnable)).append("\n");
    sb.append("    tosAuthSetting: ").append(toIndentedString(tosAuthSetting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
