/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * ListProjectItems
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:30:21.574+08:00[Asia/Shanghai]")
public class ListProjectItems {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("actions")
  private List<String> actions = null;

  @SerializedName("owners")
  private List<String> owners = null;

  @SerializedName("resource_statistics")
  private Object resourceStatistics = null;

  public ListProjectItems id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 项目id
   * @return id
  **/
  @Schema(description = "项目id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public ListProjectItems name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 项目名
   * @return name
  **/
  @Schema(description = "项目名")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ListProjectItems desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 项目描述
   * @return desc
  **/
  @Schema(description = "项目描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public ListProjectItems actions(List<String> actions) {
    this.actions = actions;
    return this;
  }

  public ListProjectItems addActionsItem(String actionsItem) {
    if (this.actions == null) {
      this.actions = new ArrayList<String>();
    }
    this.actions.add(actionsItem);
    return this;
  }

   /**
   * 登录人拥有的权限
   * @return actions
  **/
  @Schema(description = "登录人拥有的权限")
  public List<String> getActions() {
    return actions;
  }

  public void setActions(List<String> actions) {
    this.actions = actions;
  }

  public ListProjectItems owners(List<String> owners) {
    this.owners = owners;
    return this;
  }

  public ListProjectItems addOwnersItem(String ownersItem) {
    if (this.owners == null) {
      this.owners = new ArrayList<String>();
    }
    this.owners.add(ownersItem);
    return this;
  }

   /**
   * 项目管理员
   * @return owners
  **/
  @Schema(description = "项目管理员")
  public List<String> getOwners() {
    return owners;
  }

  public void setOwners(List<String> owners) {
    this.owners = owners;
  }

  public ListProjectItems resourceStatistics(Object resourceStatistics) {
    this.resourceStatistics = resourceStatistics;
    return this;
  }

   /**
   * 资源统计
   * @return resourceStatistics
  **/
  @Schema(description = "资源统计")
  public Object getResourceStatistics() {
    return resourceStatistics;
  }

  public void setResourceStatistics(Object resourceStatistics) {
    this.resourceStatistics = resourceStatistics;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ListProjectItems listProjectItems = (ListProjectItems) o;
    return Objects.equals(this.id, listProjectItems.id) &&
        Objects.equals(this.name, listProjectItems.name) &&
        Objects.equals(this.desc, listProjectItems.desc) &&
        Objects.equals(this.actions, listProjectItems.actions) &&
        Objects.equals(this.owners, listProjectItems.owners) &&
        Objects.equals(this.resourceStatistics, listProjectItems.resourceStatistics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, desc, actions, owners, resourceStatistics);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ListProjectItems {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    owners: ").append(toIndentedString(owners)).append("\n");
    sb.append("    resourceStatistics: ").append(toIndentedString(resourceStatistics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
