/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * PermissionDetail
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-09T16:07:50.570+08:00[Asia/Shanghai]")
public class PermissionDetail {
  @SerializedName("resourceType")
  private String resourceType = null;

  @SerializedName("resourceKey")
  private String resourceKey = null;

  @SerializedName("resourceName")
  private String resourceName = null;

  @SerializedName("resourceDesc")
  private String resourceDesc = null;

  @SerializedName("productKey")
  private String productKey = null;

  @SerializedName("productName")
  private String productName = null;

  @SerializedName("securityLevel")
  private Integer securityLevel = null;

  @SerializedName("dataRegion")
  private List<String> dataRegion = null;

  @SerializedName("personalDataRelated")
  private Integer personalDataRelated = null;

  @SerializedName("actions")
  private List<String> actions = null;

  public PermissionDetail resourceType(String resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源类型
   * @return resourceType
  **/
  @Schema(description = "资源类型")
  public String getResourceType() {
    return resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }

  public PermissionDetail resourceKey(String resourceKey) {
    this.resourceKey = resourceKey;
    return this;
  }

   /**
   * 资源key
   * @return resourceKey
  **/
  @Schema(description = "资源key")
  public String getResourceKey() {
    return resourceKey;
  }

  public void setResourceKey(String resourceKey) {
    this.resourceKey = resourceKey;
  }

  public PermissionDetail resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

   /**
   * 资源名称
   * @return resourceName
  **/
  @Schema(description = "资源名称")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  public PermissionDetail resourceDesc(String resourceDesc) {
    this.resourceDesc = resourceDesc;
    return this;
  }

   /**
   * 资源描述
   * @return resourceDesc
  **/
  @Schema(description = "资源描述")
  public String getResourceDesc() {
    return resourceDesc;
  }

  public void setResourceDesc(String resourceDesc) {
    this.resourceDesc = resourceDesc;
  }

  public PermissionDetail productKey(String productKey) {
    this.productKey = productKey;
    return this;
  }

   /**
   * 部门key
   * @return productKey
  **/
  @Schema(description = "部门key")
  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public PermissionDetail productName(String productName) {
    this.productName = productName;
    return this;
  }

   /**
   * 部门名称
   * @return productName
  **/
  @Schema(description = "部门名称")
  public String getProductName() {
    return productName;
  }

  public void setProductName(String productName) {
    this.productName = productName;
  }

  public PermissionDetail securityLevel(Integer securityLevel) {
    this.securityLevel = securityLevel;
    return this;
  }

   /**
   * 安全级别
   * @return securityLevel
  **/
  @Schema(description = "安全级别")
  public Integer getSecurityLevel() {
    return securityLevel;
  }

  public void setSecurityLevel(Integer securityLevel) {
    this.securityLevel = securityLevel;
  }

  public PermissionDetail dataRegion(List<String> dataRegion) {
    this.dataRegion = dataRegion;
    return this;
  }

  public PermissionDetail addDataRegionItem(String dataRegionItem) {
    if (this.dataRegion == null) {
      this.dataRegion = new ArrayList<String>();
    }
    this.dataRegion.add(dataRegionItem);
    return this;
  }

   /**
   * 数据范围
   * @return dataRegion
  **/
  @Schema(description = "数据范围")
  public List<String> getDataRegion() {
    return dataRegion;
  }

  public void setDataRegion(List<String> dataRegion) {
    this.dataRegion = dataRegion;
  }

  public PermissionDetail personalDataRelated(Integer personalDataRelated) {
    this.personalDataRelated = personalDataRelated;
    return this;
  }

   /**
   * 数据关联
   * @return personalDataRelated
  **/
  @Schema(description = "数据关联")
  public Integer getPersonalDataRelated() {
    return personalDataRelated;
  }

  public void setPersonalDataRelated(Integer personalDataRelated) {
    this.personalDataRelated = personalDataRelated;
  }

  public PermissionDetail actions(List<String> actions) {
    this.actions = actions;
    return this;
  }

  public PermissionDetail addActionsItem(String actionsItem) {
    if (this.actions == null) {
      this.actions = new ArrayList<String>();
    }
    this.actions.add(actionsItem);
    return this;
  }

   /**
   * 权限点
   * @return actions
  **/
  @Schema(description = "权限点")
  public List<String> getActions() {
    return actions;
  }

  public void setActions(List<String> actions) {
    this.actions = actions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PermissionDetail permissionDetail = (PermissionDetail) o;
    return Objects.equals(this.resourceType, permissionDetail.resourceType) &&
        Objects.equals(this.resourceKey, permissionDetail.resourceKey) &&
        Objects.equals(this.resourceName, permissionDetail.resourceName) &&
        Objects.equals(this.resourceDesc, permissionDetail.resourceDesc) &&
        Objects.equals(this.productKey, permissionDetail.productKey) &&
        Objects.equals(this.productName, permissionDetail.productName) &&
        Objects.equals(this.securityLevel, permissionDetail.securityLevel) &&
        Objects.equals(this.dataRegion, permissionDetail.dataRegion) &&
        Objects.equals(this.personalDataRelated, permissionDetail.personalDataRelated) &&
        Objects.equals(this.actions, permissionDetail.actions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceType, resourceKey, resourceName, resourceDesc, productKey, productName, securityLevel, dataRegion, personalDataRelated, actions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PermissionDetail {\n");
    
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceKey: ").append(toIndentedString(resourceKey)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    resourceDesc: ").append(toIndentedString(resourceDesc)).append("\n");
    sb.append("    productKey: ").append(toIndentedString(productKey)).append("\n");
    sb.append("    productName: ").append(toIndentedString(productName)).append("\n");
    sb.append("    securityLevel: ").append(toIndentedString(securityLevel)).append("\n");
    sb.append("    dataRegion: ").append(toIndentedString(dataRegion)).append("\n");
    sb.append("    personalDataRelated: ").append(toIndentedString(personalDataRelated)).append("\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
