/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.Owner;
import code.byted.inter.model.Relation;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * 项目详情
 */
@Schema(description = "项目详情")
@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-01-02T14:30:21.574+08:00[Asia/Shanghai]")
public class ProjectInfo {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("desc")
  private String desc = null;

  @SerializedName("owners")
  private List<Owner> owners = null;

  @SerializedName("region")
  private String region = null;

  @SerializedName("department")
  private String department = null;

  @SerializedName("app_ids")
  private List<Long> appIds = null;

  @SerializedName("relation")
  private List<Relation> relation = null;

  public ProjectInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 项目id
   * @return id
  **/
  @Schema(description = "项目id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public ProjectInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 项目名
   * @return name
  **/
  @Schema(description = "项目名")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ProjectInfo desc(String desc) {
    this.desc = desc;
    return this;
  }

   /**
   * 项目描述
   * @return desc
  **/
  @Schema(description = "项目描述")
  public String getDesc() {
    return desc;
  }

  public void setDesc(String desc) {
    this.desc = desc;
  }

  public ProjectInfo owners(List<Owner> owners) {
    this.owners = owners;
    return this;
  }

  public ProjectInfo addOwnersItem(Owner ownersItem) {
    if (this.owners == null) {
      this.owners = new ArrayList<Owner>();
    }
    this.owners.add(ownersItem);
    return this;
  }

   /**
   * 项目管理员
   * @return owners
  **/
  @Schema(description = "项目管理员")
  public List<Owner> getOwners() {
    return owners;
  }

  public void setOwners(List<Owner> owners) {
    this.owners = owners;
  }

  public ProjectInfo region(String region) {
    this.region = region;
    return this;
  }

   /**
   * 所在机房
   * @return region
  **/
  @Schema(description = "所在机房")
  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public ProjectInfo department(String department) {
    this.department = department;
    return this;
  }

   /**
   * 所在部门
   * @return department
  **/
  @Schema(description = "所在部门")
  public String getDepartment() {
    return department;
  }

  public void setDepartment(String department) {
    this.department = department;
  }

  public ProjectInfo appIds(List<Long> appIds) {
    this.appIds = appIds;
    return this;
  }

  public ProjectInfo addAppIdsItem(Long appIdsItem) {
    if (this.appIds == null) {
      this.appIds = new ArrayList<Long>();
    }
    this.appIds.add(appIdsItem);
    return this;
  }

   /**
   * 绑定appId
   * @return appIds
  **/
  @Schema(description = "绑定appId")
  public List<Long> getAppIds() {
    return appIds;
  }

  public void setAppIds(List<Long> appIds) {
    this.appIds = appIds;
  }

  public ProjectInfo relation(List<Relation> relation) {
    this.relation = relation;
    return this;
  }

  public ProjectInfo addRelationItem(Relation relationItem) {
    if (this.relation == null) {
      this.relation = new ArrayList<Relation>();
    }
    this.relation.add(relationItem);
    return this;
  }

   /**
   * Get relation
   * @return relation
  **/
  @Schema(description = "")
  public List<Relation> getRelation() {
    return relation;
  }

  public void setRelation(List<Relation> relation) {
    this.relation = relation;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectInfo projectInfo = (ProjectInfo) o;
    return Objects.equals(this.id, projectInfo.id) &&
        Objects.equals(this.name, projectInfo.name) &&
        Objects.equals(this.desc, projectInfo.desc) &&
        Objects.equals(this.owners, projectInfo.owners) &&
        Objects.equals(this.region, projectInfo.region) &&
        Objects.equals(this.department, projectInfo.department) &&
        Objects.equals(this.appIds, projectInfo.appIds) &&
        Objects.equals(this.relation, projectInfo.relation);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, desc, owners, region, department, appIds, relation);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    desc: ").append(toIndentedString(desc)).append("\n");
    sb.append("    owners: ").append(toIndentedString(owners)).append("\n");
    sb.append("    region: ").append(toIndentedString(region)).append("\n");
    sb.append("    department: ").append(toIndentedString(department)).append("\n");
    sb.append("    appIds: ").append(toIndentedString(appIds)).append("\n");
    sb.append("    relation: ").append(toIndentedString(relation)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
