/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.QueryOnlineResourceV2ResponseDataItems;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * QueryOnlineResourceV2ResponseData
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2024-12-17T15:05:09.675+08:00[Asia/Shanghai]")
public class QueryOnlineResourceV2ResponseData {
  @SerializedName("items")
  private List<QueryOnlineResourceV2ResponseDataItems> items = null;

  @SerializedName("canShowMore")
  private Boolean canShowMore = null;

  @SerializedName("total")
  private Integer total = null;

  @SerializedName("page")
  private Integer page = null;

  @SerializedName("pageSize")
  private Integer pageSize = null;

  public QueryOnlineResourceV2ResponseData items(List<QueryOnlineResourceV2ResponseDataItems> items) {
    this.items = items;
    return this;
  }

  public QueryOnlineResourceV2ResponseData addItemsItem(QueryOnlineResourceV2ResponseDataItems itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<QueryOnlineResourceV2ResponseDataItems>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Get items
   * @return items
  **/
  @Schema(description = "")
  public List<QueryOnlineResourceV2ResponseDataItems> getItems() {
    return items;
  }

  public void setItems(List<QueryOnlineResourceV2ResponseDataItems> items) {
    this.items = items;
  }

  public QueryOnlineResourceV2ResponseData canShowMore(Boolean canShowMore) {
    this.canShowMore = canShowMore;
    return this;
  }

   /**
   * 是否可以显示更多
   * @return canShowMore
  **/
  @Schema(description = "是否可以显示更多")
  public Boolean isCanShowMore() {
    return canShowMore;
  }

  public void setCanShowMore(Boolean canShowMore) {
    this.canShowMore = canShowMore;
  }

  public QueryOnlineResourceV2ResponseData total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @Schema(description = "总数")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public QueryOnlineResourceV2ResponseData page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页码
   * @return page
  **/
  @Schema(description = "当前页码")
  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  public QueryOnlineResourceV2ResponseData pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 每页数量
   * @return pageSize
  **/
  @Schema(description = "每页数量")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryOnlineResourceV2ResponseData queryOnlineResourceV2ResponseData = (QueryOnlineResourceV2ResponseData) o;
    return Objects.equals(this.items, queryOnlineResourceV2ResponseData.items) &&
        Objects.equals(this.canShowMore, queryOnlineResourceV2ResponseData.canShowMore) &&
        Objects.equals(this.total, queryOnlineResourceV2ResponseData.total) &&
        Objects.equals(this.page, queryOnlineResourceV2ResponseData.page) &&
        Objects.equals(this.pageSize, queryOnlineResourceV2ResponseData.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items, canShowMore, total, page, pageSize);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryOnlineResourceV2ResponseData {\n");
    
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    canShowMore: ").append(toIndentedString(canShowMore)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
