/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import code.byted.inter.model.QueryOnlineResourceV2ResponseDataSyncStatus;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
/**
 * QueryOnlineResourceV2ResponseDataItems
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2024-12-17T15:05:09.675+08:00[Asia/Shanghai]")
public class QueryOnlineResourceV2ResponseDataItems {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("originId")
  private Integer originId = null;

  @SerializedName("originRegion")
  private String originRegion = null;

  @SerializedName("resourceType")
  private String resourceType = null;

  @SerializedName("subjectType")
  private String subjectType = null;

  @SerializedName("relatedRegions")
  private List<String> relatedRegions = null;

  @SerializedName("relatedAppIds")
  private List<Integer> relatedAppIds = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("syncStatus")
  private List<QueryOnlineResourceV2ResponseDataSyncStatus> syncStatus = null;

  @SerializedName("createdBy")
  private String createdBy = null;

  @SerializedName("canBeUsed")
  private Boolean canBeUsed = null;

  @SerializedName("applyLink")
  private String applyLink = null;

  public QueryOnlineResourceV2ResponseDataItems id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 资源ID
   * @return id
  **/
  @Schema(description = "资源ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public QueryOnlineResourceV2ResponseDataItems originId(Integer originId) {
    this.originId = originId;
    return this;
  }

   /**
   * 原始ID
   * @return originId
  **/
  @Schema(description = "原始ID")
  public Integer getOriginId() {
    return originId;
  }

  public void setOriginId(Integer originId) {
    this.originId = originId;
  }

  public QueryOnlineResourceV2ResponseDataItems originRegion(String originRegion) {
    this.originRegion = originRegion;
    return this;
  }

   /**
   * 原始地区
   * @return originRegion
  **/
  @Schema(description = "原始地区")
  public String getOriginRegion() {
    return originRegion;
  }

  public void setOriginRegion(String originRegion) {
    this.originRegion = originRegion;
  }

  public QueryOnlineResourceV2ResponseDataItems resourceType(String resourceType) {
    this.resourceType = resourceType;
    return this;
  }

   /**
   * 资源类型
   * @return resourceType
  **/
  @Schema(description = "资源类型")
  public String getResourceType() {
    return resourceType;
  }

  public void setResourceType(String resourceType) {
    this.resourceType = resourceType;
  }

  public QueryOnlineResourceV2ResponseDataItems subjectType(String subjectType) {
    this.subjectType = subjectType;
    return this;
  }

   /**
   * 主题类型
   * @return subjectType
  **/
  @Schema(description = "主题类型")
  public String getSubjectType() {
    return subjectType;
  }

  public void setSubjectType(String subjectType) {
    this.subjectType = subjectType;
  }

  public QueryOnlineResourceV2ResponseDataItems relatedRegions(List<String> relatedRegions) {
    this.relatedRegions = relatedRegions;
    return this;
  }

  public QueryOnlineResourceV2ResponseDataItems addRelatedRegionsItem(String relatedRegionsItem) {
    if (this.relatedRegions == null) {
      this.relatedRegions = new ArrayList<String>();
    }
    this.relatedRegions.add(relatedRegionsItem);
    return this;
  }

   /**
   * 相关地区
   * @return relatedRegions
  **/
  @Schema(description = "相关地区")
  public List<String> getRelatedRegions() {
    return relatedRegions;
  }

  public void setRelatedRegions(List<String> relatedRegions) {
    this.relatedRegions = relatedRegions;
  }

  public QueryOnlineResourceV2ResponseDataItems relatedAppIds(List<Integer> relatedAppIds) {
    this.relatedAppIds = relatedAppIds;
    return this;
  }

  public QueryOnlineResourceV2ResponseDataItems addRelatedAppIdsItem(Integer relatedAppIdsItem) {
    if (this.relatedAppIds == null) {
      this.relatedAppIds = new ArrayList<Integer>();
    }
    this.relatedAppIds.add(relatedAppIdsItem);
    return this;
  }

   /**
   * 相关应用ID
   * @return relatedAppIds
  **/
  @Schema(description = "相关应用ID")
  public List<Integer> getRelatedAppIds() {
    return relatedAppIds;
  }

  public void setRelatedAppIds(List<Integer> relatedAppIds) {
    this.relatedAppIds = relatedAppIds;
  }

  public QueryOnlineResourceV2ResponseDataItems name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 名称
   * @return name
  **/
  @Schema(description = "名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public QueryOnlineResourceV2ResponseDataItems description(String description) {
    this.description = description;
    return this;
  }

   /**
   * 描述
   * @return description
  **/
  @Schema(description = "描述")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public QueryOnlineResourceV2ResponseDataItems syncStatus(List<QueryOnlineResourceV2ResponseDataSyncStatus> syncStatus) {
    this.syncStatus = syncStatus;
    return this;
  }

  public QueryOnlineResourceV2ResponseDataItems addSyncStatusItem(QueryOnlineResourceV2ResponseDataSyncStatus syncStatusItem) {
    if (this.syncStatus == null) {
      this.syncStatus = new ArrayList<QueryOnlineResourceV2ResponseDataSyncStatus>();
    }
    this.syncStatus.add(syncStatusItem);
    return this;
  }

   /**
   * 同步状态
   * @return syncStatus
  **/
  @Schema(description = "同步状态")
  public List<QueryOnlineResourceV2ResponseDataSyncStatus> getSyncStatus() {
    return syncStatus;
  }

  public void setSyncStatus(List<QueryOnlineResourceV2ResponseDataSyncStatus> syncStatus) {
    this.syncStatus = syncStatus;
  }

  public QueryOnlineResourceV2ResponseDataItems createdBy(String createdBy) {
    this.createdBy = createdBy;
    return this;
  }

   /**
   * 创建者
   * @return createdBy
  **/
  @Schema(description = "创建者")
  public String getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(String createdBy) {
    this.createdBy = createdBy;
  }

  public QueryOnlineResourceV2ResponseDataItems canBeUsed(Boolean canBeUsed) {
    this.canBeUsed = canBeUsed;
    return this;
  }

   /**
   * 是否可以使用分群
   * @return canBeUsed
  **/
  @Schema(description = "是否可以使用分群")
  public Boolean isCanBeUsed() {
    return canBeUsed;
  }

  public void setCanBeUsed(Boolean canBeUsed) {
    this.canBeUsed = canBeUsed;
  }

  public QueryOnlineResourceV2ResponseDataItems applyLink(String applyLink) {
    this.applyLink = applyLink;
    return this;
  }

   /**
   * 可选，kani申请链接
   * @return applyLink
  **/
  @Schema(description = "可选，kani申请链接")
  public String getApplyLink() {
    return applyLink;
  }

  public void setApplyLink(String applyLink) {
    this.applyLink = applyLink;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryOnlineResourceV2ResponseDataItems queryOnlineResourceV2ResponseDataItems = (QueryOnlineResourceV2ResponseDataItems) o;
    return Objects.equals(this.id, queryOnlineResourceV2ResponseDataItems.id) &&
        Objects.equals(this.originId, queryOnlineResourceV2ResponseDataItems.originId) &&
        Objects.equals(this.originRegion, queryOnlineResourceV2ResponseDataItems.originRegion) &&
        Objects.equals(this.resourceType, queryOnlineResourceV2ResponseDataItems.resourceType) &&
        Objects.equals(this.subjectType, queryOnlineResourceV2ResponseDataItems.subjectType) &&
        Objects.equals(this.relatedRegions, queryOnlineResourceV2ResponseDataItems.relatedRegions) &&
        Objects.equals(this.relatedAppIds, queryOnlineResourceV2ResponseDataItems.relatedAppIds) &&
        Objects.equals(this.name, queryOnlineResourceV2ResponseDataItems.name) &&
        Objects.equals(this.description, queryOnlineResourceV2ResponseDataItems.description) &&
        Objects.equals(this.syncStatus, queryOnlineResourceV2ResponseDataItems.syncStatus) &&
        Objects.equals(this.createdBy, queryOnlineResourceV2ResponseDataItems.createdBy) &&
        Objects.equals(this.canBeUsed, queryOnlineResourceV2ResponseDataItems.canBeUsed) &&
        Objects.equals(this.applyLink, queryOnlineResourceV2ResponseDataItems.applyLink);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, originId, originRegion, resourceType, subjectType, relatedRegions, relatedAppIds, name, description, syncStatus, createdBy, canBeUsed, applyLink);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryOnlineResourceV2ResponseDataItems {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    originId: ").append(toIndentedString(originId)).append("\n");
    sb.append("    originRegion: ").append(toIndentedString(originRegion)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    subjectType: ").append(toIndentedString(subjectType)).append("\n");
    sb.append("    relatedRegions: ").append(toIndentedString(relatedRegions)).append("\n");
    sb.append("    relatedAppIds: ").append(toIndentedString(relatedAppIds)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    syncStatus: ").append(toIndentedString(syncStatus)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    canBeUsed: ").append(toIndentedString(canBeUsed)).append("\n");
    sb.append("    applyLink: ").append(toIndentedString(applyLink)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
