/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Linker
 * Linker-Api
 *
 * OpenAPI spec version: v1
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
/**
 * RealtimeTagRule
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-03-04T13:56:49.344+08:00[Asia/Shanghai]")
public class RealtimeTagRule {
  @SerializedName("tagId")
  private Integer tagId = null;

  @SerializedName("sortBy")
  private InsightTagSortBy sortBy = null;

  @SerializedName("limit")
  private Integer limit = null;

  @SerializedName("tagStringValues")
  private List<String> tagStringValues = null;

  @SerializedName("tagDecimalValues")
  private List<Double> tagDecimalValues = null;

  @SerializedName("tagDecimalRanges")
  private List<TagDecimalRange> tagDecimalRanges = null;

  @SerializedName("tagDateRanges")
  private List<TagDateRange> tagDateRanges = null;

  @SerializedName("tagDateTimeRanges")
  private List<TagDateTimeRange> tagDateTimeRanges = null;

  @SerializedName("tagDateValues")
  private List<LocalDate> tagDateValues = null;

  @SerializedName("tagDateTimeValues")
  private List<OffsetDateTime> tagDateTimeValues = null;

  public RealtimeTagRule tagId(Integer tagId) {
    this.tagId = tagId;
    return this;
  }

  /**
   * 标签id
   * @return tagId
   **/
  @Schema(required = true, description = "标签id")
  public Integer getTagId() {
    return tagId;
  }

  public void setTagId(Integer tagId) {
    this.tagId = tagId;
  }

  public RealtimeTagRule sortBy(InsightTagSortBy sortBy) {
    this.sortBy = sortBy;
    return this;
  }

  /**
   * Get sortBy
   * @return sortBy
   **/
  @Schema(description = "")
  public InsightTagSortBy getSortBy() {
    return sortBy;
  }

  public void setSortBy(InsightTagSortBy sortBy) {
    this.sortBy = sortBy;
  }

  public RealtimeTagRule limit(Integer limit) {
    this.limit = limit;
    return this;
  }

  /**
   * 标签分布个数限制
   * @return limit
   **/
  @Schema(description = "标签分布个数限制")
  public Integer getLimit() {
    return limit;
  }

  public void setLimit(Integer limit) {
    this.limit = limit;
  }

  public RealtimeTagRule tagStringValues(List<String> tagStringValues) {
    this.tagStringValues = tagStringValues;
    return this;
  }

  public RealtimeTagRule addTagStringValuesItem(String tagStringValuesItem) {
    if (this.tagStringValues == null) {
      this.tagStringValues = new ArrayList<String>();
    }
    this.tagStringValues.add(tagStringValuesItem);
    return this;
  }

  /**
   * 标签字符枚举值
   * @return tagStringValues
   **/
  @Schema(description = "标签字符枚举值")
  public List<String> getTagStringValues() {
    return tagStringValues;
  }

  public void setTagStringValues(List<String> tagStringValues) {
    this.tagStringValues = tagStringValues;
  }

  public RealtimeTagRule tagDecimalValues(List<Double> tagDecimalValues) {
    this.tagDecimalValues = tagDecimalValues;
    return this;
  }

  public RealtimeTagRule addTagDecimalValuesItem(Double tagDecimalValuesItem) {
    if (this.tagDecimalValues == null) {
      this.tagDecimalValues = new ArrayList<Double>();
    }
    this.tagDecimalValues.add(tagDecimalValuesItem);
    return this;
  }

  /**
   * 标签数值枚举值
   * @return tagDecimalValues
   **/
  @Schema(description = "标签数值枚举值")
  public List<Double> getTagDecimalValues() {
    return tagDecimalValues;
  }

  public void setTagDecimalValues(List<Double> tagDecimalValues) {
    this.tagDecimalValues = tagDecimalValues;
  }

  public RealtimeTagRule tagDecimalRanges(List<TagDecimalRange> tagDecimalRanges) {
    this.tagDecimalRanges = tagDecimalRanges;
    return this;
  }

  public RealtimeTagRule addTagDecimalRangesItem(TagDecimalRange tagDecimalRangesItem) {
    if (this.tagDecimalRanges == null) {
      this.tagDecimalRanges = new ArrayList<TagDecimalRange>();
    }
    this.tagDecimalRanges.add(tagDecimalRangesItem);
    return this;
  }

  /**
   * 标签值数值范围
   * @return tagDecimalRanges
   **/
  @Schema(description = "标签值数值范围")
  public List<TagDecimalRange> getTagDecimalRanges() {
    return tagDecimalRanges;
  }

  public void setTagDecimalRanges(List<TagDecimalRange> tagDecimalRanges) {
    this.tagDecimalRanges = tagDecimalRanges;
  }

  public RealtimeTagRule tagDateRanges(List<TagDateRange> tagDateRanges) {
    this.tagDateRanges = tagDateRanges;
    return this;
  }

  public RealtimeTagRule addTagDateRangesItem(TagDateRange tagDateRangesItem) {
    if (this.tagDateRanges == null) {
      this.tagDateRanges = new ArrayList<TagDateRange>();
    }
    this.tagDateRanges.add(tagDateRangesItem);
    return this;
  }

  /**
   * 标签值日期范围
   * @return tagDateRanges
   **/
  @Schema(description = "标签值日期范围")
  public List<TagDateRange> getTagDateRanges() {
    return tagDateRanges;
  }

  public void setTagDateRanges(List<TagDateRange> tagDateRanges) {
    this.tagDateRanges = tagDateRanges;
  }

  public RealtimeTagRule tagDateTimeRanges(List<TagDateTimeRange> tagDateTimeRanges) {
    this.tagDateTimeRanges = tagDateTimeRanges;
    return this;
  }

  public RealtimeTagRule addTagDateTimeRangesItem(TagDateTimeRange tagDateTimeRangesItem) {
    if (this.tagDateTimeRanges == null) {
      this.tagDateTimeRanges = new ArrayList<TagDateTimeRange>();
    }
    this.tagDateTimeRanges.add(tagDateTimeRangesItem);
    return this;
  }

  /**
   * 标签值日期时间范围
   * @return tagDateTimeRanges
   **/
  @Schema(description = "标签值日期时间范围")
  public List<TagDateTimeRange> getTagDateTimeRanges() {
    return tagDateTimeRanges;
  }

  public void setTagDateTimeRanges(List<TagDateTimeRange> tagDateTimeRanges) {
    this.tagDateTimeRanges = tagDateTimeRanges;
  }

  public RealtimeTagRule tagDateValues(List<LocalDate> tagDateValues) {
    this.tagDateValues = tagDateValues;
    return this;
  }

  public RealtimeTagRule addTagDateValuesItem(LocalDate tagDateValuesItem) {
    if (this.tagDateValues == null) {
      this.tagDateValues = new ArrayList<LocalDate>();
    }
    this.tagDateValues.add(tagDateValuesItem);
    return this;
  }

  /**
   * 特定日期类型
   * @return tagDateValues
   **/
  @Schema(description = "特定日期类型")
  public List<LocalDate> getTagDateValues() {
    return tagDateValues;
  }

  public void setTagDateValues(List<LocalDate> tagDateValues) {
    this.tagDateValues = tagDateValues;
  }

  public RealtimeTagRule tagDateTimeValues(List<OffsetDateTime> tagDateTimeValues) {
    this.tagDateTimeValues = tagDateTimeValues;
    return this;
  }

  public RealtimeTagRule addTagDateTimeValuesItem(OffsetDateTime tagDateTimeValuesItem) {
    if (this.tagDateTimeValues == null) {
      this.tagDateTimeValues = new ArrayList<OffsetDateTime>();
    }
    this.tagDateTimeValues.add(tagDateTimeValuesItem);
    return this;
  }

  /**
   * 特定日期时间类型
   * @return tagDateTimeValues
   **/
  @Schema(description = "特定日期时间类型")
  public List<OffsetDateTime> getTagDateTimeValues() {
    return tagDateTimeValues;
  }

  public void setTagDateTimeValues(List<OffsetDateTime> tagDateTimeValues) {
    this.tagDateTimeValues = tagDateTimeValues;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RealtimeTagRule realtimeTagRule = (RealtimeTagRule) o;
    return Objects.equals(this.tagId, realtimeTagRule.tagId) &&
           Objects.equals(this.sortBy, realtimeTagRule.sortBy) &&
           Objects.equals(this.limit, realtimeTagRule.limit) &&
           Objects.equals(this.tagStringValues, realtimeTagRule.tagStringValues) &&
           Objects.equals(this.tagDecimalValues, realtimeTagRule.tagDecimalValues) &&
           Objects.equals(this.tagDecimalRanges, realtimeTagRule.tagDecimalRanges) &&
           Objects.equals(this.tagDateRanges, realtimeTagRule.tagDateRanges) &&
           Objects.equals(this.tagDateTimeRanges, realtimeTagRule.tagDateTimeRanges) &&
           Objects.equals(this.tagDateValues, realtimeTagRule.tagDateValues) &&
           Objects.equals(this.tagDateTimeValues, realtimeTagRule.tagDateTimeValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tagId, sortBy, limit, tagStringValues, tagDecimalValues, tagDecimalRanges, tagDateRanges, tagDateTimeRanges, tagDateValues, tagDateTimeValues);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RealtimeTagRule {\n");

    sb.append("    tagId: ").append(toIndentedString(tagId)).append("\n");
    sb.append("    sortBy: ").append(toIndentedString(sortBy)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    tagStringValues: ").append(toIndentedString(tagStringValues)).append("\n");
    sb.append("    tagDecimalValues: ").append(toIndentedString(tagDecimalValues)).append("\n");
    sb.append("    tagDecimalRanges: ").append(toIndentedString(tagDecimalRanges)).append("\n");
    sb.append("    tagDateRanges: ").append(toIndentedString(tagDateRanges)).append("\n");
    sb.append("    tagDateTimeRanges: ").append(toIndentedString(tagDateTimeRanges)).append("\n");
    sb.append("    tagDateValues: ").append(toIndentedString(tagDateValues)).append("\n");
    sb.append("    tagDateTimeValues: ").append(toIndentedString(tagDateTimeValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
