/*
 * Copyright 2022 ByteDance and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * CDP开放接口
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2023-02-10
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package code.byted.inter.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
/**
 * RecommendedTask
 */

@javax.annotation.Generated(value = "code.byted.inter.client.JavaClientCodegen", date = "2025-02-17T12:51:37.014+08:00[Asia/Shanghai]")
public class RecommendedTask {
  @SerializedName("id")
  private Long id = null;

  @SerializedName("extraTaskId")
  private Long extraTaskId = null;

  @SerializedName("projectId")
  private Long projectId = null;

  @SerializedName("name")
  private String name = null;

  /**
   * 任务的频率
   */
  @JsonAdapter(FrequencyEnum.Adapter.class)
  public enum FrequencyEnum {
    UNKNOWN("Unknown"),
    YEARLY("yearly"),
    MONTHLY("monthly"),
    WEEKLY("weekly"),
    DAILY("daily"),
    HOURLY("hourly");

    private String value;

    FrequencyEnum(String value) {
      this.value = value;
    }
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
    public static FrequencyEnum fromValue(String input) {
      for (FrequencyEnum b : FrequencyEnum.values()) {
        if (b.value.equals(input)) {
          return b;
        }
      }
      return UNKNOWN;
    }
    public static class Adapter extends TypeAdapter<FrequencyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FrequencyEnum enumeration) throws IOException {
        jsonWriter.value(String.valueOf(enumeration.getValue()));
      }

      @Override
      public FrequencyEnum read(final JsonReader jsonReader) throws IOException {
        Object value = jsonReader.nextString();
        return FrequencyEnum.fromValue((String)(value));
      }
    }
  }  @SerializedName("frequency")
  private FrequencyEnum frequency = null;

  @SerializedName("databaseName")
  private String databaseName = null;

  @SerializedName("tableName")
  private String tableName = null;

  @SerializedName("path")
  private String path = null;

  @SerializedName("type")
  private String type = null;

  @SerializedName("flowTaskId")
  private String flowTaskId = null;

  public RecommendedTask id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 依赖任务的ID
   * @return id
  **/
  @Schema(description = "依赖任务的ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public RecommendedTask extraTaskId(Long extraTaskId) {
    this.extraTaskId = extraTaskId;
    return this;
  }

   /**
   * doradoTaskId
   * @return extraTaskId
  **/
  @Schema(description = "doradoTaskId")
  public Long getExtraTaskId() {
    return extraTaskId;
  }

  public void setExtraTaskId(Long extraTaskId) {
    this.extraTaskId = extraTaskId;
  }

  public RecommendedTask projectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

   /**
   * 项目的ID
   * @return projectId
  **/
  @Schema(description = "项目的ID")
  public Long getProjectId() {
    return projectId;
  }

  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  public RecommendedTask name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 任务的名称
   * @return name
  **/
  @Schema(description = "任务的名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public RecommendedTask frequency(FrequencyEnum frequency) {
    this.frequency = frequency;
    return this;
  }

   /**
   * 任务的频率
   * @return frequency
  **/
  @Schema(description = "任务的频率")
  public FrequencyEnum getFrequency() {
    return frequency;
  }

  public void setFrequency(FrequencyEnum frequency) {
    this.frequency = frequency;
  }

  public RecommendedTask databaseName(String databaseName) {
    this.databaseName = databaseName;
    return this;
  }

   /**
   * 数据库的名称
   * @return databaseName
  **/
  @Schema(description = "数据库的名称")
  public String getDatabaseName() {
    return databaseName;
  }

  public void setDatabaseName(String databaseName) {
    this.databaseName = databaseName;
  }

  public RecommendedTask tableName(String tableName) {
    this.tableName = tableName;
    return this;
  }

   /**
   * 表的名称
   * @return tableName
  **/
  @Schema(description = "表的名称")
  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public RecommendedTask path(String path) {
    this.path = path;
    return this;
  }

   /**
   * 与任务相关的路径
   * @return path
  **/
  @Schema(description = "与任务相关的路径")
  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public RecommendedTask type(String type) {
    this.type = type;
    return this;
  }

   /**
   * 任务的类型
   * @return type
  **/
  @Schema(description = "任务的类型")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public RecommendedTask flowTaskId(String flowTaskId) {
    this.flowTaskId = flowTaskId;
    return this;
  }

   /**
   * flowTaskId
   * @return flowTaskId
  **/
  @Schema(description = "flowTaskId")
  public String getFlowTaskId() {
    return flowTaskId;
  }

  public void setFlowTaskId(String flowTaskId) {
    this.flowTaskId = flowTaskId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecommendedTask recommendedTask = (RecommendedTask) o;
    return Objects.equals(this.id, recommendedTask.id) &&
        Objects.equals(this.extraTaskId, recommendedTask.extraTaskId) &&
        Objects.equals(this.projectId, recommendedTask.projectId) &&
        Objects.equals(this.name, recommendedTask.name) &&
        Objects.equals(this.frequency, recommendedTask.frequency) &&
        Objects.equals(this.databaseName, recommendedTask.databaseName) &&
        Objects.equals(this.tableName, recommendedTask.tableName) &&
        Objects.equals(this.path, recommendedTask.path) &&
        Objects.equals(this.type, recommendedTask.type) &&
        Objects.equals(this.flowTaskId, recommendedTask.flowTaskId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, extraTaskId, projectId, name, frequency, databaseName, tableName, path, type, flowTaskId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecommendedTask {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    extraTaskId: ").append(toIndentedString(extraTaskId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    frequency: ").append(toIndentedString(frequency)).append("\n");
    sb.append("    databaseName: ").append(toIndentedString(databaseName)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    flowTaskId: ").append(toIndentedString(flowTaskId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
